<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 4.6.3
*/
@ignore_user_abort(true);
@set_time_limit(3600*2);//set_time_limit(0)  1day
@ini_set('memory_limit','2028M');//2G;
@ini_set("display_errors","off");//on off
@error_reporting(0);// 0
include('./../../../app/api/sso.class.php');
SSO::sessionAuth('AdminerAccess','check=roleID&value=1');
class AdminerSoftware extends Adminer {
	function login($login, $password) {return true;}
}
function adminer_object() {return new AdminerSoftware;}

error_reporting(6135);$Wc=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($Wc||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$Di=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($Di)$$X=$Di;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection(){global$g;return$g;}function
adminer(){global$b;return$b;}function
version(){global$ia;return$ia;}function
idf_unescape($u){$ne=substr($u,-1);return
str_replace($ne.$ne,$ne,substr($u,1,-1));}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($ng,$Wc=false){if(get_magic_quotes_gpc()){while(list($y,$X)=each($ng)){foreach($X
as$ce=>$W){unset($ng[$y][$ce]);if(is_array($W)){$ng[$y][stripslashes($ce)]=$W;$ng[]=&$ng[$y][stripslashes($ce)];}else$ng[$y][stripslashes($ce)]=($Wc?$W:stripslashes($W));}}}}function
bracket_escape($u,$Oa=false){static$oi=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($u,($Oa?array_flip($oi):$oi));}function
min_version($Ui,$Ae="",$h=null){global$g;if(!$h)$h=$g;$ih=$h->server_info;if($Ae&&preg_match('~([\d.]+)-MariaDB~',$ih,$B)){$ih=$B[1];$Ui=$Ae;}return(version_compare($ih,$Ui)>=0);}function
charset($g){return(min_version("5.5.3",0,$g)?"utf8mb4":"utf8");}function
script($sh,$ni="\n"){return"<script".nonce().">$sh</script>$ni";}function
script_src($Ii){return"<script src='".h($Ii)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($Q){return
str_replace("\0","&#0;",htmlspecialchars($Q,ENT_QUOTES,'utf-8'));}function
nl_br($Q){return
str_replace("\n","<br>",$Q);}function
checkbox($C,$Y,$fb,$je="",$pf="",$kb="",$ke=""){$I="<input type='checkbox' name='$C' value='".h($Y)."'".($fb?" checked":"").($ke?" aria-labelledby='$ke'":"").">".($pf?script("qsl('input').onclick = function () { $pf };",""):"");return($je!=""||$kb?"<label".($kb?" class='$kb'":"").">$I".h($je)."</label>":$I);}function
optionlist($vf,$ch=null,$Mi=false){$I="";foreach($vf
as$ce=>$W){$wf=array($ce=>$W);if(is_array($W)){$I.='<optgroup label="'.h($ce).'">';$wf=$W;}foreach($wf
as$y=>$X)$I.='<option'.($Mi||is_string($y)?' value="'.h($y).'"':'').(($Mi||is_string($y)?(string)$y:$X)===$ch?' selected':'').'>'.h($X);if(is_array($W))$I.='</optgroup>';}return$I;}function
html_select($C,$vf,$Y="",$of=true,$ke=""){if($of)return"<select name='".h($C)."'".($ke?" aria-labelledby='$ke'":"").">".optionlist($vf,$Y)."</select>".(is_string($of)?script("qsl('select').onchange = function () { $of };",""):"");$I="";foreach($vf
as$y=>$X)$I.="<label><input type='radio' name='".h($C)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>";return$I;}function
select_input($Ka,$vf,$Y="",$of="",$Zf=""){$Sh=($vf?"select":"input");return"<$Sh$Ka".($vf?"><option value=''>$Zf".optionlist($vf,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$Zf'>").($of?script("qsl('$Sh').onchange = $of;",""):"");}function
confirm($Ke="",$dh="qsl('input')"){return
script("$dh.onclick = function () { return confirm('".($Ke?js_escape($Ke):lang(0))."'); };","");}function
print_fieldset($t,$se,$Xi=false){echo"<fieldset><legend>","<a href='#fieldset-$t'>$se</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$t');",""),"</legend>","<div id='fieldset-$t'".($Xi?"":" class='hidden'").">\n";}function
bold($Wa,$kb=""){return($Wa?" class='active $kb'":($kb?" class='$kb'":""));}function
odd($I=' class="odd"'){static$s=0;if(!$I)$s=-1;return($s++%2?$I:'');}function
js_escape($Q){return
addcslashes($Q,"\r\n'\\/");}function
json_row($y,$X=null){static$Xc=true;if($Xc)echo"{";if($y!=""){echo($Xc?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$Xc=false;}else{echo"\n}\n";$Xc=true;}}function
ini_bool($Pd){$X=ini_get($Pd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$I;if($I===null)$I=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$I;}function
set_password($Ti,$N,$V,$F){$_SESSION["pwds"][$Ti][$N][$V]=($_COOKIE["adminer_key"]&&is_string($F)?array(encrypt_string($F,$_COOKIE["adminer_key"])):$F);}function
get_password(){$I=get_session("pwds");if(is_array($I))$I=($_COOKIE["adminer_key"]?decrypt_string($I[0],$_COOKIE["adminer_key"]):false);return$I;}function
q($Q){global$g;return$g->quote($Q);}function
get_vals($G,$d=0){global$g;$I=array();$H=$g->query($G);if(is_object($H)){while($J=$H->fetch_row())$I[]=$J[$d];}return$I;}function
get_key_vals($G,$h=null,$lh=true){global$g;if(!is_object($h))$h=$g;$I=array();$H=$h->query($G);if(is_object($H)){while($J=$H->fetch_row()){if($lh)$I[$J[0]]=$J[1];else$I[]=$J[0];}}return$I;}function
get_rows($G,$h=null,$n="<p class='error'>"){global$g;$yb=(is_object($h)?$h:$g);$I=array();$H=$yb->query($G);if(is_object($H)){while($J=$H->fetch_assoc())$I[]=$J;}elseif(!$H&&!is_object($h)&&$n&&defined("PAGE_HEADER"))echo$n.error()."\n";return$I;}function
unique_array($J,$w){foreach($w
as$v){if(preg_match("~PRIMARY|UNIQUE~",$v["type"])){$I=array();foreach($v["columns"]as$y){if(!isset($J[$y]))continue
2;$I[$y]=$J[$y];}return$I;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$B))return$B[1].idf_escape(idf_unescape($B[2])).$B[3];return
idf_escape($y);}function
where($Z,$p=array()){global$g,$x;$I=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,1);$d=escape_key($y);$I[]=$d.($x=="sql"&&preg_match('~^[0-9]*\.[0-9]*$~',$X)?" LIKE ".q(addcslashes($X,"%_\\")):($x=="mssql"?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($p[$y],q($X))));if($x=="sql"&&preg_match('~char|text~',$p[$y]["type"])&&preg_match("~[^ -@]~",$X))$I[]="$d = ".q($X)." COLLATE ".charset($g)."_bin";}foreach((array)$Z["null"]as$y)$I[]=escape_key($y)." IS NULL";return
implode(" AND ",$I);}function
where_check($X,$p=array()){parse_str($X,$db);remove_slashes(array(&$db));return
where($db,$p);}function
where_link($s,$d,$Y,$rf="="){return"&where%5B$s%5D%5Bcol%5D=".urlencode($d)."&where%5B$s%5D%5Bop%5D=".urlencode(($Y!==null?$rf:"IS NULL"))."&where%5B$s%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($e,$p,$L=array()){$I="";foreach($e
as$y=>$X){if($L&&!in_array(idf_escape($y),$L))continue;$Ha=convert_field($p[$y]);if($Ha)$I.=", $Ha AS ".idf_escape($y);}return$I;}function
cookie($C,$Y,$ve=2592000){global$ba;return
header("Set-Cookie: $C=".urlencode($Y).($ve?"; expires=".gmdate("D, d M Y H:i:s",time()+$ve)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).($ba?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
restart_session(){if(!ini_bool("session.use_cookies"))session_start();}function
stop_session($cd=false){if(!ini_bool("session.use_cookies")||($cd&&@ini_set("session.use_cookies",false)!==false))session_write_close();}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($Ti,$N,$V,$l=null){global$fc;preg_match('~([^?]*)\??(.*)~',remove_from_uri(implode("|",array_keys($fc))."|username|".($l!==null?"db|":"").session_name()),$B);return"$B[1]?".(sid()?SID."&":"").($Ti!="server"||$N!=""?urlencode($Ti)."=".urlencode($N)."&":"")."username=".urlencode($V).($l!=""?"&db=".urlencode($l):"").($B[2]?"&$B[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($A,$Ke=null){if($Ke!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($A!==null?$A:$_SERVER["REQUEST_URI"]))][]=$Ke;}if($A!==null){if($A=="")$A=".";header("Location: $A");exit;}}function
query_redirect($G,$A,$Ke,$zg=true,$Dc=true,$Oc=false,$ai=""){global$g,$n,$b;if($Dc){$_h=microtime(true);$Oc=!$g->query($G);$ai=format_time($_h);}$vh="";if($G)$vh=$b->messageQuery($G,$ai,$Oc);if($Oc){$n=error().$vh.script("messagesPrint();");return
false;}if($zg)redirect($A,$Ke.$vh);return
true;}function
queries($G){global$g;static$sg=array();static$_h;if(!$_h)$_h=microtime(true);if($G===null)return
array(implode("\n",$sg),format_time($_h));$sg[]=(preg_match('~;$~',$G)?"DELIMITER ;;\n$G;\nDELIMITER ":$G).";";return$g->query($G);}function
apply_queries($G,$T,$_c='table'){foreach($T
as$R){if(!queries("$G ".$_c($R)))return
false;}return
true;}function
queries_redirect($A,$Ke,$zg){list($sg,$ai)=queries(null);return
query_redirect($sg,$A,$Ke,$zg,false,!$zg,$ai);}function
format_time($_h){return
lang(1,max(0,microtime(true)-$_h));}function
remove_from_uri($Kf=""){return
substr(preg_replace("~(?<=[?&])($Kf".(SID?"":"|".session_name()).")=[^&]*&~",'',"$_SERVER[REQUEST_URI]&"),0,-1);}function
pagination($E,$Kb){return" ".($E==$Kb?$E+1:'<a href="'.h(remove_from_uri("page").($E?"&page=$E".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($E+1)."</a>");}function
get_file($y,$Sb=false){$Uc=$_FILES[$y];if(!$Uc)return
null;foreach($Uc
as$y=>$X)$Uc[$y]=(array)$X;$I='';foreach($Uc["error"]as$y=>$n){if($n)return$n;$C=$Uc["name"][$y];$ii=$Uc["tmp_name"][$y];$_b=file_get_contents($Sb&&preg_match('~\.gz$~',$C)?"compress.zlib://$ii":$ii);if($Sb){$_h=substr($_b,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$_h,$Eg))$_b=iconv("utf-16","utf-8",$_b);elseif($_h=="\xEF\xBB\xBF")$_b=substr($_b,3);$I.=$_b."\n\n";}else$I.=$_b;}return$I;}function
upload_error($n){$He=($n==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($n?lang(2).($He?" ".lang(3,$He):""):lang(4));}function
repeat_pattern($Xf,$te){return
str_repeat("$Xf{0,65535}",$te/65535)."$Xf{0,".($te%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
shorten_utf8($Q,$te=80,$Gh=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$te).")($)?)u",$Q,$B))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$te).")($)?)",$Q,$B);return
h($B[1]).$Gh.(isset($B[2])?"":"<i>...</i>");}function
format_number($X){return
strtr(number_format($X,0,".",lang(5)),preg_split('~~u',lang(6),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~[^a-z0-9_]~i','-',$X);}function
hidden_fields($ng,$Fd=array()){$I=false;while(list($y,$X)=each($ng)){if(!in_array($y,$Fd)){if(is_array($X)){foreach($X
as$ce=>$W)$ng[$y."[$ce]"]=$W;}else{$I=true;echo'<input type="hidden" name="'.h($y).'" value="'.h($X).'">';}}}return$I;}function
hidden_fields_get(){echo(sid()?'<input type="hidden" name="'.session_name().'" value="'.h(session_id()).'">':''),(SERVER!==null?'<input type="hidden" name="'.DRIVER.'" value="'.h(SERVER).'">':""),'<input type="hidden" name="username" value="'.h($_GET["username"]).'">';}function
table_status1($R,$Pc=false){$I=table_status($R,$Pc);return($I?$I:array("Name"=>$R));}function
column_foreign_keys($R){global$b;$I=array();foreach($b->foreignKeys($R)as$q){foreach($q["source"]as$X)$I[$X][]=$q;}return$I;}function
enum_input($U,$Ka,$o,$Y,$uc=null){global$b;preg_match_all("~'((?:[^']|'')*)'~",$o["length"],$Ce);$I=($uc!==null?"<label><input type='$U'$Ka value='$uc'".((is_array($Y)?in_array($uc,$Y):$Y===0)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($Ce[1]as$s=>$X){$X=stripcslashes(str_replace("''","'",$X));$fb=(is_int($Y)?$Y==$s+1:(is_array($Y)?in_array($s+1,$Y):$Y===$X));$I.=" <label><input type='$U'$Ka value='".($s+1)."'".($fb?' checked':'').'>'.h($b->editVal($X,$o)).'</label>';}return$I;}function
input($o,$Y,$r){global$zi,$b,$x;$C=h(bracket_escape($o["field"]));echo"<td class='function'>";if(is_array($Y)&&!$r){$Fa=array($Y);if(version_compare(PHP_VERSION,5.4)>=0)$Fa[]=JSON_PRETTY_PRINT;$Y=call_user_func_array('json_encode',$Fa);$r="json";}$Ig=($x=="mssql"&&$o["auto_increment"]);if($Ig&&!$_POST["save"])$r=null;$ld=(isset($_GET["select"])||$Ig?array("orig"=>lang(8)):array())+$b->editFunctions($o);$Ka=" name='fields[$C]'";if($o["type"]=="enum")echo
h($ld[""])."<td>".$b->editInput($_GET["edit"],$o,$Ka,$Y);else{$vd=(in_array($r,$ld)||isset($ld[$r]));echo(count($ld)>1?"<select name='function[$C]'>".optionlist($ld,$r===null||$vd?$r:"")."</select>".on_help("getTarget(event).value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($ld))).'<td>';$Rd=$b->editInput($_GET["edit"],$o,$Ka,$Y);if($Rd!="")echo$Rd;elseif(preg_match('~bool~',$o["type"]))echo"<input type='hidden'$Ka value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$Ka value='1'>";elseif($o["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$o["length"],$Ce);foreach($Ce[1]as$s=>$X){$X=stripcslashes(str_replace("''","'",$X));$fb=(is_int($Y)?($Y>>$s)&1:in_array($X,explode(",",$Y),true));echo" <label><input type='checkbox' name='fields[$C][$s]' value='".(1<<$s)."'".($fb?' checked':'').">".h($b->editVal($X,$o)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$o["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$C'>";elseif(($Yh=preg_match('~text|lob~',$o["type"]))||preg_match("~\n~",$Y)){if($Yh&&$x!="sqlite")$Ka.=" cols='50' rows='12'";else{$K=min(12,substr_count($Y,"\n")+1);$Ka.=" cols='30' rows='$K'".($K==1?" style='height: 1.2em;'":"");}echo"<textarea$Ka>".h($Y).'</textarea>';}elseif($r=="json"||preg_match('~^jsonb?$~',$o["type"]))echo"<textarea$Ka cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';else{$Je=(!preg_match('~int~',$o["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$o["length"],$B)?((preg_match("~binary~",$o["type"])?2:1)*$B[1]+($B[3]?1:0)+($B[2]&&!$o["unsigned"]?1:0)):($zi[$o["type"]]?$zi[$o["type"]]+($o["unsigned"]?0:1):0));if($x=='sql'&&min_version(5.6)&&preg_match('~time~',$o["type"]))$Je+=7;echo"<input".((!$vd||$r==="")&&preg_match('~(?<!o)int(?!er)~',$o["type"])&&!preg_match('~\[\]~',$o["full_type"])?" type='number'":"")." value='".h($Y)."'".($Je?" data-maxlength='$Je'":"").(preg_match('~char|binary~',$o["type"])&&$Je>20?" size='40'":"")."$Ka>";}echo$b->editHint($_GET["edit"],$o,$Y);$Xc=0;foreach($ld
as$y=>$X){if($y===""||!$X)break;$Xc++;}if($Xc)echo
script("mixin(qsl('td'), {onchange: partial(skipOriginal, $Xc), oninput: function () { this.onchange(); }});");}}function
process_input($o){global$b,$m;$u=bracket_escape($o["field"]);$r=$_POST["function"][$u];$Y=$_POST["fields"][$u];if($o["type"]=="enum"){if($Y==-1)return
false;if($Y=="")return"NULL";return+$Y;}if($o["auto_increment"]&&$Y=="")return
null;if($r=="orig")return($o["on_update"]=="CURRENT_TIMESTAMP"?idf_escape($o["field"]):false);if($r=="NULL")return"NULL";if($o["type"]=="set")return
array_sum((array)$Y);if($r=="json"){$r="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$o["type"])&&ini_bool("file_uploads")){$Uc=get_file("fields-$u");if(!is_string($Uc))return
false;return$m->quoteBinary($Uc);}return$b->processInput($o,$Y,$r);}function
fields_from_edit(){global$m;$I=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$C=bracket_escape($y,1);$I[$C]=array("field"=>$C,"privileges"=>array("insert"=>1,"update"=>1),"null"=>1,"auto_increment"=>($y==$m->primary),);}return$I;}function
search_tables(){global$b,$g;$_GET["where"][0]["val"]=$_POST["query"];$fh="<ul>\n";foreach(table_status('',true)as$R=>$S){$C=$b->tableName($S);if(isset($S["Engine"])&&$C!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$H=$g->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",$b->selectSearchProcess(fields($R),array())),1));if(!$H||$H->fetch_row()){$jg="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$C</a>";echo"$fh<li>".($H?$jg:"<p class='error'>$jg: ".error())."\n";$fh="";}}}echo($fh?"<p class='message'>".lang(9):"</ul>")."\n";}function
dump_headers($Dd,$Te=false){global$b;$I=$b->dumpHeaders($Dd,$Te);$Hf=$_POST["output"];if($Hf!="text")header("Content-Disposition: attachment; filename=".$b->dumpFilename($Dd).".$I".($Hf!="file"&&!preg_match('~[^0-9a-z]~',$Hf)?".$Hf":""));session_write_close();ob_flush();flush();return$I;}function
dump_csv($J){foreach($J
as$y=>$X){if(preg_match("~[\"\n,;\t]~",$X)||$X==="")$J[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$J)."\r\n";}function
apply_sql_function($r,$d){return($r?($r=="unixepoch"?"DATETIME($d, '$r')":($r=="count distinct"?"COUNT(DISTINCT ":strtoupper("$r("))."$d)"):$d);}function
get_temp_dir(){$I=ini_get("upload_tmp_dir");if(!$I){if(function_exists('sys_get_temp_dir'))$I=sys_get_temp_dir();else{$Vc=@tempnam("","");if(!$Vc)return
false;$I=dirname($Vc);unlink($Vc);}}return$I;}function
file_open_lock($Vc){$jd=@fopen($Vc,"r+");if(!$jd){$jd=@fopen($Vc,"w");if(!$jd)return;chmod($Vc,0660);}flock($jd,LOCK_EX);return$jd;}function
file_write_unlock($jd,$Mb){rewind($jd);fwrite($jd,$Mb);ftruncate($jd,strlen($Mb));flock($jd,LOCK_UN);fclose($jd);}function
password_file($i){$Vc=get_temp_dir()."/adminer.key";$I=@file_get_contents($Vc);if($I||!$i)return$I;$jd=@fopen($Vc,"w");if($jd){chmod($Vc,0660);$I=rand_string();fwrite($jd,$I);fclose($jd);}return$I;}function
rand_string(){return
md5(uniqid(mt_rand(),true));}function
select_value($X,$_,$o,$Zh){global$b;if(is_array($X)){$I="";foreach($X
as$ce=>$W)$I.="<tr>".($X!=array_values($X)?"<th>".h($ce):"")."<td>".select_value($W,$_,$o,$Zh);return"<table cellspacing='0'>$I</table>";}if(!$_)$_=$b->selectLink($X,$o);if($_===null){if(is_mail($X))$_="mailto:$X";if(is_url($X))$_=$X;}$I=$b->editVal($X,$o);if($I!==null){if(!is_utf8($I))$I="\0";elseif($Zh!=""&&is_shortable($o))$I=shorten_utf8($I,max(0,+$Zh));else$I=h($I);}return$b->selectVal($I,$_,$o,$X);}function
is_mail($rc){$Ia='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$ec='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$Xf="$Ia+(\\.$Ia+)*@($ec?\\.)+$ec";return
is_string($rc)&&preg_match("(^$Xf(,\\s*$Xf)*\$)i",$rc);}function
is_url($Q){$ec='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($ec?\\.)+$ec(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$Q);}function
is_shortable($o){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$o["type"]);}function
count_rows($R,$Z,$Xd,$od){global$x;$G=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($Xd&&($x=="sql"||count($od)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$od).")$G":"SELECT COUNT(*)".($Xd?" FROM (SELECT 1$G GROUP BY ".implode(", ",$od).") x":$G));}function
slow_query($G){global$b,$ki,$m;$l=$b->database();$bi=$b->queryTimeout();$ph=$m->slowQuery($G,$bi);if(!$ph&&support("kill")&&is_object($h=connect())&&($l==""||$h->select_db($l))){$he=$h->result(connection_id());echo'<script',nonce(),'>
var timeout = setTimeout(function () {
	ajax(\'',js_escape(ME),'script=kill\', function () {
	}, \'kill=',$he,'&token=',$ki,'\');
}, ',1000*$bi,');
</script>
';}else$h=null;ob_flush();flush();$I=@get_key_vals(($ph?$ph:$G),$h,false);if($h){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$I;}function
get_token(){$vg=rand(1,1e6);return($vg^$_SESSION["token"]).":$vg";}function
verify_token(){list($ki,$vg)=explode(":",$_POST["token"]);return($vg^$_SESSION["token"])==$ki;}function
lzw_decompress($Sa){$ac=256;$Ta=8;$mb=array();$Kg=0;$Lg=0;for($s=0;$s<strlen($Sa);$s++){$Kg=($Kg<<8)+ord($Sa[$s]);$Lg+=8;if($Lg>=$Ta){$Lg-=$Ta;$mb[]=$Kg>>$Lg;$Kg&=(1<<$Lg)-1;$ac++;if($ac>>$Ta)$Ta++;}}$Zb=range("\0","\xFF");$I="";foreach($mb
as$s=>$lb){$qc=$Zb[$lb];if(!isset($qc))$qc=$ij.$ij[0];$I.=$qc;if($s)$Zb[]=$ij.$qc[0];$ij=$qc;}return$I;}function
on_help($tb,$mh=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $tb, $mh) }, onmouseout: helpMouseout});","");}function
edit_form($a,$p,$J,$Gi){global$b,$x,$ki,$n;$Lh=$b->tableName(table_status1($a,true));page_header(($Gi?lang(10):lang(11)),$n,array("select"=>array($a,$Lh)),$Lh);if($J===false)echo"<p class='error'>".lang(12)."\n";echo'<form action="" method="post" enctype="multipart/form-data" id="form">
';if(!$p)echo"<p class='error'>".lang(13)."\n";else{echo"<table cellspacing='0'>".script("qsl('table').onkeydown = editingKeydown;");foreach($p
as$C=>$o){echo"<tr><th>".$b->fieldName($o);$Tb=$_GET["set"][bracket_escape($C)];if($Tb===null){$Tb=$o["default"];if($o["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$Tb,$Eg))$Tb=$Eg[1];}$Y=($J!==null?($J[$C]!=""&&$x=="sql"&&preg_match("~enum|set~",$o["type"])?(is_array($J[$C])?array_sum($J[$C]):+$J[$C]):$J[$C]):(!$Gi&&$o["auto_increment"]?"":(isset($_GET["select"])?false:$Tb)));if(!$_POST["save"]&&is_string($Y))$Y=$b->editVal($Y,$o);$r=($_POST["save"]?(string)$_POST["function"][$C]:($Gi&&$o["on_update"]=="CURRENT_TIMESTAMP"?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(preg_match("~time~",$o["type"])&&$Y=="CURRENT_TIMESTAMP"){$Y="";$r="now";}input($o,$Y,$r);echo"\n";}if(!support("table"))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",$b->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($p){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"])){echo"<input type='submit' name='insert' value='".($Gi?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($Gi?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."...', this); };"):"");}}echo($Gi?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":($_POST||!$p?"":script("focus(qsa('td', qs('#form'))[1].firstChild);")));if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo'<input type="hidden" name="referer" value="',h(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"]),'">
<input type="hidden" name="save" value="1">
<input type="hidden" name="token" value="',$ki,'">
</form>
';}if(isset($_GET["file"])){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0\0\n @\0C\"\0`EQ?tvM'Jdd\\b0\0\"fӈs5AXPaJ08#RTz`#.cXȀ?-\0Im?.M\0ȯ(̉/(%\0");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("\n1ٌ̇l7B14vb0fsn2Bѱ٘n:#(b.\rDc)a7Elñi1̎s-4f	i7Févt2!r0t~U'3MWB'cP:6T\rcAzr_WK\r-VNFS%~c&\\^ruŎÞً4'7kQh'g\rFB\ryT7SSP1=ǤcI:dm>S8LJt.M	ϋ`'C889 Q2#8А6mjh<9/:J)ʂ\0d>!\0Zvno(k7s>!R\"*nS\0@P\"(#[@gozn9k8n1I*=n0c(;à!*c>ΎE7DLJ1`8(3M\"39?Ee=Ҭ~Ӹ7;CE\rd!)a*5ajo\0#`38\0]e2	mke]AZsStZZ!)BRG+#Jv2(c4<#sB06YL\r=[73<:bxJ=	m_ fltIH3x*6`t6%ULeق<\0AQ<P<:#u/:T\\>-xJ͍QH\njL+jz7`\nk'NvX>C-T˩4*L%Cj>7ߨި`;yqr3#} :#n\r^=CAܸƎs&8K&*0tS=[:\\]E݌/O>^]ø<gZVq x\\޺\"J\\î##Dx65x\rHl br76j|ۖ*FAquvyOWeMD.F:R\$-T!DS`8D~A`(emT@O1@X\nLpPmyf)	GSEIxC(s(a?\$`tEn, \$aU>,В\$ZkDm,G\0\\i%ʹ ngb	y`ԆW 䗗_CT\niH%dai7At,JX4n0o͹9g\nzmM%`'IО-7:p3pQrEDb2]PF>e3j\n߰t!?4ftK;\rΞи!ou?Ph0uIC}'~2vQ8)7DI=y&eas*hɕjlA(\"\\m^iM)^	|~l#!Yf81RS!62PCl&xd!|9`_OY=G[E-eLCvT )@j-5pSg.G=ZE\$\0цKjU\$G'IP~ځ ;hNێG%*RjX[XPf^|T!*NІ\rU^q1V!Uz,I|77r,7ľB;+ߕAp^~ؼW!3PI8]vJfq|,9Wf`\0qZp}[JdhyNY|Cy,<s A{eQhdǇ B4;ks&a;˹}SJ)=d|NdI*8dlѓE6~ϨFX`M\rʞ/%B/VIN&;0UC cT&.E+@0`;G5ަj'ƐY+QZ-iyvI5,O|P]Fۏ\0249͢n/χ]س&I^=lqfI= ]x1GR&e7)':BB>az-2.bz#UᓍL7-wt3ɵeD\$#j@G8 7pRYC~:@EUJ;67v]J'q1ϳElQІi/{k<֡Mpo}rq؞cä_mw^uln	_~Gn{kܞw\rj~K\0-B;b`}CC,-L8\r,klǌn}-53ugmŸ*/׏``#x+B?#ۏN;OR\r\$kϙ\01\0k\08a/t#(&l&p삅iM{zp*-gv6k	d؋A`6lX)+d 7 \r ځcj6\rp\r\r\"oP7\r\0\0yP\rQ7Z4Qڍp/y\r##D;<g\0fi2)f\\	mGh\r#n@[ G\"Sqm\r#(Ajqѣ%̑3qE\0r0я.Q7шWu @Hq'vs0\n+0SGpO`\r)c#R=\$ƐR\rGы\$R?%2C[\0؍~!\\p#@O(rg%?ra\$)r](&?&#&R',\rqV3\"Hm+lQ\"\04\$r,=&2;.H@`a\$_*RIS&q_11+13)2V72lڄ!1g-2f`,Q70qg]!qm6_M7 7o6Qkp3g9s 36\r:S9ӏ; \r9-\0Yӧ0Q<b#<Ӂw/G>r\r=3^&Q;ѣ?q0\"0HЙ|ʖSi@*T2T# \0C07]?&ED;:/3E5EQeT\"m5E;#=48*LS5HrJE TO\rԅJJJeG)8B8,&G	+Mɲ^*G146\$.\"拢I4w!\$L 8bA2L'M?MF\$,Nr/4BJ¨");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("f:gCI\n83)781x:\nOg#)r7\n\"`|2gSiH)NS\r\"0@)`(\$s6O!V/=' T4=iS6IOerx9*źn3\rщvC`2G%Y1fȂl1\ny*pC\r\$nT3=\\r9O\"	l<\r\\I,s\nAeh+M!q0f`(N{c+wYp٧33+Ijknqzi#^r3[o;(6#Ґ\":cz>ߣC2vCX<Pc*5\n/P97|Fc0!!!\nZ%ć#CH!r8\$,Rܔ2^0@2(88P/݄\\\$La\\;cHHX\nʃt8A<sZ*;I3@2<!A8G<j-K({*\ra1N4Tc\"\\!=1^M9O:;j\rXL#H7#Tݪ/-p;B \n2!t]apΎ\0RCvMI,\r\0Hv?kT4uٱ;&+&\rXbu4ݡi882B/⃖4N8AA)522s85pWC@:t㾴eh\"#8_cp^I]OH:zd3g(Ök\\62ږi7]\rxOnp<pQUn|@#G38bA6267%#\\8\r2c\rݟk.(	-J; L W㧓ѥɤnҧM9ZНs]zy^[4-U\0ta62^.`.Cj[ᄠ% Q\0`dM8\$O0`4\n\0a\rA<@\r!:BA9?h>Ǻ~̌6Ȉh=-A7Xև\\\rQ<蚧q'!XΓ2T !D\r,K\"%HqR\r̠C =<c\n#<5M Eyo\"cJKL2&eRWAΐTwё;J\\`)5ޜBqhT3R	'\r+\":8tVA+]S72YFZ85c,J/+SnBpoWd\"QaZKpާy\$4I@L'@xCdf~}Q*ҺAQ\"B*2\0.kF\"\r o\\ԢVijYMO\$2ThH0XH5~kLT*:~P2tB\0YjvDs.9s̤P*xboP\$W/*z';\$*dmÃ'b\rn%47W-K@<gèbB[7\\|VdR6leQ`(Ԣ,d8\r]S:?1`Y`Aғ%ZkQsM*{`J*wӊ>վD>eӾ\"t+poW\$Q@3t`-k7g]lE^dW>nvtlzPHFvWV\nh;BDس/:J\\+ %]ъwaݫ=XN/wJ_[t)5QR2l-:Y9&l R;u#S	 htkE!l>SHX<,OYyЃ%L]\0	^dw3,ScQte=M:42]PTsn:u>/d a'%qҨ&@֐HG@w8p΁Z\n{[t2a>	wJ^+u~oµXkզBZk˱X=0>tlŃ)Wbܦ'A,mY,Ae#V+n1IE+[[-RmK9~L-3O`_0sL;]6|hVT:ޞerMa\$~e9>Д\r\\J1Ú%=0{	|ޗtڼ=Q|\0?[g@u?ɝ|4*c-74\ri'^n;({KhnfZϝ}l]\rpJ>,gp{;\0u)sN'HC9M5*`k㬎AhY*jJǅPN+^ D*ÀDPLQ`O&\0}\$6Zn>0 e\n	trp!hV'Py^*|r%|\nr\r#@wT.Rv8j\nmBp Y0Ϣm\0@P\r8Y\rGd	QGP%E/@]\r{\0QbR M\rF|%0SDrf/\":moރ%@3Hx\0l\0	W\n8\r\0}@D`#t.jEoDrǢlbtf40%0kz2\r W@%\r\n~1XD2!O*{0<Ek*m0ı|\r\n^i !.r  fĬ+:ŋJB5\$LPLĂ Z@`^PL%5%jpHWonkA#&8<K6/̏XWe+&%c&rj'%xnK22ֶl*.r΢*\r+jpBg{ 0%1(Z`Q#Ԏn*hvB\\F\nWr f\$93G4%db:JZ!,_f%26s*FҺEQq~`tsҀ(`\r#RRrX:R)A*3\$l*ν:\"XltbK-O>R-d=\$S\$2}7Sf[}\"@][6S|SE_>q-@z`;0ƻC*[{DjC\nfsP6'ȕ QEN\\%ro7oG+dW4A*#TqEf%DZ32.Rkz@@ED`CV!Cŕ\0I)38M3@3LZB1F@Lh~G1M64Xє}ƞfˢIN34XBtd8\nbtNQb;ܑDL\0\"\nV6]UcVfD`M6O44sJ555\\x	<5[Fߵy7m)@SVĞ#x8 ոы`\\`-v2p+vULxY.\0005(@ⰵ[U@#VJuX4u_\"JO(Dt_	5s^5^^VI\rg&]\r\"ZCI6#\rܓ]7q06}o`uab(XDfMN)VUUFо=jSWi\"\\B1ĞE0 amP&<O_L.c1Z*R\$hmv[v>ݭp(0cPom\0Rp&w+KQs6}5[sJ2/O V*)R.Du33F\r;v4H	_!2k+%:_,eoFAJO\"%\nk5`z %|%Ϋg|}lv2n7~\0	YRH@rxN-Jp\0f#@ˀmvx\r2WMO/\nD7}2VWWwɀ7Hk]\$Mz\\e.fRZaBQdKZvtw4\0Z@	Bc;b>B	3mn\noJ3k(܍\"yG\$:\rņݎG6ɲJyQ\\Qif(m)/r\$J/H]*gZODѬ]1g22f=HT]N&M\0[8xȮE8&LVmvjטF\\	&s@Q \\\"b	\rBsIw	YɜN 7C/&٫`\n\n[k*ATV*UZtz{.yS#3ipzW@yC\nKT1@|z#_CJz(B,V(K_dOP@XtЅc;WZzW_٠\0ފCFxR 	\nPA&,pfV|@N\"\$[iZ\0Zd\\\"|W`]tzo\$\0[ueəbhU-,r Lk8֫V&ald2;	'-Jyua\0a{s[9V\0FR VB0S;D>L4&ZHO1\0wgStKRzi+3wzX](G\$D+tչ(#oc:	Y6\0&	@	)!w# txND)CFZpa*Fb	ͼģSi/S!zUH*40K-/-k`nLiJ~wJn\"`=V3Oį8t>voE.Rz`pPE\\ɧ3Llѥs]ToV\n	*\r@7)Dm0W5Ӏǰwb|	JV\"ur\r&N0NBdd8D_ͫ^TH#]d+v~U,PR%xfACm͸cyŜD)uHpp^u\0}{ѡ\rgsQMY2j\r|0\0X@qI`5F6NV@ӔsEp#\rPTDeWؼ񛭁z!û:DMV(~X9\0@40Nܽ~Q[TeqSv\"\"h\0R-hZdF5P`9D&xs9W֗5Er@owkb1PO-OOxlHD6/ֿmޠ37TK~54	p#I>YIN\\5NӃMpr&GxMsq.F8Cs he5*b)Sڪ̭e0-X {5|i֢aȕ6z޽/YێM ƃ \nR*8r o @78BfzKrA\$˰	p\0?dk|45}AɶWJ2k Gi\0\"d8\0>m `8w7o4cGhQ(퀨8@\$<\0p0LeX+Ja{Bh8CyP2Ӯ*EH2DqSۘp0Ik`S\n:B7{-`6AWܖ\rpW#?{\0cD[<f--pԌ*B]nW^R70\r+NGN\$(\0#+y@@iD(8@\rhHHezz{1hW1FWho&aɜd6jw`h{v`RE\nj`ܷ*ʸ}Y	\rYH6#\0廆a QHEl4dp#obr+_)\r`!|dQ>=QʡζEOB'>PӶ A\rnKi 		%<	o;S@!	x:A+\\1d\$jO7%	/guz*GH5\"8,]raq/h#\$ /tn8y-OHb<Z!1`.(uo|`GːSBaM	ڂ9ƞD@1BtDʡ@?o(HqC8ETcncR6N%rHj2G\0aq rz9b>(Px<)x#8誹th2vWo2Ut+=l#jD	0&Rc\$*̑-Z`\r;|Ap=1	1ƈbEv(^XP2=\0}WG<GR#PHܮr9	Y!LB4NCZICMLm,f@eYxBS(+<4Y)-\rz?\$\"\" 6E\r)z@ȑr*J윋%\$eJ\0A\$ڰ/5B0SxIQ)<4YS&{b+IG=>\rPY`ZD`UF14d8X(C%`㜭0I\$7Wpǁ,Ac&Ԍp\$:>].VY\$p ]`;e\00\nK+@DLSr(onM\0@9%\"WS\" 䥙ٍػj_J-rʜ5\\25>Ze\"0%9y^WMax&a)DL2Qt?=,/of3IJ\$\r;7}\rW@ҰM|\rY]5\\*s:FV!kنRL3L	52Msb\$7\0ly& 9|m!0J4TSdGnKV:lD'/:Zs\ny%i,@ҲLj1<3ĨD2/;'Pݻ`qKȰfIL Dݬ43 OHJ	q&X!r)FXx^QwOPh՞-_>a(	x%Kb<Ej7hHt`.rPx\"{\0006CVQE&>ޅwe'?B9x>:\"73xT\0ej	[tҜ\"(\\Kezre> \0002hʇXa<JtUz`達?#2-4hFY|C\"MyƔKd E7+(UʖX /D)\"بމjohFz4tD׌GRZćȿ\0FV4Q6vbi=G;Ϭkd+\n>E\02f{!JQJؘ9(2#\\Z,Qܥ3?8`	bwR6\n*㋀ƒ(tL*Sd\0x)(*wH]7ONv(Гdgq	\nLpLNH@1M 		nze4!!	'槝-tAQPL,7\\i^\$,|Z(S9\n* +TDz?(T>LæR\$zдi̼WͨDs{)@	vPgqIVҨ\n )!8|\$pZ*!7ANjNWUQ)eFUASx\0[N2X :ST~S*T4	3]9F]:KUg;*Aya1j|8ΫIMRVh7uUr,h%<qR@N9ާk	B|8rDР@\"ɋz\rO_Q\0\0|]f\nzUeHĄ/k+TF?*03!\0It	f\0(SUZAF1\0k]WZNQ܂%x1'!-,Ƕvzg#Gh;fPH9Bju\nAVR1K+MN!SμYvdZ\\,g٨\"}WYɵtPg,	\0b-hB/@̎/MJY\0)\nI?v	Ȕ1\$(w\r+n ssQfQOP.DbV\0-J<i;[=#n,j?)\"lYL.A::BxOF7`d}}=i)@к\$ q˷(y%huzb23Ƨ.-hoO\0`VZ&yt9C鋭ZґZ!XU.kV#8G}Qu8cΫtbE>v{@{QP]<aryj\\\$jxnc6k;qsTKjJn\\C{`g65Rkts|@_0΅5:B3rѡ&㴸\0&׈ԡSXʕGmʶWr,jq\0\$޺sWP.A\n49(u.lVJuԌ+AuC>hl62GeNn='~ÞPҀ%0zur\09uEs\"\\ט^(3ՑS%<+9Ծ\0~'̞֓<+,i:@N\$o ]Z!]n,x>_fW\0006%}I\nh߀wǃ -H@_Vi{R^۔}5b,!5Hp/k<<jh|ikhLv݄\n`[WC6z\ngru=!zCţe#nj\0`^;=E*@y% LQe2A1,CixtG]qO(\nV9drD'5@x\$r6;\"ǣ7\0M0ņH_#cpn><aaq@g2lm-8?87p>jiN\$#E/0s\nB\r*zoyn[Ι 6ag8qC⼜IrNFȫ170/i(B0Z(+SJ,91/Y+jxӱFAkfJee\rCͳrzmh@9O ؝GKAdOH=<&`KPA!WO;-XLmKz7-e[upqo/`CKXfiY7=M/FR۔TdY\"=`1k1Տh\rf@Nz(@	h\0I}PJKrpR`xfo(A[19(&jo<I@p	@,y	nIs^Ўѫ:Yvc؏9q.C8bWV?҅9\$u@5#S(4YK6!N6<|v13ʊ:!`Mlf`ZJ=GXY)_lАT)P`%:!Z\"lYSUؤ(Y1Z니rv)F`K~=Y>Sc!lDBrF\$RA:\\P4VR6<OS_BCS+'V2T#LcFNBD%GWnRSI\n'k0OЎ8rݯAS?xmyvabͰ,ЅA]pJ\\\\XiEuB)Z@Ώ \"gg0{n'APR٨v~0Rw쀱\"HJΖ\\\r}i?Ғ:2g{I3)B͙Zs`.#2vtXIGU>`)%(|f<Κ_ޯ_G<_ ˟[:6G8l#J(JC`wFw\"b!,!r@K(\n@AsVSֹ4_\ns٠eڋj)&3{kQGcX^L{C\nmAD1O?((2\"UL+#o@X\0٭^n_peQ˙X}%*em{GNXlq]R\\Zv!) xd΀,cK鮇mI~K{+Gݥ=@Q,1!aEOc#6<urB\nȲdHt	{C<x3H1KwB\0u'ӆQ^򕥂irRvVɷlS.O)[xStc)kB+vBw.wC22d.Hp+a\\H[\$}nNN7H.S\rȒTw	*Hg\\\$,:KBOx>5Ӷu2n`YqDxwMBn2>GڄYaKw(2`w1m-:&LD8U8l\\<	za:,K'%7:MU[*;Kj;/wG\n^eV',;B6G1OKW(iX\npCکc6^㷀=^ûcQRp`\$	D(\0D>{ETcI\r{\$oR	ZZ4*??+jnQ`X3	\$M\n׉w\"dW~@'I᭫0+-wy6vȽ'Ԇ:Y)Y0\0*)?'ǞvfI\nz9.b!cE[F麙ks}Bvg5V,)J\$jZJ\$Yח9\0\n.^JڋbmI0:g˗ATPI]~!;D	z<PQ>m`?%YT\n\0D\0\0'H@0`<׭10(m-ɞ7A\0~~ꁡĤ?thє.w%)0	#c\"cjfW\0\0pCkC885+i:[8bl[\"5Sy\0*Q6Vs97!;\"c)OQ,Ա\r7,*0aQu?_C|R(o(<j(Tv\r|_\"3mS7D!׸h|(&@:	\"-ގ&Mu;,bк=p>A6ɭ7- WW9O,o'v2<3\0h@` 3TXϚ|\"FC_~x`'fQ-4/`'=A\$>`P_G(E&/JIv'm餧zpޞFo	/[i؋G*y(<7qY.眪B\rlr\nUnƧT>	Q_|K8ډe_xzxLp14dU#4tK\$!pwZx_i5T?}C{h/Gzj\$.BҨ=#Ϗ|*Iw/ax`**]>a?'}FJSԖA0'ʟ0:63лn'U/r|=slb0\0WrBʤ@T~\$H	D\\-(ᩖBMz+%(i㹃I5/.y/\${Q}pܻdI\\ՎB\0V0B9{T\$n8\$ZePĳ%9&Vbx}g\"%h*ٸvOw˾/oL,=V5Bg ϶3>~`\nxi\"v@nףϳyacG'%[4`n47!5ހrɉ>z(Yt0VPZXT`2~Cl[ont8jB\0d\0000Vg@V!h\0006d<=[Wf@pbaټs;G<~a?NL\"(?%x#7|SOƓ)B4+*!)6#+?'(XJO\0");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0\0Dbc!Q7Шd8~N)Eг`Ns`S)O/<x9o3n2!r:;+9CȨ\n<`b\\?`4\r#`<BeB#N \r.D`j4par㢺>8\$c1cc{n7ANRLi\r1!(j´+62X8+.\r!xh'6S\0RO\n1(W07q:NE:68n+մ5_(s\r/m6P@EQ9\nV-\".:J8weq|؇X]Y XezW 7Z1hQfuj4Z{p\\AUJ<k@ɍ@}&L7UwuYh2@u P7Ah3ÛXEͅZ]l@Mplv) HWy>Y-Y/hC[*F#~!`\r#0PC˝f\\^%B<\\fޱ&/OL\\jFjZ1\\:ƴ>NXaFAfh{\"s\n64?8^p\"띰ȸ\\e(PNq[gr&}PhW*r_sPh\nom#.\0@pdW \$ҺQ۽Tl0 HdH)ۏ)PHgUBe\rt:\0)\"t,[(DO\nR8!Ƭ֚lAV4hSq<@}gK]]=90'wA<a~WD|A2XU2yŊ=p)\0P	sn3rf\0FvGI@%+_I`\r.NKI[ʖSJaUfSzM%\"Q|9Bcaq\08#<a:z1Uf>Zle5#U@iUGn%Ұs;gxLpP?BQ\\b龒Q=7:ݡQ\r:t:y( \nd)\nX;CaA\rPGH!@9\n\nAl~HV\nsիƯbBr3\rP%ф\r}b/Α\$5PC\"wB_UgAt夅^QUjBvh졄4)+)<j^<L4U*Bg*nʖ-	9O\$طzyM3\\9.oE(i7	tߚ-&\nj!\ryyD1g]yR7\"~)TZ0E9MYZtXe!f@{Ȭyl	8;R{8Įe+UL'F18PE5-	_!7[2J;HRǹ8p痲݇@0,ծpsK0\r4\$sJ4DZI'\$cLRMpY&iz3GzҚJ%P-[/xT{pzCv:V'\\KJaM&Ӿ\"eo^Q+h^iT1ORl,5[ݘ\$)jLƁU`S`Z^|r=n登TU	1Hykt+\0vD\r	<ƙjGt*3%kYܲT*|\"ClhE(\r8r{0D_.6и;rBjO'ۜ>\$`^69#4Xmh8:c0;/ԉ;\\'(t'+̷^]Nv#,vOiϖ><SA\\\\!3*tl`u\0p'7P9bs{v{7\"{ra(^Eg/U9g/`\nL\n)(Aa\" 	&P@O\n師0(M&FJ'! 0<H*|*OZm*n/b/.o\0dn)i:RP2m\0/vOXFʳψ\"000bgj\$n0}	@=MƂ0nP/pot.̽g\0)o\n0\rFbio}\n̯	NQ'xFaJL\r\r0'd	oep4Dʐq(~ \rEprQVFHlKjN&j!H`_bh\r1n!Ɏz\\\r`V_k\"\\ׂ'V\0ʾ`ACV`\r%\rk@NB횙 !\n\0Z6\$d,%%laH\n#S\$!\$@2I\$r{!J2HZM\\hb,'||cj~gr`ļ\$+A1E <L\$Y%-FDdL焳\n@bVf;2_(Lп<%@ڜ,\"dNer\0`Z4'ld9-#`Ŗj6ƣvN͐f@܆&B\$(Z&278I P\rk\\2`\rdLb@E2`P( B'0&{:dB1^؉*\r\0c<K|5sZ`O35=@5C>@W*	=\0N<g6s67Sm7u?	{<&L.3~D\rŚx),rin/O\0o{0k]3>m1\0I@9T34+ԙ@eGFMC\rE3Etm!#1D @H(n <g,V`R]@3Cr7s~GIi@\0v5\rV'P\r\$<b%(DdPWbfO x\0} lb&vj4LSִԶ5&dsF M4\".HM01uL\"/J`{xǐYu*\"U.I53Q3QJg5s&jьu٭ЪGQMTmGBtl-c*\rZ7*hs/RUVBNˈԊiLk.t龩rYi-S3\\TOM^G>ZQj\"iMsSS\$Ib	fu:SB|iY¦8	v#D4`.^HM_ռuUz`ZJ	e@Cea\"mb6ԯJRT?ԣXMZІpQvjjV{C\r7Tʞ 5{P]\r?QAA2񾠓V)Ji-N99fl Jm;u@<FѠejĦI<+CW@Zl1<2iF7`KG~L&+NYtWH飑w	ls'gq+LzbizŢ.ЊzW zdW(y)vE4,\0\"d\$B{!)1U5bp#}m=@w	P\0\r`O|	ɍYJՂEOu_\n`F`}M.#1f*ա  zuc xf8kZRs2ʂ-Z2+ʷ(sUcDѷX!u&-vPر\0'LX Lo	>Վ\r@P\rxFEȭ%=5N֜?7NÅw`hX98 qzd%6̂t/Ll,KaN~,'ǀM\rf9w!xx[ϑG8;xA-I&5\$D\$%xѬ´]&o-39Lzy6;uzZ 8_ɐx\0D?X7yOY.#38ǀeQ=؀*Gwm Y]YOYF)z#\$e)/z?z;^FZg`^e#?eM3u偃0>\"?@חXv\"*Ԣ\r6v~OV~&ר^gđٞ'f6:-Z~O6;zx;&!+{9Mٳd \r,9Wݭ:\rٜ@睂+]-[gۇ[s[iiqyx+|7{7|w}EWWk|J؁xmq xwyj#e(ߞþ {ڏyM@ɂY(g͚-J(@;y#SYp@%so9;+	;ZNٯº kVu[x|qON?	`u6||Xس|Ox!:ϗY]c\rh9n8'\rS.1USȸX+z]ɵ?C\r\\\$`)U|ˤ|Ѩx'՜<̙e|ͳLMy(ۧlкO]{ѾFD}yuĒ,XL\\x;UWtv\\OxWJ9ȒR5WiMi[Kf(\0dĚ迩\rM7;6KʦI\rxv\rV3ɱ.R|^2^0߾\$Q[Dܣ>1'^X~t1\"6L+AeI~@pM>m<SK-HT76SMfg=GPʰP\r>2Sb\$C[()%Q#G`uGwp\rkKezhjzi(rOT=7~4\"ef~dVZU-b'VJZ7)T8.<RM\$'by\n5_wU`ei޿JbguS?`+ Mg7`\0_-_?F\0X[J8&~D#{P4ܗ\"\0@ғ\0F ?*^wО:u3xK^w߯y[Ԟ(#/zr_g?\0?1wMR&M?StT]ݴG:I)B v1<t6:W{x:=ޚ:!!\0xq&0}z\"]ozjw6JP۞[\\ }`S\0qHM/7BP]FT8S5/I\r\n O0aQ\n>2j;=ڬdA=pVL)X\n¦`e\$TƦQJlJyI	:BbPZnU;>_\n	`uM򌂂֍mLwB\0\\b8M[z&1\0	\rT+\\3Plb4-)%Wd#\nrMX\"ϡ(Ei11(b`@fSjDbf}rDR1bAIy\"WvgCIJ8z\"P\\i\\m~ZRv1ZB5Ii@x-uM\njKUh\$oJϤ!L\"#p7\0 P\0D\$	GK4e\$\nG?3EAJF4Ip\0F4<f@ %q<kw	LOp\0x(	G>@9\0TGB7-G:<Q#Ǵ1&tz0*J='J>8qХ	OXFQ,\"9p*66A',yIFRT\"HR!j#kyFezG\0paJ`Ci@T|\nIxK\"*Tk\$cƔaAh!\"E\0OdSx\0T	\0!F\nU|#S&		IvL\"\$hEAN\$%%/\nP1{) <L-R16<@O*\0J@qԪ#@ǵ0\$t|]`ĊA]PᑀCp\\pҤ\07@9bmroC+]Jrf\r)d^hI\\. g>8'HfrJ[ro.v##yR+y^F\0᱁]!ɕޔ++_,\0<@M-2WR,ce2*@\0P ca0\\PO`I_2Qs\$w=:z\0)`h\nJ@@ʫ\0 6qT4J%N-m.ɋ%*cnN6\"\r͑fApMۀI7\0M>lO4S	7c\"ߧ\06psy.	RKPAo1FtIb*<@7˂p,0N:Nm,xO%!vgz(MI	~yh\0U:OZyA8<2us~lEO00]'>ɍ:;/w'~3GΖ~ӭc.	vT\0ct';P\$\$-se|!@dObwc'@`P\"x0O5/|U{:bR\"0шk`BD\nkPc4^ p6S`\$f;7?ls߆gD'4Xja	AE%	86b:qr\r]C8cF\n'ьf_9%(*~iS@(85T[Jڍ4Il=Q\$dh@D	-!_]HƊk6:\\M-\rFJ>\n.qeG5QZ' ɢہ0zP#rtˎ<QT3D\\pOE%)77Wt[@\$F)5qG0-Wv`*)Rr=9qE*K\$g	A!PjBT:K!H R0?6yA)B@:Q8B+J5U]`Ҭ:*%Ip9̀`KcQQ.BLtbyJET7Am䢕Ku:Sji 5.q%LiFTriKҨz55T%UUIՂY\"\nSmxChNZUZ( B\$YVu@蔻|	\$\0\0oZw2Ҁx2k\$*I6InI,QU4\n).QaI]Lh\"f>:Z>L`nض7VLZueXBBZ`;J]S8f \nڶ#\$jM(ޡaG+A!xL/\0)	C\nW@4۩ RZ=8`8~hP \r	D-FyX+fQSj+X|9-sx+Vcbp쿔o6Hq@.l8gYMWMPUYL3PaH29:a`d\0&YY0٘S-%;/TBSP%f@F(֍*q +[Z:QY\0޴JUY֓/pkzȈ,𪇃jꀥW״eJFVBI\rpFNقֶ*ը3k0D{`qҲBqeDcVEnFGE>j0ga|Sh7u݄\$;a7&R[WX(q#Pזc8!HVXĎjZQ,DUaQX0ըGblBt9-oZL­pˇx6&MysҐ\"̀RIWU`c}l<|~w\"vI%r+R\n\\][6&ȭaӺj(ړTѓC' '%de,\nFCэe9CNЍ-6UeȵCXV+R+3BڌJ虜T2]\0Pat29(i#aƮ1\"S:oF)kfЪ\0ӿ,wJ@V򄎵q.e}KmZXnZ{G-ZQ}׶6ɸ_؁Չ\n@7` C\0]_ ʵ}GWW: fCYk+b۶2S,	ڋ9\0﯁+WZ!e2k.Oc(v̮8DeG`ۇL,d\"CB-İ(pp=!k}(Bkr_Rܼ08a%ۘL	\0b@\"r,0TrV>Q\"rP&3bP-xuW~\"*舞Nh%7KY^ACp\0..`c+ϊGJHEl@|I#AcD|+<[c2+*WS<rg}>i݀!`f8(cQ=f\n2ch4+q8\naRB|Rm\\qgXώ0X`nFO pHCjdfEuDVbJɦ:\\!mɱ?,TIaaT.L],J??FMct!a٧RFG!Arr-pX\rC^7&R\0f*A\n՛HyY=l<A_	+tA\0B<Ay(fy1cO;pᦝ`4СM*f 5fvy {?:y^cu'8\0ӱ?g 8B&p9O\"zrs0B!u3f{\0:\n@\0p6v.;bƫ:J>˂-BhkR`-awxEjr8\0\\\\Uhm (mH3̴Sq\0NVhHy	5M͎e\\g\nIP:Sjۡٶ<x&L;nfͶcq\$f&li0%yΞt/gU̳d\0e:hZ	^@1m#Nw@OzG\$m66}ҋX'Ii\\QY4k-.:yzH]xG3M\0@z76-DO34ދ\0Κΰt\"\"vC\"JfRʞku3M~5V j/3@gG}DBNq=]\$IӞ3x=_jX٨fk(C]^jMFաϣCzV=]&\rA<	6Ԯ״`jk7:g4ծYZqftu|hZ6i〰0?骭{-7_:ސtѯck`Y&IlP`: j{h=f	[byʀoЋBRSB6^@'41UDq}N(X6j}c{@8,	PFCB\$mvP\"LCS]ElUfwh{o()\0@*a1G (D4-cP8N|RVMn8G`e}!}p@_nCt9\0]us~r#Cnp;%>wunwݞ.[hT{值	ˁJƗiJ6O=EٴImV'@&{;op;^6Ŷ@2lNMr_ܰÍ` ( y67ǂ7/pe>|	=]oc&xNm烻oGN	pxýy\\3'I`rG]ľ7\\749]^p{<Zq4u|Qۙpi\$@ox_<9pBU\"\0005 iׂCp\ni@[4jЁ6bP\0&F2~U&}ɘ	Da<zxk=r3(l_FeF41K	\\ӎld	1H\rp!%bGXf'\0	'6ps_\$?0\0~p(H\n1W:9͢`:hBgBkpƁtEBI@<%` yd\\Y@DP?|+!W.:Lev,>qA:bY@8d>r/)B4(`|:t!?<@/SP\0>\\ |3:Vuwx(4ZjD^L'C['jº[E u{KZ[s6S1z%1cB4B\n3M`0;3.&?!YAI,)lW['ITj>FSBбPcaǌuNH	LS0Y`\"il\rB/%PNG0JX\n?a!3@MF&ó,\"lb:KJ\r`k_bAį1I,;B,:Y%J#v'{	wx:\ni}ceN`!w\0BRU#S!<`&v<&qO+ΣsfL9QBʇb_+*Su>%08@l?L1po.C&ɠBqhz\0`1_9\"!\$~~-.*3r?òds\0>z\n\001~J|Sޜk7g\0KԠdaPg%wDzm)j`kQ^1+>/wbGwOk_'-CJ7&E\0L\r>!q́7o`9O`+!}P~ENcQ)##Jz_u{K%\0=OX߶C>\n|w?FaϩUb	NYh/)G2K|y/\0Z{PYG;?Z}T!0=mNf\"%4a\"!ޟ\0}[ܾbU}ڕm2/t%#.ؖseBp&}[˟7<aK8P\0g?,\0߈r,>W/[qk~CӋ4G:XGr\0L%VFLUc䑢HybP'#	\0п`99~_0q5K-E0bϭt`lmbƘ; ,='S.bSCcʍAR,X@'8Z0&Xnc<<ȣ3\0(+*3@&\r+@h, \$O\0Œt+>bʰ\r><]#%;NsŎ*c0-@L >Yp#-f0ʱa,>`P:9oovR)e\0ڢ\\\nr{îX:A*.D7#,N\rEhQK2ݩz>P@	T<=:XGJ<GAf&A^p`{0`:);U !e\0cp\r:(@%2	S\$Y3hC:O#L/k,Koo7BD0{jj&X2{}Rxvأ9A0;0-5/< N8E	+ЅPd;*n&8/jX\r>	PϐW>KOV/U\n<\0\nIk@㦃[Ϧ²#?%.\0001\0k`1T ɐlp< .>5\0	O>k@Bn<\"i%>z3P!\r\"\r >adU?ǔ3Pj3䰑>;>t62[޾M\r>\0PBOe*Rny; 8\0o0i3ʀ2@?x[Law\nsAx\r[a6clc=ʼX0z/>+W[o2)e2HQPDYzG4#YDp)	Hp&4*@/:	T	aH5h.A>`;.Ya	t/ =3BnhD?(\n!Bs\0D&DJ)\0jQyhDh(K/!>h,=tJ+S,\"MĿN1[;Т+#<IZğP)LJDP1\$Q>dOv#/mh8881N:Z0ZT BCq3%@\0\"XD	3\0!\\8#hvibT!dV\\2SŒ\nA+ͽpxiD((<*+ETBSCȿT eA\"|uv8T\0002@8D^oo|NJ8[3Jz׳WL\0\0Ȇ8:y,6&@ Eʯݑh;!f.B;:[Z3nȑAqP4,Xc8^`׃l.ShޔO+%P#Ρ\n?IBeˑO\\]6#۽؁(!c)N?EB##D DdoPA\0:nƟ`  Q>!\r6\0V%cbHF)m&\0B2I5#]D>3<\n:ML9C0\0(ᏩH\nM\"GR\n@`[\ni*\0)u)Hp\0N	\"N:9q.\r!J{,'4BlqXc4N1ɨ5Wm3\nF`'Ҋx&>z>N\$4?(\n쀨>	ϵP!Cq͌pqGLqqGyH.^\0z\$AT9FsЅD{acc_Gz) }QhHBָ<y!L!\\'H(-\"in]Ğ\\!`MH,gȎ*Kf*\0>662hJ7{nq8H#cH#\r:78܀ZZrD߲`rG\0l\nIi\0<\0Lg~E\$P\$@PƼT03HGHlQ%*\"N?%	\nCrWC\$p%uR`%R\$<`Ifx\$/\$\$O(\0\0RY*/	\rܜC9&hh=I'\$RRI'\\a=Eu·'̙wI'TK9%d!j&v̟\\=<,E`Y\\*b0>r,dpd0DD ̖`,T 1% P/\rb(JT0``ƾJtʟ((dʪh+ <Ɉ+H%i#` 'B>tJZ\\`<J+hR8hR,J]gI0\n%J*YJwD&ʖDRK\"1Q AJKC,mV-KI*r\0L\"Kb(J:qKrdʟ-)ˆ#Ը޸[A@.[Ҩʼ4.1J.̮u#Jg\0򑧣<&K+	M?/d%'/2Y>\$l\0+}-tͅ*R\$ߔK.JHʉ2\rB(P6\"nf\0#Ї %\$[\nnoLJe'<1KyY1s0&zLf#Ƴ/%y-ˣ3-KL΁0[,̵,0(.D@2L+.|2(L*S:\03G3laːl@L3z4ǽ%̒L3!033=L4|ȗ+\"47,\$SPM\\?JY̡+(a=K4C̤<Ё=\$,UJ]5hW&tI%5ҳ\\M38g́5HN?W1H^ԸY͗ؠ͏.N3M4Å`i/P7dM>d/LR=K60>I\0[\0\r2Z@1279FG+Ҝ\r)hQtL}8\$BeC#r*H۫-H/6\$RC9ب!7k/P0Xr53D<TԒqKnH<F:1SLr%(u)Xr1nJIS\$\$.·9IΟ3 LlΙ9CN#ԡ\$/s9@6tN9N:7Ӭ:DM)<#M}+2NO&JNy*ٸ[;O\"mM<c´8K,N=07sJE=TO<J=D:C<ˉ=Kʻ̳L3LTЀ3S,.q-s7>?7O;ܠ`OA9ϻ\$O;`9nIAxpE=O<52O?d`NiO>3P	?OmSMˬ=(dAȭ9\0#@9D&?i9\n/AȭASPo?kuN5~46=򖌓*@(N\0\\۔dGp#>0\$24z )`W+\080菦z\"T0:\0\ne \$rM=r\nNPCmt80 #J=&3\0*B6\"#>	(Q\n81C\rt2EC\n`(x?j8N\0[QN>'\0x	c\n3Ch`&\08\0\nO`/A`#XcD tR\n>dBDLDt4jpGAoQoG8,-sK#);E5TQG4Ao\0>tMD8yRG@'PC	<PC\"K\0x~\0ei9v))ѵGb6H\r48@M:FtQ!H{R} URpO\0It8[D4FD#+D'M>RgIQJU)EmTZE'iEqFzA>)TQ3H#TLqIjNT&ChX\nTK\00005JH\0FE@'љFphS5F\"oѮe%aoS E) DUQFmѣMѲe(tn U1ܣ~>\$ǂ(hǑGy`\0	G35Sp(PG\$#	N\nV\$]ԜP=\"RӨ?Lzt1L\$\0G~,KN=GMNS)O]:ԊS}81RGe@C\0OPSN1T!P@SSG`\n:Pj7R @3\n DӠL	\0Q5CPSMPv4?h	hTD0֏>&ITxO?@UR8@%ԖKNKRyEE# @%LQQ?N5\0R\0ԁTFԔRS!oTEC(ĵ\0?3iSS@UQeM	K\n4PCeS\0NCPO!\"RTSNU5OU>UiIPU#UnKPUYT*CU/\0+):ReA\$\0xWD3`U5IHUY:P	e\0MJiQ>@TC{u?^v\0WR]U}C1-5+U?\rW<?5JU-SXL \\t?sMbՃV܁tT>MU+	Ec9Nm\rRǃC8SX'RXjCI#G|!QGhtQ )<Y*RmX0MOQYhduZ(Ao#NlyNVZ9IMVZuOՅTTEՇַSe\nXSQER[MFVO=/>gչTVoUTZN*T\\*S-pSVqM(Q=\\-UUUVCZ\nuV\$?M@UWJ\r\rU\\'UW]WW8N'#h=oCF(:9YuV-U9]C:U\\\nqW(TT?5P\$ R3⺟C}`>\0E]#R	#R)W:`#G)4R;ViD%8)Ǔ^Q#h	HX	\$Nx#i xԒXR'9`m\\\nEQ`bu@NdT#YYGV]j5#?Lxt/##酽OPQ6^ M\\R5tӚp*XV\"WD	oRALm\rdGN	6p\$P废E5Tx\n+C[V8UDu}ػF\$.Q-;4ȀNX\n.Xb͐\0b)#NG4KZS^״M8d\"C>dHe\nY8. ҏFDW1cZ6QKH@*\0^\\QF4U3Y|=ӤEۤ?-47YPmhYw_\rVeױMُe(0F\r!PUIu7QCю?0gu\rqधY-Q=g\0\0M#US5Zt֟ae^\$>ArV_\r;tHWZ@HhzD\0S2J HIO'ǁeg6[R<? /KM\n>HZ!iTX6iC !ӛg G }Q64>w!ڙC}VB>UQڑj8cUT'<>HC]V7jj3v`023x@Uk\n:Si5#Y-wM?cMQGQуb`\0@ҧ\0M)ZrKX֟WllTMD\r4QsS40sQ́mYhdC`{VgE\nXkՁ',4^6#<4NXnM):OM_6d[\"KUn?lx\0&\0R56T~>ո?Jn Z/i6glͦUF}.JLCTbM4cLTjSD}JtZ:Ld:Ezʤ>V\$2>[p6R9uW.?1RHuR?58ԮDupcZ?r׻ Eaf}5wYϒWwT[Sp7'_aEk\"[/i#\$;mfأWOF\r%\$ju-t#<!\n:KEA]\nUQKE#X5[>`/D֭VEp)I%qnx):le[e\\eV[j7 -+GWEwtWkE~uQ/m#ԐW`yuǣDA'ױ\rՙOD )ZM^u-|v8]ghLW\06X=YdQ7ϓ9r <֏DB`c9`D=wxI%,ᄬj[њO ``|.	AO	@@ 0h2\\ЀM{e9^>@7\0˂W\$,Ś@؀w^fm,\0yD,ם^X.ֆ72f;6\n^zCקmzn^&LFF,[eaXy9h!:z9cQ9b !Gw_Wg9S+tptɃ\nm+_	\\k5]4_h9 N]%|7֜];|X9|G[\0}UMCI:qOVԃa\0\rR6π\0@HP+rSWp7I~p/H^E-%̻&.+Jђ;:!N	~/W!BL+\$q=+`/Ƅe\\xpElpSJSݢ6_(ůb\\O&\\59\09nD{\$Kv2	d]vC?tf|W:p&Ln賞{;GR9T.yI8\rl 	Tn3T.93ZsG:	0z.]ģQ?gT%xՌ.n<-8B˳,BrgQɎ`2:{gsgZ ׌<w{bU9	`5`4\0BxMp8qnah@ؼ-(>S|038h\0CzLQ@\n?`A>2,N&xl8sah1|BɇDxB#VV׊`Wa'@	X_?\n  _. Pr2bUarI~S\0ׅ\"2>b;vPh{[7a`\0˲jo~v|fv4[\${P\rvBKGbpO5ݠ2\0jلL)mVejBB.'R{CV'`؂ %ǀ\$O\0`4 N>;4/π*\\5!`X*%N3SAMƔ,1\\caϧ @˃B/0`v2`hDJO\$@p!9!\n17pB,>8F4fπ:733T8=+~n\\e<brFز CN:c:l<\r\\3>6ONn!;@tw^FL;,^a\ra\"ڮ':vJe4א;_d\r4\r:S2[cXʦPl\$ޣiwd#Bb`:~ <\02RP\rJ8Dt@E\0\r͜67Y\"\r3.+z3;_ʟvLwJ94IJa,A;s?N\nR!ݐOms_-zۭwzܭ7zMo\0aݹ48PfY?ieBS1\0jDTeKUYS?66R	c6Ry[c5]B͔R_eA)&[凕XYRW6VYaeUfYewUbwEʆ;z^W9קݖ\0<ޘe9Sda	_-L8ǅQTH[!<p\0Py5|#P	9v2|Ǹfao,j8\$A@kabcf4!4cr,;b=;\0źcdXbxaRx0Ah+wxN[BpwT8T%Ml2}s.kY0\$/fU=sgKM ?`4c.!&分gf/f1=V AE<#̹f\n)Np`.\"\"AqX٬:a8fVsGr:VcgVlg=`WygU˙ẼeT=x 0 M@%κbwfO筘*0|t%PpgK?p@J<Bٟ#`192g!3~nlfVh.aC?-168>Aa\ry0iJ}z:\r)S@h@YmCEgcyφ<h@@zh<W`:zO\rWV08f7(Gy`St#f#C(9؀d8T:0 q79phAg6.7Frb jA5a1hZCh:%gUD9Ɉ׹0~vTi;VvSw\r΃?fnϛiYa3·9,\nr,/,@.:Y>&F)}biOi:dAnc=L9Oh{ 8hY.\rև1QU	CheO+2oNzp(]hZ|OczD;T\0j\08#>Ύ=bZ8Fj;޺T酡w)N`ÅB{z\rc|dTGi/!i0'`Z:CH(8`V\0ꧩWǪzgG-[	iN\rqno	ƥfEJapb}6=o,tY+EC\rPx4=@.F[zqX6:FG#\$@&abhE:`S11g12uhY_:Bߡdc*\0ƗFYF:n=ۨH*ZMhk/냡zٹ]h@1\0ZK^+,vfs>O|s\0֜5XѯFnAr]|Ii4 C h@عcߥ6smOgXV26g?~YѰscl \\R\0cA+1\n(^368cz:=z( ;裨sF@`;,>yT&dLן%-CHL8\rbMj]4Ym9ZBP}<X̥+g^M + B_FdXlw~\r⽋\":qA1X3ΓEh4ZZ&1~!Nfo\nMe଄XI΄G@V*X;Y5{V\nTz\rF3}mp1[>tew@Vz#2	i{9p̝gh+[elUAٶӼi1!omm*K}!Ƴ{mef`mCz=n:}g TmLu1F}=8ZOmFFMfOO/ޓVoqjn!+ZI.9!nG\\3a~O+::K@\n@Hph\\BdmfvCP\" .nW&nHY+\rzi>MfqۤQc[H+o*1'#āEwD_X)>s-~\rT=- ym{hjM)^'@V+i;FD[b!B	:MPۭoCvAE?CIiY#pP\$kJq.07xlsC|bo2X>M\rl&:2~cQod-URoYnM;n#\0PfPo׿(Cv<[o۸fѿ;ẖ[Y.oUppU.B!'\0<T:1<nFIǔV0ǁRO8w,aFɥ[ΟYO/\0oxQ?:ً`h@:/Mmx:۰c1v;^@@\n{;B8 g坒\\*gyC)E^Oh	Au>@DY`o<>pķq,Y1Q߸/qg\0+\0D? k:\$ץ6~I=@!vzO񁚲+9iag?0Gnq]{Ҹ,FO <_>f+,	&·yǩO:U¯L\núI:2-;_Ģ|%崿!f\$Xr\"Kni\$8#gt-r@L圏@S<rN\nD/rLdQk࣓eЭ\n=4)BךZ-|HbHk*	Q!'G Ybt!(n,POfq+XY\"b F6r f\"ܳ!N^rB_(\"K_-<*Q/,)H\0r\"z2(tه.F>#3268sh٠ƑI1Sn20-42As(4˶\0#rK'ͷG'7&\n>xJGO8,08\0W9I?:3n\r-w:;3ȉ!;ꃘZRM+>0/=R'148m%ȥ}χ9;=nQ=hhLGkW\r	%4ҜsΖJ3s4@U%\$N;?4N2|Z3h\035^xi2d\r|Mʣbh|#v` \0ꐮ\$\r2h#?I\n+o-?6`ṽ.\$KY%J?cRN#K:KEL>:@jPn_t&slm'ЩɸӜ;6ۗHU5#Q7UWYU bNW_;TC[<ږ>WCU6X#`MI:tӵ	u#`fu\$tX`f<;bgh97S58#^-\0չR*'(qZ壣XQFUvW GWTW~ڭ^WJ=_ؗbmbV\\l/MTmTOXu=_ITvvua\rL_qR/]]msu=H=ug o\\UՅgM	XVU%h53U\\=QMvgmuehbMGCeO5ԁO5Yi=e	GTURvOa*ivWXJ5<bu]<\$u3v#'euR5mvD5.vW=U_(\\V_<Sn)1M%QhZTf5E'WvUmiՂU]aWUdRv-YUZuUVUiRV[ZMU\\=v{XwQhuHvgqݴw!oqtU{TGq{#^G_ubQi9Qb>NUdk5hPmu[\0_[Y-r(CrMeJ!h?QrX3 x#x<{u5~-uYyQ\r-\0uգuuٿpUڅ)P\r<uS0w-i!֊Bd]ŇEvlmQݏ6kJwĞEDURev:XcNW}`-tH#ebu	~B7 ?	OPCWSE͕V>U7mӂz=1+mI,>X7].*	^N./\")	s|ӟl}!5npjh}mEzHaO0d=A|w߳uvGx#bcSo-tOm`C^M@hn\$k``HD^PE[]rRm=.ه>Ayi \"	o-,.\nq+fXd*߽K؃' %a9pKLM!,zX#VuH%!63JryՁq_u	W|@3b17|~wﱳA7	9cS&{%VxkZOwUr?N |C#Űկ /9ftEwCa^\0O<W{Y=engyf0h@S\0:C^VgpE9:853ާ@j_[+ǩx^ꮆ~@чW㓜9xFC.k^IpU9S\$\r4\0O)L[p?.PECSI1nm{?PWA߲;D;SaKf%?X+B>9GjczA͎:an0bJ{o!3!'K}\\3W5xL;2ζna;׺Xӛ]ox{5ޙjXvӚqEE{р4{	\n>aﯷL'{\n>JߌӗY\rOʽt-O49F;GIF1oOa{w0Ư;񔄑loJTb\rw2J=D#n:yS^,.?(I\$Ư3s4MaCRG̑I߰n<zyXN?.=DǼ\r\n\ro\nПCl%Y߰G}#VН%(3ɍr};׿Gn[{_<m4[	Iq?0cVnmsnM\"Nj1w?@\$1>^\\{n\\7ٟic1hoo?j<GxlSr}|\"}/?stI&^1et,*'F=/Fk,95rV쑈o9/F_~*^{I_^nN~AdUwqYT2G?&:y%XJCd	Wߎ~G!J}B-;h*RE~.~SAqDVx='E(^~o7~M[Q(ynP>[WX{qaϤ.&N3]HY[&8?3݆#Be6@[G\r+}_7|N4~(z~%?[1S]xkKxO^ArZ+*WkwD(R:\0'm!O\nu.[ P!}m 1pu,TL 	0}&P٥\n=D=\rA/o@2t6DK\0q7lB(;[kr\r;#lŔ\r<}zb+O[WrX`Z ţPm'FnSp-\0005`dPǾ;n\05fPEJw .?;Nޥ,;Ʀ-[7ei-dَ<[~6k:&.7]\0/59 @eT:煘3dsݝ5䏜5f\0PHB8JLS\0vI\07Dma3e?B\$.Ef@nbGbq3|PaˈϯX7Tg>.p5AHŵ3S,@#&w3m[Iѥ^̤J1?gTၽ#S=__	Vq/C۾݀|D g>܄ 6\r7}qŤJGB^\\g&%[2Ixì6\03]3{@RUMv<1szuP5F:i|`qV| \nk}'|gd!8 <,P7m||IA]BB F0X	D`WqmOL	.(pҁ\"!\0AV7kM\$N0\\\"f\0uq,5A6p\nΐjY7[pK4;l5n@\\fl	MP3CHbЌcEpP4eooe{\r-2.֥P50uG}\0<\r!~\n7Fd>a%c6ԞM|dO_?JC0>Ё&7kM4`%flΘB~wxZGP20=*p@BeȔ|2\r?q8Њ(yr0>>E?w|r]%Av@+XAgsCAXmNҝ4\0\r8JJǸDҚ:=	S4F;	\\&P!6%\$ixi4c0B;62=1̈PCmdpc+5\$/rCR`MQ6(\\2A\\lGl\0BqPrBт_6Ll!BQIGXRbs]BHr`X\$p8	nbR,±L\"E%\0aYBsD,!ϛpN9RbG4MtjUy\0%\$.iL!xғ(.)6T(Ia%K]mt&G7ITMB\rza])va%41Tj͹(!\\\\W\\t\$0%\0aK\$TF(YC@HHnDdWphZ'ZC,/\$JFBuܬQ:ΥA:-a#=jblUg;{RUEWnUaVNjuG*yֹ%@*Yx_z])v\"RLVIv=`'U) S\r~R\ni)5SD49~b;)3,9M3HsJkTÜ(uJ][\$ufob\n.,Yܵ9j1'!1\$Jgڤ՟ĆU0ZuahcH,YtKb55/dYAU҅[W>_V\r*j-T zYdcmҹ:[Ut-{l	i+a).[_:5hW§m%JI[Th>;X̺dSdV;\rƱ!NK&AJu4Bdg΢.Vpmb)V!U\0G丨`\\q7QbVL:ՂZ.N*ԏU]ZlzR D1I£r:\0<1~;#JbMy+۔/\"ϛj<3#̌:P.}eD\"qyJGsopX\rd\rxJ%ƼO:%yy,%{3<XøzEz(\0 D_.2+gbcxpgި|9CP48U	Q/AqQ(4 7e\$Dv:VbN4[iv2\rX1AJ(<PlF\0\\z)W(4 p`\rda6Oma}q`6P'h3|f jAz+DUWD5%#x3{L\r-͙]:jdP	jfq:Z\"sad)G3	+rNK1Qx=>\"-:FIك*@ԟyT\\UY~3Df,s8HV't9v(:B9\\Z(&E8W\$X\0\n9WBb66j9 ʈ?,| ag1\nPs\0@%#K\r\0ŧ\00?š,\0hh\08\0l\0-ZjbŬ\0p\0-f`ql0\0i-\\ps7e\"-ZlbE,\0]P Eb\0/,Z\r\0000[f-@\rӯEڋ/Z8~\"ڋ.^Qwϋ\0/t_ȼE\00d]bŤ|\0\\ؼE\0af0tZnJ\0l\00L^Qj@J^q#F(1/[1I.^8\0[q[Ñl\" \00,d\rc{cE\0o0]\0\rc%ۋ8wZ-\\{֋G/\\bp@1\0a1s!Ũ//]8~c\"ۋ2cΑm\"9q/\\^fQ~c_-\$i\"\0003fXqx#\09Z.i@F3tZH \rcKb\0j/Dj1IhavƩOZ4Zт#YE\0i.hHsX/F<.jb\0mV/d\\bE3T^(шcKFR]Xq6]hc6Eċ66hn\0005sn/dn`\r\"F-D`ՑN2Ybx#\\닇V3x1xFx\06bq!8|^ub-rq:%0pp#\06fǢŬd0qH\$@q-^B4\"\081/lnxϑG3:0tjh~@Ƽ3vHbG(e4gغq21-nX\"F<Q1\\j1Eǋ4m[nz7yh1#ގ/3\\xqKG6o1{FJ6lXq⣄u9r(1Gc\0f:rX#Ž\0i<\\}bF\0s7y2#uFe\">4i\n<{㑍ƉJ;]1#0J;4^DǮ4i(H#Ex/n1/ǡj6,l1t/\0005%0]xGG5!0rq2ޑNFPo\"4_1d%e 3s8G5 6[HcHjY;[辑b! y@\\q#WHN;cQ:-%.kXƑG͌1DfߑcWFl!0c Eܐ;lq\"F7\\\\Oq.T|\"?Ef9TyYѩSG1A\$f9R\n\"x>BHߤ\0:\$e1F?=3Tu)\nqb~<TαcH.m~CwHʱ#/I]~3^ф#>Y4^QjcK1\"8|6c\"B\"b4%G\0e\"/t1r1e!v2y<Ǡ8\\oђ#tѐ\rz@}Hby 1\\deGZ3~r)1ȿBl~H:dF-?k8qc(F͋K5|myc1<*@j1ž>IZQj2\$0hQVFT	\$Al~qڣȱ\$>\\p\rq\$/u%!Jq \$tEGN-Tq)\"Hʌ=X2-H8\\nRW\$H\"C\\_\0d\$f\".Du	'QzE&0toqjƿR@du##LLk*q\$*Gđi@TilE5r\\dI\"/Z0j\$Tz5Ld3o.Tq!1{9ZQbFwJ94n{(-82hu;\$-DkrsH#Y7\"/E	\$j^-]7[\"N\$W/]\$+1Ga/&IDn@\$!\$-k!Q)(N/\$tOKzPtX[\0Gw(*K\$v1c'G̞Ixd\nA8\\rXaIiNI%\$_6fQ#I5#Fغ#E⒕\"3\$IcHvR|QcE:RehEΏfK`8r.#Es0LRF!\nC\$`\$H?nPe!@F'/%N,hrF\$3tҀ!1<CQ%ÒJZf.6ōCԜ.[Bҿx\0NRn`Y\n%+NIMs:ùYdefB[nƹYmRגYCXjU+Vk,\0Pb@exVyT7u[Jȱ\nDeRmx&l\0)}J,\0IZƵ\$k!YbRe/Qk5.e5W`\0)Yv\"V\0\n%`YnաaxÆQ!,`\"	_.偩Ɩtm\$\"J֍v%M9j	斧*Kp֔;\\R 3(^:}|>µa-'U%w*#>@̬eJ;Pw/+5E\rjnd^[cΰuz\\ؐ1mi\"xp;P)#ؒ!A;	4a{`aV{KU8㨟0''o2yc̸9]K@җ^lBOr,du8?%gBYn+%ce\0ऱYr@f(]ּ\nbiznSS2GdBPj@(ȥ!-ve*c\04J炒,U	dej'TH]ԊG!)u֯үZB5̓W0\nRW\\Q j^r%l3,Yyf3&܎Q:ϵ2mR)T(KR0ʔ@YY:e3\r%T%XST.J\\0hąD!:uU\"Ło+7\"f'R\0J2S2#nm I劜\"X[ր} Jc9p0Q(U\0xDEW.L=<B0+)ZS V;\\I{5IA,dWu5Ew\n\$%ҁ2i_\$+O,XՑJg&JG%\\Jb.^LTFl薹]k#f@LGĐTٗH\"q1S̰jV(ΙZVzņ,G.1FgN;1ÊV5E5`\0Ct=F\nṛαK\0ۊ%D]Q\$\r\03J\\,͙<T4*.YKDQLS%,g<u0Uĉ*x(NYv!y	w4fdrGM \$^;)<P]D%%;jI0au^Jp[)v3RhRE\nL_#5|ܾm3P*\\Y51X	iN\$\"ah*KUV8u%&r˚5og;rMl[ƨgUq깚h|eO2f MlW2AP׹v~eDe3UӫlE62iUbUViI!\$iʭ&Z:xm!ņ.Ofwү!kݤ̓6b\"IJ]]:T6Vr}ǫ]U	ys7fMř3Y:T_Mw%3n\nz*3h	`UL,ۄ5vfÛ42_QhuD\no)ĜիM97foۼrWB~iTeyQTN\ndpr#M;4pt(;5	|ǂ',AV7ܔUA&RP\"yҷ)[n-3V,?s6p3fA9k|ɮSf*@5gɿ2}UݙHFl%p«IebeMSO\r[i3fLVruNA:%ry3Q_̸W.^Sl@&5Yl1}Vxgʅ^SnQ!:5ZiZCԈ:3qg%Dݪ{U3tZ`u%w:ZQ:QW f훿9Jpl)3xvK7b#X+J(hP*ӁΛ!הŏSLh*'\npBڪgNʝ8BuҪΌ8niIsUSI;vvڳUsR7Nu8H|ӷ̎8q+'`x9R	ծMaR8x)'!;UY֓sNIg:KTy3gYkܳn'LO(3w44lJw9\\hf(_~}9N\0b\"Y餃Th,ڞ@D\$I;eUn,O	Xg-+>ti'Gl%\08VBU1ye\0KT4mV2)\r]I/\rFXߨaG¹*>ERZ-)I\$:a\0Fybagw(_@v}iʳS^25DԳ	UROJH\\isfKNqiSgO\nF~|*@gR_Q<9sܬ3i+ؗ.Cw|y6aOY9ɖ\nԽ-([_}S]cS=YU-><\n<sOQ4F^}\0007uk(//5{L9\0&[<s\0&#@h3V}H*w+]'D&@ց]);TGe3\\nd\$:uN4ykt-dR!7e4(P!-94_PMGbıw6OSF)yh0+qT|+u+A?	T3.q41Te\n:P{T\nh?TAS*+u>\\ZY췢wEJ%sLdy+\rCߡ'Al,y3͗`	_*P ThKDV~5	0+,-?]3֍K`^I42(]w.r]\nYƨB	}ЋR g}:HJWP\"޵V\\<? >ܬ݆=:\n0\\+SfUU,WCֈOn΅.e9|RI'[/2QBn:I\ng9\r,R6Q\$X+>`\n)/_8Qi=v?5v\0 \nLGDmw\\F֌ѢdꟵ}s\"Yv|J*9h@XEU*(oQ]\$B,KTvAptCɃ\nC,/<ڙEW-VP=W*%K-Q`9	(59Ӏm)X@2T@\nSbdEδa+DX|U		F 2%5\njmW+xKV3#CTek&,ljbd7)ӓ\"\n+PbI@3ܵjUEs)Df뒃PZ3AΌ\nwTh𗲪ۘ4Z<uߩdqˊu(bKGnTﮈ]zf%#3IfS&}@D@++Ah\nUޥ|B;UmUEN!x21\0GmvH~HT)WYN\"k5vT#=ڥ<\n}#R3YHRIͳܦ;Rl1luB%TQJ*'E0idw,zͥ:\$;?j))ԏ\$32J}&[\$́;DnE״+0aZ{C (:O@hD\0`PTouF\rQvoܡ\$S+#7IzrpkDWFs9Q 1g#\0\\L\$3gXyy -3h!nX]+	ɝc\0\0b\0\r-{\0Q(Q\$s0m([RuV>+J[6J\0֗\\,K3.]a_\0RJ Ɨ`^ԶClRIK\n\$nŏKj\n~/mn].`ij#Kf:`\0錀67K▨zc\0/K/dFE\0aLdZ`JSʙ24@/(L0`ĩ_L]4ZhЩSDM4:cSRME4iSGEMj4zdթSFKL%4e%\$lKM21ڔiMV.ڔiLz/ۣӄM,`_imSgMƜjg59.9j_S.9_S.7r)%[2m8uTS3M:]3qnӱKN1|^kt\"HgKj-;zciӚ\r<_-iӸ\"֞U.iRڑkOF=:\\\$ZөMLE5xӻ_\"֜=<\0tS9OҞ1~iO>~q)F=6:~JP:=T)ƫPJ8@w*O5]>tT\n!\"6Y	)H/P3	/P~	Ӯ!\"Cj eNJ*%41QCZQjTBQ.\rE)\0004\$2SM+<jtj0,9Q}F\0\$sTaKΣ]Ecj*'KMMGxRT1#QꡥG5:zL4u6z\"j\"TKuN֣Gg\$jFSܨQ2H\"MT%RHz\$,wRe.\$rz)Ԧ-QJʪ@԰=R&/Iʕ1*]T7QD&өqN_(qc[TwQR崜J\0nT.956c܌SzH7R}Sr8N\"bTQ5MN#ES§-H7\"T_S}G̕?*yԩSP*5#܍T:]PʟC*ԉT:-K85CR--MȾH 'THHыTR,܋GTک-SJM*ԩUTکmMHM>gSD5MRHwU\"K8RڌU*-U*n¾TIR,tZYIUF51W)vk_KƫpJ5ZjůR4r\n^jICK}Uʓ_ԛO=NR*F-R%Wc\\aV>EYjdëUάWX5*ՋUyZ1kը7VR\\H5h*UUƧM[kvո3V}[(5WzոiBO1TV;[pRGu;T@0>\0/IW`]\08P]1m*ǍyUzmW|ݓ[֯]JшUZ*5\\jZ`Z5~EW4Z5hQ^cXZS1oVU&T5}cU^Xdm*kUuSfG=[jsտXKc\niRHi#uWtXcĹUrڢUZՇNEX4udEeV^KnV8sX¥f/hJ-J]ӂzO<Eh\$勓\0K<bw>N\")]b	+z.cS.iF	QNQV*O[XnxP	koN}<aOIߓhT;r񉉤VD6Q;z]j~':[Iv7^ʑjw[ņ:u Ds#\\w<n|*hmKv;Y҈3]^#ZjgyjħY,%;3.W\"\$3>gڜϦVTZjhYjkD*!h&Xzi+GV\"Z:Ҥ+NoGZjji]ʞkO_֬ԐmjIt#[j\rnnZ_,gĚ:9[L2W=T0f\0PU6\ns%7isY?u3nb5X|G~l&kMyS)]ܭrٸ?}u'n0W-ιbǪk?vQ7}p\nٮZ*9)5ޕZW-ZB:㫊W\0WZfpGpٮ:FpUSN/\\%s9S{ 8Zasۓ+N^9M{P5 QJy;zYV 3:DI+19M;V\rQ{ծ+FCLĹNԈ\\)\$iN'\0P]X^s1f&\"'<O̡L\0\"@%6UA1i(z݁\rՂbZ+IQO3\r=*ĉ)!`h,ЫmGPCAٲA(ZŰ%t,h/ikXEJ6IDȬ\"\naU- \nvy_ګk	aB<VD/Pa)9L(Z8vvùk	oZXk|&.東C`1]7&ę+HCBcXB7xX|10a6ubpJLǅ(mbl8I*R@tk0xX; al]4stŪ0c'l`8M8D4w`p?@706g̈~K\r Pbh\"&\nqPD\$(0QP<Q!Xx5R`w/22# `1/܁\r:²B7V7ZgMYH3 b	ZJGwgl^-R-!l7̲Lư<1 QC/ղh)W6C	*d6]VK!m05G\$R4=Cw&[YPdɚ')VK,5e\rK+1X)be)uF2A#E&g~eyfp5lYlԜ5\nm}`(M Pl9Yf]Vl-4é>`/fPEi\0kv\0fhS0&¦lͼ#fu5	i%:Fd9؀G<	{}s[7\0Ξ3ft:+.Ȕp>ձ@!Pas6q,1bǬŋZK-ar`?RxX鑡V#Ĥz; DH16D`Y`RP֋>-!\$~π`>h01&\0hIwlZ\$\\\r8~,\no_B2Da1ǩ=v<kFp``kBF6 hT T֎	@?dr剀JH@1Gdnw%JG0bTf]m(kqg\\ш3vk'^dAX~WVs*ʱdM@?}6\\m9<iݧԬh^s}-[Ksqb-OORm8\$yw##@❷\0ؤ 5F7X\n|J/-SW!f 0,wD4١RUTZX=`W\$@ԥ(XGҊa>*Y\n\n![mj0,muW@ FX=(b<!\n\"83'(R\n>@Wr!LHk\rE\nW\r'FH\$m=ۥ{LY&_\0#䔀[9\0\"@8iK0lp\ng'qbFycl@9(#JUݲ{io.{ͳ4V́VnFxz Qޞ\$kSa~ʨ0s@%y@5HNͦ@x#	ܫ /\\?<hڂIT:3\n%");}else{header("Content-Type: image/gif");switch($_GET["file"]){case"plus.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0!M*)o) qe#L\0;";break;case"cross.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0##\naFo~y._wa1JGL6]\0\0;";break;case"up.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 MQN\n}a8yaŶ\0\0;";break;case"down.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 M*)[W\\L&ٜƶ\0\0;";break;case"arrow.gif":echo"GIF89a\0\n\0\0\0!\0\0\0,\0\0\0\0\0\n\0\0iӲ޻\0\0;";break;}}exit;}if($_GET["script"]=="version"){$jd=file_open_lock(get_temp_dir()."/adminer.version");if($jd)file_write_unlock($jd,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}global$b,$g,$m,$fc,$nc,$xc,$n,$ld,$rd,$ba,$Qd,$x,$ca,$me,$nf,$Yf,$Dh,$wd,$ki,$qi,$zi,$Fi,$ia;if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];$ba=($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure");@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");$Lf=array(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",$ba);if(version_compare(PHP_VERSION,'5.2.0')>=0)$Lf[]=true;call_user_func_array('session_set_cookie_params',$Lf);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$Wc);if(get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("zend.ze1_compatibility_mode",false);@ini_set("precision",15);$me=array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ko'=>'한국어','lt'=>'Lietuvių','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);function
get_lang(){global$ca;return$ca;}function
lang($u,$ef=null){if(is_string($u)){$bg=array_search($u,get_translations("en"));if($bg!==false)$u=$bg;}global$ca,$qi;$pi=($qi[$u]?$qi[$u]:$u);if(is_array($pi)){$bg=($ef==1?0:($ca=='cs'||$ca=='sk'?($ef&&$ef<5?1:2):($ca=='fr'?(!$ef?0:1):($ca=='pl'?($ef%10>1&&$ef%10<5&&$ef/10%10!=1?1:2):($ca=='sl'?($ef%100==1?0:($ef%100==2?1:($ef%100==3||$ef%100==4?2:3))):($ca=='lt'?($ef%10==1&&$ef%100!=11?0:($ef%10>1&&$ef/10%10!=1?1:2)):($ca=='bs'||$ca=='ru'||$ca=='sr'||$ca=='uk'?($ef%10==1&&$ef%100!=11?0:($ef%10>1&&$ef%10<5&&$ef/10%10!=1?1:2)):1)))))));$pi=$pi[$bg];}$Fa=func_get_args();array_shift($Fa);$gd=str_replace("%d","%s",$pi);if($gd!=$pi)$Fa[0]=format_number($ef);return
vsprintf($gd,$Fa);}function
switch_lang(){global$ca,$me;echo"<form action='' method='post'>\n<div id='lang'>",lang(19).": ".html_select("lang",$me,$ca,"this.form.submit();")," <input type='submit' value='".lang(20)."' class='hidden'>\n","<input type='hidden' name='token' value='".get_token()."'>\n";echo"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];$_SESSION["translations"]=array();redirect(remove_from_uri());}$ca="en";if(isset($me[$_COOKIE["adminer_lang"]])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ca=$_COOKIE["adminer_lang"];}elseif(isset($me[$_SESSION["lang"]]))$ca=$_SESSION["lang"];else{$va=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$Ce,PREG_SET_ORDER);foreach($Ce
as$B)$va[$B[1]]=(isset($B[3])?$B[3]:1);arsort($va);foreach($va
as$y=>$rg){if(isset($me[$y])){$ca=$y;break;}$y=preg_replace('~-.*~','',$y);if(!isset($va[$y])&&isset($me[$y])){$ca=$y;break;}}}$qi=$_SESSION["translations"];if($_SESSION["translations_version"]!=131114700){$qi=array();$_SESSION["translations_version"]=131114700;}function
get_translations($le){switch($le){case"en":$f="A9Dy@s:G(ff	:Sa2\"1..L'Im#s,KOP#I@%9i4o2ύ,9%Pb2ar\n2NC(r41C`(:Eb9Ai:&㙔yFY\r\n 8ZS=\$A`=܌0\ndF	n:Zΰ)QmwOmfpQ΂qaį#qw7SX3o\n>ZMzis;̒_:#|@46:\r-z|(j*0:-h/̸8)+r^1/Лη,ZӈKX9,p:>#(6qCI|Ȣ,(y ,	%b{ʢ9B)B+1>P޵\r62LP2\r\\*Jb=m1jHO\$4 jFoF4 #0z\r8a^\\N-|єp2\r:x7<ص^0#2jk6@ΎA&2u\n1lĠ+s	<M]l&!b_2Oz\ra717i\rӊvèb3c2N1\0S<=PȤϭc%_accC\n\"`@_d7([Vn69h8k/k˯K,)+Z\"󰌻\"MF'iʌB\r06NRLDBލMp򍯖tF^s1t!ͺ\np7}K`O-d>O6tPc_W6WPpҐb#2x#\"2I]xPLtZP*1n}\\گ7ԫ @}I1T.AE\rWa(2Ài !Hxu%Uj\\(W*S\niN)@\"rTTrVm0h F70=4\nzw=G>nU'xvT12^	'؍	am;ET*{-0FPiaKyHGMA\0P	A8OA@\$'I(^߱Ln\"Tb|h91&pt\rlp66bTK	q0\rm\nDa\$%8ᐟM`>ǌH0I\"rC(K?怀fTI!&FdWׁi!<)F^R&8clS\$INprd\$0cICig0̑@C\nm\$ &H0T9p#z^&3 H5lZNI(*BxNT(@(\n \"Pi`^FN;B\\ӄČO,le	p	Ho5Drv\0TV6Rw;};T10gR1c`lHc'@?Bh<OwP0Dr#Gtt<VLVB@C%^+SEbFa%MN-s([hyD쐭uJصxZ-w92\n	'2PZ-r*D7^\r/!]¢S4!^ ?7z@@ o~=\"x6]B`ú	fzv' A\"qΟ0!kYAJC̼\r߈rȘ#]/¨/ej]rյIIĦ&Q	w8:G.M06rJ`(+Po')1mpHGdŒa4lXz\09eg*j@ËhI3œvYyȔXU[ɻ/PCL*lmorԔ5lp\\f3cو,!aL2S{r+˺TK(v@}azğVx氧*\rd3In͢-\\C%sumM]mo2֞=+/>?84lۘMΚ'iE0/N]d4bdMrA&,X:B\0\\^oꎠON}[?^+ɮҀAJg)\\	vny{NK){]67k wd0Q<P˧bI#:R͋\nfOIt>y+oke9I_i;+ܟ+k|`Wy)x7흉wVex!~\$j<	y29ȔI`/NhNTBP%t&. OZDgo20&fV@!#,b,&6J0Renpivj0Xe#rнV	*o	\n	0J8D!\$\nF\ny\n/pN{\0n\r/%\0<D\0K\0E@zCN]<P\rbL\"}O7\rN<7Lu.\"	q%ՐꌛtmNod \rV\0`eܢ0sz\r sbA\"ph@\npG\\.̓ZLL-,7\r|'0pxEoqzإ&6\r.־0V4prJV\$fKC\n\n'Pabڂ%brRmR5\"#/\nR%2&6\$⸍#8o+/NuqC/LN@vdvy'L0O`%trRZ\"\"vlL=	,hÓcT3eJL2@,P6oJf\"-LDD]\$\"/)[\$\r/\\";break;case"ar":$f="CPl*\r,&\nA(J.0Se\\\rb@0,\nQ,l)µAj_1CMeS\ng@OgXDM)0cAn8e*y#au4 Ir*;rSUdJ	}*zU@X;ai1l(n[ydu'c(oFe3Nbp2NSӳ:LZzP\\bu.[Q`u	!Jy&2(gTSњMx5g5KK¦0ʀ(7\rm87(9\rf\"7N9 4x荶x;#\"2ɰW\"J\nB'hkūbDi\\@pyf9V?TXWF{3)\"W9|eRhUҪ1P>\"o{\"7^pL\n7OM*O<7cp4RflNSJ\\EVJ+#܇Jr >J(ꆶ\$(RMvGIťrWj|\"v< k(3\r1T[nڰh޳\02\0yw3:x\riPHp_pBJ`|6-+3A#kuF\r^0zCܪsjQ8u,15XrZTƖn\"@P0Cs3(Z(f\$:YkU<:0ŋlSRiZ)vkR<J#[q77WSIY<ьlMTK#oci@c7Sb!jh;[3!{cT\\!>6}TTo1lkȦg[HrǙ`yٍr1a]7(vpý6+qyj͗g< Bld5=r@\r(o6-3\n~3X ydA<\0ꢃ\\!\09k:(ZC8a=@!@pu7`9Ih) A\n\$\n\\j&Hh˒Ko!+4J\$(xYtrHJƗ9@͐(\\8 Z!/PƣTXdZЯC\"I@FəAOeC\\Nv0gIp ]X@aAY-\$n3bW\"^K/X`݄܁sbICX	!8C#UͬG!!\r\nC*.@ʒjFbL h4zO(@cF8 i9aC&+\r7(uiBa1̙[sGUa|+n̍HhC`%7\$!SLO.9ja6\$l]D7zSLeełj&¥G+~+mG^(e#V\\_iO?j|&a\$>CK[[m|lqoddTZn)=aCGΰ\\\n<)BD^tm)BڑmgQ-G<fy&&NP[~3\0vvi.&\0V]*iqukOgAG㣢+eZ!96,nA<'\0 A\n\rЈB`Ej~:NbDҥ)K\0/g([S0P.͒|\\.)1H<81ID)rA/BԢ	\\J\rs_\\:Xem\"56NWO5@wẃ,G\r \njg5J~(`aR\\Bz,VjNƗ+\"^m'wDS[yo:|sbˆ\\cgi\$ƆMÑ!iC\0P \0S\r!SUǆHCၢ޷Ee@ƶkC(w&gv1wܻI)RzMcSNIJ]̜a6uGw'S3MVqʄ@V)GϦ.Pgk范?D>ң0ʕg@BHiH1Xp'\$?|`FF5{޺FU&,#D /XAf-bPk/-!6.F<)ae6t\\Rro!U*au-;1Hމ\n	G\$yzUǕA	mH<yS\$Nt,-uU<3	Oh+,5\";:XVA h9B؟\rؗ	x[Frҋd	4I?\$.G~FEb'ip	\0N)N^0F\"lgR#Gv\"-lMfA\n)~T.g,ďmՐ8K`3?G/lIʘ/P:n @RSPi\0ϬiLCgWjr#|lˏ\n}0vh\rPGP\0jp{Pz\0xzp|2EB&\$'\\¶pB^e+1nzlo\$mo&L߱QD8V\"\rPݪE\r1#	f&g#8ft^b ~P~܎rlmL0y(ip!qMQl\$Na\\ߑr\n?/-W&1OhlB\"qdh.Qf{\$*ZqS\"\$2@RJgTP\$j9Fv\"oFȔ\\Tx \"oL\$+1(O&r\"㒧5%+*\"#V/2R}+cG2-r]-\"ɐMF2eĔ?+R/02*/0 -o-E,IreIBU2<H3PS3\"Ow33S4S4snJz2H\"me/p eH1*X\$8_#eQ9e:yG+îmR|>ld[)-\rGFl1ҖV¨l}=n<'<O:&8=hz\rVh:`P]ox@Z]bf\r관@h@\npOBov*x\$nf@B.-wffqU!RwBze|`E\0DUC \rc\\TE.Re4+>1rFgǯ-ȣtOP2,p\n\n6cD4BZ\rŤz.Ttøļ+&MbPQ &tBU2ʈ\\ZU[:^d8lu0:O*4ɔ1|而<LȌ>\\SRՕ`*/%D	\0@	t\n`";break;case"bg":$f="P\rE@4!AwhZ(&~\nfaN`D4\"]4\r;Ae2a.arp@ד|.W.X4FP\$hRs}@ЗpДB4sE΢7f&E,iX\nFC1l7cMEo)_G_<Gӭ},k놊qPX}F+97iZ贚iQ_aZ*n^S9YV~]X\\R6}j}	l4v=3	\0@D|¤[^]#s.3d\0*X7p@2C9( :#9\07A8\\z8Fcm X4;r'HS26A>¦65	ܸkJ&j\"K9{.-^:*U?+*>S3z>J&SK&hR&:ɒ>IJLHHEq8ZVs[2Ø7ثέj/tZ.Om5cCmҨLX#ĳ8QBŤC*5\\ ʰ2\rHFuG#pφF|cƣ:\rx!9Dd#@2D49Ax^;pÀ`Q@]}y(2\r\\kXpx!n9)-	;%^\rjʣ]U8{ā{vM;@O;DKbUr\n7`C:<kT`O)(3J>M+{PHhtT4 SP3	8iq~c+3C%~#po	ܚ8+yqjL\"=wVHy4G(:ں,yޭ\"#wDX\nARe+n@ދn{%4׉Je;d&yVqAL(!)?FLA.Pǹfx!Bpۡpn+\n%[{Zqa`9VH!wt4H4(L	\$\\x/Wsaoƥܸ%biTA!DȔ4&l6@N;l/K~%È\0S4\r4h<SHQ&*3Ӓ|ȡd4/Is0x8 sf2LWQ0AY&Wy\nM=\nͩ]zʉ>Y\$Wi,KDPҰO*|2wK.8	)&<LXKCth*x=\"PR]ؖmI9(P4BrՈ5XrId,`@ eLDE_+t9\"c!\r)i1'JI`Tb@SOoR'#PefwRVY{1fl՛wH@hA,%CIih5~5i)T44>#χw4\\O&mUڽ^<c{*U{NlWѷ*u(Xm3Y\05CfXth9V0u7vkhq;l+ẙa9g\$`C p/lŢ\n.@P>ri\0(-A	*(\rd00Lؕ\r9Ug!#d{ Ȓ8Mx .`zE%DRZ祠:J&;K.='7q	MniR2Sº;e2-g<U'2h?abїgAN4/I%>@\$+HOD\\lZ%HXbM	~IvRIyŧ%R6ǎк&,\\XAhq\0F\n.ɂK\\b~椥zPkg9bnrL,jHbB\n+E=cV]\\}*ճF8Nh	b;Ո,\r;V 'w]CGpYG	ߒ\rzd,_\n%}/J7sCk?ɶf{1>iǹU3!:ٮOZG:8`;ؐV2nr/4JXl/y{OuRG\0\$b'B노c2sA2\rJ<[xVs=ڿp!h!񢣈{< 	RPncd#d8؆\rva]*B7m#a~Q\n\"y!=]^FDWk3v.,txH>:\\5gFByɼ/t5@\n 	\0@ E\0G&el0Gza@XdT%_s6@#*8hsPFQ(Fk*iJ)'\"I7xD+<qE+Z]ByN6GNl9؄]#lI'q~{LP+/qmQoK\rmTo-pjzPË	pn5,Ρ|.!</[Nt%6LM%ώ֑DZ	yi3 HH\$	czՂ>;M3-V(Ɔ@Brg@Bj辗|M\"bBup]B|jPNTt{\"b+XR]b.9oQ#QsN]\rO2o]Mw¼(GO)DJLn%\\8 E@ூ/E282j(A4DE\$\$\$ȴlѬi7GLb(HR+F,PxT\0S#']H-R- #.2ІrԎNN2Q,an2P]-r%q2q\"0=.0ʰΝ*Rl7\"-n-̖1/\rk1S*~AsE2R2ºS\"mQ6\"Ԩ`x&PL#%5	;6\r7\rI!77a80Ip̰r+\nN*P;5S%.e;ЃW*γ^ق24S炣4+mʾۧbwD B<(|^:c@}BlLȥ8k:]J3@fĄ)	~e.NxwR<= 3nC\rOMaDޏ=S!I#0HQ-7<s\0]>,Lŕ\"`ttQK܁2g<cKgt̡323Ij\$t)%J>҄)aGx4O'K{3P\"A/.P:ar7'd	6K;e	:3<5<R3Td1JγP3V6Ա4P/Pqzh?_Gu~Rmo:HO4	XG4'wYUKWtI\$BQNJQ5J\\]%[]lQW\\^lNx,_+ڱՌMk^M46Y97u\\bJI\$IUpx3NuZIXPu6*lH8vM`AMAJIUh!V{fϟg_TWfgϳZcid-M[tgS9dgg.5_Ķ 64viq~1cYb \$)Big7@ud\"APyӟqrSY)wr5Y;Q+#pD?u\$.	fQqV.\n\r)u\nqTs\"	usb:bb\ngcu8AVVwBQֶBE\0\npIkп	3mIB~7m8Tw4h}]s2i4%1mj# Vm>#la^ş:YըĤ+N\"tXXjrW5o>fQ%JoxwD-dTJyn+ڃ(Ht| ՗1)¸ۨ4R)q\$Y4kX|QZ7=F4dP xnIeؓjLؿ8!DJ|5C;5rWX\0A%a,m-y	H?XSd]on[\$9NtbHJn9ogZ8huOXAWbI576P_H\rb\n#3Ԏb/\"/6>r[_c'/ewMU?W)t#";break;case"bn":$f="S)\nt]\0_ 	XD)L@4l5BQp 9\n\0,hSE0ba%. H\0.b2nDe*DM,OJÐvх\$:IKg5U4L	Nd!u>&a\\@'JxS4PDz.SE<OSkbOafhb\0Br)QWE{KPP~9\\l*_W	7ɼ 4NQ 8'cIg2O9d0<CA:#ܺ%35!nnJmk,q@ᭋ(n+L9xkI2L\0I#Vܦ#`B4: ,X2,(_)7*\npp@2C9.#\0#2\r78M:c2@L S6\\4Gʂ\0/n:&.Htļ/02TgPEt̥L,L5HLGj%Rt-I04=XK\$GfJzR\$a`(+b0Ȉ@/rMXvN7cH~Q(L\$wKRWF5\",ԕ_-eRS8u*P\nِÕ8XTAԩJP2\rdO>s#߲nNcKOBPÐ4C(C@:t9}8M8^2}9д8^.A7`77x`(gd7Dz·+/FQ1A8ՓIiҮ\")E/)T9tUԱM/i78<5~B9\r`ΐ%=kO\n@ˢ!kR{{JTL84sEq\\Ƕk0]u6`Cb}6PʶÛwnx%C|d\rd^9Us@AaJ,0⭶0|Tծr1)sn,!\$D**&\n#p\n@l>kА0HQ	JjVh٢uBh1rgqpnbaI0txQ1&1 |MC	SHLɎ+(T,Y#y%hmwqE% StHw`>M7S\${%:&QǄ BA<EsD wN<3`ϔK8İS1Inyq<\0Ji\0:Lm:)C8aIz&䐧) Y-@haEq+hBNSs;@Ԭ1Y\nf>N,9N;鱰5C#?lGw>O:=g\"I-l-HWtVxD8!nPV(	47 rhN	SZk4U[Mm\r6܃tn6_k7\nChp=Jx ]KTC[PIuZmCduՅvRUTle8<&@CdZG8&yia?O'=\") s6;\riCLj\$:bQ\n4)Uq;ROΘ \n ([]\r9eQ\${`Ar46BYJc&,5eUiָ{+P:#\r<]@~MJLhy]J&,GD&x.Y[ #+(cH){Eh]\\ͽk;f%]2b3RM{d6JszcI'y|6P}ɸ6&|;^|^ςY	D;0/0O\naPI@UhÓ9\\`L< 9xEHhsz)EVEV(F\0t)^l^ؿ;on<1 ؜ƴh4ն֌!j+4DXu2ee-AԲp_neeƸ+XGd#/\$PY%>H2iaH'm9/P2rŲS\nx%E!WZۜSП_DeQ@3VQ?4ULWGc34\nls*':=UTy!F*тfDQL95*/QL;Ax24Ru:]N<%q9V)_!r6|猤>J%˖g7]z}3JI\r!CB`xS<zTs}Q&d57=;\"eǴ~_}~ tEKܔS5sK\nlt820%\rZmh'ץR\0GPoyLԮE@ĸc0J.d10)N/rU<bR0f:zHizɁ \n`\rL`OcQ\0ǞLvb6{@^:z{D\rapTE\0Ä(t\nf\n.0w䕇bvB(Y/йi\nLL.#bxP.psM2;P(p:DD*8VuB\rAHQ{N@JqTi`ܭM\$(-ZQ,T|0x-&N ˀLi\nm*?rܣBǉs!w!L%B\0R.!>/`yrx\";,nc!X2l-5P\$p`7O66V/B/%`F\$p@jwvc2q󧚑\n즮-ΩjiRR#sG1ߣnP1 Ei+1+w,RqBAm+Q -jw*ϕ+-r\rg0	K.v/qKk1R)v s%1*U*i0#ncj}PpR`H1*j#P\"n`sR*@7Ml#34qn⯤ZF:,1Y)8)+5hN\0Pp74KRҎV\$*/Tr?.N\\,)Rn \$+23+qQ>O37A;?Γ)8r!;rR>%0s3S\r?r\0V2/5D 1'A[/-F)Ր2C(=E-(Go5D.wBqXtm=,'GbAtuIq[o3\$<:EKrOKCHR,>+TT}AFt[IWtLE/^4tNVfpZrTdC\nIK->s\$BBLxLH3!!MT/UK(W\$;:QB!Up}\rI!(84\$hQ\$]O-OWΣw儐ޓʒb']; SSu үPU!ORK6]a57auBU0Τ'50EuL1R-oZCnxub6B}dmdiBu2u	/Iceo_=QʕVa5R)J4CL&h[!/꥽G#1\0hR)/)-ISuQP0-AlgA)6R;53fEI2\$QhmLP,A(6H{eeOiF*&jGn0Swfv.w\$CWq\rUqnos]z(cV'J+~ OcP/mBsR3,2uaԯoWkaNṯuQpPHVjLTbwWwwqtWUxHA\nCbr5ecSlYyvY{-{t7y'GB1^.oL-uw/	%\n|?VCv@eR+p7yYnX\r7cAbbW_vzw]X}6zTrVVF(H?lc|XxY5z3g3e'u/n4ш(}7-GX^#<8@*:sNPU)9}x!aQASN|UVwoToe5*,QbR!JsZ)QR{)_**B	4N8 `ƛ\r`@ƴh?i\r\r ̝.ۀ\nZNIs\rNFk8oc\"Tݘ|iWс+/C18ƸUl̉dB	M\0QVGeHQ7A~E~*hgN`2\\'Çw1Gpj\0Zn㐪N/b6oAxB-#5`z(Ë&㵙x8S3P6y^F1y*Ӈ/Tx2Mۃy87_`aD`^<#ǖ@@\ngQ:@C	ap\"\0r-<(R3/W9T)M!Z13؊\"`G.V:QSMN\nƒ\r8DX-)<ΙӃ`)`/d_UiN5W~+inT6~TÈw8}Pgk#VDVh7w	\0@	t\n`";break;case"bs":$f="D0\reLS?	E34S6MƨAt7ptp@u9xN0V\"d7dp؈LAHa)̅.RL	p7LX\nFC1l7AGn7(UlbeēѴ>4)yFY\n,΢Af -e3Nw|H\r]ŧ43XݣwA!D6eo7Y>9q\$iMpVtbq\$٤\n%LITk)乪0h4	\n\n:\n:4P ;c\"\\&H\ro4x@,\nlEj+)\nCr5ү/~;.j&f)|0B87,ŭZ'ģ89#|	=\rQ9l:br܀\n@F,\nhԣ4cS=,##MBB1S&!@43Ul\"9pXɌD49Ax^;ځpQ(\\{(9xDj(26|KR(FRp+;25`24Qӌfb-W{,Th0(91=n5HK&+]eJL\r#x\r \0ZѭJ#0:-%B0l;I4`058ɲ\nYH+\rCjj1\$NF5.5hvChӱ͍Ӣ∙K<ްN_an=3wFKn#]fPYPvV\"')0*cʝ')x¶9+/t P|ƣ@,H\r0́ppc^C3P A3PmSh0RKpe2X@FsX)Rv̢ x.\n2Gt^IՐg\nQՆӲt;bŐh\"Cƽ.\nP\n\"]NJ!@QIWr'\0.X'֊Z^\"%'D칗@IrFHz]WA&*hD.\\]D,\rfm|STסU;t` 0f U?\0f	,]\"@s&03&wZi.̗N	xL\$J84BP\n;ReUO.iث84ԢuXj͢	U\0007xKy=p^?dxaI|=JbH`zwk4QJ'U7Ifj̘qc\"MMY͕\\&)X4Jq\n<)I񩜨D\$x]r8\r#\"lBL9QUȎǆi).}3u6޵դ!@)\\i*O<aũ>[%\0n[=*\rd4bBml63p \n@\"A\0(4d\rȢPLҲ#ap E	{+LW.\0i9\rY]Kj]-(\"8!|]ppq'A7\n`	qDP:gY}pZv10d=Kf}g{<I<l2\nnvb,%>ȼwAa6-'rYBlP}OVQ53aB{ϒ\nc(`0쐂M/l9a˧t(o<yA{x	r.q<(e퉙L`娨1wtqݤU(ic\rB߈%o%\$<PNO013_'F\n\nMlnۡ\\dy=QaP*J_h!\$KBe*Xfb ap@Rd3{qMlb\$Ģ;lk_LKMĭ43~\$*8Xݽ<i2 w\nCx)oz4싄2.EIkM#mB8o[x_1[xsN`. ;sg4n0 ħwebr>HJX	ZUhI1#CsL\\63V@%q섉r\r.-4a\r}	Tu\"m.΀H>gOK*cc=`zsk8'\\)j\nF\\*9~}{?Tsހs0[s\\0&Z)4W{pLAF]\nƻVn)XĄI0xptJ:fP.˚CL\"/PEL(b49l\rHp{L.'V%͢MK2Jp6x0@Jn 'Otւ~m\$>pv(pwO0\"M	C*pP8r\rж#M3/'ƵPZ9tB:'gt!SC6mc8{	) 0xI\\/o .g EBFq:иKZMD'\rn,DO#\rLbpc)\rϋ_lm&8o\"oQMsH\$&pn(cRcSB.Ec`hmeH2g	O%.ѱ,ᱸ&0f\"-Vm^kg!*0(aKI>D%N\$ɍ	T/\r1#!ǝd8g|%ą %8J(=\$g:#%H~MKc ~	c1(G+r7I*\r8&I~>%!Y'RPCi.1C=҅p.2gg	 Hd1T3 h1<\r2@*`4&^1F7 Q0SX'&6B 6d\rVr/1qB\\0\"PB	\npM-ֹ\n7M	d\$ 3\n<B\"6jjz\0ac\r|+#.>\"c6cϦdj+TdD\r\nS -hNgdXj-b6Q\0zCDWE#?vog_<fuBSE<qqGTD>\r1TF(1*lu:3qT^Dpp<xKQ0\rDCd2΋`4|`\"~D#n1Շ-2l	@3b'YBP#.	\$1 @8/I";break;case"ca":$f="E9je3NCP\\33ADis9LF(d5MC	@e6Ɠrd`gIhpL9Q*K5L S,W-\r<e4&\"Pb2ar\n1eyg4&Q:h4\rC MXa+\\>RLK&v3épt0Y\$l1\"P d\$Ě`o9>U^y==\n)n+OoM|*uNr9]x{d3jP(c2&\"::\0\rrh(8p\r#{\$j#Ri*hB8BDJ4hn{K !/28,\$ #@:.j0`@ʨ4UP&J)t9I09˰!S2!@Ԛ\$H4Z&fSM<ը#P2&:M\0c|BD\n0cB7\"X44WAÐD49Ax^;ہr?Vr3_HJ|63.xB)@\\+\"Ij/E`N:!L%l.5\$7┵21,[.+y& @1-yD\rڽG)CJlM[oBnx3,T\n;/cP#T/9C;=\\TTRh8b;\rH6\rhe;L	]\r3&ejmTRe2RDVOZLV22\0(;SC 83{`l>(}Ҁw/h[\n\rk^F*P<V̇r2yuOYI9K=0MJx3C;qUOW	n(h0tF1a!\$2 aᄼcj9bY) C@?n5Ĕeb;o7*rx_3AW&Bx*<#%,Q@\0د&\$Mip\r!@ Sxcy7t cXeYg[Kp;X^W\n\\rc`!gn#>L1fMC!8)RrF vĜr:\$A2su\\/s찜b#\09D˃fh\\ܠdXF:Q\n2L:p˘#2a2Deu8\n@P \$AQ(e*oq0:XMqFTjVna;\$q8җТt9AĖCZ0:6\nEQh hTBLBI&2ݢQT~iNB ,3dO\naP)O4lJ)Ջ	I3f'1Q	Y	]QQB])Z\0'Ҧe[Jzr5Cx:M\$V	%[xNT(@+A\"n	OSO圳 _XȁC(I,'h85\$1:띓z}nGTyO\r<X!<Vl)<RU-ove\$Zּ׺(wu#޿θ&'bH\rcuS\\dQ\0\$+:,`:L%0%B)}b3gbciQG <BA㴀nCG*\r\$dܘKȌP_C{f@aX+v,zWM%y97d@fй*꾵Dsbss#Sˈ&qzܐI4whiB%knC	ɫcd(³@B=#!NmH3@^k.|2=6bMQ2\\0־FY}\$5; NPTN1B|l>H*!sWfYDZFi&xDF\r.-m}L-?!DEH+\n\0&pɃuR\\\"L(Dлh;˸Iur(7 qQ/ULB6&~]TJw@0c@M\n:)BCb0Փ) b5S}7酑8x)I4 Vx3GLM	ߧܛ櫾2S^x܉7N.a\\\"TH`F6H-\$;`\nOkĎNC֗Tk>cf[>H8e:`@+XC )I>+␬d9g	Oa%`wOlNMc\0oK(/v\0	{&w5-vw-7pMB/MЦ/mpN6H0Z\rI7C\04P\$xjj-<p(T9\00001	\n0&Cd6B.D0& AZ4ⲹE9Cd2K`Pp(h,8)Z^%0hHpdzoaG(dI\rϠ!	xf2!SQ?\np.F0*>{BJ7/DaqgC1rfX1dv;M(Єzʹ&jLГ0W9y1u\0Po|vG.ba%t1ƏG%FTV?1ÜD2VѬ ;vxr	 P\n!,\"!1\"S\r)\$|N͒Xr>2P&ѭ?Qj'B?'i~d#,Ҁ2@vzQqD2{'+\"%Qo+& ?ɼ? U*nCb\$\nf)Z.юR&ئ\\J\$2+p>f 1\nPNt Rd\rV,WRj\\& ybjB\nH,`Z#W,/\\ِg2SxA3}\nyL&Fq->%l	1C<\"1m(PSI2f<\$©/rxp^:6!=r;1fx'zVDHmӌl7&L9/6FBB&EALT\n(BcyB\0>үA461T| 5^D&̶+>f(4)DLbdpq\$DlGO|d0&\r\"jVDl*W\0gKE<UBC=*e:x2@\$δ!3D{\\8Lt2T+\".GJE1^@U 	\0t	@\n`";break;case"cs":$f="O8'c!~\nfaN2\rC2i6Qh90'Hib7ii6ȍA;͆Y@v2\r&yHsJGQ8%9e:L:e2Zt@\nFC1l7AP4Tت;j\nbdWeHa1M̬Ne^/J-{JplPDle2bcu:F\rbʻP77LDn[?j1F7I61T7r{FE3iǓ^0bbp@c4{2&\0r\"JZ\r(挥b䢦k:CP)z=\n 1c(*\n99*^:42Ya8 QF&X?|\$߸\n!\r)<iRB87x4Ƃ5/jP'#dάp0c+0<<J\0	R3\$?\0\n4;ގqB.8RD'2\r@HHLȭxf!\0=Ap~0z\r8a^\\0ՕrTx9ㄜ9HJ|;&A(K1^0Xn=}#C{S5](7CkH770a&޶l:[7#0C*%0N[eY蹼h8*GP.'NLB`	02ˣs+e&B&7\rj=07\rq3c;_|\rc\$D\r#[:\r6	\"\"G_1ytgQ/=?\n\"bn˕ l#(1l8JtB=9!b;AH<}R״&\$-*	#l\nňǦw.sMb ~<;`DCJ3<3%MM24pVN@[\0h#DI2 S*,S9ա~hn6jI\0\r@XHA9vȑA`a`렄\03`0~BEl-DCg3DD6h/K'!0p ~νCm0M.	dF#Hv8\\1ML\$7I\nʯ!e hs@[Pie_KFNCQSAJl7~Ò![xv:@V(btlESDMa\"	HҜʣV\\YEiUC[	o%¸zp'7.C;jɰ|y)Ad\0M#JPDw\$'TV\\YG\0 b9q6v#b6CPj\"J*(N2@IYy/sH!2Uu?}3GL+2Rq@\$\0AMi\"\0RT\rLF@[54J\\r@TzVtnW҃YJ \"\"\"A-R^g	],+	@5!iKlÚM6I=n4DUȒF(UD-QE消,xBO\naQ&UBg`i&S:׋{a)x3Nƥ;V((,7:II9V\rǢGm\r`S0zgBDF,%a4wm-u_DcF)E,CO.0pmA;vP qtW\$일8Sg\$Đ@&:6\n3ϒ\n46g_\n'm0\$dd{yy`'Fz3*QϴxxzA\0t,\ni:cjG	7?OYRT\ntP4݄.\0)sN͗9cJjK[daɡD[x.ݍDRZ<5\0PZwKc3&~1ڧ]m;`#\\\0\nؑ}\rE؝36w\"s!29\$^ ֔h	*@AW䚢ZAqg'\"/+>7`̲ۖs t'Ya6A}dc|4e]_ۢGͺ&T\r1;˰g\r:3/Dp3=4&ed;S=e^ջT}q.ϔ7@?=m(NZ}ؤ^Vw@zb]D)Ê@;RP>\0P̀)>IŊs{`[\r%q?t2&cz;dpyN2u~Lc^ր<*'p'ch\0'}.4-4Ħ:0dcx*kMGIf#z*\nF H(K wnČB'`d\0kH-+)θJfWm+/gƀ`@ń,;,N\n9%nj	p\"}0\r0 :#0%J\rڔ'|y02dMf &Vq\nNO0\"<.ʱPbnNO1_#QH#kQ2.kaQ\r'^L1O1P %mُB7~^HԳ\"l&!Z(BdHGY<r^zEk#Y\0\r̓\r<'˗ NEK\r3mbƂmsQ%CQP G@{Bx_n&,.\0Iy\ri&P*0}qR(Iwvΐ7){R(2d8@F	d0ZaCDkkdn>r)A.'M\rm\$s\na|C{09+J@dhDBC2O 4e*'D'[43*mu6\$?2Su10&5J%s9*\\h*1ۭU:M:&_H/ӼU:PI)F\nlc8>>RY;q<>?/2a2\$Ggf=\n\0-o\"DfHqA5CcGBfSANh2fg.\rf9\$24o.QCl5b4QsGfB5HtuHE`a@c(gL d(a^cFd9LR,XR9vjz&\nZ\nzJ!|tm#CVO#KO-#Iі&\"/Id}{d	7B? g2 #2/xH\$|Bd*L\"C@1 3Ob:B,\"@\$FT<@aLdR\$bk\"~\rrsnIP-ӌҐ(4GիO3je,YNUYШ\0C(PP5'PH&&?Ñ?\0a5\"Gm.(xnk(V+&x\ntZ3&/(\" \0Ki<u=\0C'VFydlg-N:4|Lrl`\"dsC5sdrE2\ry1I@@";break;case"da":$f="E9Qk5NCP\\33AADeA\"o0#cI\\\n&Mpci :IMJs:0#sBS\nNFM,8PFY80cAn8h(r4&	I7S	|lIFS%o7l51r(6n713/)@a:0\n]te8g:`	hB\rgЛ)03h\n!pQTk7WX'\"h.e9<:t=3ȓ.@;)CbҜ)XbDMB*ZH	8:';M<9\r#jEBp:Ѡ欑)+<!#\n#C(0(bB,EP~r&7OV:=j\0&8\\b(!L.74(3# ڵC#h+# ˋ>=C،H4\rB0/9`@SBz3ˎtd\$3.8^?xDjΌ-mȦ2x!N+0cj2=@P5Ta\"0;\r#(\\3RBpж+#ܵ22!.&7>*D64Zi*(0cB;-?jְ#\"\0)(dciӸ483I/ؑCx?¢\rΑBC\$2@a`Z9l)\"`Z5v](e%7]09,'3\\q\0P]Կ#k9K\0P7l VűwM4>ҍ0ͮ{:\"9(U3du9#8µ[SC(P9)83:ZЈb#_JVebk842I[l6[Dҙ\$DRLȕID@Ab\\VzCJ1r@]UоmP n@Ч\"2b	9)*ɵ1B\$FU:UaVbժW]+ĜnXKʑ`R\$HL>+(ϚNÆD,E6uÖUο4g)jTհ1߁|3,(g!x\rKaÛ6#tͧ[C'. EЃt.o0XN	ї3`(]ħ'\0\n`0\$S!VBS\"~ZuCKɀ9)m#ܾ=N&1%D,g1>gA2ޘpϥ?XT\n-D<)@]nʐ@f:ľD.\\=0:P	L*)0g\n&m@Y\rYHLB RJDuh J=5\"8G`.d#6ԃP*\\F\\H(X9)x*S/c<2p̠\nhn`/\0U\n @]\0D0\"SLA|ɤ0L\$)y%>G,ؼ-]`ԄN7ݽSޔ(A Ct[KUk&)tve1\nOC\nISVT䵖4ʄ9r۬Qkj5\"Vnkv\n֜rUmYV@u{8Ԗ\$t.W]5F\0M*rje%VF-aPNQeWZ9ġRIq6Z{>2γ\0PRSQ);{s1\"0Aa P|y*^CQ+(\\\00cxbK`(STk\0w\0vφ0K:h8ht>yfKC-1F{	jC&,gAZ8Ӛ<K:G/[\\5%T_¸eUڱz\\h6ĕ0_~h-Χ[SmW,BtYiy~&PEסܒ})@po%FppʓxNOo7↨Le9p]l\nXō,e24/\"`C,cR'5Ld=>REE\nd@xM[2(eđbUw:^3nbmhQ+^m7x]<}w@DIpzkv4wϤoOj4rT.~WYyBH\r:ClW[Y(\\Y[\\sg}Cz_}\ra֖_IŦxXgZ ~UycJ\\w/r8CxȊ=>&wݯf·P^HެL\rnaEoMt^FNivn\"N	GG~Dn\rTM̦40aCn~lSFLI\"|=eT%\0p\$Px\\u	AZălf)?+/Cg\n0:Qb'F)Rf6\rp\nop)P	\$(t-b0DG\nk40\n`Q0\"zQ:1?#Q)\"TE@:CLQK	ku:@1 ƴc40Ф8I)''@RBP̸4me(DN	fBM ^V-mOSX@C`@ѡJ(ufB:p启 p|;_NM8&sֲ,b*J®\nяZ1\0.->/bf\$T7D&C~hN4,5/Dk(ixlC9'0FJn8B\" .pmN*2`+j+?\$+BmR+%+pC-R+I-&#\"27+gަ2l*	fCjs\$k\\'F\"Bt;	/)0-?)`'U0-1jk6L:J\"#\nBԞF\".\r@";break;case"de":$f="S4@s4S%pQ \n6LSpo'C)@f2\rs)0aii6Mddb\$RCI[0cI S:y7at\$tCf4(e*,t\n%Mbe6[@rdQfa&7n9ԇCіg/* )aRA`m+G;=DY:֎QK\nc\n|j']C\\<,:\r٨U;Izdg#7%_,aa#\\\np7\r:Cx\$k6#zZ@x:x;C\"f!1J*n.2:8QZ,\$	00sΎH̀KZC\nTm{SC'9\r`P2lº-AI8 ф\$f&GFC/0\"눡DuB`3 U.9`2\r\npCTv1ij7c0\r{aCE225иc0z+9Ax^;r5Xp\\3_f2H^*!)p'1@}1mR:Cz:S:b;K&.(YF=BCHdIū5>,8 xZ\$NM;G1BlA(@z4X3(Α۔:f6J*\$@Rb́ϣً%@:O8E;by2\r8N1t׎SOLc۱DuԵsh61z=x8'aQT\"NOkXل;jcx3\rf SP؍t;+^@{c`TU v؅H0pA-ߑ@	P a4Q< \$6 1w?P`o=\\\r`0@4A 	C\naH#\01XEXLH1 |R2T<>-_0E(:p3\n'5uXX*rZiE i-@ʵs@'tr3)p#aPkqHHoѡ\"Nd ZiOGF	#u\rUkV\\js%FJ~#\0007.Áoio7H|AJN@&FjVBg9S '-S\$D\0hSWͥ99}lB#A5#:j a3Enf?c\\dɨ3:PFQY\0!N	[ث37á3sN?HN\$#A(rG)w̦@SB3v!ȊK\0A2uCa0ao\">(NFVQtDCAH!f+[Mt^ްVֈlF.S8i\rJB0TY_9QyJ.2,Ԕ\nZGljF&9UQXei0f5ڡ9+fP(.JѤ<\$D]l'Pr4!L3JP`E'\0 A\n .g/^ԗIBj\\\\\"m	}@M2a8CXTz\06qv\0P1'crKSDAHN*dgUC<(+pҞ9#`y6Z)sHrhk\0002b7VbApILdeۆR-8\n\rd5,}^}ZvX̉.\0ΐ9#ьll A0:0l?(->0#kNF0F\\B%Whݦd\\4TYEAG`b+&MRFTx3iFFgUvAa lêY\\!	IoY;5M+'f\rf&**á\nub<c0 ˌ0\\rc;KFP5ZN]qg'9\\^\r0A[\nsް`[l{ty)7|3&`9H_\ngIKF2KT^a&ʽRM^\r\rƋFͷ*Py6&8uFwxHvGl~E?2ta6(f9 =Fog/+sZ}S&xҊG?N͓`+,ӋP I6dA NBĄrK~5L0\nm,p*Z1Fe\"wMvעXNB6\0Z\nz9o\0P	R,@Qo#>>,pX^E0ZCO&<c>zo|poh5pv-0,\npch2c\nM⣯(x&@NfO )Plb0h'pZC,	oUx\n&F0 ZJ@أ\0d::#`Ā\$%:Z5&P9ɱ@1F`\"\rnOn+/cb{E}X` тwX\rrquL6(--b&'Яb)p^&%-\n/)\rs	\n?ʫ\n7bvˌ Mꪰ41%4>6@\$(jfn拫c\r&rE\$Y zM|d\0kbկQ'A\0\"6N`2 \rf0*e8Q0+>o1**QP+G+Rs)*R	OR_'2\"rHϪEg,2/02+S\0:1rˤ[Rb1mRRDddI,S8S=%Һ\"!`/s(C\nA19&~W)C\"`A6B:sx&`~FL<Sj。S@4w.rFa\0sJ\n;t\"Hj2\nZJ\rWCh \"gvS|ϐ#:#`Ϻ\$\"+2mCRPm*D1(Fk@F7#a<t<`+TBs%fWH#'T+R\nD-FvL&:2O~#.t<'\$R\\GEJGa:\rsvGT0T\0tL3vG%cB)^ Uί5.( )p8O\0~+?\0WM.BtQ/&\"n:M	4a IS=~Qkvb4 ʴF|\r/-J' }OD%#I2 /b";break;case"el":$f="J=Z &r͜gY{=;	E30\ng%!F3,̙i`dLIs9e'A='\nH|xVeH56@TБ:hΧg;B=\\EPTD\rd.g2MF2AV2iq+Nd*S:d[hڲG%..YJ#!j62>h\nQQ34d%Y_\\Rk_U[\nOWx:X +\\g+[Jy\"Ebw1uXK;rhs3D6%`YJF((zlܦ&s/2/%A[7[JX	đKںm늕!iBdABpT20:%#q\\5)*@I\$Ф6>rϼgfy/.J?*X7p@2C9)B :#9\07A58\n8Oc9)A\"\\=.QZ䧾P侪ڝ*\0\\NJ(*k[°b(l1Q#\nM)ƥlhʪFt.KM@\$@JynѼ/J`3NBz,/H<Nsx~_2Ø7)6T`gvN+oMϪ ;񋦫g6vv6NX\$\$n^gqOi6*02\rH8OBPE#@pϰOӼ=ϣ:\rxB!9ԀX90z\r8a^h\\0ꚴNc8_9xDl>46x|߲Kv\"\\z\$g}Od>/SRy\n\\9/v<N2z9,B9\rڰΏ @18XofE#>l]jˑZFD[bCoi޻N)D=\0v)q#@UHpzȸ̐!4\n-ЂH¥Rˡ.L!A6)iըZB4AW!9E\"Gx3\"tuqYfMuƀ@	\$*)HbD>j/\$*|0=Fs7\$*B=t^q(5.HhpI'cJ9%Ÿhd&X&`I-œ8gdܖX8B}{!:\"@\$J,Ȳ hdᢽϙsAN\$1a%*3ё2YR\nбbӉ4h& A1Ya-	H:uIkp	SYg.*5v\r^y36\$j4SKCAE] ¥bD7jІFLdĺ{&qjvdC 2Hw\\Rh)A:`elMpa7@0@'suK\ns*4}x\\KZ)ZjD\$\"dRI#1YQ>*fb{[LX3qN19\nܫ\r]0	)\\y@\0Ɍ\"S^%A%VxҢIlc7,G]c&`{f?Ҹ\\۬db`tI+hO1\0@ۃ`l~i8'\nC+!p[d\rڶm7\0 n C`s0҂M;2gZS\n,UHVD&❉دjE>əT(A.WI+-'pnRj6lj۰r\r!4ψ[PKASf!v,gHQ1\"DƜsŉHB9Q.,U\"ֹE(EzJh\$Di\n+3F鄤I.`/vhBש\nJ2' i]Dk\nAu)7GeZ;2PczPL:\0P	L*L!8ICIz*4Ǭش>W;uևV䁤=a)'X1>%7]&Hd:<3eKx 3TA0T(U7y!G rJлnbE`\n8eԱ\$L2\$1m	Ԛ3	 K\${βL!vg2yz&6=U>f2HrCqR;]R,M-+n,h%y6~^az-Qg4PcXU]HNaDݐ>\\Vh;2kOԂ~htÌ|ovsp**TM+{@R?Is\\0GCVV>ǺDHJl*\r\$bBF-/FB\"bj.4.Kxz)J08%'v{jT@Gk%'XH^zyi=fHEJbhy)> Jh4 \0nΒ\"bcPB\02YPP6i.iji֜d\"jf\"}@(V u	.ꈉDgIdoeZ\0 \n`\0\r%l\0ѥ\nFR'K.Z=XHKІ@#'bh;BEr8*6CL!4);B'xGB(5U0p|I\$q18-?)QآhRvJW̖X#HxkΛАr Ep* <HΎq4.|B#2B?R	\$NlZ%&[rD1%pBWIVr[\\ MrERN=l F,\r~wFHc!(j*,BRp,Fҽ)ocT-5'l2H2Ř҈|p'P6IkD@/\0|-XB͂b8R+!HJ8xG3!)6tEPq#d-7k7MsnR/#(@	^UxC:\n=/b+pzDB;ӫ<<E\\1qdVA7\nt	{<([ܞʵ*`UF\0N@`~3뼞\"dTBC4%J<Ƒ̺ jFl]PfLL,0-@SC[\"Lr(IHE(O\nrG7Ԁ \\go>)6:3Ho>]9()HessH>D	.sGԳMNLڽEpoLs/0?Ē.qgIkK G S QPGP}\"A5QQ'N,ʋJwHP-wu\\+OWUWUY3.Vgt>DB(J+0NxۥKkFHI4Tb!=uD'!^%GG5\\U=	^нSX5v\$M\0q>.X5{\rcs;4m\\ZxNX4WXtZug5g84L3eP{\"UNE)5h);fVtD.4&kfVէE3*Xjj	rգgPKн	MkC՟l^,mԵbb+/orL%deU-W/L?6SRS4;LSgPw&]kUN-q,4TkuoET'mU|EѭuPpJ<Bvh^.hP+Shvg5udΫN,tS]6m,Pl\"B4r6m{\\VtnW?fNFvj?|w5;OvcsOI\rv|QG{w]xMzcS&w7+Vⷁ6~ik7fyO<y݃T\$WUDCO\rO0BCaGx%K~e~Q*\"eCwwMh\ro8|\$\\2|vڷSecxM͑_QZs\\8lWlNoe_'tU\nć66Khv[qԤr<8+&&Eybņ(DTeHx5u?&9%TY~S6Ĳe\$>DT`\r` NC6U9!Xc<2%{^K5):fCx.F\np)@I2n!s83T::dvr&G\\D0x4Ke=~Z\0)<GF.הLqOjs[ԠT\r]5)L.\"ٙXK걙LGC\nʷWPn\$тKFv\"\$rh5]&D32\\]+2BZ:>{@w4Fh58'o8Is)ZZři~\nGAEZGኖs7:ۍhU~'y}Ӯ?CskeI\rwby!uc:(\0wq=h裴gUFRwV,cG4HXֹ=iY49)(夤Z+Xß)End'B2HBoK1!J}3H4W+헮Ye}}-jA?v!6TC4U4(5%";break;case"es":$f="_NgF@s2Χ#x%pQ8 2yb6Dlpt0h4QY(6Xk\nxE̒)te	Nd)\nrb蹖2\0d3\rFqn4U@Qi3L&ȭVt24&̆1)L(N\"-DˌMQvU#vBgSx#WЎu@R <fqӸprq߼n3t\"OB7(%vI U7{є9M	9J: bM;\"h(-\0ϭ`@:0\n@6/̂.#R)ʊ84	0p*\r(4C\$\\.9**aCk쎁B0ʗÎз PHP:F[*\nPA3:E5B3R#0&F	@0##?<Oئ4svȮxLw*O;\0005`7#s%N9RE jC|7 ƌR[\nD;#:9pl,CC3:xmѥT7>r3_c#JP|63-ˌx&`<QDcK>#ʬ°SJ,7'*-2++B= @1+2Q`69K*S#	#pIN*.0؏R\n8`P2c˞C2@:-=Li&Qk4e<9*Tݨco;(<UN6X#]/f&ɼ܃(U᮷qZebxUJTcx8/X7`2hn}-A3ؠ4LK=)*ܔ7b(ˎ}В`!&w*.j4%)3%>\"T#m<*\r78;fj}N慓!0YrX0RMk2A) u<8\0CcYWeқGURz ՚3;ez\\K5*J~xj U|!eDG*Yugp5|h߫n8Hц@\n&L-8 472d`x%K. IA-樴VZemuUY\\k7.W^S]<HZHt4\r4}?A1\"247@Fb#1,0\0l%hjpa	\0d/SA`b܃\nJ8R(fy8)PC*x[COTLFH\n7\\FAJ% ch\$e3~4d⚆\\0 Q4Q.\09rpϺO%4<+sk8K2~I'\"0) K%B9!*Sy	\$L<: ,*DcBD06)0	R2T*̐ ]\n<)HcRIlſ	Rdä\"pNk%\"i117R=\$/)}EC6`@1#yD[VXÑ?,☑{8hпclC\nT R!u\r;ۖѱwRAeyoxp3Ęn\r%;0Cj9v)1ܷIGnSȷ,g>{zF=͛2\$r{ DcKJR]B*pݖ;@U!OLDEZ1=s'Tz . ;\$,9-@^CGi>ӹfvø\n_aP0kjŢu.Ksؓ1\rǓ>H:6L@|[1*%R(ja\"ӽ\rrM^d<0O)I4~^+%T	\0ۖRk\n@.SU`e\rI=b04ՉAeGe{3e۽bv{!m-鳂R&#~F d\\CjQMrLTAz8nbnqK͡C)PQ,\"q})1cd;ȷsL\r͍H{g9㬢Kq*7%T	U(RC~{R׺\"H%PDAV;f!<q*y-\$U˒)D&}:EcZ4zHW<畇a.3rGH	ZCq'mgߒn+7^ơ=Oz#HB(`ջ@gL^/)f1+b%qXC#*u/ob/{)\\f8{JJwL\0*\r4䠘:.\\߮ނl.Pxo8	jbE\0PptCoT0}-BCa\0@̾BCb8&8D(iz/CifF/oBа\$4Z0TbD6%HPL\">R̫c O0'XFPvЯHPm,-2ѣvӈT00odpZM9	i͔؍/(QPiQ2Xت5	.KLZqqK.-Ig1\"XiNK~sF>zƃ1]\$M|U05]\\F¹luftvlr4qiO#zk/yhP%p>Rd.q Q;\r fqb NpOf|Q>O!Q*zrFgFՍMORRԥ!5%a%RcC%Z1%'rk&Gpgx=jU)-&P.لK\$h	\r\0\nE.J*јў7fi,jRRjr1h2D%jq,F\\iRin\"fBVw\r#0d\rVf.d#%B0hdԚ\nZ8c-BhKH5O\".l*#4Ĩ\\Co+,<)Oqt8V/-bw\"6Ԯ &+Xe6གྷdh<-z :Jj8N,	cfiJ2.TDCJIb<3G\r)o@r(\$U@۴D#bJ0u\rbfOvpkp\\utHp\$O0 Dd>#Nv\0B(d6`,\$?vKRT7oR'}\0јQ1#+%/c@	\0t	@\n`";break;case"et":$f="K0a 5MC)~\nfaF0M\ry9&!\n2IIنcfp(a53#tΧS%9pNS\$X\nFC1l7AGH\n7&xT\n*LP| j\n)NfS9f\\U}:Rɼ 4NғqUj;F| :/IIR7aýatpAߚ'#<{Л]a	U7spr9ZfC)2ӤWROcҽ	jx2nv)\nZގ~2,X#j*D(2<p,<1E`P:Ԡ88#(!jD0`P#+%	JAH#xR\"0K KK7LJSC<5rt7ɨF\n/\nL7<)ܜEܓ,KS@\$h7BS:<.N/BÄ\0#'N@ߵkVT	,`@7@2D49Ax^;ہrH=r3_6@^)ڴ(P̴<x&F18*~¨Z,j߲I \"7a@T9H5P&,l:,.<8;70m*K6?\nH@Ph#2C`떻/Sj	t2CF&%[2룠(\r#H	x\r#X֣.\rM0+yk,ԋecn'lؾc2;~6\"E=j%+\0\rQJj4z\$JϤ.OL :w^ZʲjR726T8c|P+^v\\f^vYI\0FOi\nC\n`\n)6/RS\nAe 6{IZ*0Ƒ/GR8/?eGEn'\"vNAN%ς\0rYA<VaYEv0Dlgi|hx g\$tU!*\n=BnԛSޱJNa`\\lSZKQk-މqPܹSN>*+Gt'\$ky4Jz'\"/£8ph92s*VylreT(8aƱ8(b`3\\i)|5C@i&A̚RSx#(P2\0Q!%i28i؜ @\$	ԄЬv0PA=ql3c<\r4Ż#⻘A;稇YiY=<M\n'ÒC#a9jd.&I&XRFL]g`C1\rE\\&l0u.ySjxS\n#xp\$ɨJonTRdW\\I:YҟibATG.{MLlPЦ	k`?z-SU\nEgrB(jrp(E<3Rdɏ\0U\n @-D0\"̺\$&ʹZo%őeLʣ&L\0RFc2#[y2\$W@ʽCa~.-K˧d5Rς'Vȫa;ע\$dG)3d{ϋn\"N8uϑޢ0nIe U˾PFRrb,Z<h6|2\\q50!Їyh1\$1ptQc7(f|&jR/'bҒx	EN,Z rKYhIҠT\nA\$#pӝKo^(S;Xb,\ndy?\nBE	P)^\rШBH9WFBVMޏ9ۺ1W& Ax _-Z/F,KV[q\\^^^Ja\"m6z-\nhig{n?R>>s|C)l2BH+kh3	(9T`ULg~v:|lw7%2%%\$ Fr>I5é7ᔒYiߛ|qCOdn8yO[e1ot0.@!ֻd̃1TbrfNlťq˔YJPjnr_@:zgW\n5EK!?3In7i:4^4F|{h((%t+d x#x	{?kx\"'oxIܰxG=~wrS]߸Od\0!\nN`JMPBۭ܂kFϫN#䠴j,q\0#//pOo	5ZHtZ6=PIh.BH^ie#G'Ė̬84lE+WCBEm2P'P-ER΀jꋴeg_\$J,c\0S%Rb.c0\\5Q'5\rb*_F20\rXR]㌫p[H^QJZM/u\0n\"Ly`mr \r`@Ƽptd<\0я.i7{@ K0\r/1ar.\n()HlHP!\"{(=1O	QIF&T\"H7U!qQ*!	J\\/#FOH\n1!=%ƈg\"2NA\rg\\/	'rm%q-q2z`F-(PM(0RqZ}\$ϭc׋'U/Q\"B̝ P	n@2\r'u/CЈ*	/ \\+*P \\ЦiqU0	o\rƊ&31TeVe*6o9@L `&f@H)k%\$\nZ։J;Bj*B8g-\n&nv&B\r )\rNP/`Qq5n\rv70M:\r'ꖥY36\$>dnM#TeR>ЃLkK'(1cF e|+j,p+CޖDH*/Ae\"T8M3#6gC=BgN˄NB+\"5Xm('9I.\$(B	>%/9I_<ۂ`ݬtmF~,&OmO 6RR\"Kyx5[HO%Nt6hDd2/\n0m\rn%*7lD\$^+hx	\0@	t\n`";break;case"fa":$f="B6P텛aTF6(J.0SeSěaQ\n\$6Ma+X!(At^.2[\"S-\\J)Cfh!(i2o	D6\nsRXĨ\0Sm`ۘk6Ѷmkvᶹ6	C!ZQdJɊX+<NCiWQMb\"*5o#dv\\%ZA#g+>mc[Pvrs\rZUs/Hr%)NƓqGXU+)6\r*<7\rcp;\09Cx0C2 2a:#c8AP	c2+d\"%e_!y!m*Tڤ%Br 9jS&%hiT-%,:ɤ%@5Qb<̳^&	\\z\" 72J&Y 9d(T7P43CP(:p4RHR@\nҤlƨ,b#鼩5DƌZV3CU\n^2zK3 2\rd\n7@0c1I+B(;#7DcK\0ys3:x\reApP!}uC ^(aB`\ru(7x9Q6W]3d\$jB3M<\$kᐌ	DU3WP0Cs3(gePj%@8o½\"%l>zId2Hlb} \$[~;)2DB:3S\nS0*B0\"Tz++6sYFnп5@)\"c\$%,u.<;1ZεsXeFd짨)AFVꇞ9\"O].87)2|ա]|2&\r鑸\0l6Ȓ\"MIÒ`_X	nLx#ĥHaBjf8AaC4D\"BoR7\$(HWK<(8pAB>msbi\r)^3ȂW`C\naH#\0Z\$9Hp.XfN`CE2v0|3D\$JjAP4\0Xrlp@Hn@1U&ZyRQѧ>VѺVJHݣZm!p2u;(O\n 1DuWf)G%|\";]y/E_I3\r!G&X{nGtbD%p>T3+RX8>쏤B,sY\")HԓCT	·3*F!E+ \\6\0ą!20ajpi(l\rR%#0hB\0Ƽ\0n6\$T4&'K:FЍH\n (KDB3H\nRbN5b@CRh1ų@r\r'AzZ\nOh7jHk!V1#Tn+!3jE2Ri\$M	2\"A{31:Խ4EdΔ^\$ȅCKSYL755bאqaddRIqFNAhY\$ѕU,g&\"KfqOY8HŒ[fZ9%ZI=xݶtDfA7{|Q^'&^lѯ]4`Yf{\"oUN-̰UMkMTC`p \n@\"qA&\\U.*kbjU*hLha=ۮ]Dʝ#`Jfj0D<>;åq{QkpT\0%wXg!\$>5CشYi38<SfL[VTHh%\n_OUnHF5XkUH>(n{{<VfRJ;8ą[>\"abgdYN7143^|K)`S}E~]c&yF}QeS~rs<[&GkэK0{-VP 0.R\r(ai+)тGtuӹa\\50^[\"\$m^H/66ȈH[r}%UQ KXM]R5!\\OD\ryȗE k^;ZHQ!(C*opDgS=U_q	okӹ{MP׈wj!\"W&@!~'R)\"iYZ+&<vz3󉣾6G].D2~&@A H~كJt(x2cMKZOBlhNUogB{\"NG#r'f&F@&R>ӌfh𬪖lӰpB~mPэ8/l|<ǒ*࠰%pŇ\$~Kn\rϸhdL6t纴/.[\r-i)N%p\"{I4daOd50\"#p		B%C,:\rS&ƪ\$?\$a*p0NQ\$i\nN\r?M43㇈Dl(.PeQmq L`>{P7\r,P/0QAQzq΀\".n?dbʏIDCp\"of\n\$Ѫ{\r\".MLL3D<	\$NrT0/͘GlkT9Rw	qk\$#pHw%q)2pz0Rq(͏'1C&pN.Rm\$\n+w*R4#ҲJ6G1m^R/Lډ5/k-OؑdJ.' ts\rHOP1g12\0ͥ`tBpkfS87^\$1θ\nmdR@k\r \reNQ\0MNx\nZ﮺,X~0?Ϋloiv';%B-W0-F\"u)PG?4mo`Ěn-c*sك.VH%j.\"L;w!,o002w CjUgUf'ETƅaM&L*H4thXNvqj]GJ3H7	H\r%JDݯGMVFotчHspTgp6[32kAG\$G~!TǂN~UuR;QmT2~HÉ>Kȵ\n.CHvKu(nfM's.܃H7@3";break;case"fi":$f="O6Nxa9L#P\\33`d7Άi&H\$:GNal4ep(u:&蔲`t:DHb4oABbv?Kd3\rFqt<\rL5 *Xk:+dndj0IZAa\r';e KjINw}G\r,k2h@Ʃ(våap1I݈*mMqzaMC^mv;c㞄凃PFKuҩn735\"p&#T@@8>*V9c2&AH5PޔaXji82Pcf&n(@;x#N	êdPҽ0|0@)Ӹ\nъ(ޙ\"1o:)c<یSCP<Fi:SBR9C^6X&\$=qb4c0,sP\r:BBX'9-p4ӭ.@29\0@P\$8A\n0c8@2N4\rApl:4C(CB8a^H\\֫\\zڰp2\rϲ)^0ɨ4 Fs7c(Hܶ\rc魸R׶,@:j/<B7'c:&x:9lR8,*1|i5-èx R\0e@7XZ~B5^5(3Ϧ\r3E0V9Bd<XX:5H\nPp2J%Jӧhɋ	jB\n/z\roN\n\"`Zh܃	K1: JE(FtKv\r/SCk3\"'.+\"ܼǶ.P!<x.H\n752\"MB5c\0:#HJrb#U{En{1('!TFb)\$|Γx:VP\r.&)+俣FDY\n9E\",]aMfLASc\rA26S\nARѐ.0DC\n48UOaUą#\r%D4)DD\nfe+5cNV`n;a\$4AH8nj@\n7tehsRRtVI!&'QE%\\:.E̺R.x/ ܼrm2AX̊ɴ	Gn\0U2qF\nE%`ujNal1`0Bx` K0(La},X\r\nD'59,N>,t>nA	4PQ  \n (!,!8N( D2\ni !DZB.dDUW[SDONct(Eܘ\$<dmX&jڋU<j#ZM1mUD`9?`,#f?NI\0P	L*ՓZ!t2c\\]:Lv,pd 3NIGuֲH)&Y(_	E*0`<0sI_DeZKɉ/%5@ŎA\nE 15\0U\n @ԯD0\"fz_f!#@Q2j!N^6}\naUvQcrueX\0J+RqC\na:T]Y\0(S*\$bPBd%9H%&CԠH7-*bb:-X5XAmq6i\"WnQ5OJs|]\$}FBd	AwCs)w11UŴ@ѩ]6&-%f.AvXSjJ2\"4.='hܒĐ\0\n?-tqT!\$\0	1]Xxj~ntSNtk5x\nYA1/v_ zuPIߙwƞHk|MhXiί6՝18,TcY607,iA\"k(Z'FGU.K	F32V}Q/GivԢsEԾs[zZ\rM#=zT(*}I6@1}S#]z	yI\$>nMclkV۟H(3<xⓋr1JxL@Ry0nM5`e8ΖU+/.F`(2ק}Cm!=9\n{sH2a ~*E2?`뽘\ns\\Ӵx`P\nR.lgv`:ڋoNoi(\"\0d-b\$\"zCLB#DjF`v>`in-pF.yP(XիTc<Pz'p\n~09^C/m\0rH7!\n>\n< %\":BtnG΁04\rhC\"°3->BŠ'%(r[=F(\"Ї'~̖c-l:b&:Os1&5p\r\"vo\"٠	QQPcZC	M:%1lx_p&	j&&e%P^6T81qq		QpQdj\0=u2Z\"pK̂`30LU4Ɔ\ng\0%Ym de1	R\rr4В-::!!`1с#\"Db) A/,D.w\$R8vphmdI &-h~qe\"(\r-u	s\"\\\$s&Pf&y(\$6<dnQ]\$:Fe*MorJ\\`&DhE 	Rvc\rgQRObK1hB\$)ަFC12<qti8'JApKcn\\#kwL.|(vF\n	z6pV4<B1/-5B7O@XB w&Ĉ8c0r5Ӝ8CvFSɃDD/cX5FN(L*?1\"O<b2nN.&F'؏tg--6άG'Fs.bG77\\)`(pZC}>YPd@\r~?G&jSEg\nk T\$ѬK`jT*&\"DnGrLSc0?-DÃ\\#i|e(LFnm/!R\nlI TR-XR>";break;case"fr":$f="E1iu9fSi7\n\0%(m8g3IeIcIiDi6Lİ22@sY2:JeS\ntLM&Ӄ PsLeCf4(iƓ<B\n LgStgMCL7j?7Y3:NxINa;OB',f&BuLK^\rfΈ9g!uzc7'z\\ήknM<303P퍏*X7P0rP2\rTBp;#D2NՎ\$;	C(2#K+\0P4&\\£8)QjC'\rhʣD2B4ˀP윲ɬI%*,%*hL=Ic˞a\r)KqEÜKJs *IK72hNkV.X(l+2# ڈ&47Ã<*/8@RЃٵG\0xCCx8a^\\0V#x7jGC ^*ڗ%̗(o|/ʘ60T5V*LQz0Cq21Lca\0\05~08,H2cc&P0Cu\$1Czj:!eO2I҄,{*lSZqlX0\n22o[I.Y0\0003C=r\n[B12Yy\\B[S4ci2	}B)c3OP6f2&U/bg<}Oiz1T1( Cm26Ę0篱=`TAq5UB&@U#c\"!yc\nO}O=%ЄCOgΉ!ݔy|0\"3Ѳr%8*X>aJ*;g]mWH&SkZE=4ih.H7U?	*жFa7J]r<qEZ) y*)'T+\"U\rn gE0&h2dI\$XI X0.>I\nI]\\is.V'1\"tF4*¥y M7+USB}+M!JFudtڻ׈w^kռG'eWϛ5Rt<lڟOa:fJ#*JNJ4?glRe	ɉi@JaC9]3g0go/elR}?Ѻ!FTR7_j̖]e\$)H\nqe8ǢAT\"HZ1kpȗbky@ͥ8|ZeTLrW:beKFV[BXCl&IRdѓx0GL4I\r95k?G3&B_2\n HL^˄\n!KOMO\naPB@@u,:TTj1?%H:5w6ƗHb<|| \0-1\n{SV^p̸DR0w1\0)h/(eATN!) K	nP\0p \n@\"o&\\'aB!Z]+n!Hv	Ђpu%\\e8ĘOS^JA?G2/mQ%\"\0Gz>V,:=ހJ=_@ϯ39ԉm1]\r!\0)5\0\rsaY*T	.*H.V\nWxCi%\0&qQ[:!%_+-\nȐ⑊9\rT@s*N3tt_E&#Yr\r:1ug2\$<\02HnيLᐴIY:8f622cAآ_8n'ڄ5;7RXta+@K!tʛaP*re)7MY/9SqpMy=p\nv.&0h2C:Lv1/h<UJ5!P PX\0K焣9~zv衏oOMѶ݊&ZvjSO:N+w\\<sJ\rGZ}pTRm:-߼Nv1ua3ߡ-%JϪ}\$zg'iv^!HR WbHrRt+PtVKɄbu&{PjS*V#!E%ُ[e?:ekIWlo*vȝ[lY~'gjO/)j\0\0O/l\0\"e\0kl#'\0gȖmbNKrh ¨\"h`5-Ĭ.FhEϤdmh3I.%mFƶ§*tcpp/y'lʐ%kyp\n0p*l\r{|CЬ\"v%bR\$<N?TGf\"Q0ވPp /B*&u\n?pN\r9/M&lP)L(j#pB0Oj,8J4\\\"Th\0G2 يhĵ/ʸ<3bl@=-Ц5,\$B+B\rԤ.eRr-%аe{\np-\0mzP\"&\\@ p\nC'%^}!	%q#IMk'\$:%}#\nx^ČIj\"ºm+S@\r@X8Ò@3Q%\"-2R(gamaϐf#d)2Q/U0+#/k'2bRح\$R2e-#'2b,33\$;),Hds74M)3AS3@0Ё,/dJ=.!'Ё0)Ƶ',LNOkS\r9u9/9ӎmG7R8c\0݋/;r-B]m)JD\nSB91G9d3:2rs>?sst	nJC\nNh'\n Cňbh6wj&E1CČ£jv\"`*:&:SFI_C#ޤ,@k\r-\$5c:|ndP'0Zvwj3@Z5,!Nʴw-,#ZZS/k!upiQ8@2d@U@D5I\"QI2I\0~c\r'\nju(~k'rh:3(OöbO4u\r;'r씟&20rw#WV]MP;	IMVW1#WWpM\r;e!t|&2<,#\nq\r<d.PzEB?Bm;\\]BcM~#@\r'nΌHsb0\r1=/MJ㲢,`L^Lx+}%	ZHb5vȆ\nsRT	\\3`=<>`A`";break;case"gl":$f="E9jg:P\\33AADy@Tl2\r&a9\r1h2aBQ<A'6XkYx̒lc\nNFId1\0BM	h,@\nFC1l7AF#\n74u&e7B\rƃb7fS%6P\n\$ף]EFS'M\"cr5z;djQ0·[(p% \n#	ˇ)A`Y'7T8N6BiRhGcKz&Q\nrǓ;T*uZ\n9M=Ӓ4肎K9Ț\nX0А䎬\nkҲCIYJ欥r*40m4pꆖ{Z\\.\r/ \rR8?i:\r~!;	D\nC*(\$V\$`0\n%,АDdD+OSt9B`ҧ3Ԫ\"<+0RI\n᎒]7()I01A\0Ɗ- e0@[CoH(]0X(͌D49Ax^;tiU)Ar3\0_ؐp^*ڼp̼*r*|\nc*@1r*V?Xuj9߉{\rKtaz\\7&7«\nA\$Ԩ+> @1-(yk8QC`6Tn\0O#\"1y+\\X2T`PI*2+|w*ǈ@P3c<i%PǢ\r4ʨc@,1\rT&O~DQ mtWQ (T[3N U'ϝ/N܎#@l۬9=~w)ΧTX\n\rCUbJIY1(ˌ0IxT\"\\_qP(67*GL(LC9čgt뽟֋l0\"BW*U4i\$tH_D\n\nH A+Lt\\\naL)h(lGPk؄pXTZ)fy+ z\$&p1Cb BT-Y(dd\"@2F&\$BA\n!%h:_Ca;Ȗ#ueEZ`;Rv\\!p\0\"`>pĨR\\\"kA'	RJYo\$ ؚ bFq%jr&P+d骑3*`D\$ʃf4!P H!M	=%Q`lO!C&)@ \n (P XxTс'dx#\"*pg&8<b@z\$WfwKH{QHq!OD.TCCxyʀƹBT'߶C)ШIHaf/}(vfZSo.b}Y%Ri\n<)FN_ÄlD\$\r*GP:&@HAk蒲Fib9ebLw,rN\\80*PӮ3PEP5^Yƙ:o})iBMC\nT RA<'\0 A\nlxR\nWЈB`EwxOG)v9(Ryp4:-a͘ƿ#XT\$LCr	t/g\"%TcI{&EuJb^.;p^j>6CR\$c,N*7TofdS4VIݞ`*lD1<PU lAu<C1n<,]+k͑Jh6]+wALxcU)3IU2ZaNOxjmbz%#N.fnǬUq/my5qfr8rdר\\0rSكyS3kB2`)a`Tn[!Iv>=#p+b\nR@KѦ%	bIE :g0CYQ-м5]ڝN,Je`@±ه6\rUM0\\TA?8i1,aNtסZJ	0<er%ˢ_.1+gFEQ5_Rh	LD%k%%l+I˿v3G.?Frq̨FE]d|JibDg>]iA!h4#/M5ԗo{aس-ӳ`ē~&Dɦ?O=V*/0LOaΘ{1E&}A\\]jTʴ􃞍:ZԔB&!&dzT	Epl	K] !5ƫYG>dglg\n\r |Tg(#hK\"I0\$zON08ul&,TpChux/L`ӪhKo'tPND{n-20^#Tnh1NQOJ@0Cf#-\$+LpPp%/}@\0wdn܀ɔ\"&	j3&\0X↛^RT@\0̅\r~I|{Pj\rn&d<OdFP\r~:~\0ڵG\r,a(\$bBO1l#7Gf\"p!0`RpQAWє7\rhɈk GN~f q侕϶7<q4Fpuʘ1i'^k4\r7k!Q!\rgP\0w8B>]BJlP2:vRqfb8?\$NRU\$%=\$j)7\$0a' S'c'q1٢ څ'Q)?1u(P)ː\nfg\",[#pjf)QHڊAB`	*K\$*Fa  \")B\0005,\ne#fRNQ!S\$&%LT1HT>L `Ɔ@ơ3ii\"礴1ĂE)	w*,7G%}k\npb\$N<'9.j\".#\$rB|M,|'/'İ_Cb;6n=0M͐ډk\$몢C6F`tJ*s!>vxt3;Tg!D|ϐOz94P>D4&d;Ap\rB;B²)COtIvOf'BB%L(Rlf&pHuf B ޣdЮR<1/Dl1!B/`ڃ+ABd1\"bTX)yt~gM)%nX:#:\0#h(B\r";break;case"he":$f="J5\rtU@ ak(ffP<=R\rt]SFRd~kT-t^q `z\02nI&A-yZV\r%S`(`1ƃQp9'K&cu4Q K*u\ruIЌ4 MH㖩|Bjs=5.-uF}D 3~G=`1:F9k)\\N5%(n5spr9BQt0'3(o2dp8xY\"O{J!\ryRi&J \nҔ'**- ӯHv&j\nA\n7t.|Ģ6'\\h-,Jk(;)4oHa\rtJr<(9#|2[W!!T؂B-iq5Ld.jtCAfLק h7;s>13\03ӯsoh4@:@o\0d4C(C@:t㽔4&}i[C ^)a=\r<7x@Hcω3h<!\\H2EIâF\r%P0Cu&3A(!1<զO\"03Ti\$tQpPk\\awn Z{PzOkTi9-qkx 9ӂkF!۠\"	Ʃ,z}@B&lPI.7u<W>jil\rb\rĵUk_\r-h!H6}6.<	<k	ɺ7sXCǺꁦ\$Ȇ%?N!7wl[yp:V5pޖ	v8@h9̫^Pz \$L\nPH%H	O	u	q5I)@	i-]xK@<L'WJ@D\$sNNAjt=`^Ckߑ /L,`5J˂<%\\KɁ1-	)OQ|A2pj&P:nj1\$B!leKP9'd@{Tt\\U}q Xav0f<6Τb\r\0Vԛ%\0cW/H.FC\\D!lc\0\0()`GFr)QެÐi'y0I7vs(t q3sЎ2<8F\rPēS;R<0 V} dhZ~PhTRqbzK[*'s\"5DqD\"I4}y'O\naRJCE`\$D\rΡW	-iIߑ%!8pZ\$K(2	Ħ@t'q4A3W񢢘'-mB6M]eDV3GQBنd)4&IfufIۜ_TGkN^Nj {/G󝻂s zI	SeF'BZIJ5=)1ES'6</7vj#ĭfzZl)2b6sI<\rWCӐNēy\$OLnA\\2\\YoD;.kCG@Iԙr)+B	,jA\"2b2\\uLISd @BHeGZ)9F>\\(x 94es)	dAE\r 	WU8D	|{npHy:\r6@SHnZ:ϙ(!V@dHZ+XuٲYRi(d\$¡!m\ryp&GPْ1@U֡XXZ-Y-1o4jMU	\n0wX׸!}\$qY!p@Q+g˺aXS%U#TZܗ\"ȝu\$ưBoh×xYxUS(f28BEi-BhWal-K\$FKX}s%ҵ\nQv~\$v*mְFvx{)vY\0l_>tɁ'K*R^i;zñ\r955x\"gcWDz՟AsO~i3¨gף^D	A@x*XGj!l<J.?\"{?Z4HԖ}y#d^tv\"	q rMKjs+2_b<5s6\r\n#^N#m@k婀^fˏ\0000M><0nh.\n\$jͲHQmougk\$Hhd \"cON#thNqls	0|07Bc%.'nE^ߌh\"ƯP'X'[0κ6DAP0(6ō:0gFk&\n>J'f5Z:lωk#v6Z-ЄB%)Ie~B<%666T\$88k(\0@V\0qxǨtP@qdff߬}po)lcH	\n\n-q2Dl%x}@`c:ձl\",Ȥ`FK#ǎ0\$ǎiI\$\n4j#b)C2%!.`͟M:yO/-/OyBh }#DFM'V7ʺpI'\rXxi@^&@m\"6qn.'* eerjMJ#b\$*`vRA ";break;case"hu":$f="B4e7P\\33\r5	d8NF0Q8mC|e6kiL  0CT\\\n Č'LMBl4fjMRr2X)\no9D:OF\\@\nFC1l7AL5 \nLLtn1eJ7)F)\n!aOL5xLsTV\r*DAq2QǙdu'c-L 8'cI'Χ!!4Pd&nMJ6Ap<W>do6N\n\"a}c1=]\n*JUn\\t(;1(6B5x737I8Z7*9c;\"n̘RXҬL玊zd\r謫jmc#%\rTJe^D<cHα(-C\$M#*;\"6`A3t֩9²7cH@&b\r1\"ܠMc\"\r0I%%4DaCG1	B8: P6 =))-\n\rJP1l-7sP@;COa6@9`@&#B3:xu\rlA`|:9^)5\r7x&`#bK5Lk'*i /n/AdaCRB0\0r2h:9|hD5PbCO&&ʌ#䞩53\"0:!\0툎(%o;P:c\$i3<ƊFC\0\npeX)X\r* R0X˶ף7G∙j]2C;GMAEѮVe)*%\$]vZL_Tu{Bd>8:6:ۓu{][ Bz\\3ncPhon>P7\nhxCcfЎ{Pi`	wɡփ((`1Jf 010J\r=!f\0K-23bP t0jjBN<k\rj\r@4\rJ\\%0Ha,,㷀L\n)F5%趌9ʹXs.S8-U}\"%c\\t.ػz蟈BPk~mHt`9#4E:0>rQm ʁ& KˑW;%hF2Pd98͓\0T6KÑg3IFW&-4p\ri2@1SXs&8Ƌ2n֊>LqFp@\$\n.(12>M!S63`ͩg%xXw.PS\r\nO	@2%hΩSbX5,1BJ3@t	I\"!ӫk8PfAd7tf cbTڽT;8iG\$X5T&\n(VF-sXU7QK4[MRy =\"+uvp_ܲiY!M*ڨ R;6zO_l&V\r^%\\KA;&H99*F[1Ĩ[3zSL\rSXX|f_pJ\r6qtj.禥	9A1%TJHv;\$SQoQ­16O-\\`pe{8<o{}\nfFuv\nI1mRy&,7dyEjP[S -p̴.X\\\"Sb!O~o(	@)/єx;H'מbk%;+'ze.le2G\r#GX0n{a ٛ6y=%gZ.UScD^vHLagơP*~&WzPK?AǽiUZ:\$4 ^WMPf5atDNN\r{Â{xJocN R(T^3 \rW<G(sm?FjVC}\r|yoO8LbxFGȔ^0rqPxGdC]%8\$6pTQLnݭ559H!@[YYyz,D0GIHH	3+V\rb69LfIrwONK)9߳7ʵ&ާls#Eя\n%\rV0dJ(7ЈL!A+F	\0~łp&G[`V)w';d|\"ffdƖk)\0-pPŏxJ:<ȝppL{Ϟ%o#\"&ЋϰBŬg/GE#2`3)\"P	NN|n	dw\nnz<]O\n0\ne\nnkHLp		\rBPf:; ƜDD4@H@3dau\$t\re&1\$r im*BZlj:[CfQDR5u0O;G\rrzbr=J|FѨ)'+cSrljVj{c>qLA8;#tG	b	<\n!J\$*rk\n\03+oRbОq#mpbs#e\"nnomxz`\r-=1%%@ Ƿ&2g&b\nq9Ed9b^b\$C#q)2peR+]ҭ*F>1G<{(Ɵ2(-%.-1\$-jWρ/+I/WM1dOr{mLKR%,ڤ-m3Lr[\$q+4e312Dc3rTY	Crr)VhF;,~`ʶn/7|k782ӎǳ9b~L\n\"VNjAxSi&oXƿds<΂=p/bk*\"bm`m_\r ̅_%+K\0=P\0\npN@%º6?\nf}2'7B<X44<\$D\$@B~ncg%</@M\nEL/ND.?WJ:81f㺬#A/-, \"P|&\0Ye	=;z@;FSA#IJ>kCƯL\"0\"ӛ-s6`~J|\"aO++/N\n5I 舾f5o-cN,Yh	 \r,ZODxtNiX`*b\"?.#q&)%#p	CVd\rYi,<u\n+]Ś-aZnB*g	,2ف\rp9`\$TKC:ނlWt\r";break;case"id":$f="A7\"Ʉi7BQp 9A8Nig:@e9'1p(e9NRiD0I*70#d@%9L@tAP)l`1ƃQp93||+6bUt0͒Ҝf)NfS+Դo:\r@n7#Il2:c>㘺Mp*4Sq7hA]l7c''D\$H4U7zo9KHd7xNg3ȖC\$s**JH5mܽb\\Ϫˠ,R<Ҏ\0Ε\"IOA\0ArBS87\"/M;@@HЬ(	/k,,ˀ#(%l(DCN.\0P\\8\"(6( j\"nc`H@lp4lB6O4C(C@:t\\(sܔ@}2C ^)1@O\n|ҒPiH?8تV˻.@P7HI2d:Bd77J2\$ԣ%dh@P8\"V4x #K\"TC6#c:U\0P3)L!&<@̒BM܎ZQr(B](3T8cB\$&Cm[s\$j숀/9l{\\nLڢ(3սT {u69 mPid8Ķñ)72Y^b@M3b39C\nF!\raJ[mj)B2\"	 \\	cK(6mX/)iCXx[]ϕQNr)@SUCQD.f,LaEN>DGPwALIaɪTTT*XOepS#V?|MY`\$zaAJ8CbPfLpak(09%tTQG4\"\\!:A`Lz%&H\n2I()\0:eVqlޙ\$̹BniT\"	_QЂP04@ڀekP:NO@Kq='Hk(TLA;_\nHi	,q,z</#7#\0ThaȢrhLOKg((\\Jv\$\0Tyb\r4\nA!ؙP{mh&=BREp:\0&hY!l1bQY0O	*\0BEU@-IA80AOTe\$Pǚ.jJ)AG2D3:GP8\r,)uzeًA.{	so#mҭTc&\0(+BӍqpAD+0pdDŢH\"s>YH7vHS3\$ȿ/ʁYl/!ɓVr3*xI9(I죥2tZ͢-],!ZSD5\0W׭(7Sڪ~k³ЉooDMi|d]F4֞9\";*@@ mX͹ϢFHD]Bx 0,Z+\rqߘ<k>*<fԿ\"Xuk8m\n-w)@_{.(xNOlr\"x{eC2BF6'k&h&a)rLH\\u#VeΌ{a:LQqNaLPJ3 \\_쓪D6ԻVGQ:'t)wMNF9|̻YLWnvepl}.khբn@QQMrcD<\n/#Krɶ&[D;D4˘7S@Pk	5_u[W'%@RrAk݇C8y;d@xƬ✽sb0\\.._X̾<_HTn'Sw콛ooT뜯pi\0 Pb#yip@E<=>\n	o1KZ{Bƃ3Sm4T*S}s|^Vrfӫsۯ>W}]z%Pzi.i/PkB.?{c>P˃,J&zpI϶E@\\Fv3n\r;薮=%vNy'VLLJ}R?̀p#0b\"P͈գ\0N\$(T0nҴP\$,S4P:&N`+\r+p@LX10FڏKF#ZL\$f0>␈DK	\$PNHTgfEo3oL/~aq Zw.n>\rVbb,,BcG4GP(uE(%Jw\npIk>N0ExptFM\0a`>D,ö@ɦ2k(bF(\"ɣr\$\n^a\r@XeBqF\\,ä(`K HKkd|l,Ѱ&h?͐\"bs0 O\0l0\nG \"tÚgjhN^l*ƫ(@ꗪ\$/\0ɢ&/0i-EV;ţIo	iBH8G@FggFPd\$F ";break;case"it":$f="S4Χ#x%(a9@L&)ol2\rp\"u91qp(ab㙦I!6NsYf7Xj\0BcH 2NgC,Z0cAn8S|\\o&N&(܂ZM7\r1Ib2Ms:\$Ɠ9ZY7D	C#\"'j	 !4NzSfʠ 1c0x-TE% \n\"&V3Nw⩸#;pPCΤ&C~~Fthts;#Cbl7\r*(椩j\n4QP%\r(*\r##Cv`N::MпN\\)P2.SZШ-\"(<@ITT*c*rװL0Р#1B*ݯ\r	zԒr7MЂ2\r[[#ù4A\0̏X90z\r8a^\\0ʴz*2\rC7Brݤ^0h7=Rmihk\n/K`*w:Mb/r;#ܵ7PApΆ @1*J\rbHCp!ǩ6+XRcWR#6C`\r\nw/3`3Ԍni\rlcp㕁B|KRHBc37A_vfP䦥#݈Oo`@)\"`0L+MҮSS]p̶!ԗ-6|{=;ͳ(6K9+\0002q4\"M8ihd \"	3Δ\$67s3d%;t݌,jyxe7M@5\0)B2#K&b`L;,\$cR7\n{GceY!V0J|ܠb5	Ta0Dal7l	g-*	|V0JHr&đ/w	T?jQA5NUZU;5jrW*'VA|>S,ГzlIBpC|`	s#T6TcYKfL\"0hd|];xqἵ.ALMmJ'DH¤8dX\$(\$H\n\n!ʚpPQI1rx1Zr|JDж8Hr&xwT䷞ |\$iEK\r/((0eV2E֠Bɑ&,C8jMZhh@\":d1#j&i3t7HD	L*>@y=JƧk&*Ul^1b4QL7E\$cgm%\0%b`	Hb]0RԜ\n7+ѭP*VU E	{%X^N)(rR`MUl4P(Afᥩr]\$bZ\n{T`LOpǹtyiq udsSrfH#&ltyr,XJ䈫bfQbnЛ(S6-E1s.ozuK06LR\"ԗO;.aB^7TzyԀPEړ/U|`H&SI^yCe%b0Y	*\0!eV&JiA-)Br0C	\0}?;g>L#e<ea	0^;-!#\\\0,zxKS3)߸da@..-e̓ayY,|N-ĿHA3Pҩ	kGBhdcdEW%'w4)+x_4UP'rCd\"`3[8W<=i\n^+eemIIyPpAPhmelhi*c_ĸkH KeKEb\n\\W*_sT/&-7VHˢ{䕊ܮ#;Im\\s`)b4ihA&jKRJtAD1g\nVn}[IwzOU_u&\0W0ʸO&sR3\"\$x7H-x[upz+{:,O㳞bnffҊl.\\^w;ePIxlew}xՍ<WQ~N6hLW;¨M5 Hskzy=\$43f`p\r\\_/<O߾7:JqJpY/Zǣ~?UX^/\0MV>Z	 \"8H\rgZnoG6\0ߐ8/ܿ>#f\0&4\r\0`xfX^G@\$Knoe[sߐR0epb'B%mDNL/9\$@B4	,L.0EҸDUw04\n63\r&1*0.f9h\"-\nm	E	tC\$*@X/m\$MLRRp Js\$..B0d</80fLRB._mVB1lIHcK6A 9@j\n  Le)O(	@bO\nA*f\npIr/F,&\n>҂!!L4@1bP%G\$\$GD~2D4b#\\X4qfVGi&BC#Ģ.lH#4,b\"\\\$2!\r*RR3=++ҭ,dn*N\$V2j.vP+?o@o|&NK\\jj[*0	t .Dc.nQE쮠-P6rrK\ryjnRF1,p\n\n\\A&\"0\$]kN	\0t	@\n`";break;case"ja":$f="W'\nc/ɘ2-޼Oᙘ@SN4UƂPԑ\\}%QGqB\r[^G0e<	&0S8r&#APKY}t Q\$I+ܪÕ8B0<h5\rSR9P:aKI T\n\n>Ygn4\nT:Shi1zRxL&g`ɼ 4NQ 8'cIg2Myd05CAtt0S~9s=O\\FqE:S*Lҡ\0U'(TB5ø7N`#{r֍@9Ä\r;#14ZWYBrTDzQ12<@#ʲ\$aK\$	Vē),CdDLE`G9|T)L T&VA_4+S6AT\$4B8UN39-A@N@9S(\rØ7ձ=(A~!bA'9PW%􏩕3MH#ZQKDy4*^A\nføsQL[Ab6HA\nt5\r#h@0	54aD4C(C@:tT78^2|B9q(^*!5`\r\r^7xVU͔ANE\$ЎhK4J	sek0*Wkt)M|zNA \n7=<L(qT@g9+A:0ǐ%E?GI,QӯR9hQ9vs}\\sF팤[vD\$0\$o#/\$Y+B7067u\$61#s(OqKEt;9W^Gz'KZ	'<I5bz*In눎	լ`J-`AX.e)BIX& ߁~OZ\0T#к3C4\0bVK゠o57@Uhu`L39@xg=͌@g'FG\0n0Rs V*S\nA[(cG(x\0@B\ng}I#\"Gq)Q[CRCUՂp@J	cX*ȽѨc}0DN *#<A7I\\\"\ncWdC\"R)\$pC7g,YX&c,nUD3(eAݖ2܂As1flU*\\=	!8`~o#@a\rm @%PKLOIVDH R,ӑX0f\r`1dp!3M78b,EÎ!\r93Q5Fgd,(4Ft#\"\n&uZ\\K, Me&Iѣjw9fA6fۆW8aR4pQ;)2]2zM8_Yj'\0Ě%Zw	!-42 O0D A.GԶ(\$` ip+\rJqM.x9̂l3JBhT}i(j I!G%mzz)e4Ar,(G0A>@[4h3RwXe 'h0T\n78?eb#VKȤäA\n]D(urtp \n@\"@VH\"dYDrk2ۏyC\\w`I=Epϐ(\"[7G8A)jms'8XZ!\r]\$ϸF~td~BZ'S\n|rPBsTT\\OR25\$  B*ȎT\\بK,GB\n^ϐrI!\r!׹SڿXc|OuEQ'SZlTȃ	ܪ5 Ј4h%x(\0\">~JYV\n[V9x'`\\}VbepE)1l5q%Y>+ȇGM{+@R3f4զtӹ8*A!Ys刲*>kʛ¤'noA. gS\rS:DhrD{ρD}'Vվg\$/ |G (&bXwIvxGkZc\$I[?Pֱ9]&-GPgCZ!&oo}0O?3>Kh֕ [v|/␼QbkbDQb6ac2\$2mm\$o\nm!\$mAh\"@0&,3mlk>pF0NVZhDGbfL'RL\0>A`I@~ZE/H\r#^С\nIxМwh^vNIpr\"0fqy馭BZ0g[а5pϮZ\"n dOQp0t%|0!N`P;omQ^\"B*TΊϹ \0q=@tǌ|M0l1qiIN&#*Kdm\"6S/Zi 24Bξ,pp3(60d+Ra	/(jl.Lmmᬲ]Bm\r1I\$Ƶ\\ӑ1%&rQ.'e?q/O(L|.jAC(^c ng:1xZ'(q}-r)'Luᑮ0B8..2l~r0!QWc-gc(s&#+./s)2g54S92A3a3~3\n#WW6M3(Bsf#kγs\$h3y3~M\$8spNSW7ś996%,nSU3S*i<4<?;p0O=o0nGL'%li;6S-9n.-:	\$`,r^!3a0!A\$DʌY/MC2h*\"4zA AtKDS*O.~-^h\rVh`Ta6s`޹ ̉9Ġړ4@\npTIH#9 {C'2;°~tM\"+޾*,IJ392m-h8U2#&!of~9 e*VBz'P1Aj9pNȠ{&TN#vUMNbN8<pJq3wMd\nH7CR5l:\reeUkf%6Ka~ep.\\3B\n\r:\rN΄JB%h6:fM\nUcskosM1t5eVbq5vY5Zs+h#*L>\0UB0@";break;case"ko":$f="EdHڕL@؊ZhR?	E30شDc:!#t+BuӐd<LJN\$HiBvrZ2X\\,S\n%ɖ\n؞VA*zc*D0cAn8ȡR`MiXZ:	J>]ñN,	v%qUY7D	 7i6LS:h4NP +[Gbu,ݔ#^hA?IR(X E=ig̫z	[*KXvEH*[b;\09Cx䠈#0mx7:8BQ\0c\$22K12JaX/*RP\n NHjI^\\#ǭlu<H40	J:bvDs!\"&ӑB DS*MjM TnPP乍̐BPpD9Qc(Ø7*	U)q;+v!<uB&/e4\\[uDD\\T4TUHtE^u;dH	Zev\\vd# A71D8D@0cyM>\0wB0׎KQC X90z\r8a^\\0Wd'	x78axDl\$׾4\$6}OT=SA[aBXJi\0^1zYj9[O/9NF&%\$n\n7><9`YsK5z^YRLuS\"b6D6*BiQA؜/!DQP*ufjĵ.o	2rZ767ԄB1#s(9T/:YejvE!S _/w@z][O:يWF%11BQ6A'\0`h-TEW\nYVGs`)#NjWQ3ا,tM0yg<\0C_aǂ\09l<:(zC8a>)\0@pu89ab@01d@\0\\y	\nj&&FJZBHd%a6\nttńSAvV3`!k@hG<BQ\nN_;db27yH?PR0ib1)0c}vFCr̡2,ҜfL\$nCk+(ۉ5L┒pez4( `#^|-0itb\neDxX)7ÜAɇ3\$Ѫ7G&%CL@PFH\0PUK#v1J\0J)LKCSD1:72\rCނUb?Q2KsFEGGH)d`\"oO(#Ā!(	 uד_U}:a@d\r-xW:NAbʇ4@mAvvWH\":uixS\n	ENkm?Jdmʶʤaku&bzVb2O5QNGd \"n0TO5b6X9&_ȸbئA\\O	*\0BEX(@.zy&n,K%bO׀V	_/\0oK`qr[UĶ4KZ|/@'+H(n\n=ܕr)\"Z%I	TX%	/VfUDN\$%EQ\nd;iE5*J\0t1k%SQ݋VF,TދNX)SsSj?xVBg_t B.Me50\$l-x\$,Ukjx4p|#\0<\nc]6%cb)?`( \nu1P;DZ^â<aLp73@ C	\0 ҇[QΫ/٭On/I6*8.RjSDI&|\"1+4Mg9`.D%>J\$&1&ZKɉ>)GRCmSVjGh\r+փ,Nn*0wq+\$LHVa\"W'V\$ɱ2\\5@i坥k^nge\"`hz<ǳCCM-l^n]>t%Y]KYWNPIA\"ASJrgb/|;>sB7`-:S\\ƛ^koDNIRNcʬOvd+o޹na*\$.Ulf},|0F|mR-pzPf}?˒ACzr\0002rGeЄ*n63QW	/nٌPjOЃJ˩Ϟ0F)l\"V+:)pN zEbU\0,Bȧ!<lHP=l8o꺁3V\ntiB,++1'\r0fۇ\rjG_UE\rMKL,an*O(>o1Jlj0D%WX\0;\"i{#	+ql-J<'\nH:k!q%p2'1VD\0:P]b!R9#C\$gjp1rVV\$:2&i@M-QLtKb<j#/AG(tL'`g)w*21'c!OME%-,%҅,,})!.(!D\0ňޭ(G'2*rrn@C	\nGBvS(-N<BpHF#ݦtSf\nnT[&OY-bh\rVh\\`Q_\$r@޲@̇( ڑ\$@ȨA\npQ\"CoP@212F/@s4bj>	\r3PAhjafNO420|O\rfT8cT*d\$AF,\0|PS.;aefdv~y.S@\\!Q@QiFP6qTbOP,Rz5\\ʴ	@]m_?\r&=^<ʐ&FdtP4/NJFpx/ǿ\0dZ〬_\0/:\r>sPZFr~0X%ÃpS6{!2JU%Vt#nEnH`taB>\0";break;case"lt":$f="T4FH%(e8NǓY@W̦á@f\rQ4k9MaŌ!^-	Nd)!BaS9lt:F 0cAn8Ui0#InP!D@l2Kg\$)L=&:\nb+ulF0jo:\r#(8Yƛ/:E@t4MHI'S9P춛hb&Nq|JPVuo^<k49`\$g,#H(,1XI3&U7spr9XC	X2k>6cF8,c@c#:Lͮ.X@0Xض#rY#z\"*ZH*Cд#RӍ()h\"<\rb	  2C+\n5Hh2l)`P5J,oֲ(H:Š2n'm)KP%_\r鬚tvK`(PH:4#]Ӵ-B6A(0(!\01lRUl0j\0yf\r0C@:t5}b9!|gC ^'Aڱ8̱h|#5%(ʢ\"!0X+=Ï䍸(sfP®-Bm;hJ2K9r&{gC)`!KЄH1Ԩ1\0c`2X.\01~30#*n9B4*WGRT BbU鱋34h2#V`͈`0&,6m+Pc+YtILe\"_8Ø4Pا`\r2KW@ӃK6(h6\"Lfzߩej>B	mg8dQ\r3b)UA@EXn.:Ux3c-ἳ'U,l`e\$;A%) iy-'PLб%%ܞ5N\$nr Jb%@X5\0ܑy>\$}]Ah4JC\"ZfIk-t-3L\rXK`{_%p2FIU\"]=x`\rzj\\;EPB]v'2❥`פ0>Lx)	YCh)(2ԤDGdE%;#B1ќi2Uɕ/3V}FH( XӼR k\0؉YmYn(Dyt7'&KK(\"G`CPӹBrgg\n!zAh\$.oCrmH6{*hV7NJIY-%ڨQ,iEbM&LbtkXy2\nڠDCs85p\r[#P\\hQ\"X<I/fK*qq1q|ՙU5tJͭvP+ m(Cf*ЧPf0o\\1[88c`I:}\nC5pBqI:SSp<YCh(#W1gu\r|)#VkQ9~oJ|4Cq}>B%\";vEǑ+Xr+\n8Gz.Qy*)s}f?*^{\r^DKC.QM|N3l熷_0e*p7XS/%%sQlܡ aIjjMJ0gMpIzAG60[{L~M>b3/XecCRh.A>hpilpt{!^\\}wPKPR\0Jˁdn6Z+G\r\r֘x)HKgǮ\\͙b~K)=:nLW7#\0+O]ᑟQC	\0lk^kID6|s>e93Of0YVa\$VN:Hx.\"R%9G#ܫr`/2:|ג4Qg<F6GH#/'r:A6]rBźTX9U끯@s˓AG;bt(vF;{(trݵv+·<G1@gv	5x>a8	kL15[o{|f{oD=,i[uY4io;?\r񾦥G@`q\r/\$߷cfz~g~C% \06!a;9\$DC0\"LDL`l%\"/|#^qzQKi@2&Rǫυ&,h{e#e)0TLLxJ d\n&NүzBNfnN(ND\n\rbЦg7ry]n'0l6D#Ưb\"t7\rk^تԢ\rdքs~#pJ/\"g)#ư\"\":@b:ANsNJ1,q2(Q),6Jz7\\.*#(pL&L%4Tp#	٧0>P1O@qL9#0-ұ\r)#-g~/t&8JQ~Q8\\,%F\"<NثNwCf:ɰϖp\"*-ѺǌB>m;r:f#kd/#B>2B983!кbl\rƞ\ndc1(PI\$cXK&y\$b. iѹO\r)Q4GUx\r,ѱ*R%(u+O--Ib ĪFn6B2G\"dx1o\")0rd\r B-R2,'RJ`bbgf6pSI\$<#P sD-4>Gsc5P׆|\0je3b_\ņS#Ӕ /9Nf\rVh`M2^j6;\"z@)⅀@\nZԎI9Z#,,#\0i:I@\"8#2KL#ъ	#2p +84׀,b/e`8vcB3*4896r+g8ń?m\0\n\\QA֤hL\nllϯ{rsu\nx\0Bh`\"PSL*ǀL2d+\rrm6\$JcBOof9B4m\0+4D:|(sJ&Ԧ%1KvF\r	V=-TDvzJ`w\0JBTT@CCUGôjג|\" k`I\n2)?";break;case"ms":$f="A7\"t4BQp 9S	@n0Mb4d 3d&p(=G#is4Nn30r5h	Nd))WFSQ%h5\rQs7PcaT4 f\$RH\n*(1A7[0!i9`JXe6鱤@k2!)Bɝ/Bk4C%A4Js.g@	œoF6sBe9NyCJ|y`J#h(GuH>Tk7r\":7Nqs|[8z,c*<⌤h7)Z\"íBR| 3P7z0Z%p\n,X0P>cx@I2['I(ɂĤҀ䌸; \n*0\"sz4PB[(b(G\nݠC&\r˒Tl# Ժ?ì(c&	>o;#7؃@@X90z\r8a^\\Qs=8^%Z9xDk#3ޖHx!J(\r+lf̃\n\n(H;5C᠗T`j8@.P禌0\nT\"!(.xaz\"%5Xr45H\\0usB3L2EZ\$3! Rwj[8\nn&3p\"B8(Nz_F%p<-ۣ)QFKB)\"`ߨ R`0+ǹC?_00ȣzbγ\0C\"g!GtMC4d?F ('#x3-2KC22)y\n	N76CΔj#sBruzaKN3+{xR7b)#@\\6p^7OÓ\nǎl(ާg3`aNt&tPIH3	|DNybXAW6[4&XfUJKTCKV6Gy̕wZm\$?2w-|ə}'c\$\\\\+xX@,ZW'j,-00\0ƽIdmpʞ6O|v}%I؝C1{ƷMڤ\r|ǥ!#f|6(R\"|\npƭ!3.!.\rP6X`@@P&SKAfSϞPBμBE0ypyI?MR<MYI+OrHRJN6&4	F	CBHC\0(%1f񎍯ǥTA(D'Ry3^js\n<)HC?HƹNb} g	vaO4\0e\r苑6GW+lO\"M!2*KhmINY6ro̝'(jt3J4A<'\0 A\nPB`Eh5v*LBM%qNGᕺE%J#\n_Q2?\"ciz3!'zv{TbNh\\C 6)Hs-ͷG)mIt`{1꿒dhV:cٖB(VYKysT+Po2BnqJK7r[@PCT4a&%	4t,	HH7M@_AG\\kTEOa|ڄ'{k_	\$7R\rL&jmQEbU,AM]M܌F-:KT%)1*5,#<EMt\0F*\0LN	*;+a`f#\nHNJ2vQy7%W\$jV:VM4y!U6^d9f46s\rB Ҙ^w\"\$L4J)cO>N42I^M5=x{9		*KtrqO={9r#u9!j; 6ͽM!v#F90L(<~qև[_7d]67Tׯa9[ݮA̅oiiT/X2e2	~\"3b,My:ۤNNS\rA~D`;QmH@q#Gg?+8fɿ6BM_9Ծ9{򭴏;Vu9VuZ6^&xY{'úMV~H2&Lʯ]2*XpǛ,:'gD)|Gz@yU`B~F}f-}sZA]7qxon>aڀ|~G\r<I~sEKCHBN~&>(LFGCvϠؓPF-. Z^Of2\09Ǝư/菂:&l`O%Ӱ~fPem&2F3\"-	,d?pO0Y\nYpq20\nKL\\	lLNvɈ\npMOi@搀,H\n;&!\r~!\0bvNâ}.'J-KC`-w^5FR1 D2#8E@΍F\np\$\\ьL2:8IK%Wj\r!b..6+(軧H'biO_\\\ri:Ll?Gm%&~n-Du.\n\"v2/rO\r3bf\nFjug\nQrzq\$>F'.`¬V̊@\0D-#'de\nh\n1#B'!r)e#k(]0\0>~q";break;case"nl":$f="W2N)~\nfaO7Ms)j5FSn2X!o0p(a<MSle2tI&#y+Nb)̅5!Qq;9`1ƃQp9 &pQi3M`(ɤf˔Y;M`@߰\n,ঃ	Xn7s4'S,:*R	5't)<_uFĜ'5>2vt+CN6DϾG#U7~	ʘr({S	X2'@m` c9ȚOc.Nc(j*%\n2Jc2DbO[چJPʙahl8:#H\$#\"::01p@,	,' NKjP6J.|Җ*c8\0ұF\"b>o2P%nB4l3O\0\$xԊ9r91\r  jPA4RCIåLسHpd臎EJt㽴&5r.8^E#R3.j;^0Ѓ \rʛi\\\\1*:=:@POs<ͪ;\rأ'+î\"4tȰJCVU#pH(0CrLUcUYSL(0b;#`2q#v1K\"-'Zi4\"̗C2Td5\n3u^##h%ފb65%J.K\"7-0P5CRt#CȊ|^ZX;yBIX\"\"ebf1в-w L)ӌ PשiXk2`3lzj*A	8_]Y#6#k3ʊ*%6|2RTȼ1>9`rXa!9<a]yR6vҹ\$78|J 3Xii4`@H2ZET\0u^JQ*g@@_ypIK&dqPJCіZamuUzKr'TJ	.3kLKxTPI\r^EU	#'(rg	#*up1oDHa	ZvҞ}4,y,h3Q8Q~\$p#(S\$n'AU~)?4aҚtvhAS6jѦHsoI7'\$잪Tp\$hH	AMT(Ļ҅RgMSEŧS	'22^MADp\0 -w\\ٕSg1EvKt6C@HNNzbQMa/&*1?j4\\#IVʋVQtC&RQHbP/2Ep \n@\"k &Z/\r9B,XA0DnaG\ne\rO\0O\r\0Z(6Ïl2tJ?+DG0q룶-􎺷n!,T4\nR[78Ik&d5THcĘ\"75VI;W[PuX9޺ٓL*\r\$*j&5`({VEʩO^]m2v/ySe<8LETL!Ø	},M?=pC]{ZPD<|@S=uPU\r20ĎWt\"΍E#ua~\n!AEj\"W	YZ PSX;/H)8B>	I2!G7=?8EX29AR\$~}Q+pv%]W38Y̈en`u6j <%U9OJE+E5DKVײ-[DH&,C@Q\0[x\"JJ!+I\"#b|X~f33*[RQS\$i{2S|9Rő?N&}:y<}ܱ,x bUhkʃeCns7JCsdոLu!͙\"\$N{6QAp*f!PX)A8[tm]`sOmW#1.ĖC9CUܴsjA]VL۳XM%V+ȣ''~b`7ZmoǑv;v)xQ1V,=׌aRz#@L(:<HItU!La̩\\%B?W.ϯ xԎ\$͈Lnؚヴ2&j\0\0Pb.Xbv#zXI#\$&(gP,X0:.C6İ'LSnE&VnC#T\r;쒸<J0O:ɤ\r'Njfn%P~p&3\nFj3,s\n\\uD:HR03\r/\n&etB>:Psc%\\\njQQ%zl`Ʊ\r@lPAi/w	8,lą<1b3C'D`ʣV\"Pq/2C8bU@Xh1&if!feG\n5T\rЁG\r%tZ}Tgb\nqm,d	\0֑\r	rf\rV\rb<\$'C.yz&Bԣ1C.M@n)8}\npIVeL&\nc%\"8v\"MhB#oK#\r0#B#B't*	`T(NN1QtL~\$ E'D   q8aj	Dk&ٰ|xxFdC(\$gq^oJ.B-rL(%Y 68G4q\r.*c8BF8Q'L.;-ob,k}4LFnK*nDT4 2R҃`ae\nt#\0:PRBt)aV/(T\r.@NnW*hN`p\r\",si+.XTJ 	\0t	@\n`";break;case"no":$f="E9Qk5NCP\\33AADeA\"atl\\u6xA%kl9!B)̅)#I̦Zi¨q,@\nFC1l7AGCyo9Lq\n\$?6B%#)\n̳hZr&K(6nWmj4`qe>䶁\rKM7'*\\^w6^MҒa>mv>t4	j	Lw;iy`N-1B9{Sqo;!G+Da:]у!ˢgY8#ØH֍R>O6Lbͨ)2,\"8	ɀ= @CHצּL	;!N2*h\n%#\n,&@7 |*	)*R<HR;\rP\0s(-˖ޭh2(\rZ# ڶ(o?(+8?Ј12S:\rx!\09P X(ПD4&Àx]]Ar3X_S#J(|63-g-x@z2N`P :Եc2U#`ˈŁB9\r`9\$<\0HKXC>\nPˈ\r|\rF7Z}p3#p`ȪZ5KL\00*^P:`+@3k2dWKSy\$r>`\$2C\$f^0\"k,M0Hwy]4\n5C+\"	,p09^Ϙw/+[\0\$~o=.} U΢ }ǂHF2	5\"6ƪ;{QxO*t͕#Uwl0*WaJR*ؿR)ߩh@5.L#!0CyL\$bHA%!P45sDuRBZ 0@:(RL˒[dasl'a?jKP	@t%\$ Z!M0&ĥXV[+tX+\rb劕ZY498\$!P!^YaI`ҚxNY?atm!Нb0NvGFɞ0feI-r1wT*\"C2^QUT=pK\\S᠙Ic844a˙LTk'R0P\$\\H@P\rkAE1I(\n\\ih8`oQ\r.`290Q@rkK֩g^LLl\$SzfCP[DC\$\$Q]*O/Aa;tjUȀH4|:p\\i:	@	iV^\nkI2[Z\$t(D_7pH@d&䈒Jx@BnWJPFiδ])b)G)sD2(ιЂxNT(@+A\"fO=7/pZm	.\"[ʛ0h\"J3\$vܑtn+\0)XtCT\$a\$]+)7I\n^t|WCJTJ]КSRbO\$<֎~`LPUCnuZdB!o?bY!R]*`R\\La-t\rD;^	3;gA'\$ؑqKxT-/(ljD9'G\n[X/핟i@Y(RTqy;TyAYpBH8yQ=@ː>\0/* Fi	s*0 pO	jFLipr!1(6ͥ ZsH&u 72O8z<Y8tL]ꭌDT7!C!IP\$fݜNk!1 )3/\ny\nO,K{AކvKBb옹8\09 3ы-\\z\rGՓ1nEť\"-\"yxM5#>-^Сyg4 5Nd^-H\nZشo¿\"f/\r!Pe\r #~LßS:_B.R:!jd?d%FC\\1IrTׄ\\t'x>e2SLa\"GAd?]c\0?Wvߛ;bS~b;fMXƠ\r:	\0T8DgD\$x_t3\rKY7Oȿ0y}>9wcʳh4T_v`eUry\$L-Oۏ\rʭS0i#d'DwO)&zo-v^e\0T^<5+i2Dp:`6lQrH̩lhOSID_\rFdݤ`\\\r'.Aeglp(pP|\$l\$\r~bt<M0\rB]~b)jpF\rqgM>9H1?Q(K(bе*EijBe9b8eV*N?}A0lh,:N30\0FƾʪDzMIніl\03,.ꄝIsCBAtSfR0Ȼ*(d%z	f\$`d\"dd:!J1ըH\0D``A\" M4CXʹ.ā&ZK&\nr\r<%1tnFy%\noܨ.gP6P}~ŀCQ\0#N#\"lh>߮°Ad^E60)bˋ0lc\\SHsq,B1,\$q~6+0-j53s/˛-D&c\".G,,\\`J|#2n0\0.20m3-]\\Kfq3- cڷn\ng\n!t@P?x02Pb.&J	bDQ1F\n-iFn\"";break;case"pl":$f="C=D)eb)e7BQp 9s\r&ybob\$Gs(M0gin0!Sa`b!29)V%9	Y 4I0cAn8X1b2i<\n!GjC\r6\"'CD78k@r2юFF6ՎZB.j4 Ui'\nv7v;=SF7&A<؉rZpk'z\n*κ\0Q+5Ə&(y7r7C\r0c+D7`:#\09ȩ{<em(2ZNx! t*\n-򴇫PȠϢ*#j3< P:;=C;#\0/J9IB87#06@J@\04E9N.8Ø7)@PmcBNOc \$@	H޼2D9#Cv6\r;=9nhºkY\0cUJ ?:4p+<C9A13\n@:\rx^p|\"Ʌ\0xC@:t5|9^*^7p7x*cx04ܳ1[`-.Jhf\$Tb%J'> ,J:23:9l58Yj猨	cx\$({LB\r#pI.]^(F6\"xZbëӭ\n9W%=b,X3\r)(q\n1:0H00R\0|':%0B5k@B&P8XMOw :v܌y\r迹S80hQ㤅Ih@P6|`}>_eKCÈ^:`(6&#AH9	Ma3\$>MyT\n#DIY-NC*>x0V:An2Ε9``\neo4Ag!.ИBY\nԉ SP+,\r!8Pq耨a¤PKf:`CX;\"Ȁ aL)`\\E62RPA:^\\C݂J,:V	'<I#`ρ\rD\$'<7LoBek-\n\"ƌ2X96QJ=JpMQ/\"Ila̔'DJ1kV[qUκe	]6/D|^КɄ\rR(p0.T}GLbA	aA ɬ1LD)(@(MX'C`l\$)Ya:%~C4*+RjPsT	V]`s3R\"WP\ntUQ2(d(!^LIvpS@@JV'@=@Ú4\r'bQ\\-4d-4\$00,	Fi>QXcHid0a\"%(A	;p\$9/-.sӉ6	D ^P(ՑğrTOi595 j,>e̓q^c+w\0007%\\&Js{U	M1:6d7[@@p0iTDvHTЪd(!0\0;\0RJ2?0Ty9b\r%zGj?3X;P[\nIuSk#Ӑcj22woFi'Jg>[q	ǵ6Ãl0\$v\rPtЇy.j牒f(,I΂#DկP\n)^K/SE`DLxƔZY)C oX[|0d+uSRCQP\$j d7|ke\rfe̞C\\0ID(k`&ҔLWٟmQ<wI?\\cH8\$Vx+ptn(K2lX1N{ka>)xFm\"HR.2U6\0V49#SP[[r&*&CxeH\$\\_P !P*ƶ%ݎ=EBoT:>H5y2\$όyBAvc'M^\$u{\$[-kې5=#Waa?k/j2q?#2|&Iw,K;|B%0Wл;i|-j񳮻&	+z=/gPGXZ5_X.#oZ<ؑ(/MXgLCv	=d\0ĭ2aI5H\$(M\0@PL\"JFK0c ;TeaC#R>pBJf\$|*&:BDې@@h8\r(0mB0H	Fw.KPt߰0yۂ̞um6LFƶ!6Ʉ\"<&ԠD8*\$\n^8CN\rEx9&ʬA4`\n(|w	L缳PGh\r2F˧4\$\n~;Pk/ǬЈyQ懰{Zp`S10W	oN\ngAk0MMz{	uq\r쵮fb{YOfooh1`i	/zfXbX	1MHhLX`19..JqoLŲ 1Y]\nC*ጠ:.dTo()B\$\$DVDtc-eAb%F@%8p\$X<lZ?%2jPl)G@ED \" 0	G'FFώ5A>QISmF:,k-p=\n&7.\rdiQ%rؾ\r .x( dE13	.S %0y䍳2;JJrf%=C8@/1\$ǀʧd.1AmD(QSNi7}.\0֖ҴcIS9\0T}:;2:d u%2\"hj_-r8\rs4),>=r82?;3@G\"s8QA1\"7-#C<ӽ@̂.C*tApMCCm rBN5D-\"sD.P.y\\'D 0{g|bGASACNHbDGncS)eu\"7Q{C;&DH3tED(SF21ªL4p7M43o0tc1MK+L/\"e!%NL@`*>sJ\$Ð)ú),X1,R(\$6)B/t\nZmP%!.WWt-0h]WƸu%:@e,##b~&/BNT'I\$45P\$SӊrD.;sH!ETXX\"5_k3MR?k#=:9C߂2 @ޏBc+bZ/cV%X0(h62GM\"	v#RpaY2f#R,ct#nYVaȪ~%|S\rpTV.PcneGthʼc xOn(/2Mk0pH3Q*-bɘTHdCS1DӶ36iin?\"R-@{\0@%";break;case"pt":$f="T2Dr:OF(J.0Q97js9էc)@e7&2f4SI.&	6'I2dfsXl@%9jTl 7E&Z!8h5\rQz4Fi7MZԞ	&))8&̆X\n\$py1~4נ\"^&aV#'ٞ2Hd0vfβK\$Syx`\\[\rOZxN-&gM[<7ES<n5stIܰl0)\rT:\"m<#0;\"p(.\0C#&/K\$aR`@5(L4cȚ)ҏ6Q`7\r*Cd8\$jCCjPr!/\n\nN㌯%r2\\BC3Rk\$	1-[\r@Ą TT\$A#2JD'ҽ@PҀJ02t j|AAƃ\$:C;#~:ְA\nC X ΌD49Ax^;ہtmU\r8\\zP2(@ˢx繡^0S3>9Mbılk+ &8J9ap7̺϶PHpΊ @1(Hbcx:1=LNtpr2 ؏k2c-ܿǈf@ӱ(xk8cfV\r{LF;b9U!)vkg9Bƌ[ؓWz&\rx7)\0(SC;[ACm(u89o]r\"PeBSZ4(	#l8(V׬(_u%\"OO{߁LI(j3Fҥ83] 2i*\rzQ؇0Ձu.Ie(\0C8a/E((`J\0C\naH#A@PYHMK׳V%WC2%psW̛N~\r%y]*A[Q2IV,LP@ʗ_MQaYh=\r!ا54CŌЩ~u,ŝZemվ\n\\s蝗jyxx I7ךH؞N	\$BH@R9dXMyGs.!;D(4\nka}RqjEhF)̔ @hD/MO+BH\n5d\n\n)\$yG\$\r<#׆sGU73u	IǑ	)\$(3Q(%cq#\$TW1HP6N!ɦZ\$M\"H(,\\ney\rbD?eB<)EyIuu3g9V]ԅ|MA4ge&9:dESy.aI@ލb.y!p Ru\\Q^|Ƣ\"HY\$ɅVj\rQrf;\0\0U\n @kD0\"e4ag	`Rl\\xpm\rŵKM`e0@JV Y#xi	qPYsТ^/=owF6Z\$Q:yb87h\n3(D̾#R\0PV x\0u&MV97Ke@'\"ZF F⨎39\rc	ȠSR)}0	).k4(^.%A;3Y'X1	7v&8,Ю-qu(\\YlX;D)=8*g*{Cp)d9\$ɏir+ܗ&׃\\7SDD,KR\nH[PBH\r̺Qpy@2^kڲj2z\r͗lAnJeqHҲAD3&7^K9[m\\/~[?nmfEg\n!XՒMa8fKi*@Im0oVfjIj<prppk)\$ա1,PRn}kɸ@Dd(&U	-q\\֗Co=!rS4~MDEAco᠛BzEը0c)VO&nhI>mf\"aWe|N/h=cۘ\"Wn+7ِdKtAF/C!6	܂LtZ>~O9S:E36oA^n:U/-\n8\rߥw\"4g	Bb7&_ԫw\"\$o,/whx˟>9</{q7Sݸ\\܎/|dm4+B5\r\0fT*æ.o5-P(a0OR9v/+Mb+6;I(fF,/jDl\$ n\$gK.^ⶭ͜ P`JMA\rG/Plr\n q\ro\rϦgp%(0CԎ(\"[L.MRhDk\"(p-Tb2)(Ìb(0-AO1D:TFqvK\$lNRj͊-EǮCQp;Gn#k\$2PQaThW&q_pJ0%b)\"O{qQg\n.Ѣ[\rrYc[O!r'\"giCg^M #D'>yE\$2@0ɀދrJb'fpm6O,Ijfe/o<1hX#7Nxh<@j\r&HD^B3N@E,\r<Ab\nqF1fTOk0(T0S\nޛ#xN\"%w1v!R3\$ȭ\rrE ūex	^<(H̡tj⊽Kc @1N6SCB'oQC~6P<0@j(אJ{,:D;:|5z\0URB<k!\r&6&LxDτ'p˞QЀ ]##\$:M\"\"mBN/\$14.TRSu<O`r7\0*sM:e	(p&t@:`";break;case"pt-br":$f="V7jm̧(1?	E30\n'0f\rR 8g6e6㱤rG%oihXj2LSIp6NLv>%9\$\\n 7FZ)\r9h5\rQz4Fi7M&)A9\"*RQ\$sNXHfF[\"MQ'Sfs!\r4g฽䧂fLo7TY|%7RA\\iA_fDIA\$QT*fyܕM8䜈;Kn؎v9Ȝ@35z7ȃ2k\nںR4	Ȇ0X\r)q\$	Ct9#%څO\\(v!0R\nC,r+/؈ϸ򰘦ڄ\\55X漲ȘϱH> ئK6I%mp!A\$J\"++3b`޿x䞍Z#\"PSpA@Aƅ\$oH@0Đ0Hꒀ:0G\nC XьD49Ax^;tqSar3X^8Bv J|n3/x8h<:ꒋ-: ؃SZ#xV4>'\rҼЮJ.\0<NIe\r!`ǉ_12m裂\rjƽ=2э26faV]R:ƴ\r8Ǆ2!a\0؀@PbLsSOjF\n\$Ѓb:ؔS{9ioP*&L[>c( h[HDs\\92Lv\"|GtM'l)6#\$(\"7եɇƁUC\" vw1}_͵Mb^\r060+0IޠBˎn9^M;#?qd`PPI9\n5@R˸;7RAp RĴY//&Ļ3y)dƅ\$\$o`Q?F8 Tp9,veʣiY&f,I0'H3UI,#±ЂCvQ\0cbBXECFBʈ=h5|\roܸC(NAt.\r&8\n%8pf\"+G0Sk2p`WP{%!4h]*HOtG'DghFi 0QDA5@@PA\nm\nIQfFfH9BIb6:\n1rH\r6̕X?xDRppAQC	9\n'Rf/P!FS\$#lޒ&2L7&FIAHy5h ,J7d6iD;s6ֈ\$\\2\0¢1JHu(:V;/%Hq18mS:Y	}44eL7~bVt=O\r[bLCs@'̔+	-Oϝ7D\\I1'2*vxm8PT@-#	\\dOo@1E#3|'(!jfNQJ<fc-YQe\r!%ҏeztK\"P,U(տHhJqY|'z\"!ߗFSfs4C\$}`#[#`Hn਩Gja)8dh\nSOrJ¤QC\r'F,Ƨ0x0Yꗕ%3oU+C92ftaC(wAXϖ,fcb;b4솕hXi%˹}z)pNuL\\};ÀI}09vrΩ/Oj0\nz27t7#	;@\"_`Ҥ\nP 0A}Ao~*aA#X/-,ѱNʙ.O6>XYcIɐf=P\0adF(݃2D{M6F&e8y9epc7PJvcۊᣠZ6->`7~~ֹ̇	jd#DHTvxst\\t3V+hHHG\n/R01b	\\)BۺLqH;,04L871(0ř}hƼ3@LOऍ'\r=,S1ׅ<fV@N¸\$*{z18a1Yd%2rEI\\95iÄ\"aS_bZqPzQup\nUd6'ޫxԥ~??{=%v<+\"(&~kx?u͎\"x2ң\0ۨ4N4nNڰ͒P7\rI6K8JLK4ȫ\0ohJlVbfcovE\$\$<.^b z\rG)J0\\DO\"TR_Ϝe%98M\rEpFp_v/\$l?2Jsk?ʌ<oPiTq3vk\nN2pR\0Q6\0XB/*f̼:4TB^h*,!Zjm (^H#L\rBP6֑Qq\0Pjrf'L\n2HM'XCq,Ѻ(`.@o/&\rII!U\roʰ\0Wo Gq,3\r\n?\"Cg9pf,*fl@L\"JLm2s\$V\"!RJb]%Rp3` mi&@QHG,HKJIuĭ%2Ir41K!àr}&WG\0S\rƽ1\",fֹ\"dʒc0oX2V*CC(ڒ/.m.#\rVm,\r]94\\Q+' C1ܴZh\$\rkr-6b-0<\$DNjV\"GqV\0Kb/3C*lZ|\r?C2kݰ\rXqN7,4RcJ5\nSF(˺6~'7/1 fgD?7Й\0006qƎ`44*045^;\"?*,pBƣD?<,?\0ҮfB~+joĹFvk8O`4sV@DFD3`0,Z2 /3d3)\$2&%'&`q\rGnJ6a/";break;case"ro":$f="S:VBl 9LSBQp	@p:\$\"cfLL#>eL1p(/iiLI@-	Nde9%	@nh|X\nFC1l7AFsyo9B&\rن7F԰82`uZ:LFSazE2`xHx(n9̹gIf;=,foNƜ :nN,h2YYN;΁ Af2r'-K !{:<ٸ\nd& g-(0`PތP7\rcp;)'#-@2\r1À+C*9Ȟ˨ބ:/a62āJE\nℛ,JhP#JhV9#JA(0\r,+ѡ9P\"ڐ./q) #x2lҦi¤/1G4=Cc,zi2t̬Bp\n0B1T\n,7p8&j(IH(i/㒵*#&û446Vz?ģX4<0z\r8a^\\)/8_IpxDj/c2x!Έ2P#Uh̥C `WY.N4.\"ɍ\rbANJ+r3hDcCc~5BT0ق:\"a+\nC?1L20حLӢ# #Z4C;\\K70A°[Ƶ;3\rE\rozä(\0㹎CƌnG9M\r9SW6wyzcE9VoD!8Ί~<t\$:\"o+oVnLHzcBHA#jD`)=	\$¾(2%1C\r.E\nF(ŨC@@s\$!0\0o\rjH>BC<(fEk f1z\r)	-0&kW0 ]\ru D|KىX\r!\$-Rq\\>+3]c&F#IMBo4LJN<005Իr^K{/\r<#w3|ʧAQ)xb{a5D*,/29P!19qQ.We8V\r'p-J`3I#tM+b\rA9?ģa}R)!)+,چ\$oFd){1cࠩBZ܆v[)%e6䚡G)uR@LWDH<6NHX\$&bhM)G#tZ\njhVHkREb2@3\\<\$.ZZ4.\"u-Az,\rB#}\"Ja\rE('ehHv˔O\$r@U혢^AT%\\BҢ-jIM\"vMaJR9Mrn`F\n@Ul%bO9^QR!_KQif'0x(L%L>VV\rMXő#,}oD #C9ק}OV[I	`ASI?gW<hY{n0 2UZa/VDpru*+_n~\$bXZX2+#yQ@X4TԲER\"KHIDbLU9Â5}rk:IdH[ a^/gl%l\"ǄӸel8PK07ǊOQ{zɐxpxD^|OS&SܙJKX&*ӸٱyXCvL`8\" M	dv\\\n).UbɡSa-o-HIF\r5eלu*aԉ @BHu	Vb !	F/遬ť\0^7=qύp\n\n.	&2䄻]3<P̏	*;pJYY\\8/K1@~>*vG+	J&D8¶iv%e!\0ʉS1+}1(_\rH3!͛yoB^uA9ae42qwi\rHԽvGVKj0Wx	rdy=fo|tȬSfgǚ5A&mA\0PF'yq	o(Q0팧Fu۳\$cg,%%n/v?96ʑɴciRA9C|U6J6\rX-E¾{ٝC_eKNZg+OքrI*nǸ/tr(obgq,zz?*f´X9ʑn@Ex20hdcP*J|gt+PxPNt-nAd505)p2ˀj\\ǫ:ZcGX0?py`pӐ=P?fzi #P*>MKb h<<,c]#\\\rc;((\r&( [nU<\0%V-&813fsP{&]pfP]QQPͮel,p-RG2 OL0qE0wo}\$Bmperc1B𖎜\$\$#@;'*'2p:8ngpp-\$	'\rp%\"d1\n,#j`玙- eC:J@4\$5&g&kO&\$P/&AV Aw#҉(%)#L'c2r)q{%}*+\")Rp:,,ĳ'\rL286].\$}hno\0!KdSQHr>S,\rS0EA/VTM@ľͷ03.3DTK1O%\n\"z\nFD4'B̒DJ\nz< @P?e(K&* j91sT6Wgb2\"lj7g\no1n:i9ө	5XP jwpmJ\"&1H\$r\r&\0@\nZ;i\\i`䧦nkBM	#|64#<\$DCMq4F/&hvDʤ|C3G\n#N1b\\sܐ(sf&Ɋ8\"A(O,vRNifUn)FUBN&U葡KgO2hO+OL±Zo\\g:j)xtM1.57h6&\"M̸D1DeX\$fcDKFk'56;<oBb:DDt @&My>\$Ũ	QF_\"cj.\$n374\$-#:I\"@X&(+ ,͊o;mMsB	\0@	t\n`";break;case"ru":$f="I4Qb\rh-Z(KA{ᙘ@s4\$hX4mEFyAg\nQBKW2)RA@apz\0]NKWRiAy-]!&	pCE#yl\n@N'R)\0	Nd*;AEJKF\$V&'AA0@\nFC1l7c+&\"IIз>ĹK,qϴ.u9꠆L,&NsDMe!_ZG*r;i9Xpd'ˌ6ky}V\nPػN3\0\$,:)f(nB>\$e\nmz!0<=S<lP*Ei䦖;(P1WjtEB5x7(9\r㒎\"#1#x9h苎*ㄺ9Ⱥ\nc\n*J\\iT\$S[,D;Hdn*˒R-e:hBŪ0S<Y1if8E<v;ASJ\nsA<xh&:±ÕlD9&=HX 9cd7[q\\(:p4sV51qcE!x-0X2򨑉_!hK#*P#fB/8rZ(fB6#t0LS\$4MS`@0cw>w0K2ܻ/H4\r0p8NA`@j@2D49Ax^;p×2]*}Z2\rҨ,px!Ȳ<}Z:Tl@&.#	xd<!G5YZDɡlMʿFv+XY;z4.`0Cvb3(էIyĽi~Kʟ!ʇH#\$)eE5Vr=;ԣ\$YT{];|!48)	>)bq{jFD礵IR3ΩY\">#\$>e4o!-ejȗ˪|ÅY=ٟQ	ݞt H%1%-S%BMչ]jAd\"mQ3w:Ҟ,v}'	lnq=sI*ʂxxLFEiN\$fLthX!NcQ@ c #*ƕrH`%\\HϙX&	8*\"7-C,(+%1Ug3HHq*X\$dJd<\$I!0\\WQJ>4O\$DD@XN6%MNq;\n)\rF9M\\3.}?&2kɳAálfN:#9(3(ϞFƻsG@4bR#C	Μ\"rIHdx%H(W1^q@R%P1e.0Ih)-28@hL3 Ճ]ᑙ@֚^.@&q*RФ5RO-O.+\rQ{M<=d LS3\"E\\T;')jA+gm-¶܃sr]kwƁ;sE,>0թ1(\0SȈ1T9(;Oq/0AI\r\$~\r̻+s``oZ_[6cu!9SyR9'Qu+c)&'f B33&:ty\rD?nX pYc\rHv\r+x3F\"Lᴝ21\rgAWϢwRX0)S2^r͂snLC!PȉvԣքQʔJD;,Cȕ)*m6Lb/hd Q,;D(\"V,#me\r[mET1r[ɔv,5FLk0(\"m2*{%34DU\\\0֛*d<B_=%/&Hq\nlբg2]ےwo=QcDy\0F\nA`vWCF߂(lT&U;/t3ft`hkMG3r2'\"CSǦ//a߿ȟǏG @pܦH}NjQuZUDPf;~G\\s1;iT?D܌OO݂YRx.Y 6)YP4\$im%Bz*8OK%,|ɡ_n\0ߦ}(ާBH7# ܲrq@߁ (UImoue]yَt8oǤ\\#+_M\"e)a?iv#ZZ\0HhZ`eahd)G輅wՏLuNti\$P*zP.H'ꇂ/t,K>BO\$3\"DʘY\n'^Z/(DDl*LU/H&-dhZL/F.Xw%7\nP<*#%(	&21JJ	A)4HA\nXV,O2(a\"Xf`\n 	G8J2Hl\$.BXFP \"GyT@z\rAq_g%ۧvEazn|0	0aGq|<q+b.'E܇O!،nF1^j#h,h{ N(-\$I\$:j=\$z0FFڭC%I&2!QCTI(2w\rRzWhȆm\"@A\\&%\\/e%(\$(\"&\"YΈR.!E!fF?j2RR-I.M,g(>C+vd{\\.){އO̸zJ`P!'\0>3JChNo@0o5*.wR+Fc5eDPu.bNX.vUZJc/.9,v*:':c{:6b6GU%ZS~^,'Ө\0t(\"04bC[@p<d\$Ϡab-8\$/=	wGUMCD4/	AoF*rol;6tbbnɱd3*2(9'tdiHT@fFt916EFH9KI?IKF6c6aCLa L\0*X3&Hҿ&q28'6\$&S|AԬ=t\"tFEN/=qP 7SJɥPI'NgNQ͹R'jEkFS2%Sa|\r.XRp*1VBV NƧwMU'\rqXԙ@\"DjBb;H.O=UtZ\n&&g9YrGgS\"F/\n\$[U\$k*),1[+ c:P;VdAVՋ\rHN~\rGc9H/G,W3sG4ISSRq&deC]S6%Zee.mIԕV4Iggc8pZYgG6Kiwe_ejV8kN/4f 2ZVi6I<6kU< |{V(A\rnBBЇO6%i.Q'SG/O\$=fs6wOpyqvP;W#9w&@w+ZVGV;2SPdIv	;HcvAqRcXT	mc(tU@AWt83Q\0AUyi{MICLOyu7=סzB{!KJWR7K4u.tWח}#mV#zV\"o~h׿my݀?=zu<I0#xN/tv{vw3_p3(W\"p!u~4;WQxV-5hۃ'/0!xW1xe,Tt%iLmu:WZ;[eN7}xW<-,Pcux+Eȓ4sz+sNxrU)OW40aUUwvSQyp9\n<.\$cDQ +H	04y:] ]]\$PYYaUC)4ir\rVRºޡ>e>wاоbYJE&R\r[']^AXLS@\n0*]q+Q(˝HM/yZ\"&jD`y`D;9lxr25/E\r(\$5ciId|7pLVO4NZ+\nD0.j\\\nٗA{D0+(\nIPI6seZ9r*aX:_]*}:PݥYJYbh~cL.c;E=z&q#cszC;z̮3Zz=EYy~.//q=39I==@\"+_\0TC\nPz>tkGXvr&: y\00o8Z([{b2gded:4[RA6tp/	X;B}̀ &x8w<SJ_xa@";break;case"sk":$f="N0FP%(](a@n2\rC	l7&P\rhl25rxdB\$r:\rFQ\0B18-9H0cAn8)D&sLb\nbM&}0a1g̤k02pQZ@_bԷ0 _0ɾh\rY83Nbp/ƃNbaaWwM\r+o;ICv\0!F\"<lbXjv&g0<zn59\"iH0{TףC8@ØH\0oڞ>dz=\n1H5*j+P2`2I5eKX<b6 P+P,@P)`2h:32j'AmNhCp4R- I'\ncʳ\$s@PHElP\$-64ba?*NMM%4-NP2\rA0[Gp'#~9pה):\rBD.9`@\" 3:xwrAr&3_l^)ډ̉c\0007x%\")9U*Џ<3`5Cs\r	V#n('9	4ݍrR5N h:Z;!á](\n`%)BP\"քLV9(+\\c6Ap bC(ë1֢ϴ%CXzPd\\22@P+C&%֜Y>9׾J659c܇\n\"e<mxɽYkRcJvEb]T^/]ۭp1JHb(>~~eU!{~C7\"gJI)3`خHOP&y!=a<V1a@]Mt0p]A0hͱPPI)	e*Bt/Ma' !0p GX2ÐmmFr`TUZCeT;-f)\nJV-XK\".%\"\$XyQL-w\nV1lhUᄔ*Eh%\\8ІVmsֻWxw^*]/UCr	?_Pp'\rD䚖 \nk)dHȾIJI Q	7')&5XRIմ(jh!3\")<#-%k'1M@1v^b22쾙xOhd\0'\"H bdB'!1ztpz0@\n\nt9A\r@![d42\rYAՆa<@nIjH\na#!wnƜq\0^L`fHLN(J!h;C8L5*h-̬\0̀s!2@BB\r;xII	((/hK'J*Hڿ)(30qDhe\rU2k\nAE7kaL1DX#@pCsA%ϲk?Ĥ!Pk'B&rɢ`('@BD!P\"K(LӐCTv8`t(IfA%sХPERDxüxCf[FĄ\n<rn̢[19ABT(	g>MJsd\n92x=@:ɧB>Zztl\$bLiX@P	]\0RCDNjJUPs6r	+U&3vJ*`apiI>j7D!`ɱJ\$='P!)\\ԐopBnWILƳ\0005S4\\Ofxt;uװF<HrIʏb͟TvMz'tci1Y5(#0%dI8*~.M*VP*H.WłeHa0_Yh 4s2C[L30q.PZ<n#*o'Xvh!(`\\y=1UnS k)< mP;I7>rCѪ(<+R^ha|=AfVi,@h's~ې`i}ջGpᠦ{:&1+\r RE:!/\$l2B#*E9vzD\n@4JFD- bb20F5z\n iY\$MH#w*a/9a𦲃Y&d<]V¸*grwU\$3ˎɻb5hm^,#l\\(mZ\0r~I 7\r媼-~I@\0F\"\nBqk.9jBH\$r\r	7@f@\$I:航d(Ib f@&j^A\0SgJ@gyPP%G p\0JB`ǐD\"p0\r'Q\0M-\nm=\r{=#cCmE&Ĩ.ZF戬ot\$q*&..nΙ\rq%J1Ro\n^``켍+Clq1ZE1]\r|e`\rFjIB,lj`G*fI6&j&f}s,̂j\\qkjmY6wPIQ B,qF²Oٍ|Sj'[\0r,Æ*+1jRfv&LrjeRbz\\Rx:(B\rq\0ݣ)g2q`9〼Ҟ(c&z(*ǈ/@keEƮ	bL!RTBu:JHmqeQI)M+'0%/#01mh8Ho`fS\"3l2gO2~go3/0|JiLI`Q'W E\\u1ҵsl'3q*QYǚyS7_3r9d5}4)p&	Q7J[(xU4#-.m&)UWq̟12;]>\"J* R.'6Q@!}rg;MHt@z4\"m1\"1(rzI1ڃ-hXF>P2ӔP@5J/	F-o	b@ch~\rQD+E2\$^B9	'GM`ցέ!Z8[@\"m8:D~Dn2BRˣ\n0ZEb6<ت˶XpQ|ElO%\"q{EbCPƞ.0~**B#>&	Ĝ\nTFI^2RJ)#dhCP~2\$G\".wU##	h&mJ|/j2s\$4JdJgsR7\$Ȣ6p\rʋ\r+06nY\"ucP\$բp5c@'܈`W-C5\$XaT`&+\"SD:V\n5*P#bR	\n6W#T5tFX|u(q\0&pie#\ndTM9#|uT1[BUu]	kuXpUg[-65Dgf\nvCĸ!	\0t	@\n`";break;case"sl":$f="S:Dib#L&H%(6l7WƓ@d0\rY]0XI \r&y'̲%9JnnS鉆^ #!j6 !n7F9<lI/*LQZvccMQ3g#N\0e3Nb	Pp@sNnbf.Pl5MBz67Qfn_T9n3'Q(p]/SqwNG(.St0FC~k#?9)9ȗ`4c<Mʨ2\$R%Jp@*^;1!ֹ\r#b,0J`:B0H`&#x2!*L4A+R< #t7MS\r{Jh_!\\LLTA(\$izF(қ0*5R<l|h J.?H~0c58@/ h\0C\$&`3:xa͵\${9^)2246#L|k(âZ\nx0I03 Ĵh %O\0ˌ%~.K촉|3}R2`+eBĘN*bRbӐc%C`2`PB\\c-<	2Z6':W+Ծë1sд2C:N\rj0'N%44+#l&A	\$h\"\reEhz63(1nފb89v6.=_*\r*\rs';nd;\r+D\0`bM}ƃKZFl13Ҡ%>Yp[pLC;O8@-&c\"6\$:!@zBAbp ]\\Bmh\0rY(BnC+:xCyL3ʁQ)PcLhcH*ZG*\\3b@,\rZ dQ-ش(e	/	Ā՞U_E\0mڽWauKrYK07,m`\$et`/\$С[3YBh0sQ&ሒd;mfF*dUȀzBKB3ER(|.ESa%\0^i#̗\"\noOCX?&i\r!\n̦#`H\n\0RGI2v7\n:Fc0PlҟuFxwԜBdi.&Ț uє2Gqb5 RA}\"D,E'\$\n\"aŒp҅\r\nZa>MR!*x=O񙂏؝ɠz&@'0\0B\rG^@CBIG]S\\f{G#)M6D!h,eF` q!2B`	F\nlD<?)C\"f\$VhhI胮慍C|sTpluL88C/OƵVi!NPn\08&a@y4f\\*\\>6&O&&)fFJJ.ΓóϺLɆb˔\r;.d;4BޥMRd1H}\0Odx%\rC\n˜G<v~	)fX@XZ1yc[[HꐡvI\0_0F&^捑ng!24\rNM}[lLL0ܐ'l\"q/ۑB	bq]G[Ӑ\0cr\\PF[d]!<ٔx38C	\04}xD{602MFIZ02Itb:HA4(bn\rACZÕ`uֳTX6֜י{_jc#;\\m\ru@OlK֛fgg6u9Dd:zML;r<CݧoAnT7qLӼ[q%\nJor\"8'<?%6JE&~{	,:PA}VO ׿#,{rrp'm̦2#L*s\$bvc0\"\\)R6\\.޼H2D{Kl5kR+=.uCa&T'#bYv\$\n+U:~l;vZrid	\0WTh\$-\"Hr5霓э~_\$.]z\n\\y9Zq4 \rՕ9}## b\0Pb/k\0ڍVx\ra|~u\r`Np(t'G9	 \0<e`-Qm-HFذL PPU].n\0@ېk0Ub</-HpNtɦԋ7l,Fk!/V\"e̥pDtv\$hjp6LeFX#6hCD06BJ	.bl\$59j̔6Afͅn=DI]\$W\r0\"nɆwfXƥd(Pp]\01SBb˭l}\rqhATgpBNLDgXf.e<V\ra\rc\r\"HEq	NYr	 K߂L|&Pg2QSv\"@j	0NO.#F`à&`pшU%=!%d&\r\rd`p(ri\$Pu%eQ R&3!3a#Rl^,'np޽,N1	=,*2*m},c*F;yq#\$O-B+ě,/'|NcZN\nޑ LD'6\"!RF/TM1氨(=cS\0b)A4C5Ko4+3P&e3+ʼ%FL\$`7f+3w8Bdے	5m95&/Q9paaIIk+h\07&%\"IL8@\nZ)T\"vO9Mn-@Qz@Q6`AݐՔG*p#\"0#E1dOKb/` \nBSl=<dN|gN :-=C%\rZ=H:\$pDF.,Όr\"\"&*J`k~ߪL-'̯^wMT#M.3c2\$KCh_nkBg%@\rtxCQ=l9I+SG\0	n#m -7Z0K\"bI6D2k\0'S2k|Ms(RvOBUz̢8Gcn";break;case"sr":$f="J44P-Ak	@6\rh/`P\\33`hEC\\fLJⰦe_DehRƂhQ	jQ*1a1CV9%9P	u6ccUP/ABPb2as\$_TI0.\"uZH-0ՃAcYXZ5V\$Q4Yiqc9m:MQv2\ri;MS9 :q!:\r<˵ɫxbx>DqM|];ٴRTRҔ=q0!/kV֠N)\nS)H3<Ӛƨ2EH2	׊pp@2C9(B##2\rs78Frcf2-d⚓EDN+1\"&,n kBր4 ;XM`&	pIu2Qȧsֲ>k%;+\ryHSI6!,,Rնƌ#LqNSFl\$d@0\0PX@^7V\rq]W(Ø7ثZ+-7XNH*Ъ_>\rR)Jt@.-:*d2	!?W35PhLSNT# 	Fy8r!ȡ\01nu	Xn1G.4-܂0D9`@c@2D49Ax^;p`f3(㜓%\r	јXpx!D3L]Kjh{#4TM\0\\QRYr{38'q6]}ܢ9\rАΑ\"ϼ`,\"ֺN*\$EZ32Ɓ j{W\n=&P0d;#`2º#ʍO2n?*+زu(&?o;Y0MC>WJ<==M	?(gbJIT[\\ًkH,0O4uV\n'rpɓqrT6d<j|fto¢ 4c]M. 3S1/`AD\$r\rb&@DD\")dCC\0)#rnS'W!3\0Z[Vt*pybVÃ37t\$tR(0pr7S\n)-euNHC\naH#A#b.ոyR!\"R\r>5lmT7Ȩ\"xgR#DBNZ0s@+⚛U-o 2xkpE82IŃ\"uxԱ=)&5Cd<\0c#d2\\4ٜ`=g	b,eZ8I\r|'>V>1tAO\rm-##	MkeV\$(EY1nS9AB\n,MpX\\Y\0kSgC5HR=I%\$.bdUDi tbzYC23D\$Au/-RdB\0*]\rgz,^ )0cBcr`eq9Cv;۩VLr\r&ExZnvEU,X638\"{O*CD5\rge RQP)XlIy4\nH?;G=~fFAmVvYsnNIADY¥\$KR\np!,Ecݽ%j]5T*[:ydzJ`ZnQNTx\n.:rQf0T9EfX A#pzL'2NܭCTd3	8PTP2%{٪K\r٣J)Z@.њ9(Ŋ\"/Libǥ\06T.+aVe&Lڐ&&\0?\"05kĴ]\"WAvɭ\rtY,i[G/)̿pbJq}pD,AҡT&֭^8_80#XW1yb}r#U.*oWPQ9\"`	4M?hoNZϹ.ĦI&O9EY}n0r0r핺]B!nզSdC08CA#@Hr7Te;ZH)1GlD3Jw<thߍ'C\$;DfЅI#B\"\\VFuSc2=rV\0E;ĶOv萨BH#po~jާ6:x d45p/h۪C)0e3UJ\"rН?BO.1/qj?k̽pnO\0锈CfІ{#n,16-\"S\rҎkVŰ:\"0B\"Hp0zL p@Ix.Zbu	>\n0.(.@F@\$bJȖMj[\$PbP?,MmbRbDWFN\"d*1EJeG\$.%]Ԍ8zϲ|\$0l\"͔1nW,}d_DY8BLlobi\n-D7=Nf@NxjPm!EΙѠ4ѵ&H{+\r\0Ѹۥ5\nΐl3}W#֤BEdF@b9 \rJR#r5lERNI\"/([4[f.Fs)m~.0la'hLG(j\r C x-؞ѝ}҉M*kO7GR&o(-2Ⱥ**m,QC\"0:m3\$&[*01\r2\n0o(pU2#'l\"-\r(b35e\\{06Q\rkrί)6U+\nKآ9&\"oG\$?\nP% FDd39:\$v'+;Y\$By.%Sl]& ¯<}+2-bk!3s75>f>Qv@m\"3ل5)C(S7TA\"D6TDnܥ5BG\0DiDnn9.7PW.j>+Gl^ImI ȘDoF?81k0#쌪>KQ6/f~KBHS#My/NB+EN&͊}htBmӎ=Py'\"1HxuR?.,\"A~(G\r򵋏Up%E^)H4OP/HJ4a#]WF'YSfQ5QXt/<4O[B\$oCշ\\TIqIS(>\"\\\0\$[S'B\\58o9HtjuU-tND7NJD5+5\$Js1MF)/mT	jJn-	k:U3G)e+=dKEBMoJm6'vg^R.3\0Ob@3Q3*6f֮4i4\rV=PLv.*:t(@ˠE\npWi'sIDvrFʼ֡p'fJv3J<PҶJKeJJS\0	޿/,%C!a\rQCKJp,q#%51A˪&*sx1@1	wCH{O,eTn>Ava3ma{Q'P&ܙb4u|&R	w(UZ~~ruww@V83YLvt4\$QxQ~j7%փ>Ї+ҫNu`\n\rA48	tÎLl1/{G\$S Gww\n%\"s-'ҿzD4_.52_:.`";break;case"ta":$f="W* iF\\Hd_+BQp 9t\\U@W(<\\@1	|@(:\r	S.WAht]R&\\I`DJ\$:TϠX`*rj1k,Յz@%95|Udߠj䦸Cf4~Lgp:E5e&@.quW[\"+@m\0,-һ[׋&a;Dxr4&)s<!:\r?8\nRl[zR.<\n8N\"0AN*Åq`	&B%0dBBʳ(BֶnK*9QāB4:Nr\$Ţ)20\n*[;\09Cx0o7:\$\n5O9PEȊRZĩ\0BnzAJ<>p4rK)TB|%(DFF\r,t]TjrD:=KW-D4:\0ȩ]_4b-,WBG \rz6O&r̤ʲpՊIG=:2F6JrZ{<CM,s|87-B#=5Lv8S<2-ERTN6iJ͂\n\nq?bb9mŢL\r\ns;9hyzZI+&aXJRRBٳۙEtIt&E[jndFĩ@ l3O>1p8<CO2\0yӍ3:x߅/7Lt3P_?tL\0|6O3MCkxPF׷0S`Tnz1\"pPRUq~}^TC}.RN|!i@bt~0IR@4/WS\rAJ#pW\n9%},`&ᛁu:!BB!p9+>6r'0P؞a\r2󄽟J)J5`teDW2B` p;T3ôsH\\mjgfGeuGi0	5dIZe\\(I	IN,S\"ލ6FHa\r(':[3#%rDB\"xG(IB 5\\ح]2Mt6QVJNT\\gĢ%y\\6tC)gq]`.d\r,d<ݔa\$63(\"YIO*MxGJ0M4Ci՝x=T7i7JsuM1CX7&0	rGl0f\r,~<\nAorN]̆h\ngIֱw+ R@ 0S\n)+) R\rsu+4Z((@dHsVʷ!7Yb(gWjt`GyE^Ze.Qi#\n\$COUp@guR0yvN0D\"I%ST-JiY%!)MVb[e3cc6@So1:ivJ\r;]wn߇w\\Zkx\$7<R+zTfT.>cHf|`a\roY>z͉(ƔA3`*NزY\r/rRE-\0b<A3&+fI<-kytGpeHPCHO&y1\01ln]0(YL\\hs\njG^|O)='XfÐt>;:ihþXQS{R(E+x0FG?kNGCL\"Oklh5[Q\$3'fr#&]&0tnKJ!>fȆ_|WLm;Us;I#8܁ eXdc#@4ۏ%?,94u~=m6͊\0¢a4fm7pO썥\$66Fol>~0i9H\$0PeǇC;US2Q\\b@)7t*i	uM\"5<q)ăO*}*tT}Ir0O	*\0BE^h@/n!'ЃΥFkW(3LJJM=d)&2YMEn0\nw~)_3X*B)I&J6rC {5x\r|!§*\\40O͢Ed\0/m\$<|⩍}08GUxRI~)-\$F P\nX= ND&%0,i\"6>-1LV?\$\r\0@ TTl0KkĽz\r&HHL1\nGfv@\rx&.\"+K%\r F4=WOFp\$tj~X	*\0\r«hf\n`ǴK>f=@K4+Ʌ\\QD}jPk/јT\rѢzfa1ĦJN̷qo:KN~b,G+	Zf`q:3ʝ1Fr+,k%~ǲ>ƆR,Tdm!p }fќ7Fje⮑d8@\n`1jO Pr(SpRAQ^1%/t96j+cqf煪&p`FS~GO	a/Zk(p,~K(-102Ol/hAB\"ݳ,fK/^\"!)/-\"s2pR0)	!rIH+.+'&.)a23\r6-/+,-Ӎҷ2R9S3s2\\p䲀	t`@M VG+mz(ϩ>C\n4+v?#FGJZȰ'30+<LGHy5!\"HJn\"^FB׊۳PR@T^K8*e;~A)\nJcF'Gbp0l3roQCGBh7DRg0Cf꠆=XhcZS78joϹ%n0)2w3ತ'5Hs;NSIk8\ngPhR5	NG2.<4<e.\rSs:U'St\n^|8U<AU5,/h!B\0<.n}xW/@LP`̋쭟@f@bc\$<#R8,A.+ջ0TrHg\\ǥs<5E-aADc^71	<95S_	PȖ'e\0@\nː[,''j|WY&cu1N5iBYB6\nsCQ6=EK4`Re5d[dP=f+PTRUW/9VXf309V֑Vq9J\nPgWVJ,<tDvkT	lh#l;AJt`6g6eV^+Me2Rдph#Ig^od1C/u3\0003D1fH6·OiV[q5Q,wj!rT?-Sy5)siC}u\rDvVKmMoVSi%:T;l#UWvכ1)VWShWgmTntIC]a	0c[ir I_QZMTH+WxUgN_	2 Q@LTsf pMA29Kx~&|N_|}7b\"߬\"%(51|bHR&]5f	)Y@6 ЗIX\"&0wם5s<o]Tm%0ynxY]}rU1AHA/jVWz)c7Rs%wV2hT8U=d'E	b#%&&\rhyIS]Xz(񹋈{z%۔uy+cBy7{%%f~yOS`Y%\"mm7яHRO v1\\Ђ%&xn8oDXWӝi*ZCKQ3jt87|ApYi/j7l.q6S܎L?;98in-IZ*̫Iұ%\"akĳ9VD2JCꇦ7Un:y}Gyd{v7.?DݖQ]^e3:z eya`P56%x5o:j=aG˭\"@oe%Nv:9mWYqI.8ߨ Qx{+:\ri#+#KI\r5[A{7T/͵ZSV^cy}^فpwTrFW%E-]:;%[歺nfeZ]\r1#cRӡѯup	pWF4¥\rM\r9#D:]e瓷=-urs^||#/'w^KKYB(qÒԉK8vnّ\"\$ڇs:QO&\\3Y/ e\rVj`tZPŀ\0̭F+\0\nJL\npd+8S?[>\n7(8HYM.[P{St!ϵHs\r8jςy}]	84 Iƭ@n tB_F!@ЬAD,J\"&8A?bqog<W#Lv;\"\naF}pUq=dsBډVKy:*}ϑw6ӫ8J)ٽ/zYޗ25ޣok5y[i=5p>iBꛩ+=99[{_W\0dc; 5Vmvq\$(gGVY~>e.[XyeLI't[ꨴM@d}h[Ј`8J\"~	\\qQbf\\Jǣ@Saݰ-}C=ǑdWB'~\nlh}a6C+O/DM?Ajwz>ًfvADEDN	\0@	t\n`";break;case"th":$f="\\! M@0tD\0 \nX:&\0*\n8\0	E30/\0ZB(^\0AK2\0&b8KGn	I?J\\)b.)\\S\"s\0CWJ_6\\+eV6rJé5k]8@%994fv2 #!j65:i\\(zʳyW ej\0MLrS{q\0ק|\\Iq	n[R|馛7;Z4	=j.Y7D	 7i6LS0x4\r/0Oڶp\0@-pBP,JQpXD1jCb2α;󤅗\$3\$\r6мJ+.6Q󄟨1`P#pάP.JV!\00@P7\ro7(9\r㒰\"@`9 >xp89i؃+¿)ä6MJԟ1lY\$O*U@,8nx\\5T(6/\n58BNH\\I1rlHÔY;r|ՌIM&3I h_QB1,nm1,;,dE;&id(UZb!NP|N3h݌F89cc(Ø70{RIF\$!-_H[+q\rsЅfLX\\5_6bwv;M ֈgnl+ɛN* l7AS1oU+:S;0;>t=9`@rC@2D49Ax^;pþ3(ÝE\r*ӈecpx!}W;u2*\nYh̳c1M!qLS?~2vs8,ӣ9Y'n.Apΰ\n\n9Ù!!\\!K(pAKf\$sѹkajN6ϕ,'hpF,u\r;C+K&!O	X	\\T'`PlJ_+|\"cF쬇\rBlȴʥ+&>9\n.d0VIqB+T]SvIPad\n\0001Qj0ڲ*ex*.WK\nLoue=_/v,yH++*3aJAh<S\$D.oqYɦJ%	IܘZ}*s5〰:8E\")7f/ohDAꂇ7`)(\0͐ѹ\n<A\0ue!8\0l\r*7D(!0PAO,o:PPKב,>[\0C\naH#Aê\\j/;f@S<keA0[*sѧDm9օ0YCؚdǆp@*ntA2!t0D]RsU5=zH%{6\"T%NVo'ű?\rEtvJMN<hxӨFlu;'hݳ\rɸ;z3(eLpC\r:Y|[g<*nױgחsV*/.[hYe}D1ٶXl!`\\!(\nX^/4ʚ&0a\0so`i[s`UjNc!hJW:N^\n (\0PbJB%Xw`UPCeos|?2	O+	P}b{Ŏ*<T,vf)VXTY*]杹7k`MR)ui\$.-+\$CLp_4]8q?dl=pbd1NrP<rpwτ[J]'WMi!J,Y!BQ.{ll܉\nUi:VJ*J\r2vD apL50Tɲ\rС)9*5EzXͱ\\#i1(@PO	*\0BE<\"Pz(hu6jxF7Jh匭:iEVȕ1T]i9vX.!|4&Ӷbd9SJ5רwCQ~;me3MaKWv~|?֝TbH5+Vq@sjYi+/djIK[\\5Wr֜db'CnRGiHb!5m1CZiQG1^m7&Vgrbջkdփc^	dIo%.b`eFD<'C+&8v,c</((ʞr2'ԥf&hTV\\M+\$(S|#gBh?DSc;E8Bd^\"av8\"p &}lB,Nj\0 	\0@D\r\$lP\r6{X @1DJI[&'e\\D&qFVU#06m	܅\"ϭL@P1mKlE:&+,BߣX5E[f8DFk22;9\"9C( Hqc&XqTQОW#A:vg\$OJp(cOpid%qXhXm!e[vb[6[~G#6b\0m#x9?;%&itPDdPةfbIV~vVAxGQe~%DSD*!NAn8CQ(6|'	|7\rr|:I,\"kt0:\$jɄX#Ј'o]@N\0W~+2LB:F+gS-29r#R֒3.m3e1C[nR:Ix8}D#03g-Q/^09NPEELμo\"RDp\r\nmO\nDE(/E,BF5>r.\r<s\r`!3.i3\n,sy+1;<z\noILz4\r@s~60~>szS)V0­+RT0QL%P)/L|AhIJag+yEB鴀8Ԅ~Qg?45ACmGQG:}I?㊍~͢e\"\n>P8\"g8fCL\n<%LD%Ƒ.<Q VhrsgL<\$Y	R}DHHTbMM%KJI.YKsnQ-5tڏ&EݭMS'Se3;Ju>6GF;S/Iu.4HfHgWgc\rP(rXh_\"՛BJGWZZ[U=2Cu>>[[PY_ƄVg1:#him[ja2A1aaљ``<%Z@sfBqHdLvQ;]5ZJO^4Ruf4fu@̦Y6T/?n>dqO`5'hjUhOY֦>i֠2\$[)N'1	c7+A֊=[mm_KgqDBӿfovnpi5pJVngT,%[n/3evMvԉgtCVO-r^lV=wV7tX\n	6XwNwp5hmqLvp)o7K^;gp4	uzח	Q~_(\" kD10zWh0m7˷=^Tv}T[}V	\r\nM|N.+*ȬbzV>2Bp_\n~0gDh4'P괐xи4a2\rHn4s\"Fʢ\0`ƣ\0\rm\$/&|+\0ڰ~M\npc/QR8iq#+[:Y}d-NŸmNTL\"	ߋ\0.PfVp9 	a]	u1e-8㝈*J~P)pU0vB*+\0\ry'NrdY6v/\"%2}ojMяVk_&TU3t̜@ʩ.UUTLT8б6q.l</A0<kRs@d=ؠ6o\n]tfթa杌d+79Q\r8I.yyE;QY%C/4X\"\n\r9!:,|[zՉ2fh;8;1gl⍖<<H\\JC<b:.SA\"<68An|Хv+_́\\;Sl䔇)`	\0@	t\n`";break;case"tr":$f="E6M	i=BQp 9 3!i6`'y\\\nb,P!= 2̑Ho<NXbn)̅'b):GX@\nFC1l7ASv*|%4F`(a1\r	!^2Q|%O3vKsfSdkXjyat5XlF:ډix\\Fa63]7F	ӺAE= 4\\KK:L&QTk78KH0Ffe9<8SpNÙJ2\$(@:N\r\nl40@50J	/㢐SB:/Bl-P45\n6iA`ЍH `P2`HƵJ\r҂p<Cri8'C{9ãk:êB} P\rH+%4 4JbJ=#\"7#ʈ>C{?\n0l\r8@SH4\r.2\0x3:xc\r#rJ3_X?^(ڒ̒ǃx\$>,#|,m4#2492+ڼ6ʝON'}	ER*\\鄣\"lN3-H<+t[w'K4\r4pTzB	?|wiNփ\$h%̢DfC43E8.:+f 1-HϥpFԹci(C\r5Mм/`xiO\$XB\0WƄꔥms5H|JW-:iu qdd:'^O.=\$J|5AÄ0=A<v9eU76Ԃ.!v=&`n[I4D#A(aL)`RQ8!iN=nZ1'ĝF\"C*d陓6K\ra:G\n]ҊbĲ~ܹW<|o9qɘlZ2CHC	\r*C28.t#c6'2[Cj\$!DExXd,\\Iz\rE.&s8ƛb>BiEBnH`F[	\$ͨOej`9\r50Ɂƺb,a1Rҽ\nwd|D]NI#ɺ Iª\rzR\$|#Y!R(r'E0PQ`{P3mMuTQUHa9p,KCR3ME.B	c\$f|GB\r3\r 2CI't\$^kQ%FYf23ƒQhIN4IQEPB՘<^pJS{N1D\rURK\n<)CZG2AZiQ\"FF%T:Λ89¡cS\0T6X}qA\0)\$Rp\$LfoϪm)4\\qp:'UW)\0\0A,0 \0U\n @@H95sLa\0D\nq[\n@Uϼ!&[v.t]\$82ކF\\nݹt߁IΆIԁ:f( P!㢰rRns_f4t(V{b\$9Lqs36`f^`@WOB\$!g>xAWV\nz|3:q&NȠ'2p})r^\n7-\\֜n+f'&\$7IRh\rJ]<\$4Bp *&-n_Ը}Wf%:9ϷJ:A>\0000nlK].#1d\$^rWD'ai,qqBz	.hQgN@AV?Yc<I\$aMgTKNc༫\0YF}oX\$^oe[c[{g19vn2y3f|BJ'5:agμ\")&م.?-ft%q\nߞߜ3A<ss*uCj!jFH?\"Hj-+\r)ݻ1Sϭ\"΋}NA#xRyQȇ0=c7*_\n	/QEXls\"뉛4Fb2K_`薎O(Ӎpu;\$wd(.x	:Z晳g5%3@V^h͕B#_>awSR4&:d,*xOȴI?&L:ޅ\\&;ƞsc'hB%ŧ<Ͷ;)\0\0&}ZP&K:w0/f(:mVcpnx*f,~Nb#\n`7.N@`Nfj6Ѐփ\r(	0BNK&7лb\0bF'ńX\"#\"G:VFtl;\$\r7ЦAXC)GZբm<La8)9M./c҈0*\"Ұ2>ȍ0P>PN1J|-(q(a_#(㸻H\0Gdz-xcp\"`|Nm6q0\n06\$;*\\d#I1f:1\nPIDD]`Bì%qRD1\n8d/ho)y\"\r}!^q[#r3!#\0ҖqnzQ;^,\nXK/K&abNnB&@]R4+-t!f4`lN~~.2mbD8RN\"e3Ң߮f2p{OHd 2l36^R\0@d\rVb*j\nZl+:Ni-Kַ	NRS81l^z&\n\"Rt|H\"#\"^Ok/I&S^6f6*d,(ha%~\"XC+VQ{ǆd\"7(P,xһ<\00011a+vͯuc>hCQ\"B#&Ӱ7O_3X	,\$/>#BCda>m&̉8TO@ \"\05'#@_E &7E\r`xw6sOz-@dsORL\r`d\nmL*i\"@";break;case"uk":$f="I4ɠh-`&KBQp 9	rh--}[ZH`RdbrbhdZGH\rMs6@Se+ȃE6JTdJsh\$g\$Gfj>Cf4jSdRB\rhSE6\rVG!TIV{ZLʔi%QBvUXhZ<,΢Aev4s)@tNC	Ӑt4zC	kK4\\L+U0\\F>kC5A2@\$M4TAJ\\GOR	.%\nKB4;\\\r'TSX55C7I{08HCY\"Ֆ:F\n*X#.h2Bِ)7)䦩Q\$D&j,ÚֶKz%˻JAQ\$B22;`ՠс NR4J2l2R?\n7TE/d&\$A+\"<O+>p7WB`V\0<;p4rP 7*Ҙ4}@d*5jU]\\T8Ҍ욲(b4HJw1Q^x)adҺP2\rrH;%rd#IHKIC(c090z\r8a^h\\0{x7)JxDlxD4x6|*c\rbJA/	NM5\0ը¡pj`YmwSn ش	#f⭫cG( P0Ct@3!(Ȃ4^݂sv|W\rev)\"@j%s(y{fN]_3z:P0[5~!Ѯ55U!~!nh!,Z݅R+)ShaɱB!:M&I*w>JH38884AîHc!I[DhY)xbQ:%'CLAvĭ;Vq͈&\nGa8&3EG\0004b1B'v|#@O\nIcnurcg[]) 4Ƌv.3F B\\͢dO9\0pA\r34\n嶀A\0uYՓ2\0l\r4!0\0A1\r\nKY7ja6G@S\nA!u<ba`]pBP\$L\n<\"WL&a%E<\nf̲C)̤rCYᑍӈ_`\$U[lmM3s#2\$.QtKF.MlԚs)T)dxRY-i3pih	TQf~ZEh%ڈnG 5fjZ-ymjґ\\;\0ȓ̮t.~QS!\\4)P r- Z \\@pG4:RKn[u/1<^ˑ\\\0cu4fc*tox٪F))[\0-?\r<\\WAg)wo˂(v8G/TD}0{'I\\ICZ51U^i:'L2<I!!LuCıKnNsSZ1	9\nÈ!D,Cc1r% ީ9ݰZ4B؅-)bԼJCStDПII\"1jf_PsIAXXj]\$;iҁ=\rD&B`	L*@y!qGbʡ3{!=\0004-F5[/ݮ\npˬ ɹ%@sa7;R2hXS3_@tF\nA^k{#fZ. q\rsX Q*o1!RVA\nѰha0AI>pC0ADh	0AB٣Az)]\$ExP\nv]MA} :%G*A}}=EH!r3	Ei͌Ơ5>\nX>\\M&Ga\"u5cF\\G?:K\"zi8gJ@{=>=sn}Ѻi[g}Ⴆкh\"ڊl?nkڌr!]10t| KY0aQ9:C#rGL\\ɢqІ4]VGry	E?}׊AjuF6C(e(5۩)sg=\"LƍAt/*4[}:x#E.B^A!Ϛ^!Dpv(\\l nfL^DV \n`D,I`J[\$LJPB \"g^vrGr7x2qvnTw=(rpBCJpڂO\n*h8\$tppxo`\\0tpV\$C(.0g\$Q*Z	͂O\r٢?\n{u|I*w\$\$)xv%P\r0CPILp\\*=}'uh4xq9	P5\rG`#0&6\$`FA%\0oE\n@hj=	]\"]%b-m<eE)T*Qc5eΨLm\"񭸛Ș.wVZ*CB44gba<j44@#.j41 Lnu,	d#tQ\$8tXc\$BIA%\$Bb?&ph8notbKh)lߣnrspjW\"ІAv2H8Ahp<Ce//	 G`O\$ۢnJ\"K'QIĲ2^E/\"q0,gh)/ry)Q@.s9DT!4i`J\0Rs% (#	G25\\^Z674+6SVsZh5*(%\\5ҢѐsdOJo'&':n(8%;H;%sdn-\$6ŽLU\0 2L1ERO9%9ܨs܌&>O?,_?6'A)#A،1p\$£)4-@M!m\n *#:I'/fBG#GmF/3!G.3%s\0r*%rKC j`+~\nCl\"B>\$&0.fC1sL_ R42HdM.\n\"tFSFG\"/C޲(HֹG*s:A@G\"<XpFsG=]US;ҫ:)jrqwE)/65W5S2NXst;eStY';IWYTE)I_A]@1bPuNW\$,N{N!#]\rD0+`䒁Ap5rSBX_a3ZUvӑ1~(;ZϪQb0չ!cn'cL2ad, 븝!MDP84n@Pk`5bN..LTT<SH֟YtWb@jEMi9[Pi jVSdxVW5Wk	KeKD>m<DE]kVbp/+ԗb`0vqlP?U6TՃY-]P.HTset%YuUab\\vVW-rJAN5`AfnS\0_)vB_v9шUǽ4!6(4C6B^wVFC?^_zxxBQzM5/]gkN6dbWbtUqqe9{wπk/%@e%U)TK#p)\rVml>bS1Lp=Xkєl\rIK@n\nZ uq+4nVuJhEQQЁ΁e0#{@P1\rzUi-\"d(	2(o 	߇\$F7BS!CD~G_CV`K )	>ʉUx	զhX<us8x\0Dk\n#ꉬVaQxT߁c 2Cf\rr	7,bTs'J4UoxqiӚop!(RxQ@?t+)s(UN4T)OT3!@.0Ns4be2 ,*3\"%2\nJ\rK7LzPEC`QSAqS#+S18\n3]x0eÞfQiVE>wN҂]L,wDo\0";break;case"vi":$f="Bp& *(J.0Q,Z)v@Tf\npjp*VC`]rY<#\$b\$L2@%9IΓ4˅d3\rFqt9N1QE3ڡhj[J;o\n(UbdaI¾RiD\0\0A)X8@q:g!C_#y̸6:ڋ.K;.}FͼS06\\vN5n5x!r7C	1#(͍&:;#\"\\!%:8!KH+ڜ0R7wC(\$F]]+0Ҏ9jjPeFdc@J*#ӊX\n\npEɚ44K\nd@3&!\03Z09ʤHLn1\r?!\07?wBTX<840(T4BB-KdPɒpSZ&;q&%l%Kr!\n&F/c,6J;rb!åh,VejE-@]8LB6o	APAÔ0c\rI;(:\"9pX90z\r8a^\\0w+}x(2\r҃px!\\,˳4튂h	K)Ft @aV\rK-B9\rΊ\"<!@ NĐI`0֪Jhlp6AC6(1BTJv7oL2pJGg5%V]3ɆQ7,tWëg	}6C(, P\$LѬ(S;FBqbR\"&Cz\r436J\"|?< g*@yͶGKK\0j٬s³IBJŤ&Ķ5zс2\0S\rwPY_02\r([y iaR&I t(iފK/\0ZȸLtEe`M*IrlHN3Z\n\nA'S2YZ~3\$ #B:君WAAxZf*4:B6\$CL1P3	-dEЍ3vrKh\r*\nvi;H		yoFnHABՠV=U1\nw0ØbY19(O.d72% )efaBLm\n8`4!t[\$/SM0FkP/MكfR*5u\r4EGIFxPRШ:.nXA3[4t&h	xN2%!v8 vg	ta>t|9lPFe-@*,蘐\\DHAVF9w7&cDb-E\0EI?\"H\$\$ \$76b;[a@(3(1hU\$kQk̒<Q	`/\n<)Hw9\"@O۹3#4Q'aeEڡ3\\鞎Y2OH5 `TN|̐g>\0e|rV\rX5\$8vq嵬b%\ni6,I\$U\$\nH@LK!aX!\n]֪I8K=\$A	V,-\nb>A9-dl2^DwqT	5@`.G~o9sSy_f|LЕ\"/̻Ő\n*}QQD7)4QX\n\nb8(MSx³\"^Lo5&䆹Z[8.#xP⫙/hOX굝[Q6wwGMB80׹wQyLx䪀~#aφpxuh-M]j		]LL(%HIDMYN*@DX+5؃!&*]5@C92I-bN̒UgvJFdF9h1Y?I򭡂]7)|aȻ&dV\r+E\08\$T\\8pm?jkE/zʠxh=~'p*˱O%\$+σ+u*iX*^m̲8H&DJ1\"@ڹ~]\n\rw6]@Ve]TɄ~˫hb[? 7:ń8IVFZ/Fa/@/Mo6Ͱ'\rC\\ǈmĮ\$.Ōd*DGh~d	h̨fg`(d}\\dIjT(?\0\\#l\"lΎg!\"C5\\\"м\$泐\r0 \06<\"'ltH\rP\0 diN`X,C\0g똅j:bdq\"*\rʋM/6GT}cŤJ&j\rfM \"vK1{Ծ<ᩩmLhp\nw'\r-(qroaN7 #iddf(aYy\nNqYI EQ!1QVpN\$R#bMa\0|l9VOPI!Pb2	Ph%\"!(Vb-R8)Le %((qđT<XX{)ed Rfڲ(+ҵ̄*2,}e\\\$\\xe+f<0VЃ/!/ΐMdg/'4Ȇ%PX0's\"5fJ&:;),sD!*밭!	:bУt~҄\0JoA&zҮ\$C\0k/O4W\"\nZh/g)qD4\$vh0b#_%\n/t]M8Pk6E86vg1,mSfNeJD\nzj\rmD~bU1Df\nînJz@˭HMt)4@ϨL\"H7:#7l~sѺ8S;DSDW}\n}#xmVh \"i2SH0ljsR-'8`@}O*IKǁ^0jŖ\$v N)44iɨ!OIH!4I%vL-*8c:[e-qF* ";break;case"zh":$f="^s\\r|%:\$\nr.2r/dȻ[8 S8r!T\\sI4brЀJs!KdueVDX,#!j6 :t\nrU:.ZPˑ.\rVWd^%䌵rTԼ*s#U`Qdu'c(oFe3Nb`p2NSӣ:LYta~&6ۊrsk{6c(2fqЈP:S*@S^t*ΔT^\\nNG#yj\"5M9 2xm8c9ڼź\0>A~L6s%IXˊ:M(bxd*bKaLK#sXg)<<vq>sKtFCD!zH\$C*re^@P׶Lѿ:8A<(ՍØ7ЭKYn\n)QBr4t\"\$jW9@@;DL%*ݜasՓ}^ k4phPX1m\r{\0P*;-kc30*9`@Y@2D49Ax^;p\\o3(C)\r*Ppx!jtIE2k%|sӂI1(\\9\r6FU.Q`re5SB9\r9 ARYED&eACO)UQPrDGW :X0b13MZN)9vszF\\u<J,qXsctì#lcI>A7;\"r(vD^=nSx9YNWG-SwE.^l7oxFHSGAMRS:gR~?HLkfs3\rj9*0pyBU3d7stP(0pw ]j@s/¤S\nAqH9H*LFFn#ċ&r*HtE	4l\$9@o5\"\\EqV>@:4&MSYL5d<!ґK[|lG.5W?!8ƅጫt.ػw^K7\\PJC(Hm|6wk4cK,k`D@]chBB.@d\$WK\"Xa-@*J֌C4A9d\"頤?P֚@eCa1\\[@s\"DLyqXJ\nb \n (	XCIj\"N8ڳ%3xV5%cMp4,0!Nc@ܗd`I7'\"a\\-X_*e	(	\$L<pZ2A[FËjh,3d5zAD	;Z4*(R5HpHP	L*PLbH^\0>Y\n3vB f\0bSu3R@@gVpF\n5մ`*!#(@	Îa@xA<'\0 A\nPB`EeVz-Th	]%EͱktΩt<\"0.QwE\")vJ:F|;Lcm~8U>G_R]E9DxkE\08pV\"./d5=:\n39\"|LĶߎ[yYS\r!ѹU	\\r3z\nyH\0Jמc\$\$\"4c:Ce ({fmQfZ.dlPwp0I\"(Pv%;-`Hミ0qC6.0\"L_a`۶|X<\$0q4F4H*@@ '4~ej¥ĖJykBe\0^6-׺W\$H)QbJǨF6XQ&#QvJLWQd퀍EKk)LDC(&Zwh̔B(\nQ=)Ãar2F=)m\r1CBrĠJr89k}b1C0-99<eԄg^aϜbt]:=XW#z9.C|֜DA @b90M 9e14/; ͙y1x%R:I..5-/0)UGih/O2~VyGؼwX9t|Y5sona~_s/XB3Af\$I\"P>.O'OG̴*aP|>EpO,Mc~#!(	k\$7rt\"ki fe^M,PTftfsdMH)z%P%\"0;MJsp-dgRa^y!\\as t70t@f*O/Oqc'n#0L&a<6qeoPVQQ1g1%\0qg1?1*O-S:MЍ\rXQ\\S1B-бi0Qz>.VJ	-cAo.@i{BA>M:\$k+r)-\n\"l\"0afzۭH4\rVg`OYm#Xު́E6Ƴ?\0\npOH6,0P#B8cj	\r2Af.!C裒c(#m*:QK&/1\r8`5#bߒ\$Cj\$⧢H\nA<Lβ\"iXN%Ioq.OF2C)#\n\rtˤ0c\0EAo,z\",L ,8\rN1RJ\nŎ\r0,FJ!rP&%<-c.KnX.+=krSE\0bd@	\0t	@\n`";break;case"zh-tw":$f="^%ӕ\\r|%u:HB(\\4prneRQ̡D8 S\nt*.tI&GNAʤSV:	t%9Sy:\"<rST,#!j61uL\0U:.I9BK&]\nDX[}-,r&a;Dxr4&)s3St\rAbEE1ԣg:x]#0,'}üb1Q\\y\0VE<gS )ЪOLP\0ΔMƼ 2F׶{N͍@9;#ttnz>Dql@g1&Z%)T'9jB\nC\"%)nj\"dCo{@IBOsĀ*Otě\$dlY\nr%\0JB#h۴P?t)>`7cHB7P.˪VsedXt*ʬrL)^C kE4V%\\Repr\$)X`P2\r@;9A9AC1+6\$\0001@L4LBP2\0yj3:x{\ra?p_p*J@|6Ӽ3?k_C\r^0@QU TW!u2qJ)!Dtĵeن@/3O%tMP0Cs3hxC`aKKR\\&%So1UY+ɌTu#:9%9{(6Cℷvs|s)GT*UA\\zx P@GI*[%2[ #mcS=c7;br%I'.-+xgysntUfQy%O~k~\$sŷz}zr)]%zoU\"Kelm1xr2FQj.0lXF]'ybA<\0Z!\09k:(:C8a;VCpujmV\n\"	4aL)cR[/`E#N%r7E	*ё\n\\ _ÃCPas,c	` T[c)(вcb9+\"tP0|BS\"P.3i]HYs.Wz^k{uq0'PT*a(\$ik'`A0VO5S0ĘhRC(y/HQ\n%bA,5lvO!M B,\$vОulLAa`\0(inAVQz1Ff0.{/GH@PEHB`! \"<ri̳>hM=eCPmB͝A;ӺDt\n\\J0I\"G`L\n@¸ZȜQ	rxLJLBU\0\0y46fuPf?a6Kl\r\"iP	L*)!@/|M*D\$VZ4A&\"TwGBuiaM\0NAZ*xi>g^?R	a/0ԥBP(O	*\0BEW@-j2Q ɑ:Z݅ACv:\"ȸg+	2/D&E!y?W\"*H*P\"ܲbE7.\"\0q\"!i>\"\"҄0]d2Ȣy0b%^kx5fL4L%:nS:vxp#kڬ\0^ؒШ%yܥf_w*ÜZ\n!/e;Fh {.B@D^&^(kv_HrL@bd^jҬ9I\"\0Q/^9{ӗꋱmT~Ԍ:B\nP 0+}@ WuOj1Kt\nEx/Xlx i<nc6ݢ'\r}D\"X>/sx]KG*G/\"1NxGF\0r ?aݦGФ㛒E\"G8sro8ÑM)lP=1M:*9O;f.KCaZ(hI\"2nýI5&F\r!\nXI8(\"\rFt{\nH&šCqdtkOht1\0/CH\$E^IUTe<Jȅ\0hC?<.\0Ff'%1	j;SFC#}JI!ERTЦH0;H#\r_mLQhwoOh7<DAͦ\"OZy\0~-j^bGon ð\rJ벻pJPWj20LB|DCPUp\\*+@F¨(ezQBtJ*DP\r 8b<hHB	~L\r;\nBMBc@\$dfl/\raI-\\oFfD-١m'1(i2^ڭD`eg^r B|yDy͓F`*!!\0}pToLlarmģ#}Zd\$PbDt11<\0.a-dՅ=mUQhy m]bmjĲKdK!r,H3H.I\"	\"^r̀}'L(N\0?i`P4RɺFAHcF.z%bE.~4!D!1>^`Ƃ@\rd>n&6(4\r:[tˀ\ra\nZ*;G⒮o8hݤ\0--D8069nL-z{M\"	޶\\6]4<\"C6\",r.gdO,z,8Hdv.(a(9cWOcP23.\r.pu*\npZlXο>B8N,\nŜ\rf\0gφ|8fNVN|.WB<ӎd>1\nlSCl\$<ӡ:Qra%p[!K	\0t	@\n`";break;}$qi=array();foreach(explode("\n",lzw_decompress($f))as$X)$qi[]=(strpos($X,"\t")?explode("\t",$X):$X);return$qi;}if(!$qi){$qi=get_translations($ca);$_SESSION["translations"]=$qi;}if(extension_loaded('pdo')){class
Min_PDO
extends
PDO{var$_result,$server_info,$affected_rows,$errno,$error;function
__construct(){global$b;$bg=array_search("SQL",$b->operators);if($bg!==false)unset($b->operators[$bg]);}function
dsn($kc,$V,$F,$vf=array()){try{parent::__construct($kc,$V,$F,$vf);}catch(Exception$Bc){auth_error(h($Bc->getMessage()));}$this->setAttribute(13,array('Min_PDOStatement'));$this->server_info=@$this->getAttribute(4);}function
query($G,$_i=false){$H=parent::query($G);$this->error="";if(!$H){list(,$this->errno,$this->error)=$this->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($H);return$H;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result($H=null){if(!$H){$H=$this->_result;if(!$H)return
false;}if($H->columnCount()){$H->num_rows=$H->rowCount();return$H;}$this->affected_rows=$H->rowCount();return
true;}function
next_result(){if(!$this->_result)return
false;$this->_result->_offset=0;return@$this->_result->nextRowset();}function
result($G,$o=0){$H=$this->query($G);if(!$H)return
false;$J=$H->fetch();return$J[$o];}}class
Min_PDOStatement
extends
PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(2);}function
fetch_row(){return$this->fetch(3);}function
fetch_field(){$J=(object)$this->getColumnMeta($this->_offset++);$J->orgtable=$J->table;$J->orgname=$J->name;$J->charsetnr=(in_array("blob",(array)$J->flags)?63:0);return$J;}}}$fc=array();class
Min_SQL{var$_conn;function
__construct($g){$this->_conn=$g;}function
select($R,$L,$Z,$od,$xf=array(),$z=1,$E=0,$jg=false){global$b,$x;$Xd=(count($od)<count($L));$G=$b->selectQueryBuild($L,$Z,$od,$xf,$z,$E);if(!$G)$G="SELECT".limit(($_GET["page"]!="last"&&$z!=""&&$od&&$Xd&&$x=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$L)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($od&&$Xd?"\nGROUP BY ".implode(", ",$od):"").($xf?"\nORDER BY ".implode(", ",$xf):""),($z!=""?+$z:null),($E?$z*$E:0),"\n");$_h=microtime(true);$I=$this->_conn->query($G);if($jg)echo$b->selectQuery($G,$_h,!$I);return$I;}function
delete($R,$tg,$z=0){$G="FROM ".table($R);return
queries("DELETE".($z?limit1($R,$G,$tg):" $G$tg"));}function
update($R,$O,$tg,$z=0,$M="\n"){$Ri=array();foreach($O
as$y=>$X)$Ri[]="$y = $X";$G=table($R)." SET$M".implode(",$M",$Ri);return
queries("UPDATE".($z?limit1($R,$G,$tg,$M):" $G$tg"));}function
insert($R,$O){return
queries("INSERT INTO ".table($R).($O?" (".implode(", ",array_keys($O)).")\nVALUES (".implode(", ",$O).")":" DEFAULT VALUES"));}function
insertUpdate($R,$K,$hg){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($G,$bi){}function
convertSearch($u,$X,$o){return$u;}function
value($X,$o){return(method_exists($this->_conn,'value')?$this->_conn->value($X,$o):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($Vg){return
q($Vg);}function
warnings(){return'';}function
tableHelp($C){}}$fc["sqlite"]="SQLite 3";$fc["sqlite2"]="SQLite 2";if(isset($_GET["sqlite"])||isset($_GET["sqlite2"])){$eg=array((isset($_GET["sqlite"])?"SQLite3":"SQLite"),"PDO_SQLite");define("DRIVER",(isset($_GET["sqlite"])?"sqlite":"sqlite2"));if(class_exists(isset($_GET["sqlite"])?"SQLite3":"SQLiteDatabase")){if(isset($_GET["sqlite"])){class
Min_SQLite{var$extension="SQLite3",$server_info,$affected_rows,$errno,$error,$_link;function
__construct($Vc){$this->_link=new
SQLite3($Vc);$Ui=$this->_link->version();$this->server_info=$Ui["versionString"];}function
query($G){$H=@$this->_link->query($G);$this->error="";if(!$H){$this->errno=$this->_link->lastErrorCode();$this->error=$this->_link->lastErrorMsg();return
false;}elseif($H->numColumns())return
new
Min_Result($H);$this->affected_rows=$this->_link->changes();return
true;}function
quote($Q){return(is_utf8($Q)?"'".$this->_link->escapeString($Q)."'":"x'".reset(unpack('H*',$Q))."'");}function
store_result(){return$this->_result;}function
result($G,$o=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->_result->fetchArray();return$J[$o];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;}function
fetch_assoc(){return$this->_result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->_result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$d=$this->_offset++;$U=$this->_result->columnType($d);return(object)array("name"=>$this->_result->columnName($d),"type"=>$U,"charsetnr"=>($U==SQLITE3_BLOB?63:0),);}function
__desctruct(){return$this->_result->finalize();}}}else{class
Min_SQLite{var$extension="SQLite",$server_info,$affected_rows,$error,$_link;function
__construct($Vc){$this->server_info=sqlite_libversion();$this->_link=new
SQLiteDatabase($Vc);}function
query($G,$_i=false){$Qe=($_i?"unbufferedQuery":"query");$H=@$this->_link->$Qe($G,SQLITE_BOTH,$n);$this->error="";if(!$H){$this->error=$n;return
false;}elseif($H===true){$this->affected_rows=$this->changes();return
true;}return
new
Min_Result($H);}function
quote($Q){return"'".sqlite_escape_string($Q)."'";}function
store_result(){return$this->_result;}function
result($G,$o=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->_result->fetch();return$J[$o];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;if(method_exists($H,'numRows'))$this->num_rows=$H->numRows();}function
fetch_assoc(){$J=$this->_result->fetch(SQLITE_ASSOC);if(!$J)return
false;$I=array();foreach($J
as$y=>$X)$I[($y[0]=='"'?idf_unescape($y):$y)]=$X;return$I;}function
fetch_row(){return$this->_result->fetch(SQLITE_NUM);}function
fetch_field(){$C=$this->_result->fieldName($this->_offset++);$Xf='(\[.*]|"(?:[^"]|"")*"|(.+))';if(preg_match("~^($Xf\\.)?$Xf\$~",$C,$B)){$R=($B[3]!=""?$B[3]:idf_unescape($B[2]));$C=($B[5]!=""?$B[5]:idf_unescape($B[4]));}return(object)array("name"=>$C,"orgname"=>$C,"orgtable"=>$R,);}}}}elseif(extension_loaded("pdo_sqlite")){class
Min_SQLite
extends
Min_PDO{var$extension="PDO_SQLite";function
__construct($Vc){$this->dsn(DRIVER.":$Vc","","");}}}if(class_exists("Min_SQLite")){class
Min_DB
extends
Min_SQLite{function
__construct(){parent::__construct(":memory:");$this->query("PRAGMA foreign_keys = 1");}function
select_db($Vc){if(is_readable($Vc)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$Vc)?$Vc:dirname($_SERVER["SCRIPT_FILENAME"])."/$Vc")." AS a")){parent::__construct($Vc);$this->query("PRAGMA foreign_keys = 1");return
true;}return
false;}function
multi_query($G){return$this->_result=$this->query($G);}function
next_result(){return
false;}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($R,$K,$hg){$Ri=array();foreach($K
as$O)$Ri[]="(".implode(", ",$O).")";return
queries("REPLACE INTO ".table($R)." (".implode(", ",array_keys(reset($K))).") VALUES\n".implode(",\n",$Ri));}function
tableHelp($C){if($C=="sqlite_sequence")return"fileformat2.html#seqtab";if($C=="sqlite_master")return"fileformat2.html#$C";}}function
idf_escape($u){return'"'.str_replace('"','""',$u).'"';}function
table($u){return
idf_escape($u);}function
connect(){global$b;list(,,$F)=$b->credentials();if($F!="")return
lang(22);return
new
Min_DB;}function
get_databases(){return
array();}function
limit($G,$Z,$z,$D=0,$M=" "){return" $G$Z".($z!==null?$M."LIMIT $z".($D?" OFFSET $D":""):"");}function
limit1($R,$G,$Z,$M="\n"){global$g;return(preg_match('~^INTO~',$G)||$g->result("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($G,$Z,1,0,$M):" $G WHERE rowid = (SELECT rowid FROM ".table($R).$Z.$M."LIMIT 1)");}function
db_collation($l,$qb){global$g;return$g->result("PRAGMA encoding");}function
engines(){return
array();}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($k){return
array();}function
table_status($C=""){global$g;$I=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($C!=""?"AND name = ".q($C):"ORDER BY name"))as$J){$J["Rows"]=$g->result("SELECT COUNT(*) FROM ".idf_escape($J["Name"]));$I[$J["Name"]]=$J;}foreach(get_rows("SELECT * FROM sqlite_sequence",null,"")as$J)$I[$J["name"]]["Auto_increment"]=$J["seq"];return($C!=""?$I[$C]:$I);}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){global$g;return!$g->result("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($R){global$g;$I=array();$hg="";foreach(get_rows("PRAGMA table_info(".table($R).")")as$J){$C=$J["name"];$U=strtolower($J["type"]);$Tb=$J["dflt_value"];$I[$C]=array("field"=>$C,"type"=>(preg_match('~int~i',$U)?"integer":(preg_match('~char|clob|text~i',$U)?"text":(preg_match('~blob~i',$U)?"blob":(preg_match('~real|floa|doub~i',$U)?"real":"numeric")))),"full_type"=>$U,"default"=>(preg_match("~'(.*)'~",$Tb,$B)?str_replace("''","'",$B[1]):($Tb=="NULL"?null:$Tb)),"null"=>!$J["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1),"primary"=>$J["pk"],);if($J["pk"]){if($hg!="")$I[$hg]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$U))$I[$C]["auto_increment"]=true;$hg=$C;}}$vh=$g->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));preg_match_all('~(("[^"]*+")+|[a-z0-9_]+)\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$vh,$Ce,PREG_SET_ORDER);foreach($Ce
as$B){$C=str_replace('""','"',preg_replace('~^"|"$~','',$B[1]));if($I[$C])$I[$C]["collation"]=trim($B[3],"'");}return$I;}function
indexes($R,$h=null){global$g;if(!is_object($h))$h=$g;$I=array();$vh=$h->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$vh,$B)){$I[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$B[1],$Ce,PREG_SET_ORDER);foreach($Ce
as$B){$I[""]["columns"][]=idf_unescape($B[2]).$B[4];$I[""]["descs"][]=(preg_match('~DESC~i',$B[5])?'1':null);}}if(!$I){foreach(fields($R)as$C=>$o){if($o["primary"])$I[""]=array("type"=>"PRIMARY","columns"=>array($C),"lengths"=>array(),"descs"=>array(null));}}$yh=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($R),$h);foreach(get_rows("PRAGMA index_list(".table($R).")",$h)as$J){$C=$J["name"];$v=array("type"=>($J["unique"]?"UNIQUE":"INDEX"));$v["lengths"]=array();$v["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($C).")",$h)as$Ug){$v["columns"][]=$Ug["name"];$v["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($C).' ON '.idf_escape($R),'~').' \((.*)\)$~i',$yh[$C],$Eg)){preg_match_all('/("[^"]*+")+( DESC)?/',$Eg[2],$Ce);foreach($Ce[2]as$y=>$X){if($X)$v["descs"][$y]='1';}}if(!$I[""]||$v["type"]!="UNIQUE"||$v["columns"]!=$I[""]["columns"]||$v["descs"]!=$I[""]["descs"]||!preg_match("~^sqlite_~",$C))$I[$C]=$v;}return$I;}function
foreign_keys($R){$I=array();foreach(get_rows("PRAGMA foreign_key_list(".table($R).")")as$J){$q=&$I[$J["id"]];if(!$q)$q=$J;$q["source"][]=$J["from"];$q["target"][]=$J["to"];}return$I;}function
view($C){global$g;return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',$g->result("SELECT sql FROM sqlite_master WHERE name = ".q($C))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($l){return
false;}function
error(){global$g;return
h($g->error);}function
check_sqlite_name($C){global$g;$Lc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Lc)\$~",$C)){$g->error=lang(23,str_replace("|",", ",$Lc));return
false;}return
true;}function
create_database($l,$pb){global$g;if(file_exists($l)){$g->error=lang(24);return
false;}if(!check_sqlite_name($l))return
false;try{$_=new
Min_SQLite($l);}catch(Exception$Bc){$g->error=$Bc->getMessage();return
false;}$_->query('PRAGMA encoding = "UTF-8"');$_->query('CREATE TABLE adminer (i)');$_->query('DROP TABLE adminer');return
true;}function
drop_databases($k){global$g;$g->__construct(":memory:");foreach($k
as$l){if(!@unlink($l)){$g->error=lang(24);return
false;}}return
true;}function
rename_database($C,$pb){global$g;if(!check_sqlite_name($C))return
false;$g->__construct(":memory:");$g->error=lang(24);return@rename(DB,$C);}function
auto_increment(){return" PRIMARY KEY".(DRIVER=="sqlite"?" AUTOINCREMENT":"");}function
alter_table($R,$C,$p,$dd,$vb,$vc,$pb,$Ma,$Rf){$Li=($R==""||$dd);foreach($p
as$o){if($o[0]!=""||!$o[1]||$o[2]){$Li=true;break;}}$c=array();$Ff=array();foreach($p
as$o){if($o[1]){$c[]=($Li?$o[1]:"ADD ".implode($o[1]));if($o[0]!="")$Ff[$o[0]]=$o[1][0];}}if(!$Li){foreach($c
as$X){if(!queries("ALTER TABLE ".table($R)." $X"))return
false;}if($R!=$C&&!queries("ALTER TABLE ".table($R)." RENAME TO ".table($C)))return
false;}elseif(!recreate_table($R,$C,$c,$Ff,$dd))return
false;if($Ma)queries("UPDATE sqlite_sequence SET seq = $Ma WHERE name = ".q($C));return
true;}function
recreate_table($R,$C,$p,$Ff,$dd,$w=array()){if($R!=""){if(!$p){foreach(fields($R)as$y=>$o){if($w)$o["auto_increment"]=0;$p[]=process_field($o,$o);$Ff[$y]=idf_escape($y);}}$ig=false;foreach($p
as$o){if($o[6])$ig=true;}$ic=array();foreach($w
as$y=>$X){if($X[2]=="DROP"){$ic[$X[1]]=true;unset($w[$y]);}}foreach(indexes($R)as$fe=>$v){$e=array();foreach($v["columns"]as$y=>$d){if(!$Ff[$d])continue
2;$e[]=$Ff[$d].($v["descs"][$y]?" DESC":"");}if(!$ic[$fe]){if($v["type"]!="PRIMARY"||!$ig)$w[]=array($v["type"],$fe,$e);}}foreach($w
as$y=>$X){if($X[0]=="PRIMARY"){unset($w[$y]);$dd[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($R)as$fe=>$q){foreach($q["source"]as$y=>$d){if(!$Ff[$d])continue
2;$q["source"][$y]=idf_unescape($Ff[$d]);}if(!isset($dd[" $fe"]))$dd[]=" ".format_foreign_key($q);}queries("BEGIN");}foreach($p
as$y=>$o)$p[$y]="  ".implode($o);$p=array_merge($p,array_filter($dd));if(!queries("CREATE TABLE ".table($R!=""?"adminer_$C":$C)." (\n".implode(",\n",$p)."\n)"))return
false;if($R!=""){if($Ff&&!queries("INSERT INTO ".table("adminer_$C")." (".implode(", ",$Ff).") SELECT ".implode(", ",array_map('idf_escape',array_keys($Ff)))." FROM ".table($R)))return
false;$wi=array();foreach(triggers($R)as$ui=>$ci){$ti=trigger($ui);$wi[]="CREATE TRIGGER ".idf_escape($ui)." ".implode(" ",$ci)." ON ".table($C)."\n$ti[Statement]";}if(!queries("DROP TABLE ".table($R)))return
false;queries("ALTER TABLE ".table("adminer_$C")." RENAME TO ".table($C));if(!alter_indexes($C,$w))return
false;foreach($wi
as$ti){if(!queries($ti))return
false;}queries("COMMIT");}return
true;}function
index_sql($R,$U,$C,$e){return"CREATE $U ".($U!="INDEX"?"INDEX ":"").idf_escape($C!=""?$C:uniqid($R."_"))." ON ".table($R)." $e";}function
alter_indexes($R,$c){foreach($c
as$hg){if($hg[0]=="PRIMARY")return
recreate_table($R,$R,array(),array(),array(),$c);}foreach(array_reverse($c)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($R,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($T){return
apply_queries("DELETE FROM",$T);}function
drop_views($Wi){return
apply_queries("DROP VIEW",$Wi);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
move_tables($T,$Wi,$Th){return
false;}function
trigger($C){global$g;if($C=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$u='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$vi=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$u\\s*(".implode("|",$vi["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($u))?\\s+ON\\s*$u\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",$g->result("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($C)),$B);$gf=$B[3];return
array("Timing"=>strtoupper($B[1]),"Event"=>strtoupper($B[2]).($gf?" OF":""),"Of"=>($gf[0]=='`'||$gf[0]=='"'?idf_unescape($gf):$gf),"Trigger"=>$C,"Statement"=>$B[4],);}function
triggers($R){$I=array();$vi=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R))as$J){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$vi["Timing"]).')\s*(.*)\s+ON\b~iU',$J["sql"],$B);$I[$J["name"]]=array($B[1],$B[2]);}return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id(){global$g;return$g->result("SELECT LAST_INSERT_ROWID()");}function
explain($g,$G){return$g->query("EXPLAIN QUERY PLAN $G");}function
found_rows($S,$Z){}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Yg){return
true;}function
create_sql($R,$Ma,$Eh){global$g;$I=$g->result("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($R));foreach(indexes($R)as$C=>$v){if($C=='')continue;$I.=";\n\n".index_sql($R,$v['type'],$C,"(".implode(", ",array_map('idf_escape',$v['columns'])).")");}return$I;}function
truncate_sql($R){return"DELETE FROM ".table($R);}function
use_sql($j){}function
trigger_sql($R){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R)));}function
show_variables(){global$g;$I=array();foreach(array("auto_vacuum","cache_size","count_changes","default_cache_size","empty_result_callbacks","encoding","foreign_keys","full_column_names","fullfsync","journal_mode","journal_size_limit","legacy_file_format","locking_mode","page_size","max_page_count","read_uncommitted","recursive_triggers","reverse_unordered_selects","secure_delete","short_column_names","synchronous","temp_store","temp_store_directory","schema_version","integrity_check","quick_check")as$y)$I[$y]=$g->result("PRAGMA $y");return$I;}function
show_status(){$I=array();foreach(get_vals("PRAGMA compile_options")as$uf){list($y,$X)=explode("=",$uf,2);$I[$y]=$X;}return$I;}function
convert_field($o){}function
unconvert_field($o,$I){return$I;}function
support($Qc){return
preg_match('~^(columns|database|drop_col|dump|indexes|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Qc);}$x="sqlite";$zi=array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0);$Dh=array_keys($zi);$Fi=array();$sf=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");$ld=array("hex","length","lower","round","unixepoch","upper");$rd=array("avg","count","count distinct","group_concat","max","min","sum");$nc=array(array(),array("integer|real|numeric"=>"+/-","text"=>"||",));}$fc["pgsql"]="PostgreSQL";if(isset($_GET["pgsql"])){$eg=array("PgSQL","PDO_PgSQL");define("DRIVER","pgsql");if(extension_loaded("pgsql")){class
Min_DB{var$extension="PgSQL",$_link,$_result,$_string,$_database=true,$server_info,$affected_rows,$error,$timeout;function
_error($yc,$n){if(ini_bool("html_errors"))$n=html_entity_decode(strip_tags($n));$n=preg_replace('~^[^:]*: ~','',$n);$this->error=$n;}function
connect($N,$V,$F){global$b;$l=$b->database();set_error_handler(array($this,'_error'));$this->_string="host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($F,"'\\")."'";$this->_link=@pg_connect("$this->_string dbname='".($l!=""?addcslashes($l,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->_link&&$l!=""){$this->_database=false;$this->_link=@pg_connect("$this->_string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->_link){$Ui=pg_version($this->_link);$this->server_info=$Ui["server"];pg_set_client_encoding($this->_link,"UTF8");}return(bool)$this->_link;}function
quote($Q){return"'".pg_escape_string($this->_link,$Q)."'";}function
value($X,$o){return($o["type"]=="bytea"?pg_unescape_bytea($X):$X);}function
quoteBinary($Q){return"'".pg_escape_bytea($this->_link,$Q)."'";}function
select_db($j){global$b;if($j==$b->database())return$this->_database;$I=@pg_connect("$this->_string dbname='".addcslashes($j,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($I)$this->_link=$I;return$I;}function
close(){$this->_link=@pg_connect("$this->_string dbname='postgres'");}function
query($G,$_i=false){$H=@pg_query($this->_link,$G);$this->error="";if(!$H){$this->error=pg_last_error($this->_link);$I=false;}elseif(!pg_num_fields($H)){$this->affected_rows=pg_affected_rows($H);$I=true;}else$I=new
Min_Result($H);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$I;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$o=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;return
pg_fetch_result($H->_result,0,$o);}function
warnings(){return
h(pg_last_notice($this->_link));}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=pg_num_rows($H);}function
fetch_assoc(){return
pg_fetch_assoc($this->_result);}function
fetch_row(){return
pg_fetch_row($this->_result);}function
fetch_field(){$d=$this->_offset++;$I=new
stdClass;if(function_exists('pg_field_table'))$I->orgtable=pg_field_table($this->_result,$d);$I->name=pg_field_name($this->_result,$d);$I->orgname=$I->name;$I->type=pg_field_type($this->_result,$d);$I->charsetnr=($I->type=="bytea"?63:0);return$I;}function
__destruct(){pg_free_result($this->_result);}}}elseif(extension_loaded("pdo_pgsql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_PgSQL",$timeout;function
connect($N,$V,$F){global$b;$l=$b->database();$Q="pgsql:host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' options='-c client_encoding=utf8'";$this->dsn("$Q dbname='".($l!=""?addcslashes($l,"'\\"):"postgres")."'",$V,$F);return
true;}function
select_db($j){global$b;return($b->database()==$j);}function
quoteBinary($Vg){return
q($Vg);}function
query($G,$_i=false){$I=parent::query($G,$_i);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$I;}function
warnings(){return'';}function
close(){}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($R,$K,$hg){global$g;foreach($K
as$O){$Gi=array();$Z=array();foreach($O
as$y=>$X){$Gi[]="$y = $X";if(isset($hg[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$Gi)." WHERE ".implode(" AND ",$Z))&&$g->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
slowQuery($G,$bi){$this->_conn->query("SET statement_timeout = ".(1000*$bi));$this->_conn->timeout=1000*$bi;return$G;}function
convertSearch($u,$X,$o){return(preg_match('~char|text'.(!preg_match('~LIKE~',$X["op"])?'|date|time(stamp)?|boolean|uuid|'.number_type():'').'~',$o["type"])?$u:"CAST($u AS text)");}function
quoteBinary($Vg){return$this->_conn->quoteBinary($Vg);}function
warnings(){return$this->_conn->warnings();}function
tableHelp($C){$we=array("information_schema"=>"infoschema","pg_catalog"=>"catalog",);$_=$we[$_GET["ns"]];if($_)return"$_-".str_replace("_","-",$C).".html";}}function
idf_escape($u){return'"'.str_replace('"','""',$u).'"';}function
table($u){return
idf_escape($u);}function
connect(){global$b,$zi,$Dh;$g=new
Min_DB;$Hb=$b->credentials();if($g->connect($Hb[0],$Hb[1],$Hb[2])){if(min_version(9,0,$g)){$g->query("SET application_name = 'Adminer'");if(min_version(9.2,0,$g)){$Dh[lang(25)][]="json";$zi["json"]=4294967295;if(min_version(9.4,0,$g)){$Dh[lang(25)][]="jsonb";$zi["jsonb"]=4294967295;}}}return$g;}return$g->error;}function
get_databases(){return
get_vals("SELECT datname FROM pg_database WHERE has_database_privilege(datname, 'CONNECT') ORDER BY datname");}function
limit($G,$Z,$z,$D=0,$M=" "){return" $G$Z".($z!==null?$M."LIMIT $z".($D?" OFFSET $D":""):"");}function
limit1($R,$G,$Z,$M="\n"){return(preg_match('~^INTO~',$G)?limit($G,$Z,1,0,$M):" $G".(is_view(table_status1($R))?$Z:" WHERE ctid = (SELECT ctid FROM ".table($R).$Z.$M."LIMIT 1)"));}function
db_collation($l,$qb){global$g;return$g->result("SHOW LC_COLLATE");}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT user");}function
tables_list(){$G="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support('materializedview'))$G.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$G.="
ORDER BY 1";return
get_key_vals($G);}function
count_tables($k){return
array();}function
table_status($C=""){$I=array();foreach(get_rows("SELECT c.relname AS \"Name\", CASE c.relkind WHEN 'r' THEN 'table' WHEN 'm' THEN 'materialized view' ELSE 'view' END AS \"Engine\", pg_relation_size(c.oid) AS \"Data_length\", pg_total_relation_size(c.oid) - pg_relation_size(c.oid) AS \"Index_length\", obj_description(c.oid, 'pg_class') AS \"Comment\", CASE WHEN c.relhasoids THEN 'oid' ELSE '' END AS \"Oid\", c.reltuples as \"Rows\", n.nspname
FROM pg_class c
JOIN pg_namespace n ON(n.nspname = current_schema() AND n.oid = c.relnamespace)
WHERE relkind IN ('r', 'm', 'v', 'f')
".($C!=""?"AND relname = ".q($C):"ORDER BY relname"))as$J)$I[$J["Name"]]=$J;return($C!=""?$I[$C]:$I);}function
is_view($S){return
in_array($S["Engine"],array("view","materialized view"));}function
fk_support($S){return
true;}function
fields($R){$I=array();$Da=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT a.attname AS field, format_type(a.atttypid, a.atttypmod) AS full_type, d.adsrc AS default, a.attnotnull::int, col_description(c.oid, a.attnum) AS comment
FROM pg_class c
JOIN pg_namespace n ON c.relnamespace = n.oid
JOIN pg_attribute a ON c.oid = a.attrelid
LEFT JOIN pg_attrdef d ON c.oid = d.adrelid AND a.attnum = d.adnum
WHERE c.relname = ".q($R)."
AND n.nspname = current_schema()
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$J){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$J["full_type"],$B);list(,$U,$te,$J["length"],$xa,$Ga)=$B;$J["length"].=$Ga;$eb=$U.$xa;if(isset($Da[$eb])){$J["type"]=$Da[$eb];$J["full_type"]=$J["type"].$te.$Ga;}else{$J["type"]=$U;$J["full_type"]=$J["type"].$te.$xa.$Ga;}$J["null"]=!$J["attnotnull"];$J["auto_increment"]=preg_match('~^nextval\(~i',$J["default"]);$J["privileges"]=array("insert"=>1,"select"=>1,"update"=>1);if(preg_match('~(.+)::[^)]+(.*)~',$J["default"],$B))$J["default"]=($B[1]=="NULL"?null:(($B[1][0]=="'"?idf_unescape($B[1]):$B[1]).$B[2]));$I[$J["field"]]=$J;}return$I;}function
indexes($R,$h=null){global$g;if(!is_object($h))$h=$g;$I=array();$Mh=$h->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($R));$e=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $Mh AND attnum > 0",$h);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption , (indpred IS NOT NULL)::int as indispartial FROM pg_index i, pg_class ci WHERE i.indrelid = $Mh AND ci.oid = i.indexrelid",$h)as$J){$Fg=$J["relname"];$I[$Fg]["type"]=($J["indispartial"]?"INDEX":($J["indisprimary"]?"PRIMARY":($J["indisunique"]?"UNIQUE":"INDEX")));$I[$Fg]["columns"]=array();foreach(explode(" ",$J["indkey"])as$Md)$I[$Fg]["columns"][]=$e[$Md];$I[$Fg]["descs"]=array();foreach(explode(" ",$J["indoption"])as$Nd)$I[$Fg]["descs"][]=($Nd&1?'1':null);$I[$Fg]["lengths"]=array();}return$I;}function
foreign_keys($R){global$nf;$I=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = (SELECT pc.oid FROM pg_class AS pc INNER JOIN pg_namespace AS pn ON (pn.oid = pc.relnamespace) WHERE pc.relname = ".q($R)." AND pn.nspname = current_schema())
AND contype = 'f'::char
ORDER BY conkey, conname")as$J){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$J['definition'],$B)){$J['source']=array_map('trim',explode(',',$B[1]));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$B[2],$Be)){$J['ns']=str_replace('""','"',preg_replace('~^"(.+)"$~','\1',$Be[2]));$J['table']=str_replace('""','"',preg_replace('~^"(.+)"$~','\1',$Be[4]));}$J['target']=array_map('trim',explode(',',$B[3]));$J['on_delete']=(preg_match("~ON DELETE ($nf)~",$B[4],$Be)?$Be[1]:'NO ACTION');$J['on_update']=(preg_match("~ON UPDATE ($nf)~",$B[4],$Be)?$Be[1]:'NO ACTION');$I[$J['conname']]=$J;}}return$I;}function
view($C){global$g;return
array("select"=>trim($g->result("SELECT view_definition
FROM information_schema.views
WHERE table_schema = current_schema() AND table_name = ".q($C))));}function
collations(){return
array();}function
information_schema($l){return($l=="information_schema");}function
error(){global$g;$I=h($g->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$I,$B))$I=$B[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($B[3]).'})(.*)~','\1<b>\2</b>',$B[2]).$B[4];return
nl_br($I);}function
create_database($l,$pb){return
queries("CREATE DATABASE ".idf_escape($l).($pb?" ENCODING ".idf_escape($pb):""));}function
drop_databases($k){global$g;$g->close();return
apply_queries("DROP DATABASE",$k,'idf_escape');}function
rename_database($C,$pb){return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($C));}function
auto_increment(){return"";}function
alter_table($R,$C,$p,$dd,$vb,$vc,$pb,$Ma,$Rf){$c=array();$sg=array();foreach($p
as$o){$d=idf_escape($o[0]);$X=$o[1];if(!$X)$c[]="DROP $d";else{$Qi=$X[5];unset($X[5]);if(isset($X[6])&&$o[0]=="")$X[1]=($X[1]=="bigint"?" big":" ")."serial";if($o[0]=="")$c[]=($R!=""?"ADD ":"  ").implode($X);else{if($d!=$X[0])$sg[]="ALTER TABLE ".table($R)." RENAME $d TO $X[0]";$c[]="ALTER $d TYPE$X[1]";if(!$X[6]){$c[]="ALTER $d ".($X[3]?"SET$X[3]":"DROP DEFAULT");$c[]="ALTER $d ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}}if($o[0]!=""||$Qi!="")$sg[]="COMMENT ON COLUMN ".table($R).".$X[0] IS ".($Qi!=""?substr($Qi,9):"''");}}$c=array_merge($c,$dd);if($R=="")array_unshift($sg,"CREATE TABLE ".table($C)." (\n".implode(",\n",$c)."\n)");elseif($c)array_unshift($sg,"ALTER TABLE ".table($R)."\n".implode(",\n",$c));if($R!=""&&$R!=$C)$sg[]="ALTER TABLE ".table($R)." RENAME TO ".table($C);if($R!=""||$vb!="")$sg[]="COMMENT ON TABLE ".table($C)." IS ".q($vb);if($Ma!=""){}foreach($sg
as$G){if(!queries($G))return
false;}return
true;}function
alter_indexes($R,$c){$i=array();$gc=array();$sg=array();foreach($c
as$X){if($X[0]!="INDEX")$i[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$gc[]=idf_escape($X[1]);else$sg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($i)array_unshift($sg,"ALTER TABLE ".table($R).implode(",",$i));if($gc)array_unshift($sg,"DROP INDEX ".implode(", ",$gc));foreach($sg
as$G){if(!queries($G))return
false;}return
true;}function
truncate_tables($T){return
queries("TRUNCATE ".implode(", ",array_map('table',$T)));return
true;}function
drop_views($Wi){return
drop_tables($Wi);}function
drop_tables($T){foreach($T
as$R){$P=table_status($R);if(!queries("DROP ".strtoupper($P["Engine"])." ".table($R)))return
false;}return
true;}function
move_tables($T,$Wi,$Th){foreach(array_merge($T,$Wi)as$R){$P=table_status($R);if(!queries("ALTER ".strtoupper($P["Engine"])." ".table($R)." SET SCHEMA ".idf_escape($Th)))return
false;}return
true;}function
trigger($C,$R=null){if($C=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");if($R===null)$R=$_GET['trigger'];$K=get_rows('SELECT t.trigger_name AS "Trigger", t.action_timing AS "Timing", (SELECT STRING_AGG(event_manipulation, \' OR \') FROM information_schema.triggers WHERE event_object_table = t.event_object_table AND trigger_name = t.trigger_name ) AS "Events", t.event_manipulation AS "Event", \'FOR EACH \' || t.action_orientation AS "Type", t.action_statement AS "Statement" FROM information_schema.triggers t WHERE t.event_object_table = '.q($R).' AND t.trigger_name = '.q($C));return
reset($K);}function
triggers($R){$I=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE event_object_table = ".q($R))as$J)$I[$J["trigger_name"]]=array($J["action_timing"],$J["event_manipulation"]);return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($C,$U){$K=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($C));$I=$K[0];$I["returns"]=array("type"=>$I["type_udt_name"]);$I["fields"]=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($C).'
ORDER BY ordinal_position');return$I;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($C,$J){$I=array();foreach($J["fields"]as$o)$I[]=$o["type"];return
idf_escape($C)."(".implode(", ",$I).")";}function
last_id(){return
0;}function
explain($g,$G){return$g->query("EXPLAIN $G");}function
found_rows($S,$Z){global$g;if(preg_match("~ rows=([0-9]+)~",$g->result("EXPLAIN SELECT * FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$Eg))return$Eg[1];return
false;}function
types(){return
get_vals("SELECT typname
FROM pg_type
WHERE typnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema())
AND typtype IN ('b','d','e')
AND typelem = 0");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){global$g;return$g->result("SELECT current_schema()");}function
set_schema($Xg){global$g,$zi,$Dh;$I=$g->query("SET search_path TO ".idf_escape($Xg));foreach(types()as$U){if(!isset($zi[$U])){$zi[$U]=0;$Dh[lang(26)][]=$U;}}return$I;}function
create_sql($R,$Ma,$Eh){global$g;$I='';$Ng=array();$hh=array();$P=table_status($R);$p=fields($R);$w=indexes($R);ksort($w);$ad=foreign_keys($R);ksort($ad);if(!$P||empty($p))return
false;$I="CREATE TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." (\n    ";foreach($p
as$Sc=>$o){$Of=idf_escape($o['field']).' '.$o['full_type'].default_value($o).($o['attnotnull']?" NOT NULL":"");$Ng[]=$Of;if(preg_match('~nextval\(\'([^\']+)\'\)~',$o['default'],$Ce)){$gh=$Ce[1];$uh=reset(get_rows(min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q($gh):"SELECT * FROM $gh"));$hh[]=($Eh=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $gh;\n":"")."CREATE SEQUENCE $gh INCREMENT $uh[increment_by] MINVALUE $uh[min_value] MAXVALUE $uh[max_value] START ".($Ma?$uh['last_value']:1)." CACHE $uh[cache_value];";}}if(!empty($hh))$I=implode("\n\n",$hh)."\n\n$I";foreach($w
as$Hd=>$v){switch($v['type']){case'UNIQUE':$Ng[]="CONSTRAINT ".idf_escape($Hd)." UNIQUE (".implode(', ',array_map('idf_escape',$v['columns'])).")";break;case'PRIMARY':$Ng[]="CONSTRAINT ".idf_escape($Hd)." PRIMARY KEY (".implode(', ',array_map('idf_escape',$v['columns'])).")";break;}}foreach($ad
as$Zc=>$Yc)$Ng[]="CONSTRAINT ".idf_escape($Zc)." $Yc[definition] ".($Yc['deferrable']?'DEFERRABLE':'NOT DEFERRABLE');$I.=implode(",\n    ",$Ng)."\n) WITH (oids = ".($P['Oid']?'true':'false').");";foreach($w
as$Hd=>$v){if($v['type']=='INDEX')$I.="\n\nCREATE INDEX ".idf_escape($Hd)." ON ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." USING btree (".implode(', ',array_map('idf_escape',$v['columns'])).");";}if($P['Comment'])$I.="\n\nCOMMENT ON TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." IS ".q($P['Comment']).";";foreach($p
as$Sc=>$o){if($o['comment'])$I.="\n\nCOMMENT ON COLUMN ".idf_escape($P['nspname']).".".idf_escape($P['Name']).".".idf_escape($Sc)." IS ".q($o['comment']).";";}return
rtrim($I,';');}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
trigger_sql($R){$P=table_status($R);$I="";foreach(triggers($R)as$si=>$ri){$ti=trigger($si,$P['Name']);$I.="\nCREATE TRIGGER ".idf_escape($ti['Trigger'])." $ti[Timing] $ti[Events] ON ".idf_escape($P["nspname"]).".".idf_escape($P['Name'])." $ti[Type] $ti[Statement];;\n";}return$I;}function
use_sql($j){return"\connect ".idf_escape($j);}function
show_variables(){return
get_key_vals("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
show_status(){}function
convert_field($o){}function
unconvert_field($o,$I){return$I;}function
support($Qc){return
preg_match('~^(database|table|columns|sql|indexes|comment|view|'.(min_version(9.3)?'materializedview|':'').'scheme|routine|processlist|sequence|trigger|type|variables|drop_col|kill|dump)$~',$Qc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){global$g;return$g->result("SHOW max_connections");}$x="pgsql";$zi=array();$Dh=array();foreach(array(lang(27)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(28)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(25)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(29)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(30)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"txid_snapshot"=>0),lang(31)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),)as$y=>$X){$zi+=$X;$Dh[$y]=array_keys($X);}$Fi=array();$sf=array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");$ld=array("char_length","lower","round","to_hex","to_timestamp","upper");$rd=array("avg","count","count distinct","max","min","sum");$nc=array(array("char"=>"md5","date|time"=>"now",),array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",));}$fc["oracle"]="Oracle (beta)";if(isset($_GET["oracle"])){$eg=array("OCI8","PDO_OCI");define("DRIVER","oracle");if(extension_loaded("oci8")){class
Min_DB{var$extension="oci8",$_link,$_result,$server_info,$affected_rows,$errno,$error;function
_error($yc,$n){if(ini_bool("html_errors"))$n=html_entity_decode(strip_tags($n));$n=preg_replace('~^[^:]*: ~','',$n);$this->error=$n;}function
connect($N,$V,$F){$this->_link=@oci_new_connect($V,$F,$N,"AL32UTF8");if($this->_link){$this->server_info=oci_server_version($this->_link);return
true;}$n=oci_error();$this->error=$n["message"];return
false;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($j){return
true;}function
query($G,$_i=false){$H=oci_parse($this->_link,$G);$this->error="";if(!$H){$n=oci_error($this->_link);$this->errno=$n["code"];$this->error=$n["message"];return
false;}set_error_handler(array($this,'_error'));$I=@oci_execute($H);restore_error_handler();if($I){if(oci_num_fields($H))return
new
Min_Result($H);$this->affected_rows=oci_num_rows($H);}return$I;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$o=1){$H=$this->query($G);if(!is_object($H)||!oci_fetch($H->_result))return
false;return
oci_result($H->_result,$o);}}class
Min_Result{var$_result,$_offset=1,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$y=>$X){if(is_a($X,'OCI-Lob'))$J[$y]=$X->load();}return$J;}function
fetch_assoc(){return$this->_convert(oci_fetch_assoc($this->_result));}function
fetch_row(){return$this->_convert(oci_fetch_row($this->_result));}function
fetch_field(){$d=$this->_offset++;$I=new
stdClass;$I->name=oci_field_name($this->_result,$d);$I->orgname=$I->name;$I->type=oci_field_type($this->_result,$d);$I->charsetnr=(preg_match("~raw|blob|bfile~",$I->type)?63:0);return$I;}function
__destruct(){oci_free_statement($this->_result);}}}elseif(extension_loaded("pdo_oci")){class
Min_DB
extends
Min_PDO{var$extension="PDO_OCI";function
connect($N,$V,$F){$this->dsn("oci:dbname=//$N;charset=AL32UTF8",$V,$F);return
true;}function
select_db($j){return
true;}}}class
Min_Driver
extends
Min_SQL{function
begin(){return
true;}}function
idf_escape($u){return'"'.str_replace('"','""',$u).'"';}function
table($u){return
idf_escape($u);}function
connect(){global$b;$g=new
Min_DB;$Hb=$b->credentials();if($g->connect($Hb[0],$Hb[1],$Hb[2]))return$g;return$g->error;}function
get_databases(){return
get_vals("SELECT tablespace_name FROM user_tablespaces");}function
limit($G,$Z,$z,$D=0,$M=" "){return($D?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $G$Z) t WHERE rownum <= ".($z+$D).") WHERE rnum > $D":($z!==null?" * FROM (SELECT $G$Z) WHERE rownum <= ".($z+$D):" $G$Z"));}function
limit1($R,$G,$Z,$M="\n"){return" $G$Z";}function
db_collation($l,$qb){global$g;return$g->result("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT USER FROM DUAL");}function
tables_list(){return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."
UNION SELECT view_name, 'view' FROM user_views
ORDER BY 1");}function
count_tables($k){return
array();}function
table_status($C=""){$I=array();$Zg=q($C);foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q(DB).($C!=""?" AND table_name = $Zg":"")."
UNION SELECT view_name, 'view', 0, 0 FROM user_views".($C!=""?" WHERE view_name = $Zg":"")."
ORDER BY 1")as$J){if($C!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return
true;}function
fields($R){$I=array();foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($R)." ORDER BY column_id")as$J){$U=$J["DATA_TYPE"];$te="$J[DATA_PRECISION],$J[DATA_SCALE]";if($te==",")$te=$J["DATA_LENGTH"];$I[$J["COLUMN_NAME"]]=array("field"=>$J["COLUMN_NAME"],"full_type"=>$U.($te?"($te)":""),"type"=>strtolower($U),"length"=>$te,"default"=>$J["DATA_DEFAULT"],"null"=>($J["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);}return$I;}function
indexes($R,$h=null){$I=array();foreach(get_rows("SELECT uic.*, uc.constraint_type
FROM user_ind_columns uic
LEFT JOIN user_constraints uc ON uic.index_name = uc.constraint_name AND uic.table_name = uc.table_name
WHERE uic.table_name = ".q($R)."
ORDER BY uc.constraint_type, uic.column_position",$h)as$J){$Hd=$J["INDEX_NAME"];$I[$Hd]["type"]=($J["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($J["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$I[$Hd]["columns"][]=$J["COLUMN_NAME"];$I[$Hd]["lengths"][]=($J["CHAR_LENGTH"]&&$J["CHAR_LENGTH"]!=$J["COLUMN_LENGTH"]?$J["CHAR_LENGTH"]:null);$I[$Hd]["descs"][]=($J["DESCEND"]?'1':null);}return$I;}function
view($C){$K=get_rows('SELECT text "select" FROM user_views WHERE view_name = '.q($C));return
reset($K);}function
collations(){return
array();}function
information_schema($l){return
false;}function
error(){global$g;return
h($g->error);}function
explain($g,$G){$g->query("EXPLAIN PLAN FOR $G");return$g->query("SELECT * FROM plan_table");}function
found_rows($S,$Z){}function
alter_table($R,$C,$p,$dd,$vb,$vc,$pb,$Ma,$Rf){$c=$gc=array();foreach($p
as$o){$X=$o[1];if($X&&$o[0]!=""&&idf_escape($o[0])!=$X[0])queries("ALTER TABLE ".table($R)." RENAME COLUMN ".idf_escape($o[0])." TO $X[0]");if($X)$c[]=($R!=""?($o[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($R!=""?")":"");else$gc[]=idf_escape($o[0]);}if($R=="")return
queries("CREATE TABLE ".table($C)." (\n".implode(",\n",$c)."\n)");return(!$c||queries("ALTER TABLE ".table($R)."\n".implode("\n",$c)))&&(!$gc||queries("ALTER TABLE ".table($R)." DROP (".implode(", ",$gc).")"))&&($R==$C||queries("ALTER TABLE ".table($R)." RENAME TO ".table($C)));}function
foreign_keys($R){$I=array();$G="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($R);foreach(get_rows($G)as$J)$I[$J['NAME']]=array("db"=>$J['DEST_DB'],"table"=>$J['DEST_TABLE'],"source"=>array($J['SRC_COLUMN']),"target"=>array($J['DEST_COLUMN']),"on_delete"=>$J['ON_DELETE'],"on_update"=>null,);return$I;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($Wi){return
apply_queries("DROP VIEW",$Wi);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
last_id(){return
0;}function
schemas(){return
get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX'))");}function
get_schema(){global$g;return$g->result("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($Yg){global$g;return$g->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($Yg));}function
show_variables(){return
get_key_vals('SELECT name, display_value FROM v$parameter');}function
process_list(){return
get_rows('SELECT sess.process AS "process", sess.username AS "user", sess.schemaname AS "schema", sess.status AS "status", sess.wait_class AS "wait_class", sess.seconds_in_wait AS "seconds_in_wait", sql.sql_text AS "sql_text", sess.machine AS "machine", sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
show_status(){$K=get_rows('SELECT * FROM v$instance');return
reset($K);}function
convert_field($o){}function
unconvert_field($o,$I){return$I;}function
support($Qc){return
preg_match('~^(columns|database|drop_col|indexes|processlist|scheme|sql|status|table|variables|view|view_trigger)$~',$Qc);}$x="oracle";$zi=array();$Dh=array();foreach(array(lang(27)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(28)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(25)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(29)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),)as$y=>$X){$zi+=$X;$Dh[$y]=array_keys($X);}$Fi=array();$sf=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");$ld=array("length","lower","round","upper");$rd=array("avg","count","count distinct","max","min","sum");$nc=array(array("date"=>"current_date","timestamp"=>"current_timestamp",),array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",));}$fc["mssql"]="MS SQL (beta)";if(isset($_GET["mssql"])){$eg=array("SQLSRV","MSSQL","PDO_DBLIB");define("DRIVER","mssql");if(extension_loaded("sqlsrv")){class
Min_DB{var$extension="sqlsrv",$_link,$_result,$server_info,$affected_rows,$errno,$error;function
_get_error(){$this->error="";foreach(sqlsrv_errors()as$n){$this->errno=$n["code"];$this->error.="$n[message]\n";}$this->error=rtrim($this->error);}function
connect($N,$V,$F){$this->_link=@sqlsrv_connect(preg_replace('~:~',',',$N),array("UID"=>$V,"PWD"=>$F,"CharacterSet"=>"UTF-8"));if($this->_link){$Od=sqlsrv_server_info($this->_link);$this->server_info=$Od['SQLServerVersion'];}else$this->_get_error();return(bool)$this->_link;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($j){return$this->query("USE ".idf_escape($j));}function
query($G,$_i=false){$H=sqlsrv_query($this->_link,$G);$this->error="";if(!$H){$this->_get_error();return
false;}return$this->store_result($H);}function
multi_query($G){$this->_result=sqlsrv_query($this->_link,$G);$this->error="";if(!$this->_result){$this->_get_error();return
false;}return
true;}function
store_result($H=null){if(!$H)$H=$this->_result;if(!$H)return
false;if(sqlsrv_field_metadata($H))return
new
Min_Result($H);$this->affected_rows=sqlsrv_rows_affected($H);return
true;}function
next_result(){return$this->_result?sqlsrv_next_result($this->_result):null;}function
result($G,$o=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->fetch_row();return$J[$o];}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$y=>$X){if(is_a($X,'DateTime'))$J[$y]=$X->format("Y-m-d H:i:s");}return$J;}function
fetch_assoc(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->_fields)$this->_fields=sqlsrv_field_metadata($this->_result);$o=$this->_fields[$this->_offset++];$I=new
stdClass;$I->name=$o["Name"];$I->orgname=$o["Name"];$I->type=($o["Type"]==1?254:0);return$I;}function
seek($D){for($s=0;$s<$D;$s++)sqlsrv_fetch($this->_result);}function
__destruct(){sqlsrv_free_stmt($this->_result);}}}elseif(extension_loaded("mssql")){class
Min_DB{var$extension="MSSQL",$_link,$_result,$server_info,$affected_rows,$error;function
connect($N,$V,$F){$this->_link=@mssql_connect($N,$V,$F);if($this->_link){$H=$this->query("SELECT SERVERPROPERTY('ProductLevel'), SERVERPROPERTY('Edition')");if($H){$J=$H->fetch_row();$this->server_info=$this->result("sp_server_info 2",2)." [$J[0]] $J[1]";}}else$this->error=mssql_get_last_message();return(bool)$this->_link;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($j){return
mssql_select_db($j);}function
query($G,$_i=false){$H=@mssql_query($G,$this->_link);$this->error="";if(!$H){$this->error=mssql_get_last_message();return
false;}if($H===true){$this->affected_rows=mssql_rows_affected($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
mssql_next_result($this->_result->_result);}function
result($G,$o=0){$H=$this->query($G);if(!is_object($H))return
false;return
mssql_result($H->_result,0,$o);}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=mssql_num_rows($H);}function
fetch_assoc(){return
mssql_fetch_assoc($this->_result);}function
fetch_row(){return
mssql_fetch_row($this->_result);}function
num_rows(){return
mssql_num_rows($this->_result);}function
fetch_field(){$I=mssql_fetch_field($this->_result);$I->orgtable=$I->table;$I->orgname=$I->name;return$I;}function
seek($D){mssql_data_seek($this->_result,$D);}function
__destruct(){mssql_free_result($this->_result);}}}elseif(extension_loaded("pdo_dblib")){class
Min_DB
extends
Min_PDO{var$extension="PDO_DBLIB";function
connect($N,$V,$F){$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$F);return
true;}function
select_db($j){return$this->query("USE ".idf_escape($j));}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($R,$K,$hg){foreach($K
as$O){$Gi=array();$Z=array();foreach($O
as$y=>$X){$Gi[]="$y = $X";if(isset($hg[idf_unescape($y)]))$Z[]="$y = $X";}if(!queries("MERGE ".table($R)." USING (VALUES(".implode(", ",$O).")) AS source (c".implode(", c",range(1,count($O))).") ON ".implode(" AND ",$Z)." WHEN MATCHED THEN UPDATE SET ".implode(", ",$Gi)." WHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).");"))return
false;}return
true;}function
begin(){return
queries("BEGIN TRANSACTION");}}function
idf_escape($u){return"[".str_replace("]","]]",$u)."]";}function
table($u){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($u);}function
connect(){global$b;$g=new
Min_DB;$Hb=$b->credentials();if($g->connect($Hb[0],$Hb[1],$Hb[2]))return$g;return$g->error;}function
get_databases(){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($G,$Z,$z,$D=0,$M=" "){return($z!==null?" TOP (".($z+$D).")":"")." $G$Z";}function
limit1($R,$G,$Z,$M="\n"){return
limit($G,$Z,1,0,$M);}function
db_collation($l,$qb){global$g;return$g->result("SELECT collation_name FROM sys.databases WHERE name = ".q($l));}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($k){global$g;$I=array();foreach($k
as$l){$g->select_db($l);$I[$l]=$g->result("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$I;}function
table_status($C=""){$I=array();foreach(get_rows("SELECT name AS Name, type_desc AS Engine FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($C!=""?"AND name = ".q($C):"ORDER BY name"))as$J){if($C!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($S){return$S["Engine"]=="VIEW";}function
fk_support($S){return
true;}function
fields($R){$I=array();foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, CAST(d.definition as text) [default]
FROM sys.all_columns c
JOIN sys.all_objects o ON c.object_id = o.object_id
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.parent_column_id
WHERE o.schema_id = SCHEMA_ID(".q(get_schema()).") AND o.type IN ('S', 'U', 'V') AND o.name = ".q($R))as$J){$U=$J["type"];$te=(preg_match("~char|binary~",$U)?$J["max_length"]:($U=="decimal"?"$J[precision],$J[scale]":""));$I[$J["name"]]=array("field"=>$J["name"],"full_type"=>$U.($te?"($te)":""),"type"=>$U,"length"=>$te,"default"=>$J["default"],"null"=>$J["is_nullable"],"auto_increment"=>$J["is_identity"],"collation"=>$J["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),"primary"=>$J["is_identity"],);}return$I;}function
indexes($R,$h=null){$I=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($R),$h)as$J){$C=$J["name"];$I[$C]["type"]=($J["is_primary_key"]?"PRIMARY":($J["is_unique"]?"UNIQUE":"INDEX"));$I[$C]["lengths"]=array();$I[$C]["columns"][$J["key_ordinal"]]=$J["column_name"];$I[$C]["descs"][$J["key_ordinal"]]=($J["is_descending_key"]?'1':null);}return$I;}function
view($C){global$g;return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',$g->result("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($C))));}function
collations(){$I=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$pb)$I[preg_replace('~_.*~','',$pb)][]=$pb;return$I;}function
information_schema($l){return
false;}function
error(){global$g;return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',$g->error)));}function
create_database($l,$pb){return
queries("CREATE DATABASE ".idf_escape($l).(preg_match('~^[a-z0-9_]+$~i',$pb)?" COLLATE $pb":""));}function
drop_databases($k){return
queries("DROP DATABASE ".implode(", ",array_map('idf_escape',$k)));}function
rename_database($C,$pb){if(preg_match('~^[a-z0-9_]+$~i',$pb))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $pb");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($C));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($R,$C,$p,$dd,$vb,$vc,$pb,$Ma,$Rf){$c=array();foreach($p
as$o){$d=idf_escape($o[0]);$X=$o[1];if(!$X)$c["DROP"][]=" COLUMN $d";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);if($o[0]=="")$c["ADD"][]="\n  ".implode("",$X).($R==""?substr($dd[$X[0]],16+strlen($X[0])):"");else{unset($X[6]);if($d!=$X[0])queries("EXEC sp_rename ".q(table($R).".$d").", ".q(idf_unescape($X[0])).", 'COLUMN'");$c["ALTER COLUMN ".implode("",$X)][]="";}}}if($R=="")return
queries("CREATE TABLE ".table($C)." (".implode(",",(array)$c["ADD"])."\n)");if($R!=$C)queries("EXEC sp_rename ".q(table($R)).", ".q($C));if($dd)$c[""]=$dd;foreach($c
as$y=>$X){if(!queries("ALTER TABLE ".idf_escape($C)." $y".implode(",",$X)))return
false;}return
true;}function
alter_indexes($R,$c){$v=array();$gc=array();foreach($c
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$gc[]=idf_escape($X[1]);else$v[]=idf_escape($X[1])." ON ".table($R);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R):"ALTER TABLE ".table($R)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$v||queries("DROP INDEX ".implode(", ",$v)))&&(!$gc||queries("ALTER TABLE ".table($R)." DROP ".implode(", ",$gc)));}function
last_id(){global$g;return$g->result("SELECT SCOPE_IDENTITY()");}function
explain($g,$G){$g->query("SET SHOWPLAN_ALL ON");$I=$g->query($G);$g->query("SET SHOWPLAN_ALL OFF");return$I;}function
found_rows($S,$Z){}function
foreign_keys($R){$I=array();foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($R))as$J){$q=&$I[$J["FK_NAME"]];$q["table"]=$J["PKTABLE_NAME"];$q["source"][]=$J["FKCOLUMN_NAME"];$q["target"][]=$J["PKCOLUMN_NAME"];}return$I;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($Wi){return
queries("DROP VIEW ".implode(", ",array_map('table',$Wi)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('table',$T)));}function
move_tables($T,$Wi,$Th){return
apply_queries("ALTER SCHEMA ".idf_escape($Th)." TRANSFER",array_merge($T,$Wi));}function
trigger($C){if($C=="")return
array();$K=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($C));$I=reset($K);if($I)$I["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$I["text"]);return$I;}function
triggers($R){$I=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($R))as$J)$I[$J["name"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){global$g;if($_GET["ns"]!="")return$_GET["ns"];return$g->result("SELECT SCHEMA_NAME()");}function
set_schema($Xg){return
true;}function
use_sql($j){return"USE ".idf_escape($j);}function
show_variables(){return
array();}function
show_status(){return
array();}function
convert_field($o){}function
unconvert_field($o,$I){return$I;}function
support($Qc){return
preg_match('~^(columns|database|drop_col|indexes|scheme|sql|table|trigger|view|view_trigger)$~',$Qc);}$x="mssql";$zi=array();$Dh=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(28)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(25)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(29)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),)as$y=>$X){$zi+=$X;$Dh[$y]=array_keys($X);}$Fi=array();$sf=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");$ld=array("len","lower","round","upper");$rd=array("avg","count","count distinct","max","min","sum");$nc=array(array("date|time"=>"getdate",),array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",));}$fc['firebird']='Firebird (alpha)';if(isset($_GET["firebird"])){$eg=array("interbase");define("DRIVER","firebird");if(extension_loaded("interbase")){class
Min_DB{var$extension="Firebird",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($N,$V,$F){$this->_link=ibase_connect($N,$V,$F);if($this->_link){$Ji=explode(':',$N);$this->service_link=ibase_service_attach($Ji[0],$V,$F);$this->server_info=ibase_server_info($this->service_link,IBASE_SVC_SERVER_VERSION);}else{$this->errno=ibase_errcode();$this->error=ibase_errmsg();}return(bool)$this->_link;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($j){return($j=="domain");}function
query($G,$_i=false){$H=ibase_query($G,$this->_link);if(!$H){$this->errno=ibase_errcode();$this->error=ibase_errmsg();return
false;}$this->error="";if($H===true){$this->affected_rows=ibase_affected_rows($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$o=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;$J=$H->fetch_row();return$J[$o];}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($H){$this->_result=$H;}function
fetch_assoc(){return
ibase_fetch_assoc($this->_result);}function
fetch_row(){return
ibase_fetch_row($this->_result);}function
fetch_field(){$o=ibase_field_info($this->_result,$this->_offset++);return(object)array('name'=>$o['name'],'orgname'=>$o['name'],'type'=>$o['type'],'charsetnr'=>$o['length'],);}function
__destruct(){ibase_free_result($this->_result);}}}class
Min_Driver
extends
Min_SQL{}function
idf_escape($u){return'"'.str_replace('"','""',$u).'"';}function
table($u){return
idf_escape($u);}function
connect(){global$b;$g=new
Min_DB;$Hb=$b->credentials();if($g->connect($Hb[0],$Hb[1],$Hb[2]))return$g;return$g->error;}function
get_databases($bd){return
array("domain");}function
limit($G,$Z,$z,$D=0,$M=" "){$I='';$I.=($z!==null?$M."FIRST $z".($D?" SKIP $D":""):"");$I.=" $G$Z";return$I;}function
limit1($R,$G,$Z,$M="\n"){return
limit($G,$Z,1,0,$M);}function
db_collation($l,$qb){}function
engines(){return
array();}function
logged_user(){global$b;$Hb=$b->credentials();return$Hb[1];}function
tables_list(){global$g;$G='SELECT RDB$RELATION_NAME FROM rdb$relations WHERE rdb$system_flag = 0';$H=ibase_query($g->_link,$G);$I=array();while($J=ibase_fetch_assoc($H))$I[$J['RDB$RELATION_NAME']]='table';ksort($I);return$I;}function
count_tables($k){return
array();}function
table_status($C="",$Pc=false){global$g;$I=array();$Mb=tables_list();foreach($Mb
as$v=>$X){$v=trim($v);$I[$v]=array('Name'=>$v,'Engine'=>'standard',);if($C==$v)return$I[$v];}return$I;}function
is_view($S){return
false;}function
fk_support($S){return
preg_match('~InnoDB|IBMDB2I~i',$S["Engine"]);}function
fields($R){global$g;$I=array();$G='SELECT r.RDB$FIELD_NAME AS field_name,
r.RDB$DESCRIPTION AS field_description,
r.RDB$DEFAULT_VALUE AS field_default_value,
r.RDB$NULL_FLAG AS field_not_null_constraint,
f.RDB$FIELD_LENGTH AS field_length,
f.RDB$FIELD_PRECISION AS field_precision,
f.RDB$FIELD_SCALE AS field_scale,
CASE f.RDB$FIELD_TYPE
WHEN 261 THEN \'BLOB\'
WHEN 14 THEN \'CHAR\'
WHEN 40 THEN \'CSTRING\'
WHEN 11 THEN \'D_FLOAT\'
WHEN 27 THEN \'DOUBLE\'
WHEN 10 THEN \'FLOAT\'
WHEN 16 THEN \'INT64\'
WHEN 8 THEN \'INTEGER\'
WHEN 9 THEN \'QUAD\'
WHEN 7 THEN \'SMALLINT\'
WHEN 12 THEN \'DATE\'
WHEN 13 THEN \'TIME\'
WHEN 35 THEN \'TIMESTAMP\'
WHEN 37 THEN \'VARCHAR\'
ELSE \'UNKNOWN\'
END AS field_type,
f.RDB$FIELD_SUB_TYPE AS field_subtype,
coll.RDB$COLLATION_NAME AS field_collation,
cset.RDB$CHARACTER_SET_NAME AS field_charset
FROM RDB$RELATION_FIELDS r
LEFT JOIN RDB$FIELDS f ON r.RDB$FIELD_SOURCE = f.RDB$FIELD_NAME
LEFT JOIN RDB$COLLATIONS coll ON f.RDB$COLLATION_ID = coll.RDB$COLLATION_ID
LEFT JOIN RDB$CHARACTER_SETS cset ON f.RDB$CHARACTER_SET_ID = cset.RDB$CHARACTER_SET_ID
WHERE r.RDB$RELATION_NAME = '.q($R).'
ORDER BY r.RDB$FIELD_POSITION';$H=ibase_query($g->_link,$G);while($J=ibase_fetch_assoc($H))$I[trim($J['FIELD_NAME'])]=array("field"=>trim($J["FIELD_NAME"]),"full_type"=>trim($J["FIELD_TYPE"]),"type"=>trim($J["FIELD_SUB_TYPE"]),"default"=>trim($J['FIELD_DEFAULT_VALUE']),"null"=>(trim($J["FIELD_NOT_NULL_CONSTRAINT"])=="YES"),"auto_increment"=>'0',"collation"=>trim($J["FIELD_COLLATION"]),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),"comment"=>trim($J["FIELD_DESCRIPTION"]),);return$I;}function
indexes($R,$h=null){$I=array();return$I;}function
foreign_keys($R){return
array();}function
collations(){return
array();}function
information_schema($l){return
false;}function
error(){global$g;return
h($g->error);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Xg){return
true;}function
support($Qc){return
preg_match("~^(columns|sql|status|table)$~",$Qc);}$x="firebird";$sf=array("=");$ld=array();$rd=array();$nc=array();}$fc["simpledb"]="SimpleDB";if(isset($_GET["simpledb"])){$eg=array("SimpleXML + allow_url_fopen");define("DRIVER","simpledb");if(class_exists('SimpleXMLElement')&&ini_bool('allow_url_fopen')){class
Min_DB{var$extension="SimpleXML",$server_info='2009-04-15',$error,$timeout,$next,$affected_rows,$_result;function
select_db($j){return($j=="domain");}function
query($G,$_i=false){$Lf=array('SelectExpression'=>$G,'ConsistentRead'=>'true');if($this->next)$Lf['NextToken']=$this->next;$H=sdb_request_all('Select','Item',$Lf,$this->timeout);$this->timeout=0;if($H===false)return$H;if(preg_match('~^\s*SELECT\s+COUNT\(~i',$G)){$Hh=0;foreach($H
as$ae)$Hh+=$ae->Attribute->Value;$H=array((object)array('Attribute'=>array((object)array('Name'=>'Count','Value'=>$Hh,))));}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0;function
__construct($H){foreach($H
as$ae){$J=array();if($ae->Name!='')$J['itemName()']=(string)$ae->Name;foreach($ae->Attribute
as$Ja){$C=$this->_processValue($Ja->Name);$Y=$this->_processValue($Ja->Value);if(isset($J[$C])){$J[$C]=(array)$J[$C];$J[$C][]=$Y;}else$J[$C]=$Y;}$this->_rows[]=$J;foreach($J
as$y=>$X){if(!isset($this->_rows[0][$y]))$this->_rows[0][$y]=null;}}$this->num_rows=count($this->_rows);}function
_processValue($qc){return(is_object($qc)&&$qc['encoding']=='base64'?base64_decode($qc):(string)$qc);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$y=>$X)$I[$y]=$J[$y];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$ge=array_keys($this->_rows[0]);return(object)array('name'=>$ge[$this->_offset++]);}}}class
Min_Driver
extends
Min_SQL{public$hg="itemName()";function
_chunkRequest($Ed,$wa,$Lf,$Fc=array()){global$g;foreach(array_chunk($Ed,25)as$ib){$Mf=$Lf;foreach($ib
as$s=>$t){$Mf["Item.$s.ItemName"]=$t;foreach($Fc
as$y=>$X)$Mf["Item.$s.$y"]=$X;}if(!sdb_request($wa,$Mf))return
false;}$g->affected_rows=count($Ed);return
true;}function
_extractIds($R,$tg,$z){$I=array();if(preg_match_all("~itemName\(\) = (('[^']*+')+)~",$tg,$Ce))$I=array_map('idf_unescape',$Ce[1]);else{foreach(sdb_request_all('Select','Item',array('SelectExpression'=>'SELECT itemName() FROM '.table($R).$tg.($z?" LIMIT 1":"")))as$ae)$I[]=$ae->Name;}return$I;}function
select($R,$L,$Z,$od,$xf=array(),$z=1,$E=0,$jg=false){global$g;$g->next=$_GET["next"];$I=parent::select($R,$L,$Z,$od,$xf,$z,$E,$jg);$g->next=0;return$I;}function
delete($R,$tg,$z=0){return$this->_chunkRequest($this->_extractIds($R,$tg,$z),'BatchDeleteAttributes',array('DomainName'=>$R));}function
update($R,$O,$tg,$z=0,$M="\n"){$Vb=array();$Sd=array();$s=0;$Ed=$this->_extractIds($R,$tg,$z);$t=idf_unescape($O["`itemName()`"]);unset($O["`itemName()`"]);foreach($O
as$y=>$X){$y=idf_unescape($y);if($X=="NULL"||($t!=""&&array($t)!=$Ed))$Vb["Attribute.".count($Vb).".Name"]=$y;if($X!="NULL"){foreach((array)$X
as$ce=>$W){$Sd["Attribute.$s.Name"]=$y;$Sd["Attribute.$s.Value"]=(is_array($X)?$W:idf_unescape($W));if(!$ce)$Sd["Attribute.$s.Replace"]="true";$s++;}}}$Lf=array('DomainName'=>$R);return(!$Sd||$this->_chunkRequest(($t!=""?array($t):$Ed),'BatchPutAttributes',$Lf,$Sd))&&(!$Vb||$this->_chunkRequest($Ed,'BatchDeleteAttributes',$Lf,$Vb));}function
insert($R,$O){$Lf=array("DomainName"=>$R);$s=0;foreach($O
as$C=>$Y){if($Y!="NULL"){$C=idf_unescape($C);if($C=="itemName()")$Lf["ItemName"]=idf_unescape($Y);else{foreach((array)$Y
as$X){$Lf["Attribute.$s.Name"]=$C;$Lf["Attribute.$s.Value"]=(is_array($Y)?$X:idf_unescape($Y));$s++;}}}}return
sdb_request('PutAttributes',$Lf);}function
insertUpdate($R,$K,$hg){foreach($K
as$O){if(!$this->update($R,$O,"WHERE `itemName()` = ".q($O["`itemName()`"])))return
false;}return
true;}function
begin(){return
false;}function
commit(){return
false;}function
rollback(){return
false;}function
slowQuery($G,$bi){$this->_conn->timeout=$bi;return$G;}}function
connect(){global$b;list(,,$F)=$b->credentials();if($F!="")return
lang(22);return
new
Min_DB;}function
support($Qc){return
preg_match('~sql~',$Qc);}function
logged_user(){global$b;$Hb=$b->credentials();return$Hb[1];}function
get_databases(){return
array("domain");}function
collations(){return
array();}function
db_collation($l,$qb){}function
tables_list(){global$g;$I=array();foreach(sdb_request_all('ListDomains','DomainName')as$R)$I[(string)$R]='table';if($g->error&&defined("PAGE_HEADER"))echo"<p class='error'>".error()."\n";return$I;}function
table_status($C="",$Pc=false){$I=array();foreach(($C!=""?array($C=>true):tables_list())as$R=>$U){$J=array("Name"=>$R,"Auto_increment"=>"");if(!$Pc){$Pe=sdb_request('DomainMetadata',array('DomainName'=>$R));if($Pe){foreach(array("Rows"=>"ItemCount","Data_length"=>"ItemNamesSizeBytes","Index_length"=>"AttributeValuesSizeBytes","Data_free"=>"AttributeNamesSizeBytes",)as$y=>$X)$J[$y]=(string)$Pe->$X;}}if($C!="")return$J;$I[$R]=$J;}return$I;}function
explain($g,$G){}function
error(){global$g;return
h($g->error);}function
information_schema(){}function
is_view($S){}function
indexes($R,$h=null){return
array(array("type"=>"PRIMARY","columns"=>array("itemName()")),);}function
fields($R){return
fields_from_edit();}function
foreign_keys($R){return
array();}function
table($u){return
idf_escape($u);}function
idf_escape($u){return"`".str_replace("`","``",$u)."`";}function
limit($G,$Z,$z,$D=0,$M=" "){return" $G$Z".($z!==null?$M."LIMIT $z":"");}function
unconvert_field($o,$I){return$I;}function
fk_support($S){}function
engines(){return
array();}function
alter_table($R,$C,$p,$dd,$vb,$vc,$pb,$Ma,$Rf){return($R==""&&sdb_request('CreateDomain',array('DomainName'=>$C)));}function
drop_tables($T){foreach($T
as$R){if(!sdb_request('DeleteDomain',array('DomainName'=>$R)))return
false;}return
true;}function
count_tables($k){foreach($k
as$l)return
array($l=>count(tables_list()));}function
found_rows($S,$Z){return($Z?null:$S["Rows"]);}function
last_id(){}function
hmac($Ca,$Mb,$y,$xg=false){$Va=64;if(strlen($y)>$Va)$y=pack("H*",$Ca($y));$y=str_pad($y,$Va,"\0");$de=$y^str_repeat("\x36",$Va);$ee=$y^str_repeat("\x5C",$Va);$I=$Ca($ee.pack("H*",$Ca($de.$Mb)));if($xg)$I=pack("H*",$I);return$I;}function
sdb_request($wa,$Lf=array()){global$b,$g;list($Bd,$Lf['AWSAccessKeyId'],$ah)=$b->credentials();$Lf['Action']=$wa;$Lf['Timestamp']=gmdate('Y-m-d\TH:i:s+00:00');$Lf['Version']='2009-04-15';$Lf['SignatureVersion']=2;$Lf['SignatureMethod']='HmacSHA1';ksort($Lf);$G='';foreach($Lf
as$y=>$X)$G.='&'.rawurlencode($y).'='.rawurlencode($X);$G=str_replace('%7E','~',substr($G,1));$G.="&Signature=".urlencode(base64_encode(hmac('sha1',"POST\n".preg_replace('~^https?://~','',$Bd)."\n/\n$G",$ah,true)));@ini_set('track_errors',1);$Uc=@file_get_contents((preg_match('~^https?://~',$Bd)?$Bd:"http://$Bd"),false,stream_context_create(array('http'=>array('method'=>'POST','content'=>$G,'ignore_errors'=>1,))));if(!$Uc){$g->error=$php_errormsg;return
false;}libxml_use_internal_errors(true);$jj=simplexml_load_string($Uc);if(!$jj){$n=libxml_get_last_error();$g->error=$n->message;return
false;}if($jj->Errors){$n=$jj->Errors->Error;$g->error="$n->Message ($n->Code)";return
false;}$g->error='';$Sh=$wa."Result";return($jj->$Sh?$jj->$Sh:true);}function
sdb_request_all($wa,$Sh,$Lf=array(),$bi=0){$I=array();$_h=($bi?microtime(true):0);$z=(preg_match('~LIMIT\s+(\d+)\s*$~i',$Lf['SelectExpression'],$B)?$B[1]:0);do{$jj=sdb_request($wa,$Lf);if(!$jj)break;foreach($jj->$Sh
as$qc)$I[]=$qc;if($z&&count($I)>=$z){$_GET["next"]=$jj->NextToken;break;}if($bi&&microtime(true)-$_h>$bi)return
false;$Lf['NextToken']=$jj->NextToken;if($z)$Lf['SelectExpression']=preg_replace('~\d+\s*$~',$z-count($I),$Lf['SelectExpression']);}while($jj->NextToken);return$I;}$x="simpledb";$sf=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","IS NOT NULL");$ld=array();$rd=array("count");$nc=array(array("json"));}$fc["mongo"]="MongoDB";if(isset($_GET["mongo"])){$eg=array("mongo","mongodb");define("DRIVER","mongo");if(class_exists('MongoDB')){class
Min_DB{var$extension="Mongo",$server_info=MongoClient::VERSION,$error,$last_id,$_link,$_db;function
connect($Hi,$vf){return@new
MongoClient($Hi,$vf);}function
query($G){return
false;}function
select_db($j){try{$this->_db=$this->_link->selectDB($j);return
true;}catch(Exception$Bc){$this->error=$Bc->getMessage();return
false;}}function
quote($Q){return$Q;}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$ae){$J=array();foreach($ae
as$y=>$X){if(is_a($X,'MongoBinData'))$this->_charset[$y]=63;$J[$y]=(is_a($X,'MongoId')?'ObjectId("'.strval($X).'")':(is_a($X,'MongoDate')?gmdate("Y-m-d H:i:s",$X->sec)." GMT":(is_a($X,'MongoBinData')?$X->bin:(is_a($X,'MongoRegex')?strval($X):(is_object($X)?get_class($X):$X)))));}$this->_rows[]=$J;foreach($J
as$y=>$X){if(!isset($this->_rows[0][$y]))$this->_rows[0][$y]=null;}}$this->num_rows=count($this->_rows);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$y=>$X)$I[$y]=$J[$y];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$ge=array_keys($this->_rows[0]);$C=$ge[$this->_offset++];return(object)array('name'=>$C,'charsetnr'=>$this->_charset[$C],);}}class
Min_Driver
extends
Min_SQL{public$hg="_id";function
select($R,$L,$Z,$od,$xf=array(),$z=1,$E=0,$jg=false){$L=($L==array("*")?array():array_fill_keys($L,true));$rh=array();foreach($xf
as$X){$X=preg_replace('~ DESC$~','',$X,1,$Eb);$rh[$X]=($Eb?-1:1);}return
new
Min_Result($this->_conn->_db->selectCollection($R)->find(array(),$L)->sort($rh)->limit($z!=""?+$z:0)->skip($E*$z));}function
insert($R,$O){try{$I=$this->_conn->_db->selectCollection($R)->insert($O);$this->_conn->errno=$I['code'];$this->_conn->error=$I['err'];$this->_conn->last_id=$O['_id'];return!$I['err'];}catch(Exception$Bc){$this->_conn->error=$Bc->getMessage();return
false;}}}function
get_databases($bd){global$g;$I=array();$Rb=$g->_link->listDBs();foreach($Rb['databases']as$l)$I[]=$l['name'];return$I;}function
count_tables($k){global$g;$I=array();foreach($k
as$l)$I[$l]=count($g->_link->selectDB($l)->getCollectionNames(true));return$I;}function
tables_list(){global$g;return
array_fill_keys($g->_db->getCollectionNames(true),'table');}function
drop_databases($k){global$g;foreach($k
as$l){$Jg=$g->_link->selectDB($l)->drop();if(!$Jg['ok'])return
false;}return
true;}function
indexes($R,$h=null){global$g;$I=array();foreach($g->_db->selectCollection($R)->getIndexInfo()as$v){$Yb=array();foreach($v["key"]as$d=>$U)$Yb[]=($U==-1?'1':null);$I[$v["name"]]=array("type"=>($v["name"]=="_id_"?"PRIMARY":($v["unique"]?"UNIQUE":"INDEX")),"columns"=>array_keys($v["key"]),"lengths"=>array(),"descs"=>$Yb,);}return$I;}function
fields($R){return
fields_from_edit();}function
found_rows($S,$Z){global$g;return$g->_db->selectCollection($_GET["select"])->count($Z);}$sf=array("=");}elseif(class_exists('MongoDB\Driver\Manager')){class
Min_DB{var$extension="MongoDB",$server_info=MONGODB_VERSION,$error,$last_id;var$_link;var$_db,$_db_name;function
connect($Hi,$vf){$kb='MongoDB\Driver\Manager';return
new$kb($Hi,$vf);}function
query($G){return
false;}function
select_db($j){$this->_db_name=$j;return
true;}function
quote($Q){return$Q;}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$ae){$J=array();foreach($ae
as$y=>$X){if(is_a($X,'MongoDB\BSON\Binary'))$this->_charset[$y]=63;$J[$y]=(is_a($X,'MongoDB\BSON\ObjectID')?'MongoDB\BSON\ObjectID("'.strval($X).'")':(is_a($X,'MongoDB\BSON\UTCDatetime')?$X->toDateTime()->format('Y-m-d H:i:s'):(is_a($X,'MongoDB\BSON\Binary')?$X->bin:(is_a($X,'MongoDB\BSON\Regex')?strval($X):(is_object($X)?json_encode($X,256):$X)))));}$this->_rows[]=$J;foreach($J
as$y=>$X){if(!isset($this->_rows[0][$y]))$this->_rows[0][$y]=null;}}$this->num_rows=$H->count;}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$y=>$X)$I[$y]=$J[$y];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$ge=array_keys($this->_rows[0]);$C=$ge[$this->_offset++];return(object)array('name'=>$C,'charsetnr'=>$this->_charset[$C],);}}class
Min_Driver
extends
Min_SQL{public$hg="_id";function
select($R,$L,$Z,$od,$xf=array(),$z=1,$E=0,$jg=false){global$g;$L=($L==array("*")?array():array_fill_keys($L,1));if(count($L)&&!isset($L['_id']))$L['_id']=0;$Z=where_to_query($Z);$rh=array();foreach($xf
as$X){$X=preg_replace('~ DESC$~','',$X,1,$Eb);$rh[$X]=($Eb?-1:1);}if(isset($_GET['limit'])&&is_numeric($_GET['limit'])&&$_GET['limit']>0)$z=$_GET['limit'];$z=min(200,max(1,(int)$z));$oh=$E*$z;$kb='MongoDB\Driver\Query';$G=new$kb($Z,array('projection'=>$L,'limit'=>$z,'skip'=>$oh,'sort'=>$rh));$Mg=$g->_link->executeQuery("$g->_db_name.$R",$G);return
new
Min_Result($Mg);}function
update($R,$O,$tg,$z=0,$M="\n"){global$g;$l=$g->_db_name;$Z=sql_query_where_parser($tg);$kb='MongoDB\Driver\BulkWrite';$Za=new$kb(array());if(isset($O['_id']))unset($O['_id']);$Gg=array();foreach($O
as$y=>$Y){if($Y=='NULL'){$Gg[$y]=1;unset($O[$y]);}}$Gi=array('$set'=>$O);if(count($Gg))$Gi['$unset']=$Gg;$Za->update($Z,$Gi,array('upsert'=>false));$Mg=$g->_link->executeBulkWrite("$l.$R",$Za);$g->affected_rows=$Mg->getModifiedCount();return
true;}function
delete($R,$tg,$z=0){global$g;$l=$g->_db_name;$Z=sql_query_where_parser($tg);$kb='MongoDB\Driver\BulkWrite';$Za=new$kb(array());$Za->delete($Z,array('limit'=>$z));$Mg=$g->_link->executeBulkWrite("$l.$R",$Za);$g->affected_rows=$Mg->getDeletedCount();return
true;}function
insert($R,$O){global$g;$l=$g->_db_name;$kb='MongoDB\Driver\BulkWrite';$Za=new$kb(array());if(isset($O['_id'])&&empty($O['_id']))unset($O['_id']);$Za->insert($O);$Mg=$g->_link->executeBulkWrite("$l.$R",$Za);$g->affected_rows=$Mg->getInsertedCount();return
true;}}function
get_databases($bd){global$g;$I=array();$kb='MongoDB\Driver\Command';$tb=new$kb(array('listDatabases'=>1));$Mg=$g->_link->executeCommand('admin',$tb);foreach($Mg
as$Rb){foreach($Rb->databases
as$l)$I[]=$l->name;}return$I;}function
count_tables($k){$I=array();return$I;}function
tables_list(){global$g;$kb='MongoDB\Driver\Command';$tb=new$kb(array('listCollections'=>1));$Mg=$g->_link->executeCommand($g->_db_name,$tb);$rb=array();foreach($Mg
as$H)$rb[$H->name]='table';return$rb;}function
drop_databases($k){return
false;}function
indexes($R,$h=null){global$g;$I=array();$kb='MongoDB\Driver\Command';$tb=new$kb(array('listIndexes'=>$R));$Mg=$g->_link->executeCommand($g->_db_name,$tb);foreach($Mg
as$v){$Yb=array();$e=array();foreach(get_object_vars($v->key)as$d=>$U){$Yb[]=($U==-1?'1':null);$e[]=$d;}$I[$v->name]=array("type"=>($v->name=="_id_"?"PRIMARY":(isset($v->unique)?"UNIQUE":"INDEX")),"columns"=>$e,"lengths"=>array(),"descs"=>$Yb,);}return$I;}function
fields($R){$p=fields_from_edit();if(!count($p)){global$m;$H=$m->select($R,array("*"),null,null,array(),10);while($J=$H->fetch_assoc()){foreach($J
as$y=>$X){$J[$y]=null;$p[$y]=array("field"=>$y,"type"=>"string","null"=>($y!=$m->primary),"auto_increment"=>($y==$m->primary),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,),);}}}return$p;}function
found_rows($S,$Z){global$g;$Z=where_to_query($Z);$kb='MongoDB\Driver\Command';$tb=new$kb(array('count'=>$S['Name'],'query'=>$Z));$Mg=$g->_link->executeCommand($g->_db_name,$tb);$ji=$Mg->toArray();return$ji[0]->n;}function
sql_query_where_parser($tg){$tg=trim(preg_replace('/WHERE[\s]?[(]?\(?/','',$tg));$tg=preg_replace('/\)\)\)$/',')',$tg);$gj=explode(' AND ',$tg);$hj=explode(') OR (',$tg);$Z=array();foreach($gj
as$ej)$Z[]=trim($ej);if(count($hj)==1)$hj=array();elseif(count($hj)>1)$Z=array();return
where_to_query($Z,$hj);}function
where_to_query($cj=array(),$dj=array()){global$b;$Mb=array();foreach(array('and'=>$cj,'or'=>$dj)as$U=>$Z){if(is_array($Z)){foreach($Z
as$Ic){list($nb,$qf,$X)=explode(" ",$Ic,3);if($nb=="_id"){$X=str_replace('MongoDB\BSON\ObjectID("',"",$X);$X=str_replace('")',"",$X);$kb='MongoDB\BSON\ObjectID';$X=new$kb($X);}if(!in_array($qf,$b->operators))continue;if(preg_match('~^\(f\)(.+)~',$qf,$B)){$X=(float)$X;$qf=$B[1];}elseif(preg_match('~^\(date\)(.+)~',$qf,$B)){$Ob=new
DateTime($X);$kb='MongoDB\BSON\UTCDatetime';$X=new$kb($Ob->getTimestamp()*1000);$qf=$B[1];}switch($qf){case'=':$qf='$eq';break;case'!=':$qf='$ne';break;case'>':$qf='$gt';break;case'<':$qf='$lt';break;case'>=':$qf='$gte';break;case'<=':$qf='$lte';break;case'regex':$qf='$regex';break;default:continue;}if($U=='and')$Mb['$and'][]=array($nb=>array($qf=>$X));elseif($U=='or')$Mb['$or'][]=array($nb=>array($qf=>$X));}}}return$Mb;}$sf=array("=","!=",">","<",">=","<=","regex","(f)=","(f)!=","(f)>","(f)<","(f)>=","(f)<=","(date)=","(date)!=","(date)>","(date)<","(date)>=","(date)<=",);}function
table($u){return$u;}function
idf_escape($u){return$u;}function
table_status($C="",$Pc=false){$I=array();foreach(tables_list()as$R=>$U){$I[$R]=array("Name"=>$R);if($C==$R)return$I[$R];}return$I;}function
create_database($l,$pb){return
true;}function
last_id(){global$g;return$g->last_id;}function
error(){global$g;return
h($g->error);}function
collations(){return
array();}function
logged_user(){global$b;$Hb=$b->credentials();return$Hb[1];}function
connect(){global$b;$g=new
Min_DB;list($N,$V,$F)=$b->credentials();$vf=array();if($V.$F!=""){$vf["username"]=$V;$vf["password"]=$F;}$l=$b->database();if($l!="")$vf["db"]=$l;try{$g->_link=$g->connect("mongodb://$N",$vf);if($F!=""){$vf["password"]="";try{$g->connect("mongodb://$N",$vf);return
lang(22);}catch(Exception$Bc){}}return$g;}catch(Exception$Bc){return$Bc->getMessage();}}function
alter_indexes($R,$c){global$g;foreach($c
as$X){list($U,$C,$O)=$X;if($O=="DROP")$I=$g->_db->command(array("deleteIndexes"=>$R,"index"=>$C));else{$e=array();foreach($O
as$d){$d=preg_replace('~ DESC$~','',$d,1,$Eb);$e[$d]=($Eb?-1:1);}$I=$g->_db->selectCollection($R)->ensureIndex($e,array("unique"=>($U=="UNIQUE"),"name"=>$C,));}if($I['errmsg']){$g->error=$I['errmsg'];return
false;}}return
true;}function
support($Qc){return
preg_match("~database|indexes~",$Qc);}function
db_collation($l,$qb){}function
information_schema(){}function
is_view($S){}function
convert_field($o){}function
unconvert_field($o,$I){return$I;}function
foreign_keys($R){return
array();}function
fk_support($S){}function
engines(){return
array();}function
alter_table($R,$C,$p,$dd,$vb,$vc,$pb,$Ma,$Rf){global$g;if($R==""){$g->_db->createCollection($C);return
true;}}function
drop_tables($T){global$g;foreach($T
as$R){$Jg=$g->_db->selectCollection($R)->drop();if(!$Jg['ok'])return
false;}return
true;}function
truncate_tables($T){global$g;foreach($T
as$R){$Jg=$g->_db->selectCollection($R)->remove();if(!$Jg['ok'])return
false;}return
true;}$x="mongo";$ld=array();$rd=array();$nc=array(array("json"));}$fc["elastic"]="Elasticsearch (beta)";if(isset($_GET["elastic"])){$eg=array("json + allow_url_fopen");define("DRIVER","elastic");if(function_exists('json_decode')&&ini_bool('allow_url_fopen')){class
Min_DB{var$extension="JSON",$server_info,$errno,$error,$_url;function
rootQuery($Vf,$_b=array(),$Qe='GET'){@ini_set('track_errors',1);$Uc=@file_get_contents("$this->_url/".ltrim($Vf,'/'),false,stream_context_create(array('http'=>array('method'=>$Qe,'content'=>$_b===null?$_b:json_encode($_b),'header'=>'Content-Type: application/json','ignore_errors'=>1,))));if(!$Uc){$this->error=$php_errormsg;return$Uc;}if(!preg_match('~^HTTP/[0-9.]+ 2~i',$http_response_header[0])){$this->error=$Uc;return
false;}$I=json_decode($Uc,true);if($I===null){$this->errno=json_last_error();if(function_exists('json_last_error_msg'))$this->error=json_last_error_msg();else{$zb=get_defined_constants(true);foreach($zb['json']as$C=>$Y){if($Y==$this->errno&&preg_match('~^JSON_ERROR_~',$C)){$this->error=$C;break;}}}}return$I;}function
query($Vf,$_b=array(),$Qe='GET'){return$this->rootQuery(($this->_db!=""?"$this->_db/":"/").ltrim($Vf,'/'),$_b,$Qe);}function
connect($N,$V,$F){preg_match('~^(https?://)?(.*)~',$N,$B);$this->_url=($B[1]?$B[1]:"http://")."$V:$F@$B[2]";$I=$this->query('');if($I)$this->server_info=$I['version']['number'];return(bool)$I;}function
select_db($j){$this->_db=$j;return
true;}function
quote($Q){return$Q;}}class
Min_Result{var$num_rows,$_rows;function
__construct($K){$this->num_rows=count($this->_rows);$this->_rows=$K;reset($this->_rows);}function
fetch_assoc(){$I=current($this->_rows);next($this->_rows);return$I;}function
fetch_row(){return
array_values($this->fetch_assoc());}}}class
Min_Driver
extends
Min_SQL{function
select($R,$L,$Z,$od,$xf=array(),$z=1,$E=0,$jg=false){global$b;$Mb=array();$G="$R/_search";if($L!=array("*"))$Mb["fields"]=$L;if($xf){$rh=array();foreach($xf
as$nb){$nb=preg_replace('~ DESC$~','',$nb,1,$Eb);$rh[]=($Eb?array($nb=>"desc"):$nb);}$Mb["sort"]=$rh;}if($z){$Mb["size"]=+$z;if($E)$Mb["from"]=($E*$z);}foreach($Z
as$X){list($nb,$qf,$X)=explode(" ",$X,3);if($nb=="_id")$Mb["query"]["ids"]["values"][]=$X;elseif($nb.$X!=""){$Wh=array("term"=>array(($nb!=""?$nb:"_all")=>$X));if($qf=="=")$Mb["query"]["filtered"]["filter"]["and"][]=$Wh;else$Mb["query"]["filtered"]["query"]["bool"]["must"][]=$Wh;}}if($Mb["query"]&&!$Mb["query"]["filtered"]["query"]&&!$Mb["query"]["ids"])$Mb["query"]["filtered"]["query"]=array("match_all"=>array());$_h=microtime(true);$Zg=$this->_conn->query($G,$Mb);if($jg)echo$b->selectQuery("$G: ".print_r($Mb,true),$_h,!$Zg);if(!$Zg)return
false;$I=array();foreach($Zg['hits']['hits']as$Ad){$J=array();if($L==array("*"))$J["_id"]=$Ad["_id"];$p=$Ad['_source'];if($L!=array("*")){$p=array();foreach($L
as$y)$p[$y]=$Ad['fields'][$y];}foreach($p
as$y=>$X){if($Mb["fields"])$X=$X[0];$J[$y]=(is_array($X)?json_encode($X):$X);}$I[]=$J;}return
new
Min_Result($I);}function
update($U,$yg,$tg,$z=0,$M="\n"){$Tf=preg_split('~ *= *~',$tg);if(count($Tf)==2){$t=trim($Tf[1]);$G="$U/$t";return$this->_conn->query($G,$yg,'POST');}return
false;}function
insert($U,$yg){$t="";$G="$U/$t";$Jg=$this->_conn->query($G,$yg,'POST');$this->_conn->last_id=$Jg['_id'];return$Jg['created'];}function
delete($U,$tg,$z=0){$Ed=array();if(is_array($_GET["where"])&&$_GET["where"]["_id"])$Ed[]=$_GET["where"]["_id"];if(is_array($_POST['check'])){foreach($_POST['check']as$db){$Tf=preg_split('~ *= *~',$db);if(count($Tf)==2)$Ed[]=trim($Tf[1]);}}$this->_conn->affected_rows=0;foreach($Ed
as$t){$G="{$U}/{$t}";$Jg=$this->_conn->query($G,'{}','DELETE');if(is_array($Jg)&&$Jg['found']==true)$this->_conn->affected_rows++;}return$this->_conn->affected_rows;}}function
connect(){global$b;$g=new
Min_DB;list($N,$V,$F)=$b->credentials();if($F!=""&&$g->connect($N,$V,""))return
lang(22);if($g->connect($N,$V,$F))return$g;return$g->error;}function
support($Qc){return
preg_match("~database|table|columns~",$Qc);}function
logged_user(){global$b;$Hb=$b->credentials();return$Hb[1];}function
get_databases(){global$g;$I=$g->rootQuery('_aliases');if($I){$I=array_keys($I);sort($I,SORT_STRING);}return$I;}function
collations(){return
array();}function
db_collation($l,$qb){}function
engines(){return
array();}function
count_tables($k){global$g;$I=array();$H=$g->query('_stats');if($H&&$H['indices']){$Ld=$H['indices'];foreach($Ld
as$Kd=>$Ah){$Jd=$Ah['total']['indexing'];$I[$Kd]=$Jd['index_total'];}}return$I;}function
tables_list(){global$g;$I=$g->query('_mapping');if($I)$I=array_fill_keys(array_keys($I[$g->_db]["mappings"]),'table');return$I;}function
table_status($C="",$Pc=false){global$g;$Zg=$g->query("_search",array("size"=>0,"aggregations"=>array("count_by_type"=>array("terms"=>array("field"=>"_type")))),"POST");$I=array();if($Zg){$T=$Zg["aggregations"]["count_by_type"]["buckets"];foreach($T
as$R){$I[$R["key"]]=array("Name"=>$R["key"],"Engine"=>"table","Rows"=>$R["doc_count"],);if($C!=""&&$C==$R["key"])return$I[$C];}}return$I;}function
error(){global$g;return
h($g->error);}function
information_schema(){}function
is_view($S){}function
indexes($R,$h=null){return
array(array("type"=>"PRIMARY","columns"=>array("_id")),);}function
fields($R){global$g;$H=$g->query("$R/_mapping");$I=array();if($H){$ze=$H[$R]['properties'];if(!$ze)$ze=$H[$g->_db]['mappings'][$R]['properties'];if($ze){foreach($ze
as$C=>$o){$I[$C]=array("field"=>$C,"full_type"=>$o["type"],"type"=>$o["type"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);if($o["properties"]){unset($I[$C]["privileges"]["insert"]);unset($I[$C]["privileges"]["update"]);}}}}return$I;}function
foreign_keys($R){return
array();}function
table($u){return$u;}function
idf_escape($u){return$u;}function
convert_field($o){}function
unconvert_field($o,$I){return$I;}function
fk_support($S){}function
found_rows($S,$Z){return
null;}function
create_database($l){global$g;return$g->rootQuery(urlencode($l),null,'PUT');}function
drop_databases($k){global$g;return$g->rootQuery(urlencode(implode(',',$k)),array(),'DELETE');}function
alter_table($R,$C,$p,$dd,$vb,$vc,$pb,$Ma,$Rf){global$g;$pg=array();foreach($p
as$Nc){$Sc=trim($Nc[1][0]);$Tc=trim($Nc[1][1]?$Nc[1][1]:"text");$pg[$Sc]=array('type'=>$Tc);}if(!empty($pg))$pg=array('properties'=>$pg);return$g->query("_mapping/{$C}",$pg,'PUT');}function
drop_tables($T){global$g;$I=true;foreach($T
as$R)$I=$I&&$g->query(urlencode($R),array(),'DELETE');return$I;}function
last_id(){global$g;return$g->last_id;}$x="elastic";$sf=array("=","query");$ld=array();$rd=array();$nc=array(array("json"));$zi=array();$Dh=array();foreach(array(lang(27)=>array("long"=>3,"integer"=>5,"short"=>8,"byte"=>10,"double"=>20,"float"=>66,"half_float"=>12,"scaled_float"=>21),lang(28)=>array("date"=>10),lang(25)=>array("string"=>65535,"text"=>65535),lang(29)=>array("binary"=>255),)as$y=>$X){$zi+=$X;$Dh[$y]=array_keys($X);}}$fc=array("server"=>"MySQL")+$fc;if(!defined("DRIVER")){$eg=array("MySQLi","MySQL","PDO_MySQL");define("DRIVER","server");if(extension_loaded("mysqli")){class
Min_DB
extends
MySQLi{var$extension="MySQLi";function
__construct(){parent::init();}function
connect($N="",$V="",$F="",$j=null,$ag=null,$qh=null){global$b;mysqli_report(MYSQLI_REPORT_OFF);list($Bd,$ag)=explode(":",$N,2);$zh=$b->connectSsl();if($zh)$this->ssl_set($zh['key'],$zh['cert'],$zh['ca'],'','');$I=@$this->real_connect(($N!=""?$Bd:ini_get("mysqli.default_host")),($N.$V!=""?$V:ini_get("mysqli.default_user")),($N.$V.$F!=""?$F:ini_get("mysqli.default_pw")),$j,(is_numeric($ag)?$ag:ini_get("mysqli.default_port")),(!is_numeric($ag)?$ag:$qh),($zh?64:0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return$I;}function
set_charset($cb){if(parent::set_charset($cb))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $cb");}function
result($G,$o=0){$H=$this->query($G);if(!$H)return
false;$J=$H->fetch_array();return$J[$o];}function
quote($Q){return"'".$this->escape_string($Q)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Min_DB{var$extension="MySQL",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($N,$V,$F){if(ini_bool("mysql.allow_local_infile")){$this->error=lang(32,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");return
false;}$this->_link=@mysql_connect(($N!=""?$N:ini_get("mysql.default_host")),("$N$V"!=""?$V:ini_get("mysql.default_user")),("$N$V$F"!=""?$F:ini_get("mysql.default_password")),true,131072);if($this->_link)$this->server_info=mysql_get_server_info($this->_link);else$this->error=mysql_error();return(bool)$this->_link;}function
set_charset($cb){if(function_exists('mysql_set_charset')){if(mysql_set_charset($cb,$this->_link))return
true;mysql_set_charset('utf8',$this->_link);}return$this->query("SET NAMES $cb");}function
quote($Q){return"'".mysql_real_escape_string($Q,$this->_link)."'";}function
select_db($j){return
mysql_select_db($j,$this->_link);}function
query($G,$_i=false){$H=@($_i?mysql_unbuffered_query($G,$this->_link):mysql_query($G,$this->_link));$this->error="";if(!$H){$this->errno=mysql_errno($this->_link);$this->error=mysql_error($this->_link);return
false;}if($H===true){$this->affected_rows=mysql_affected_rows($this->_link);$this->info=mysql_info($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$o=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;return
mysql_result($H->_result,0,$o);}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($H){$this->_result=$H;$this->num_rows=mysql_num_rows($H);}function
fetch_assoc(){return
mysql_fetch_assoc($this->_result);}function
fetch_row(){return
mysql_fetch_row($this->_result);}function
fetch_field(){$I=mysql_fetch_field($this->_result,$this->_offset++);$I->orgtable=$I->table;$I->orgname=$I->name;$I->charsetnr=($I->blob?63:0);return$I;}function
__destruct(){mysql_free_result($this->_result);}}}elseif(extension_loaded("pdo_mysql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_MySQL";function
connect($N,$V,$F){global$b;$vf=array(PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$zh=$b->connectSsl();if($zh)$vf+=array(PDO::MYSQL_ATTR_SSL_KEY=>$zh['key'],PDO::MYSQL_ATTR_SSL_CERT=>$zh['cert'],PDO::MYSQL_ATTR_SSL_CA=>$zh['ca'],);$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$F,$vf);return
true;}function
set_charset($cb){$this->query("SET NAMES $cb");}function
select_db($j){return$this->query("USE ".idf_escape($j));}function
query($G,$_i=false){$this->setAttribute(1000,!$_i);return
parent::query($G,$_i);}}}class
Min_Driver
extends
Min_SQL{function
insert($R,$O){return($O?parent::insert($R,$O):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,$K,$hg){$e=array_keys(reset($K));$fg="INSERT INTO ".table($R)." (".implode(", ",$e).") VALUES\n";$Ri=array();foreach($e
as$y)$Ri[$y]="$y = VALUES($y)";$Gh="\nON DUPLICATE KEY UPDATE ".implode(", ",$Ri);$Ri=array();$te=0;foreach($K
as$O){$Y="(".implode(", ",$O).")";if($Ri&&(strlen($fg)+$te+strlen($Y)+strlen($Gh)>1e6)){if(!queries($fg.implode(",\n",$Ri).$Gh))return
false;$Ri=array();$te=0;}$Ri[]=$Y;$te+=strlen($Y)+2;}return
queries($fg.implode(",\n",$Ri).$Gh);}function
slowQuery($G,$bi){if(min_version('5.7.8','10.1.2')){if(preg_match('~MariaDB~',$this->_conn->server_info))return"SET STATEMENT max_statement_time=$bi FOR $G";elseif(preg_match('~^(SELECT\b)(.+)~is',$G,$B))return"$B[1] /*+ MAX_EXECUTION_TIME(".($bi*1000).") */ $B[2]";}}function
convertSearch($u,$X,$o){return(preg_match('~char|text|enum|set~',$o["type"])&&!preg_match("~^utf8~",$o["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($u USING ".charset($this->_conn).")":$u);}function
warnings(){$H=$this->_conn->query("SHOW WARNINGS");if($H&&$H->num_rows){ob_start();select($H);return
ob_get_clean();}}function
tableHelp($C){$_e=preg_match('~MariaDB~',$this->_conn->server_info);if(information_schema(DB))return
strtolower(($_e?"information-schema-$C-table/":str_replace("_","-",$C)."-table.html"));if(DB=="mysql")return($_e?"mysql$C-table/":"system-database.html");}}function
idf_escape($u){return"`".str_replace("`","``",$u)."`";}function
table($u){return
idf_escape($u);}function
connect(){global$b,$zi,$Dh;$g=new
Min_DB;$Hb=$b->credentials();if($g->connect($Hb[0],$Hb[1],$Hb[2])){$g->set_charset(charset($g));$g->query("SET sql_quote_show_create = 1, autocommit = 1");if(min_version('5.7.8',10.2,$g)){$Dh[lang(25)][]="json";$zi["json"]=4294967295;}return$g;}$I=$g->error;if(function_exists('iconv')&&!is_utf8($I)&&strlen($Vg=iconv("windows-1250","utf-8",$I))>strlen($I))$I=$Vg;return$I;}function
get_databases($bd){$I=get_session("dbs");if($I===null){$G=(min_version(5)?"SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME":"SHOW DATABASES");$I=($bd?slow_query($G):get_vals($G));restart_session();set_session("dbs",$I);stop_session();}return$I;}function
limit($G,$Z,$z,$D=0,$M=" "){return" $G$Z".($z!==null?$M."LIMIT $z".($D?" OFFSET $D":""):"");}function
limit1($R,$G,$Z,$M="\n"){return
limit($G,$Z,1,0,$M);}function
db_collation($l,$qb){global$g;$I=null;$i=$g->result("SHOW CREATE DATABASE ".idf_escape($l),1);if(preg_match('~ COLLATE ([^ ]+)~',$i,$B))$I=$B[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$i,$B))$I=$qb[$B[1]][-1];return$I;}function
engines(){$I=array();foreach(get_rows("SHOW ENGINES")as$J){if(preg_match("~YES|DEFAULT~",$J["Support"]))$I[]=$J["Engine"];}return$I;}function
logged_user(){global$g;return$g->result("SELECT USER()");}function
tables_list(){return
get_key_vals(min_version(5)?"SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME":"SHOW TABLES");}function
count_tables($k){$I=array();foreach($k
as$l)$I[$l]=count(get_vals("SHOW TABLES IN ".idf_escape($l)));return$I;}function
table_status($C="",$Pc=false){$I=array();foreach(get_rows($Pc&&min_version(5)?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($C!=""?"AND TABLE_NAME = ".q($C):"ORDER BY Name"):"SHOW TABLE STATUS".($C!=""?" LIKE ".q(addcslashes($C,"%_\\")):""))as$J){if($J["Engine"]=="InnoDB")$J["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$J["Comment"]);if(!isset($J["Engine"]))$J["Comment"]="";if($C!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($S){return$S["Engine"]===null;}function
fk_support($S){return
preg_match('~InnoDB|IBMDB2I~i',$S["Engine"])||(preg_match('~NDB~i',$S["Engine"])&&min_version(5.6));}function
fields($R){$I=array();foreach(get_rows("SHOW FULL COLUMNS FROM ".table($R))as$J){preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$J["Type"],$B);$I[$J["Field"]]=array("field"=>$J["Field"],"full_type"=>$J["Type"],"type"=>$B[1],"length"=>$B[2],"unsigned"=>ltrim($B[3].$B[4]),"default"=>($J["Default"]!=""||preg_match("~char|set~",$B[1])?$J["Default"]:null),"null"=>($J["Null"]=="YES"),"auto_increment"=>($J["Extra"]=="auto_increment"),"on_update"=>(preg_match('~^on update (.+)~i',$J["Extra"],$B)?$B[1]:""),"collation"=>$J["Collation"],"privileges"=>array_flip(preg_split('~, *~',$J["Privileges"])),"comment"=>$J["Comment"],"primary"=>($J["Key"]=="PRI"),);}return$I;}function
indexes($R,$h=null){$I=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$h)as$J){$C=$J["Key_name"];$I[$C]["type"]=($C=="PRIMARY"?"PRIMARY":($J["Index_type"]=="FULLTEXT"?"FULLTEXT":($J["Non_unique"]?($J["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$I[$C]["columns"][]=$J["Column_name"];$I[$C]["lengths"][]=($J["Index_type"]=="SPATIAL"?null:$J["Sub_part"]);$I[$C]["descs"][]=null;}return$I;}function
foreign_keys($R){global$g,$nf;static$Xf='`(?:[^`]|``)+`';$I=array();$Fb=$g->result("SHOW CREATE TABLE ".table($R),1);if($Fb){preg_match_all("~CONSTRAINT ($Xf) FOREIGN KEY ?\\(((?:$Xf,? ?)+)\\) REFERENCES ($Xf)(?:\\.($Xf))? \\(((?:$Xf,? ?)+)\\)(?: ON DELETE ($nf))?(?: ON UPDATE ($nf))?~",$Fb,$Ce,PREG_SET_ORDER);foreach($Ce
as$B){preg_match_all("~$Xf~",$B[2],$sh);preg_match_all("~$Xf~",$B[5],$Th);$I[idf_unescape($B[1])]=array("db"=>idf_unescape($B[4]!=""?$B[3]:$B[4]),"table"=>idf_unescape($B[4]!=""?$B[4]:$B[3]),"source"=>array_map('idf_unescape',$sh[0]),"target"=>array_map('idf_unescape',$Th[0]),"on_delete"=>($B[6]?$B[6]:"RESTRICT"),"on_update"=>($B[7]?$B[7]:"RESTRICT"),);}}return$I;}function
view($C){global$g;return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',$g->result("SHOW CREATE VIEW ".table($C),1)));}function
collations(){$I=array();foreach(get_rows("SHOW COLLATION")as$J){if($J["Default"])$I[$J["Charset"]][-1]=$J["Collation"];else$I[$J["Charset"]][]=$J["Collation"];}ksort($I);foreach($I
as$y=>$X)asort($I[$y]);return$I;}function
information_schema($l){return(min_version(5)&&$l=="information_schema")||(min_version(5.5)&&$l=="performance_schema");}function
error(){global$g;return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",$g->error));}function
create_database($l,$pb){return
queries("CREATE DATABASE ".idf_escape($l).($pb?" COLLATE ".q($pb):""));}function
drop_databases($k){$I=apply_queries("DROP DATABASE",$k,'idf_escape');restart_session();set_session("dbs",null);return$I;}function
rename_database($C,$pb){$I=false;if(create_database($C,$pb)){$Hg=array();foreach(tables_list()as$R=>$U)$Hg[]=table($R)." TO ".idf_escape($C).".".table($R);$I=(!$Hg||queries("RENAME TABLE ".implode(", ",$Hg)));if($I)queries("DROP DATABASE ".idf_escape(DB));restart_session();set_session("dbs",null);}return$I;}function
auto_increment(){$Na=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$v){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$v["columns"],true)){$Na="";break;}if($v["type"]=="PRIMARY")$Na=" UNIQUE";}}return" AUTO_INCREMENT$Na";}function
alter_table($R,$C,$p,$dd,$vb,$vc,$pb,$Ma,$Rf){$c=array();foreach($p
as$o)$c[]=($o[1]?($R!=""?($o[0]!=""?"CHANGE ".idf_escape($o[0]):"ADD"):" ")." ".implode($o[1]).($R!=""?$o[2]:""):"DROP ".idf_escape($o[0]));$c=array_merge($c,$dd);$P=($vb!==null?" COMMENT=".q($vb):"").($vc?" ENGINE=".q($vc):"").($pb?" COLLATE ".q($pb):"").($Ma!=""?" AUTO_INCREMENT=$Ma":"");if($R=="")return
queries("CREATE TABLE ".table($C)." (\n".implode(",\n",$c)."\n)$P$Rf");if($R!=$C)$c[]="RENAME TO ".table($C);if($P)$c[]=ltrim($P);return($c||$Rf?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$c).$Rf):true);}function
alter_indexes($R,$c){foreach($c
as$y=>$X)$c[$y]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$c));}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($Wi){return
queries("DROP VIEW ".implode(", ",array_map('table',$Wi)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('table',$T)));}function
move_tables($T,$Wi,$Th){$Hg=array();foreach(array_merge($T,$Wi)as$R)$Hg[]=table($R)." TO ".idf_escape($Th).".".table($R);return
queries("RENAME TABLE ".implode(", ",$Hg));}function
copy_tables($T,$Wi,$Th){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$C=($Th==DB?table("copy_$R"):idf_escape($Th).".".table($R));if(!queries("\nDROP TABLE IF EXISTS $C")||!queries("CREATE TABLE $C LIKE ".table($R))||!queries("INSERT INTO $C SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$J){$ti=$J["Trigger"];if(!queries("CREATE TRIGGER ".($Th==DB?idf_escape("copy_$ti"):idf_escape($Th).".".idf_escape($ti))." $J[Timing] $J[Event] ON $C FOR EACH ROW\n$J[Statement];"))return
false;}}foreach($Wi
as$R){$C=($Th==DB?table("copy_$R"):idf_escape($Th).".".table($R));$Vi=view($R);if(!queries("DROP VIEW IF EXISTS $C")||!queries("CREATE VIEW $C AS $Vi[select]"))return
false;}return
true;}function
trigger($C){if($C=="")return
array();$K=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($C));return
reset($K);}function
triggers($R){$I=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$J)$I[$J["Trigger"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($C,$U){global$g,$xc,$Qd,$zi;$Da=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$th="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$yi="((".implode("|",array_merge(array_keys($zi),$Da)).")\\b(?:\\s*\\(((?:[^'\")]|$xc)++)\\))?\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$Xf="$th*(".($U=="FUNCTION"?"":$Qd).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$yi";$i=$g->result("SHOW CREATE $U ".idf_escape($C),2);preg_match("~\\(((?:$Xf\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$yi\\s+":"")."(.*)~is",$i,$B);$p=array();preg_match_all("~$Xf\\s*,?~is",$B[1],$Ce,PREG_SET_ORDER);foreach($Ce
as$Kf){$C=str_replace("``","`",$Kf[2]).$Kf[3];$p[]=array("field"=>$C,"type"=>strtolower($Kf[5]),"length"=>preg_replace_callback("~$xc~s",'normalize_enum',$Kf[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Kf[8] $Kf[7]"))),"null"=>1,"full_type"=>$Kf[4],"inout"=>strtoupper($Kf[1]),"collation"=>strtolower($Kf[9]),);}if($U!="FUNCTION")return
array("fields"=>$p,"definition"=>$B[11]);return
array("fields"=>$p,"returns"=>array("type"=>$B[12],"length"=>$B[13],"unsigned"=>$B[15],"collation"=>$B[16]),"definition"=>$B[17],"language"=>"SQL",);}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB));}function
routine_languages(){return
array();}function
routine_id($C,$J){return
idf_escape($C);}function
last_id(){global$g;return$g->result("SELECT LAST_INSERT_ID()");}function
explain($g,$G){return$g->query("EXPLAIN ".(min_version(5.1)?"PARTITIONS ":"").$G);}function
found_rows($S,$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Xg){return
true;}function
create_sql($R,$Ma,$Eh){global$g;$I=$g->result("SHOW CREATE TABLE ".table($R),1);if(!$Ma)$I=preg_replace('~ AUTO_INCREMENT=\d+~','',$I);return$I;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($j){return"USE ".idf_escape($j);}function
trigger_sql($R){$I="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$J)$I.="\nCREATE TRIGGER ".idf_escape($J["Trigger"])." $J[Timing] $J[Event] ON ".table($J["Table"])." FOR EACH ROW\n$J[Statement];;\n";return$I;}function
show_variables(){return
get_key_vals("SHOW VARIABLES");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
show_status(){return
get_key_vals("SHOW STATUS");}function
convert_field($o){if(preg_match("~binary~",$o["type"]))return"HEX(".idf_escape($o["field"]).")";if($o["type"]=="bit")return"BIN(".idf_escape($o["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$o["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($o["field"]).")";}function
unconvert_field($o,$I){if(preg_match("~binary~",$o["type"]))$I="UNHEX($I)";if($o["type"]=="bit")$I="CONV($I, 2, 10) + 0";if(preg_match("~geometry|point|linestring|polygon~",$o["type"]))$I=(min_version(8)?"ST_":"")."GeomFromText($I)";return$I;}function
support($Qc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(5.1)?"":"|event|partitioning".(min_version(5)?"":"|routine|trigger|view"))."~",$Qc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){global$g;return$g->result("SELECT @@max_connections");}$x="sql";$zi=array();$Dh=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(28)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(25)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(33)=>array("enum"=>65535,"set"=>64),lang(29)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(31)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),)as$y=>$X){$zi+=$X;$Dh[$y]=array_keys($X);}$Fi=array("unsigned","zerofill","unsigned zerofill");$sf=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");$ld=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");$rd=array("avg","count","count distinct","group_concat","max","min","sum");$nc=array(array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",),array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",));}define("SERVER",$_GET[DRIVER]);define("DB",$_GET["db"]);define("ME",preg_replace('~^[^?]*/([^?]*).*~','\1',$_SERVER["REQUEST_URI"]).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));$ia="4.6.3";class
Adminer{var$operators;function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($i=false){return
password_file($i);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($N){return
h($N);}function
database(){return
DB;}function
databases($bd=true){return
get_databases($bd);}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(){return
csp();}function
head(){return
true;}function
css(){$I=array();$Vc="adminer.css";if(file_exists($Vc))$I[]=$Vc;return$I;}function
loginForm(){global$fc;echo"<table cellspacing='0'>\n",$this->loginFormField('driver','<tr><th>'.lang(34).'<td>',html_select("auth[driver]",$fc,DRIVER)."\n"),$this->loginFormField('server','<tr><th>'.lang(35).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'."\n"),$this->loginFormField('username','<tr><th>'.lang(36).'<td>','<input name="auth[username]" id="username" value="'.h($_GET["username"]).'" autocapitalize="off">'.script("focus(qs('#username'));")),$this->loginFormField('password','<tr><th>'.lang(37).'<td>','<input type="password" name="auth[password]">'."\n"),$this->loginFormField('db','<tr><th>'.lang(38).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'."\n"),"</table>\n","<p><input type='submit' value='".lang(39)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(40))."\n";}function
loginFormField($C,$yd,$Y){return$yd.$Y;}function
login($xe,$F){if($F=="")return
lang(41,target_blank());return
true;}function
tableName($Kh){return
h($Kh["Name"]);}function
fieldName($o,$xf=0){return'<span title="'.h($o["full_type"]).'">'.h($o["field"]).'</span>';}function
selectLinks($Kh,$O=""){global$x,$m;echo'<p class="links">';$we=array("select"=>lang(42));if(support("table")||support("indexes"))$we["table"]=lang(43);if(support("table")){if(is_view($Kh))$we["view"]=lang(44);else$we["create"]=lang(45);}if($O!==null)$we["edit"]=lang(46);$C=$Kh["Name"];foreach($we
as$y=>$X)echo" <a href='".h(ME)."$y=".urlencode($C).($y=="edit"?$O:"")."'".bold(isset($_GET[$y])).">$X</a>";echo
doc_link(array($x=>$m->tableHelp($C)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$Jh){return
array();}function
backwardKeysPrint($Pa,$J){}function
selectQuery($G,$_h,$Oc=false){global$x,$m;$I="</p>\n";if(!$Oc&&($Zi=$m->warnings())){$t="warnings";$I=", <a href='#$t'>".lang(47)."</a>".script("qsl('a').onclick = partial(toggle, '$t');","")."$I<div id='$t' class='hidden'>\n$Zi</div>\n";}return"<p><code class='jush-$x'>".h(str_replace("\n"," ",$G))."</code> <span class='time'>(".format_time($_h).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($G)."'>".lang(10)."</a>":"").$I;}function
sqlCommandQuery($G){return
shorten_utf8(trim($G),1000);}function
rowDescription($R){return"";}function
rowDescriptions($K,$ed){return$K;}function
selectLink($X,$o){}function
selectVal($X,$_,$o,$Ef){$I=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$o["type"])&&!preg_match("~var~",$o["type"])?"<code>$X</code>":$X));if(preg_match('~blob|bytea|raw|file~',$o["type"])&&!is_utf8($X))$I="<i>".lang(48,strlen($Ef))."</i>";if(preg_match('~json~',$o["type"]))$I="<code class='jush-js'>$I</code>";return($_?"<a href='".h($_)."'".(is_url($_)?target_blank():"").">$I</a>":$I);}function
editVal($X,$o){return$X;}function
tableStructurePrint($p){echo"<table cellspacing='0' class='nowrap'>\n","<thead><tr><th>".lang(49)."<td>".lang(50).(support("comment")?"<td>".lang(51):"")."</thead>\n";foreach($p
as$o){echo"<tr".odd()."><th>".h($o["field"]),"<td><span title='".h($o["collation"])."'>".h($o["full_type"])."</span>",($o["null"]?" <i>NULL</i>":""),($o["auto_increment"]?" <i>".lang(52)."</i>":""),(isset($o["default"])?" <span title='".lang(53)."'>[<b>".h($o["default"])."</b>]</span>":""),(support("comment")?"<td>".h($o["comment"]):""),"\n";}echo"</table>\n";}function
tableIndexesPrint($w){echo"<table cellspacing='0'>\n";foreach($w
as$C=>$v){ksort($v["columns"]);$jg=array();foreach($v["columns"]as$y=>$X)$jg[]="<i>".h($X)."</i>".($v["lengths"][$y]?"(".$v["lengths"][$y].")":"").($v["descs"][$y]?" DESC":"");echo"<tr title='".h($C)."'><th>$v[type]<td>".implode(", ",$jg)."\n";}echo"</table>\n";}function
selectColumnsPrint($L,$e){global$ld,$rd;print_fieldset("select",lang(54),$L);$s=0;$L[""]=array();foreach($L
as$y=>$X){$X=$_GET["columns"][$y];$d=select_input(" name='columns[$s][col]'",$e,$X["col"],($y!==""?"selectFieldChange":"selectAddRow"));echo"<div>".($ld||$rd?"<select name='columns[$s][fun]'>".optionlist(array(-1=>"")+array_filter(array(lang(55)=>$ld,lang(56)=>$rd)),$X["fun"])."</select>".on_help("getTarget(event).value && getTarget(event).value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($y!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)."</div>\n";$s++;}echo"</div></fieldset>\n";}function
selectSearchPrint($Z,$e,$w){print_fieldset("search",lang(57),$Z);foreach($w
as$s=>$v){if($v["type"]=="FULLTEXT"){echo"<div>(<i>".implode("</i>, <i>",array_map('h',$v["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$s]' value='".h($_GET["fulltext"][$s])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$s]",1,isset($_GET["boolean"][$s]),"BOOL"),"</div>\n";}}$bb="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$s=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators))){echo"<div>".select_input(" name='where[$s][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(58).")"),html_select("where[$s][op]",$this->operators,$X["op"],$bb),"<input type='search' name='where[$s][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $bb }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}}echo"</div></fieldset>\n";}function
selectOrderPrint($xf,$e,$w){print_fieldset("sort",lang(59),$xf);$s=0;foreach((array)$_GET["order"]as$y=>$X){if($X!=""){echo"<div>".select_input(" name='order[$s]'",$e,$X,"selectFieldChange"),checkbox("desc[$s]",1,isset($_GET["desc"][$y]),lang(60))."</div>\n";$s++;}}echo"<div>".select_input(" name='order[$s]'",$e,"","selectAddRow"),checkbox("desc[$s]",1,false,lang(60))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($z){echo"<fieldset><legend>".lang(61)."</legend><div>";echo"<input type='number' name='limit' class='size' value='".h($z)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($Zh){if($Zh!==null){echo"<fieldset><legend>".lang(62)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($Zh)."'>","</div></fieldset>\n";}}function
selectActionPrint($w){echo"<fieldset><legend>".lang(63)."</legend><div>","<input type='submit' value='".lang(54)."'>"," <span id='noindex' title='".lang(64)."'></span>","<script".nonce().">\n","var indexColumns = ";$e=array();foreach($w
as$v){$Lb=reset($v["columns"]);if($v["type"]!="FULLTEXT"&&$Lb)$e[$Lb]=1;}$e[""]=1;foreach($e
as$y=>$X)json_row($y);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint($sc,$e){}function
selectColumnsProcess($e,$w){global$ld,$rd;$L=array();$od=array();foreach((array)$_GET["columns"]as$y=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],$ld)||in_array($X["fun"],$rd)))){$L[$y]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],$rd))$od[]=$L[$y];}}return
array($L,$od);}function
selectSearchProcess($p,$w){global$g,$m;$I=array();foreach($w
as$s=>$v){if($v["type"]=="FULLTEXT"&&$_GET["fulltext"][$s]!="")$I[]="MATCH (".implode(", ",array_map('idf_escape',$v["columns"])).") AGAINST (".q($_GET["fulltext"][$s]).(isset($_GET["boolean"][$s])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$y=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators)){$fg="";$xb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Gd=process_length($X["val"]);$xb.=" ".($Gd!=""?$Gd:"(NULL)");}elseif($X["op"]=="SQL")$xb=" $X[val]";elseif($X["op"]=="LIKE %%")$xb=" LIKE ".$this->processInput($p[$X["col"]],"%$X[val]%");elseif($X["op"]=="ILIKE %%")$xb=" ILIKE ".$this->processInput($p[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$fg="$X[op](".q($X["val"]).", ";$xb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$xb.=" ".$this->processInput($p[$X["col"]],$X["val"]);if($X["col"]!="")$I[]=$fg.$m->convertSearch(idf_escape($X["col"]),$X,$p[$X["col"]]).$xb;else{$sb=array();foreach($p
as$C=>$o){if((preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$o["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$o["type"])))$sb[]=$fg.$m->convertSearch(idf_escape($C),$X,$o).$xb;}$I[]=($sb?"(".implode(" OR ",$sb).")":"1 = 0");}}}return$I;}function
selectOrderProcess($p,$w){$I=array();foreach((array)$_GET["order"]as$y=>$X){if($X!="")$I[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$y])?" DESC":"");}return$I;}function
selectLimitProcess(){return(isset($_GET["limit"])?$_GET["limit"]:"50");}function
selectLengthProcess(){return(isset($_GET["text_length"])?$_GET["text_length"]:"100");}function
selectEmailProcess($Z,$ed){return
false;}function
selectQueryBuild($L,$Z,$od,$xf,$z,$E){return"";}function
messageQuery($G,$ai,$Oc=false){global$x,$m;restart_session();$zd=&get_session("queries");if(!$zd[$_GET["db"]])$zd[$_GET["db"]]=array();if(strlen($G)>1e6)$G=preg_replace('~[\x80-\xFF]+$~','',substr($G,0,1e6))."\n...";$zd[$_GET["db"]][]=array($G,time(),$ai);$xh="sql-".count($zd[$_GET["db"]]);$I="<a href='#$xh' class='toggle'>".lang(65)."</a>\n";if(!$Oc&&($Zi=$m->warnings())){$t="warnings-".count($zd[$_GET["db"]]);$I="<a href='#$t' class='toggle'>".lang(47)."</a>, $I<div id='$t' class='hidden'>\n$Zi</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $I<div id='$xh' class='hidden'><pre><code class='jush-$x'>".shorten_utf8($G,1000)."</code></pre>".($ai?" <span class='time'>($ai)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($zd[$_GET["db"]])-1)).'">'.lang(10).'</a>':'').'</div>';}function
editFunctions($o){global$nc;$I=($o["null"]?"NULL/":"");foreach($nc
as$y=>$ld){if(!$y||(!isset($_GET["call"])&&(isset($_GET["select"])||where($_GET)))){foreach($ld
as$Xf=>$X){if(!$Xf||preg_match("~$Xf~",$o["type"]))$I.="/$X";}if($y&&!preg_match('~set|blob|bytea|raw|file~',$o["type"]))$I.="/SQL";}}if($o["auto_increment"]&&!isset($_GET["select"])&&!where($_GET))$I=lang(52);return
explode("/",$I);}function
editInput($R,$o,$Ka,$Y){if($o["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$Ka value='-1' checked><i>".lang(8)."</i></label> ":"").($o["null"]?"<label><input type='radio'$Ka value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$Ka,$o,$Y,0);return"";}function
editHint($R,$o,$Y){return"";}function
processInput($o,$Y,$r=""){if($r=="SQL")return$Y;$C=$o["field"];$I=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$r))$I="$r()";elseif(preg_match('~^current_(date|timestamp)$~',$r))$I=$r;elseif(preg_match('~^([+-]|\|\|)$~',$r))$I=idf_escape($C)." $r $I";elseif(preg_match('~^[+-] interval$~',$r))$I=idf_escape($C)." $r ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$I);elseif(preg_match('~^(addtime|subtime|concat)$~',$r))$I="$r(".idf_escape($C).", $I)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$r))$I="$r($I)";return
unconvert_field($o,$I);}function
dumpOutput(){$I=array('text'=>lang(66),'file'=>lang(67));if(function_exists('gzencode'))$I['gz']='gzip';return$I;}function
dumpFormat(){return
array('sql'=>'SQL','csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($l){}function
dumpTable($R,$Eh,$Zd=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($Eh)dump_csv(array_keys(fields($R)));}else{if($Zd==2){$p=array();foreach(fields($R)as$C=>$o)$p[]=idf_escape($C)." $o[full_type]";$i="CREATE TABLE ".table($R)." (".implode(", ",$p).")";}else$i=create_sql($R,$_POST["auto_increment"],$Eh);set_utf8mb4($i);if($Eh&&$i){if($Eh=="DROP+CREATE"||$Zd==1)echo"DROP ".($Zd==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($Zd==1)$i=remove_definer($i);echo"$i;\n\n";}}}function
dumpData($R,$Eh,$G){global$g,$x;$Ee=($x=="sqlite"?0:1048576);if($Eh){if($_POST["format"]=="sql"){if($Eh=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$p=fields($R);}$H=$g->query($G,1);if($H){$Sd="";$Ya="";$ge=array();$Gh="";$Rc=($R!=''?'fetch_assoc':'fetch_row');while($J=$H->$Rc()){if(!$ge){$Ri=array();foreach($J
as$X){$o=$H->fetch_field();$ge[]=$o->name;$y=idf_escape($o->name);$Ri[]="$y = VALUES($y)";}$Gh=($Eh=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$Ri):"").";\n";}if($_POST["format"]!="sql"){if($Eh=="table"){dump_csv($ge);$Eh="INSERT";}dump_csv($J);}else{if(!$Sd)$Sd="INSERT INTO ".table($R)." (".implode(", ",array_map('idf_escape',$ge)).") VALUES";foreach($J
as$y=>$X){$o=$p[$y];$J[$y]=($X!==null?unconvert_field($o,preg_match(number_type(),$o["type"])&&$X!=''?$X:q(($X===false?0:$X))):"NULL");}$Vg=($Ee?"\n":" ")."(".implode(",\t",$J).")";if(!$Ya)$Ya=$Sd.$Vg;elseif(strlen($Ya)+4+strlen($Vg)+strlen($Gh)<$Ee)$Ya.=",$Vg";else{echo$Ya.$Gh;$Ya=$Sd.$Vg;}}}if($Ya)echo$Ya.$Gh;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",$g->error)."\n";}}function
dumpFilename($Dd){return
friendly_url($Dd!=""?$Dd:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($Dd,$Te=false){$Hf=$_POST["output"];$Jc=(preg_match('~sql~',$_POST["format"])?"sql":($Te?"tar":"csv"));header("Content-Type: ".($Hf=="gz"?"application/x-gzip":($Jc=="tar"?"application/x-tar":($Jc=="sql"||$Hf!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($Hf=="gz")ob_start('ob_gzencode',1e6);return$Jc;}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(68)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(69):lang(70))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(71)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(72)."</a>\n":"");return
true;}function
navigation($Se){global$ia,$x,$fc,$g;echo'<h1>
',$this->name(),' <span class="version">',$ia,'</span>
<a href="https://www.adminer.org/#download"',target_blank(),' id="version">',(version_compare($ia,$_COOKIE["adminer_version"])<0?h($_COOKIE["adminer_version"]):""),'</a>
</h1>
';if($Se=="auth"){$Xc=true;foreach((array)$_SESSION["pwds"]as$Ti=>$jh){foreach($jh
as$N=>$Oi){foreach($Oi
as$V=>$F){if($F!==null){if($Xc){echo"<p id='logins'>".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");$Xc=false;}$Rb=$_SESSION["db"][$Ti][$N][$V];foreach(($Rb?array_keys($Rb):array(""))as$l)echo"<a href='".h(auth_url($Ti,$N,$V,$l))."'>($fc[$Ti]) ".h($V.($N!=""?"@".$this->serverName($N):"").($l!=""?" - $l":""))."</a><br>\n";}}}}}else{if($_GET["ns"]!==""&&!$Se&&DB!=""){$g->select_db(DB);$T=table_status('',true);}echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=4.6.3");if(support("sql")){echo'<script',nonce(),'>
';if($T){$we=array();foreach($T
as$R=>$U)$we[]=preg_quote($R,'/');echo"var jushLinks = { $x: [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$we).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.$x;\n";}$ih=$g->server_info;echo'bodyLoad(\'',(is_object($g)?preg_replace('~^(\d\.?\d).*~s','\1',$ih):""),'\'',(preg_match('~MariaDB~',$ih)?", true":""),');
</script>
';}$this->databasesPrint($Se);if(DB==""||!$Se){echo"<p class='links'>".(support("sql")?"<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(65)."</a>\n<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(73)."</a>\n":"")."";if(support("dump"))echo"<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(74)."</a>\n";}if($_GET["ns"]!==""&&!$Se&&DB!=""){echo'<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(75)."</a>\n";if(!$T)echo"<p class='message'>".lang(9)."\n";else$this->tablesPrint($T);}}}function
databasesPrint($Se){global$b,$g;$k=$this->databases();if($k&&!in_array(DB,$k))array_unshift($k,DB);echo'<form action="">
<p id="dbs">
';hidden_fields_get();$Pb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<span title='".lang(76)."'>".lang(77)."</span>: ".($k?"<select name='db'>".optionlist(array(""=>"")+$k,DB)."</select>$Pb":"<input name='db' value='".h(DB)."' autocapitalize='off'>\n"),"<input type='submit' value='".lang(20)."'".($k?" class='hidden'":"").">\n";if($Se!="db"&&DB!=""&&$g->select_db(DB)){if(support("scheme")){echo"<br>".lang(78).": <select name='ns'>".optionlist(array(""=>"")+$b->schemas(),$_GET["ns"])."</select>$Pb";if($_GET["ns"]!="")set_schema($_GET["ns"]);}}foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo"<input type='hidden' name='$X' value=''>";break;}}echo"</p></form>\n";}function
tablesPrint($T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$P){$C=$this->tableName($P);if($C!=""){echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select").">".lang(79)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"])),(is_view($P)?"view":"structure"))." title='".lang(43)."'>$C</a>":"<span>$C</span>")."\n";}}echo"</ul>\n";}}$b=(function_exists('adminer_object')?adminer_object():new
Adminer);if($b->operators===null)$b->operators=$sf;function
page_header($di,$n="",$Xa=array(),$ei=""){global$ca,$ia,$b,$fc,$x;page_headers();if(is_ajax()&&$n){page_messages($n);exit;}$fi=$di.($ei!=""?": $ei":"");$gi=strip_tags($fi.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".$b->name());echo'<!DOCTYPE html>
<html lang="',$ca,'" dir="',lang(80),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<title>',$gi,'</title>
<link rel="stylesheet" type="text/css" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=4.6.3"),'">
',script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=4.6.3");if($b->head()){echo'<link rel="shortcut icon" type="image/x-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.6.3"),'">
<link rel="apple-touch-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.6.3"),'">
';foreach($b->css()as$Jb){echo'<link rel="stylesheet" type="text/css" href="',h($Jb),'">
';}}echo'
<body class="',lang(80),' nojs">
';$Vc=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($Vc)&&filemtime($Vc)+86400>time()){$Ui=unserialize(file_get_contents($Vc));$qg="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($Ui["version"],base64_decode($Ui["signature"]),$qg)==1)$_COOKIE["adminer_version"]=$Ui["version"];}echo'<script',nonce(),'>
mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick',(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '$ia', '".js_escape(ME)."', '".get_token()."')");?>});
document.body.className = document.body.className.replace(/ nojs/, ' js');
var offlineMessage = '<?php echo
js_escape(lang(81)),'\';
var thousandsSeparator = \'',js_escape(lang(5)),'\';
</script>

<div id="help" class="jush-',$x,' jsonly hidden"></div>
',script("mixin(qs('#help'), {onmouseover: function () { helpOpen = 1; }, onmouseout: helpMouseout});"),'
<div id="content">
';if($Xa!==null){$_=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($_?$_:".").'">'.$fc[DRIVER].'</a> &raquo; ';$_=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$N=$b->serverName(SERVER);$N=($N!=""?$N:lang(35));if($Xa===false)echo"$N\n";else{echo"<a href='".($_?h($_):".")."' accesskey='1' title='Alt+Shift+1'>$N</a> &raquo; ";if($_GET["ns"]!=""||(DB!=""&&is_array($Xa)))echo'<a href="'.h($_."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> &raquo; ';if(is_array($Xa)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> &raquo; ';foreach($Xa
as$y=>$X){$Xb=(is_array($X)?$X[1]:h($X));if($Xb!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$Xb</a> &raquo; ";}}echo"$di\n";}}echo"<h2>$fi</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($n);$k=&get_session("dbs");if(DB!=""&&$k&&!in_array(DB,$k,true))$k=null;stop_session();define("PAGE_HEADER",1);}function
page_headers(){global$b;header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach($b->csp()as$Ib){$xd=array();foreach($Ib
as$y=>$X)$xd[]="$y $X";header("Content-Security-Policy: ".implode("; ",$xd));}$b->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$cf;if(!$cf)$cf=base64_encode(rand_string());return$cf;}function
page_messages($n){$Hi=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Oe=$_SESSION["messages"][$Hi];if($Oe){echo"<div class='message'>".implode("</div>\n<div class='message'>",$Oe)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Hi]);}if($n)echo"<div class='error'>$n</div>\n";}function
page_footer($Se=""){global$b,$ki;echo'</div>

';switch_lang();if($Se!="auth"){echo'<form action="" method="post">
<p class="logout">
<input type="submit" name="logout" value="',lang(82),'" id="logout">
<input type="hidden" name="token" value="',$ki,'">
</p>
</form>
';}echo'<div id="menu">
';$b->navigation($Se);echo'</div>
',script("setupSubmitHighlight(document);");}function
int32($Ve){while($Ve>=2147483648)$Ve-=4294967296;while($Ve<=-2147483649)$Ve+=4294967296;return(int)$Ve;}function
long2str($W,$Yi){$Vg='';foreach($W
as$X)$Vg.=pack('V',$X);if($Yi)return
substr($Vg,0,end($W));return$Vg;}function
str2long($Vg,$Yi){$W=array_values(unpack('V*',str_pad($Vg,4*ceil(strlen($Vg)/4),"\0")));if($Yi)$W[]=strlen($Vg);return$W;}function
xxtea_mx($lj,$kj,$Hh,$ce){return
int32((($lj>>5&0x7FFFFFF)^$kj<<2)+(($kj>>3&0x1FFFFFFF)^$lj<<4))^int32(($Hh^$kj)+($ce^$lj));}function
encrypt_string($Ch,$y){if($Ch=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Ch,true);$Ve=count($W)-1;$lj=$W[$Ve];$kj=$W[0];$rg=floor(6+52/($Ve+1));$Hh=0;while($rg-->0){$Hh=int32($Hh+0x9E3779B9);$mc=$Hh>>2&3;for($If=0;$If<$Ve;$If++){$kj=$W[$If+1];$Ue=xxtea_mx($lj,$kj,$Hh,$y[$If&3^$mc]);$lj=int32($W[$If]+$Ue);$W[$If]=$lj;}$kj=$W[0];$Ue=xxtea_mx($lj,$kj,$Hh,$y[$If&3^$mc]);$lj=int32($W[$Ve]+$Ue);$W[$Ve]=$lj;}return
long2str($W,false);}function
decrypt_string($Ch,$y){if($Ch=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Ch,false);$Ve=count($W)-1;$lj=$W[$Ve];$kj=$W[0];$rg=floor(6+52/($Ve+1));$Hh=int32($rg*0x9E3779B9);while($Hh){$mc=$Hh>>2&3;for($If=$Ve;$If>0;$If--){$lj=$W[$If-1];$Ue=xxtea_mx($lj,$kj,$Hh,$y[$If&3^$mc]);$kj=int32($W[$If]-$Ue);$W[$If]=$kj;}$lj=$W[$Ve];$Ue=xxtea_mx($lj,$kj,$Hh,$y[$If&3^$mc]);$kj=int32($W[0]-$Ue);$W[0]=$kj;$Hh=int32($Hh-0x9E3779B9);}return
long2str($W,true);}$g='';$wd=$_SESSION["token"];if(!$wd)$_SESSION["token"]=rand(1,1e6);$ki=get_token();$Yf=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$Yf[$y]=$X;}}function
add_invalid_login(){global$b;$jd=file_open_lock(get_temp_dir()."/adminer.invalid");if(!$jd)return;$Vd=unserialize(stream_get_contents($jd));$ai=time();if($Vd){foreach($Vd
as$Wd=>$X){if($X[0]<$ai)unset($Vd[$Wd]);}}$Ud=&$Vd[$b->bruteForceKey()];if(!$Ud)$Ud=array($ai+30*60,0);$Ud[1]++;file_write_unlock($jd,serialize($Vd));}function
check_invalid_login(){global$b;$Vd=unserialize(@file_get_contents(get_temp_dir()."/adminer.invalid"));$Ud=$Vd[$b->bruteForceKey()];$bf=($Ud[1]>29?$Ud[0]-time():0);if($bf>0)auth_error(lang(83,ceil($bf/60)));}$La=$_POST["auth"];if($La){session_regenerate_id();$Ti=$La["driver"];$N=$La["server"];$V=$La["username"];$F=(string)$La["password"];$l=$La["db"];set_password($Ti,$N,$V,$F);$_SESSION["db"][$Ti][$N][$V][$l]=true;if($La["permanent"]){$y=base64_encode($Ti)."-".base64_encode($N)."-".base64_encode($V)."-".base64_encode($l);$kg=$b->permanentLogin(true);$Yf[$y]="$y:".base64_encode($kg?encrypt_string($F,$kg):"");cookie("adminer_permanent",implode(" ",$Yf));}if(count($_POST)==1||DRIVER!=$Ti||SERVER!=$N||$_GET["username"]!==$V||DB!=$l)redirect(auth_url($Ti,$N,$V,$l));}elseif($_POST["logout"]){if($wd&&!verify_token()){page_header(lang(82),lang(84));page_footer("db");exit;}else{foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent();redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(85).' '.lang(86,'https://sourceforge.net/donate/index.php?group_id=264133'));}}elseif($Yf&&!$_SESSION["pwds"]){session_regenerate_id();$kg=$b->permanentLogin();foreach($Yf
as$y=>$X){list(,$jb)=explode(":",$X);list($Ti,$N,$V,$l)=array_map('base64_decode',explode("-",$y));set_password($Ti,$N,$V,decrypt_string(base64_decode($jb),$kg));$_SESSION["db"][$Ti][$N][$V][$l]=true;}}function
unset_permanent(){global$Yf;foreach($Yf
as$y=>$X){list($Ti,$N,$V,$l)=array_map('base64_decode',explode("-",$y));if($Ti==DRIVER&&$N==SERVER&&$V==$_GET["username"]&&$l==DB)unset($Yf[$y]);}cookie("adminer_permanent",implode(" ",$Yf));}function
auth_error($n){global$b,$wd;$kh=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$kh]||$_GET[$kh])&&!$wd)$n=lang(87);else{restart_session();add_invalid_login();$F=get_password();if($F!==null){if($F===false)$n.='<br>'.lang(88,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent();}}if(!$_COOKIE[$kh]&&$_GET[$kh]&&ini_bool("session.use_only_cookies"))$n=lang(89);$Lf=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?$_COOKIE["adminer_key"]:rand_string()),$Lf["lifetime"]);page_header(lang(39),$n,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(90)."\n";echo"</div>\n";$b->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists("Min_DB")){unset($_SESSION["pwds"][DRIVER]);unset_permanent();page_header(lang(91),lang(92,implode(", ",$eg)),false);page_footer("auth");exit;}stop_session(true);if(isset($_GET["username"])){list($Bd,$ag)=explode(":",SERVER,2);if(is_numeric($ag)&&$ag<1024)auth_error(lang(93));check_invalid_login();$g=connect();$m=new
Min_Driver($g);}$xe=null;if(!is_object($g)||($xe=$b->login($_GET["username"],get_password()))!==true)auth_error((is_string($g)?h($g):(is_string($xe)?$xe:lang(94))));if($La&&$_POST["token"])$_POST["token"]=$ki;$n='';if($_POST){if(!verify_token()){$Pd="max_input_vars";$Ie=ini_get($Pd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$Ie||$X<$Ie)){$Pd=$y;$Ie=$X;}}}$n=(!$_POST["token"]&&$Ie?lang(95,"'$Pd'"):lang(84).' '.lang(96));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$n=lang(97,"'post_max_size'");if(isset($_GET["sql"]))$n.=' '.lang(98);}function
select($H,$h=null,$_f=array(),$z=0){global$x;$we=array();$w=array();$e=array();$Ua=array();$zi=array();$I=array();odd('');for($s=0;(!$z||$s<$z)&&($J=$H->fetch_row());$s++){if(!$s){echo"<table cellspacing='0' class='nowrap'>\n","<thead><tr>";for($be=0;$be<count($J);$be++){$o=$H->fetch_field();$C=$o->name;$zf=$o->orgtable;$yf=$o->orgname;$I[$o->table]=$zf;if($_f&&$x=="sql")$we[$be]=($C=="table"?"table=":($C=="possible_keys"?"indexes=":null));elseif($zf!=""){if(!isset($w[$zf])){$w[$zf]=array();foreach(indexes($zf,$h)as$v){if($v["type"]=="PRIMARY"){$w[$zf]=array_flip($v["columns"]);break;}}$e[$zf]=$w[$zf];}if(isset($e[$zf][$yf])){unset($e[$zf][$yf]);$w[$zf][$yf]=$be;$we[$be]=$zf;}}if($o->charsetnr==63)$Ua[$be]=true;$zi[$be]=$o->type;echo"<th".($zf!=""||$o->name!=$yf?" title='".h(($zf!=""?"$zf.":"").$yf)."'":"").">".h($C).($_f?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($C),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr".odd().">";foreach($J
as$y=>$X){if($X===null)$X="<i>NULL</i>";elseif($Ua[$y]&&!is_utf8($X))$X="<i>".lang(48,strlen($X))."</i>";else{$X=h($X);if($zi[$y]==254)$X="<code>$X</code>";}if(isset($we[$y])&&!$e[$we[$y]]){if($_f&&$x=="sql"){$R=$J[array_search("table=",$we)];$_=$we[$y].urlencode($_f[$R]!=""?$_f[$R]:$R);}else{$_="edit=".urlencode($we[$y]);foreach($w[$we[$y]]as$nb=>$be)$_.="&where".urlencode("[".bracket_escape($nb)."]")."=".urlencode($J[$be]);}$X="<a href='".h(ME.$_)."'>$X</a>";}echo"<td>$X";}}echo($s?"</table>":"<p class='message'>".lang(12))."\n";return$I;}function
referencable_primary($eh){$I=array();foreach(table_status('',true)as$Lh=>$R){if($Lh!=$eh&&fk_support($R)){foreach(fields($Lh)as$o){if($o["primary"]){if($I[$Lh]){unset($I[$Lh]);break;}$I[$Lh]=$o;}}}}return$I;}function
textarea($C,$Y,$K=10,$sb=80){global$x;echo"<textarea name='$C' rows='$K' cols='$sb' class='sqlarea jush-$x' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
edit_type($y,$o,$qb,$fd=array(),$Mc=array()){global$Dh,$zi,$Fi,$nf;$U=$o["type"];echo'<td><select name="',h($y),'[type]" class="type" aria-labelledby="label-type">';if($U&&!isset($zi[$U])&&!isset($fd[$U])&&!in_array($U,$Mc))$Mc[]=$U;if($fd)$Dh[lang(99)]=$fd;echo
optionlist(array_merge($Mc,$Dh),$U),'</select>
',on_help("getTarget(event).value",1),script("mixin(qsl('select'), {onfocus: function () { lastType = selectValue(this); }, onchange: editingTypeChange});",""),'<td><input name="',h($y),'[length]" value="',h($o["length"]),'" size="3"',(!$o["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"");echo' aria-labelledby="label-length">',script("mixin(qsl('input'), {onfocus: editingLengthFocus, oninput: editingLengthChange});",""),'<td class="options">',"<select name='".h($y)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'").'><option value="">('.lang(100).')'.optionlist($qb,$o["collation"]).'</select>',($Fi?"<select name='".h($y)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist($Fi,$o["unsigned"]).'</select>':''),(isset($o['on_update'])?"<select name='".h($y)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(101).")","CURRENT_TIMESTAMP"),$o["on_update"]).'</select>':''),($fd?"<select name='".h($y)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(102).")".optionlist(explode("|",$nf),$o["on_delete"])."</select> ":" ");}function
process_length($te){global$xc;return(preg_match("~^\\s*\\(?\\s*$xc(?:\\s*,\\s*$xc)*+\\s*\\)?\\s*\$~",$te)&&preg_match_all("~$xc~",$te,$Ce)?"(".implode(",",$Ce[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$te)));}function
process_type($o,$ob="COLLATE"){global$Fi;return" $o[type]".process_length($o["length"]).(preg_match(number_type(),$o["type"])&&in_array($o["unsigned"],$Fi)?" $o[unsigned]":"").(preg_match('~char|text|enum|set~',$o["type"])&&$o["collation"]?" $ob ".q($o["collation"]):"");}function
process_field($o,$xi){return
array(idf_escape(trim($o["field"])),process_type($xi),($o["null"]?" NULL":" NOT NULL"),default_value($o),(preg_match('~timestamp|datetime~',$o["type"])&&$o["on_update"]?" ON UPDATE $o[on_update]":""),(support("comment")&&$o["comment"]!=""?" COMMENT ".q($o["comment"]):""),($o["auto_increment"]?auto_increment():null),);}function
default_value($o){$Tb=$o["default"];return($Tb===null?"":" DEFAULT ".(preg_match('~char|binary|text|enum|set~',$o["type"])||preg_match('~^(?![a-z])~i',$Tb)?q($Tb):$Tb));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$y=>$X){if(preg_match("~$y|$X~",$U))return" class='$y'";}}function
edit_fields($p,$qb,$U="TABLE",$fd=array(),$wb=false){global$Qd;$p=array_values($p);echo'<thead><tr>
';if($U=="PROCEDURE"){echo'<td>';}echo'<th id="label-name">',($U=="TABLE"?lang(103):lang(104)),'<td id="label-type">',lang(50),'<textarea id="enum-edit" rows="4" cols="12" wrap="off" style="display: none;"></textarea>',script("qs('#enum-edit').onblur = editingLengthBlur;"),'<td id="label-length">',lang(105),'<td>',lang(106);if($U=="TABLE"){echo'<td id="label-null">NULL
<td><input type="radio" name="auto_increment_col" value=""><acronym id="label-ai" title="',lang(52),'">AI</acronym>',doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype.html#DATATYPE-SERIAL",'mssql'=>"ms186775.aspx",)),'<td id="label-default">',lang(53),(support("comment")?"<td id='label-comment'".($wb?"":" class='hidden'").">".lang(51):"");}echo'<td>',"<input type='image' class='icon' name='add[".(support("move_col")?0:count($p))."]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.6.3")."' alt='+' title='".lang(107)."'>".script("row_count = ".count($p).";"),'</thead>
<tbody>
',script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($p
as$s=>$o){$s++;$Af=$o[($_POST?"orig":"field")];$bc=(isset($_POST["add"][$s-1])||(isset($o["field"])&&!$_POST["drop_col"][$s]))&&(support("drop_col")||$Af=="");echo'<tr',($bc?"":" style='display: none;'"),'>
',($U=="PROCEDURE"?"<td>".html_select("fields[$s][inout]",explode("|",$Qd),$o["inout"]):""),'<th>';if($bc){echo'<input name="fields[',$s,'][field]" value="',h($o["field"]),'" maxlength="64" autocapitalize="off" aria-labelledby="label-name">',script("qsl('input').oninput = function () { editingNameChange.call(this);".($o["field"]!=""||count($p)>1?"":" editingAddRow.call(this);")." };","");}echo'<input type="hidden" name="fields[',$s,'][orig]" value="',h($Af),'">
';edit_type("fields[$s]",$o,$qb,$fd);if($U=="TABLE"){echo'<td>',checkbox("fields[$s][null]",1,$o["null"],"","","block","label-null"),'<td><label class="block"><input type="radio" name="auto_increment_col" value="',$s,'"';if($o["auto_increment"]){echo' checked';}echo' aria-labelledby="label-ai"></label><td>',checkbox("fields[$s][has_default]",1,$o["has_default"],"","","","label-default"),'<input name="fields[',$s,'][default]" value="',h($o["default"]),'" aria-labelledby="label-default">',(support("comment")?"<td".($wb?"":" class='hidden'")."><input name='fields[$s][comment]' value='".h($o["comment"])."' maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");}echo"<td>",(support("move_col")?"<input type='image' class='icon' name='add[$s]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.6.3")."' alt='+' title='".lang(107)."'> "."<input type='image' class='icon' name='up[$s]' src='".h(preg_replace("~\\?.*~","",ME)."?file=up.gif&version=4.6.3")."' alt='↑' title='".lang(108)."'> "."<input type='image' class='icon' name='down[$s]' src='".h(preg_replace("~\\?.*~","",ME)."?file=down.gif&version=4.6.3")."' alt='↓' title='".lang(109)."'> ":""),($Af==""||support("drop_col")?"<input type='image' class='icon' name='drop_col[$s]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.6.3")."' alt='x' title='".lang(110)."'>":"");}}function
process_fields(&$p){$D=0;if($_POST["up"]){$ne=0;foreach($p
as$y=>$o){if(key($_POST["up"])==$y){unset($p[$y]);array_splice($p,$ne,0,array($o));break;}if(isset($o["field"]))$ne=$D;$D++;}}elseif($_POST["down"]){$hd=false;foreach($p
as$y=>$o){if(isset($o["field"])&&$hd){unset($p[key($_POST["down"])]);array_splice($p,$D,0,array($hd));break;}if(key($_POST["down"])==$y)$hd=$o;$D++;}}elseif($_POST["add"]){$p=array_values($p);array_splice($p,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum($B){return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($B[0][0].$B[0][0],$B[0][0],substr($B[0],1,-1))),'\\'))."'";}function
grant($md,$mg,$e,$mf){if(!$mg)return
true;if($mg==array("ALL PRIVILEGES","GRANT OPTION"))return($md=="GRANT"?queries("$md ALL PRIVILEGES$mf WITH GRANT OPTION"):queries("$md ALL PRIVILEGES$mf")&&queries("$md GRANT OPTION$mf"));return
queries("$md ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$mg).$e).$mf);}function
drop_create($gc,$i,$hc,$Xh,$jc,$A,$Ne,$Le,$Me,$jf,$Ye){if($_POST["drop"])query_redirect($gc,$A,$Ne);elseif($jf=="")query_redirect($i,$A,$Me);elseif($jf!=$Ye){$Gb=queries($i);queries_redirect($A,$Le,$Gb&&queries($gc));if($Gb)queries($hc);}else
queries_redirect($A,$Le,queries($Xh)&&queries($jc)&&queries($gc)&&queries($i));}function
create_trigger($mf,$J){global$x;$ci=" $J[Timing] $J[Event]".($J["Event"]=="UPDATE OF"?" ".idf_escape($J["Of"]):"");return"CREATE TRIGGER ".idf_escape($J["Trigger"]).($x=="mssql"?$mf.$ci:$ci.$mf).rtrim(" $J[Type]\n$J[Statement]",";").";";}function
create_routine($Rg,$J){global$Qd,$x;$O=array();$p=(array)$J["fields"];ksort($p);foreach($p
as$o){if($o["field"]!="")$O[]=(preg_match("~^($Qd)\$~",$o["inout"])?"$o[inout] ":"").idf_escape($o["field"]).process_type($o,"CHARACTER SET");}$Ub=rtrim("\n$J[definition]",";");return"CREATE $Rg ".idf_escape(trim($J["name"]))." (".implode(", ",$O).")".(isset($_GET["function"])?" RETURNS".process_type($J["returns"],"CHARACTER SET"):"").($J["language"]?" LANGUAGE $J[language]":"").($x=="pgsql"?" AS ".q($Ub):"$Ub;");}function
remove_definer($G){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$G);}function
format_foreign_key($q){global$nf;return" FOREIGN KEY (".implode(", ",array_map('idf_escape',$q["source"])).") REFERENCES ".table($q["table"])." (".implode(", ",array_map('idf_escape',$q["target"])).")".(preg_match("~^($nf)\$~",$q["on_delete"])?" ON DELETE $q[on_delete]":"").(preg_match("~^($nf)\$~",$q["on_update"])?" ON UPDATE $q[on_update]":"");}function
tar_file($Vc,$hi){$I=pack("a100a8a8a8a12a12",$Vc,644,0,0,decoct($hi->size),decoct(time()));$hb=8*32;for($s=0;$s<strlen($I);$s++)$hb+=ord($I[$s]);$I.=sprintf("%06o",$hb)."\0 ";echo$I,str_repeat("\0",512-strlen($I));$hi->send();echo
str_repeat("\0",511-($hi->size+511)%512);}function
ini_bytes($Pd){$X=ini_get($Pd);switch(strtolower(substr($X,-1))){case'g':$X*=1024;case'm':$X*=1024;case'k':$X*=1024;}return$X;}function
doc_link($Wf,$Yh="<sup>?</sup>"){global$x,$g;$ih=$g->server_info;$Ui=preg_replace('~^(\d\.?\d).*~s','\1',$ih);$Ki=array('sql'=>"https://dev.mysql.com/doc/refman/$Ui/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/$Ui/static/",'mssql'=>"https://msdn.microsoft.com/library/",'oracle'=>"https://download.oracle.com/docs/cd/B19306_01/server.102/b14200/",);if(preg_match('~MariaDB~',$ih)){$Ki['sql']="https://mariadb.com/kb/en/library/";$Wf['sql']=(isset($Wf['mariadb'])?$Wf['mariadb']:str_replace(".html","/",$Wf['sql']));}return($Wf[$x]?"<a href='$Ki[$x]$Wf[$x]'".target_blank().">$Yh</a>":"");}function
ob_gzencode($Q){return
gzencode($Q);}function
db_size($l){global$g;if(!$g->select_db($l))return"?";$I=0;foreach(table_status()as$S)$I+=$S["Data_length"]+$S["Index_length"];return
format_number($I);}function
set_utf8mb4($i){global$g;static$O=false;if(!$O&&preg_match('~\butf8mb4~i',$i)){$O=true;echo"SET NAMES ".charset($g).";\n\n";}}function
connect_error(){global$b,$g,$ki,$n,$fc;if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(38).": ".h(DB),lang(111),true);}else{if($_POST["db"]&&!$n)queries_redirect(substr(ME,0,-1),lang(112),drop_databases($_POST["db"]));page_header(lang(113),$n,false);echo"<p class='links'>\n";foreach(array('database'=>lang(114),'privileges'=>lang(72),'processlist'=>lang(115),'variables'=>lang(116),'status'=>lang(117),)as$y=>$X){if(support($y))echo"<a href='".h(ME)."$y='>$X</a>\n";}echo"<p>".lang(118,$fc[DRIVER],"<b>".h($g->server_info)."</b>","<b>$g->extension</b>")."\n","<p>".lang(119,"<b>".h(logged_user())."</b>")."\n";$k=$b->databases();if($k){$Yg=support("scheme");$qb=collations();echo"<form action='' method='post'>\n","<table cellspacing='0' class='checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(38)." - <a href='".h(ME)."refresh=1'>".lang(120)."</a>"."<td>".lang(121)."<td>".lang(122)."<td>".lang(123)." - <a href='".h(ME)."dbsize=1'>".lang(124)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$k=($_GET["dbsize"]?count_tables($k):array_flip($k));foreach($k
as$l=>$T){$Qg=h(ME)."db=".urlencode($l);$t=h("Db-".$l);echo"<tr".odd().">".(support("database")?"<td>".checkbox("db[]",$l,in_array($l,(array)$_POST["db"]),"","","",$t):""),"<th><a href='$Qg' id='$t'>".h($l)."</a>";$pb=h(db_collation($l,$qb));echo"<td>".(support("database")?"<a href='$Qg".($Yg?"&amp;ns=":"")."&amp;database=' title='".lang(68)."'>$pb</a>":$pb),"<td align='right'><a href='$Qg&amp;schema=' id='tables-".h($l)."' title='".lang(71)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($l)."'>".($_GET["dbsize"]?db_size($l):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(125)." <span id='selected'></span></legend><div>\n"."<input type='hidden' name='all' value=''>".script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(126)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),"<input type='hidden' name='token' value='$ki'>\n","</form>\n",script("tableCheck();");}}page_footer("db");}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?$g->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}connect_error();exit;}if(support("scheme")&&DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(78).": ".h($_GET["ns"]),lang(127),true);page_footer("ns");exit;}}$nf="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";class
TmpFile{var$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($Ab){$this->size+=strlen($Ab);fwrite($this->handler,$Ab);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}$xc="'(?:''|[^'\\\\]|\\\\.)*'";$Qd="IN|OUT|INOUT";if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$p=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$L=array(idf_escape($_GET["field"]));$H=$m->select($a,$L,array(where($_GET,$p)),$L);$J=($H?$H->fetch_row():array());echo$m->value($J[0],$p[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$p=fields($a);if(!$p)$n=error();$S=table_status1($a,true);$C=$b->tableName($S);page_header(($p&&is_view($S)?$S['Engine']=='materialized view'?lang(128):lang(129):lang(130)).": ".($C!=""?$C:h($a)),$n);$b->selectLinks($S);$vb=$S["Comment"];if($vb!="")echo"<p class='nowrap'>".lang(51).": ".h($vb)."\n";if($p)$b->tableStructurePrint($p);if(!is_view($S)){if(support("indexes")){echo"<h3 id='indexes'>".lang(131)."</h3>\n";$w=indexes($a);if($w)$b->tableIndexesPrint($w);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(132)."</a>\n";}if(fk_support($S)){echo"<h3 id='foreign-keys'>".lang(99)."</h3>\n";$fd=foreign_keys($a);if($fd){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(133)."<td>".lang(134)."<td>".lang(102)."<td>".lang(101)."<td></thead>\n";foreach($fd
as$C=>$q){echo"<tr title='".h($C)."'>","<th><i>".implode("</i>, <i>",array_map('h',$q["source"]))."</i>","<td><a href='".h($q["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($q["db"]),ME):($q["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($q["ns"]),ME):ME))."table=".urlencode($q["table"])."'>".($q["db"]!=""?"<b>".h($q["db"])."</b>.":"").($q["ns"]!=""?"<b>".h($q["ns"])."</b>.":"").h($q["table"])."</a>","(<i>".implode("</i>, <i>",array_map('h',$q["target"]))."</i>)","<td>".h($q["on_delete"])."\n","<td>".h($q["on_update"])."\n",'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($C)).'">'.lang(135).'</a>';}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(136)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(137)."</h3>\n";$wi=triggers($a);if($wi){echo"<table cellspacing='0'>\n";foreach($wi
as$y=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($y)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($y))."'>".lang(135)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(138)."</a>\n";}}elseif(isset($_GET["schema"])){page_header(lang(71),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$Nh=array();$Oh=array();$ea=($_GET["schema"]?$_GET["schema"]:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$ea,$Ce,PREG_SET_ORDER);foreach($Ce
as$s=>$B){$Nh[$B[1]]=array($B[2],$B[3]);$Oh[]="\n\t'".js_escape($B[1])."': [ $B[2], $B[3] ]";}$li=0;$Ra=-1;$Xg=array();$Cg=array();$re=array();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$bg=0;$Xg[$R]["fields"]=array();foreach(fields($R)as$C=>$o){$bg+=1.25;$o["pos"]=$bg;$Xg[$R]["fields"][$C]=$o;}$Xg[$R]["pos"]=($Nh[$R]?$Nh[$R]:array($li,0));foreach($b->foreignKeys($R)as$X){if(!$X["db"]){$pe=$Ra;if($Nh[$R][1]||$Nh[$X["table"]][1])$pe=min(floatval($Nh[$R][1]),floatval($Nh[$X["table"]][1]))-1;else$Ra-=.1;while($re[(string)$pe])$pe-=.0001;$Xg[$R]["references"][$X["table"]][(string)$pe]=array($X["source"],$X["target"]);$Cg[$X["table"]][$R][(string)$pe]=$X["target"];$re[(string)$pe]=true;}}$li=max($li,$Xg[$R]["pos"][0]+2.5+$bg);}echo'<div id="schema" style="height: ',$li,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = function () { return false; };
var tablePos = {',implode(",",$Oh)."\n",'};
var em = qs(\'#schema\').offsetHeight / ',$li,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($Xg
as$C=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($C).'"><b>'.h($C)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$o){$X='<span'.type_class($o["type"]).' title="'.h($o["full_type"].($o["null"]?" NULL":'')).'">'.h($o["field"]).'</span>';echo"<br>".($o["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$Uh=>$Dg){foreach($Dg
as$pe=>$_g){$qe=$pe-$Nh[$C][1];$s=0;foreach($_g[0]as$sh)echo"\n<div class='references' title='".h($Uh)."' id='refs$pe-".($s++)."' style='left: $qe"."em; top: ".$R["fields"][$sh]["pos"]."em; padding-top: .5em;'><div style='border-top: 1px solid Gray; width: ".(-$qe)."em;'></div></div>";}}foreach((array)$Cg[$C]as$Uh=>$Dg){foreach($Dg
as$pe=>$e){$qe=$pe-$Nh[$C][1];$s=0;foreach($e
as$Th)echo"\n<div class='references' title='".h($Uh)."' id='refd$pe-".($s++)."' style='left: $qe"."em; top: ".$R["fields"][$Th]["pos"]."em; height: 1.25em; background: url(".h(preg_replace("~\\?.*~","",ME)."?file=arrow.gif) no-repeat right center;&version=4.6.3")."'><div style='height: .5em; border-bottom: 1px solid Gray; width: ".(-$qe)."em;'></div></div>";}}echo"\n</div>\n";}foreach($Xg
as$C=>$R){foreach((array)$R["references"]as$Uh=>$Dg){foreach($Dg
as$pe=>$_g){$Re=$li;$Ge=-10;foreach($_g[0]as$y=>$sh){$cg=$R["pos"][0]+$R["fields"][$sh]["pos"];$dg=$Xg[$Uh]["pos"][0]+$Xg[$Uh]["fields"][$_g[1][$y]]["pos"];$Re=min($Re,$cg,$dg);$Ge=max($Ge,$cg,$dg);}echo"<div class='references' id='refl$pe' style='left: $pe"."em; top: $Re"."em; padding: .5em 0;'><div style='border-right: 1px solid Gray; margin-top: 1px; height: ".($Ge-$Re)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($ea)),'" id="schema-link">',lang(139),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$n){$Db="";foreach(array("output","format","db_style","routines","events","table_style","auto_increment","triggers","data_style")as$y)$Db.="&$y=".urlencode($_POST[$y]);cookie("adminer_export",substr($Db,1));$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Jc=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$Yd=preg_match('~sql~',$_POST["format"]);if($Yd){echo"-- Adminer $ia ".$fc[DRIVER]." dump\n\n";if($x=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
".($_POST["data_style"]?"SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";$g->query("SET time_zone = '+00:00';");}}$Eh=$_POST["db_style"];$k=array(DB);if(DB==""){$k=$_POST["databases"];if(is_string($k))$k=explode("\n",rtrim(str_replace("\r","",$k),"\n"));}foreach((array)$k
as$l){$b->dumpDatabase($l);if($g->select_db($l)){if($Yd&&preg_match('~CREATE~',$Eh)&&($i=$g->result("SHOW CREATE DATABASE ".idf_escape($l),1))){set_utf8mb4($i);if($Eh=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($l).";\n";echo"$i;\n";}if($Yd){if($Eh)echo
use_sql($l).";\n\n";$Gf="";if($_POST["routines"]){foreach(array("FUNCTION","PROCEDURE")as$Rg){foreach(get_rows("SHOW $Rg STATUS WHERE Db = ".q($l),null,"-- ")as$J){$i=remove_definer($g->result("SHOW CREATE $Rg ".idf_escape($J["Name"]),2));set_utf8mb4($i);$Gf.=($Eh!='DROP+CREATE'?"DROP $Rg IF EXISTS ".idf_escape($J["Name"]).";;\n":"")."$i;;\n\n";}}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$J){$i=remove_definer($g->result("SHOW CREATE EVENT ".idf_escape($J["Name"]),3));set_utf8mb4($i);$Gf.=($Eh!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($J["Name"]).";;\n":"")."$i;;\n\n";}}if($Gf)echo"DELIMITER ;;\n\n$Gf"."DELIMITER ;\n\n";}if($_POST["table_style"]||$_POST["data_style"]){$Wi=array();foreach(table_status('',true)as$C=>$S){$R=(DB==""||in_array($C,(array)$_POST["tables"]));$Mb=(DB==""||in_array($C,(array)$_POST["data"]));if($R||$Mb){if($Jc=="tar"){$hi=new
TmpFile;ob_start(array($hi,'write'),1e5);}$b->dumpTable($C,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$Wi[]=$C;elseif($Mb){$p=fields($C);$b->dumpData($C,$_POST["data_style"],"SELECT *".convert_fields($p,$p)." FROM ".table($C));}if($Yd&&$_POST["triggers"]&&$R&&($wi=trigger_sql($C)))echo"\nDELIMITER ;;\n$wi\nDELIMITER ;\n";if($Jc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$l/")."$C.csv",$hi);}elseif($Yd)echo"\n";}}foreach($Wi
as$Vi)$b->dumpTable($Vi,$_POST["table_style"],1);if($Jc=="tar")echo
pack("x512");}}}if($Yd)echo"-- ".$g->result("SELECT NOW()")."\n";exit;}page_header(lang(74),$n,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table cellspacing="0">
';$Qb=array('','USE','DROP+CREATE','CREATE');$Ph=array('','DROP+CREATE','CREATE');$Nb=array('','TRUNCATE+INSERT','INSERT');if($x=="sql")$Nb[]='INSERT+UPDATE';parse_str($_COOKIE["adminer_export"],$J);if(!$J)$J=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($J["events"])){$J["routines"]=$J["events"]=($_GET["dump"]=="");$J["triggers"]=$J["table_style"];}echo"<tr><th>".lang(140)."<td>".html_select("output",$b->dumpOutput(),$J["output"],0)."\n";echo"<tr><th>".lang(141)."<td>".html_select("format",$b->dumpFormat(),$J["format"],0)."\n";echo($x=="sqlite"?"":"<tr><th>".lang(38)."<td>".html_select('db_style',$Qb,$J["db_style"]).(support("routine")?checkbox("routines",1,$J["routines"],lang(142)):"").(support("event")?checkbox("events",1,$J["events"],lang(143)):"")),"<tr><th>".lang(122)."<td>".html_select('table_style',$Ph,$J["table_style"]).checkbox("auto_increment",1,$J["auto_increment"],lang(52)).(support("trigger")?checkbox("triggers",1,$J["triggers"],lang(137)):""),"<tr><th>".lang(144)."<td>".html_select('data_style',$Nb,$J["data_style"]),'</table>
<p><input type="submit" value="',lang(74),'">
<input type="hidden" name="token" value="',$ki,'">

<table cellspacing="0">
',script("qsl('table').onclick = dumpClick;");$gg=array();if(DB!=""){$fb=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$fb>".lang(122)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(144)."<input type='checkbox' id='check-data'$fb></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$Wi="";$Qh=tables_list();foreach($Qh
as$C=>$U){$fg=preg_replace('~_.*~','',$C);$fb=($a==""||$a==(substr($a,-1)=="%"?"$fg%":$C));$jg="<tr><td>".checkbox("tables[]",$C,$fb,$C,"","block");if($U!==null&&!preg_match('~table~i',$U))$Wi.="$jg\n";else
echo"$jg<td align='right'><label class='block'><span id='Rows-".h($C)."'></span>".checkbox("data[]",$C,$fb)."</label>\n";$gg[$fg]++;}echo$Wi;if($Qh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(38)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$k=$b->databases();if($k){foreach($k
as$l){if(!information_schema($l)){$fg=preg_replace('~_.*~','',$l);echo"<tr><td>".checkbox("databases[]",$l,$a==""||$a=="$fg%",$l,"","block")."\n";$gg[$fg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$Xc=true;foreach($gg
as$y=>$X){if($y!=""&&$X>1){echo($Xc?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$y%")."'>".h($y)."</a>";$Xc=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(72));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(145)."</a>";$H=$g->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$md=$H;if(!$H)$H=$g->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo"<input type='hidden' name='db' value='".h(DB)."'>\n",($md?"":"<input type='hidden' name='grant' value=''>\n"),"<table cellspacing='0'>\n","<thead><tr><th>".lang(36)."<th>".lang(35)."<th></thead>\n";while($J=$H->fetch_assoc())echo'<tr'.odd().'><td>'.h($J["User"])."<td>".h($J["Host"]).'<td><a href="'.h(ME.'user='.urlencode($J["User"]).'&host='.urlencode($J["Host"])).'">'.lang(10)."</a>\n";if(!$md||DB!="")echo"<tr".odd()."><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$n&&$_POST["export"]){dump_headers("sql");$b->dumpTable("","");$b->dumpData("","table",$_POST["query"]);exit;}restart_session();$_d=&get_session("queries");$zd=&$_d[DB];if(!$n&&$_POST["clear"]){$zd=array();redirect(remove_from_uri("history"));}page_header((isset($_GET["import"])?lang(73):lang(65)),$n);if(!$n&&$_POST){$jd=false;if(!isset($_GET["import"]))$G=$_POST["query"];elseif($_POST["webfile"]){$wh=$b->importServerPath();$jd=@fopen((file_exists($wh)?$wh:"compress.zlib://$wh.gz"),"rb");$G=($jd?fread($jd,1e6):false);}else$G=get_file("sql_file",true);if(is_string($G)){if(function_exists('memory_get_usage'))@ini_set("memory_limit",max(ini_bytes("memory_limit"),2*strlen($G)+memory_get_usage()+8e6));if($G!=""&&strlen($G)<1e6){$rg=$G.(preg_match("~;[ \t\r\n]*\$~",$G)?"":";");if(!$zd||reset(end($zd))!=$rg){restart_session();$zd[]=array($rg,time());set_session("queries",$_d);stop_session();}}$th="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Wb=";";$D=0;$uc=true;$h=connect();if(is_object($h)&&DB!="")$h->select_db(DB);$ub=0;$zc=array();$Nf='[\'"'.($x=="sql"?'`#':($x=="sqlite"?'`[':($x=="mssql"?'[':''))).']|/\*|-- |$'.($x=="pgsql"?'|\$[^$]*\$':'');$mi=microtime(true);parse_str($_COOKIE["adminer_export"],$ya);$lc=$b->dumpFormat();unset($lc["sql"]);while($G!=""){if(!$D&&preg_match("~^$th*+DELIMITER\\s+(\\S+)~i",$G,$B)){$Wb=$B[1];$G=substr($G,strlen($B[0]));}else{preg_match('('.preg_quote($Wb)."\\s*|$Nf)",$G,$B,PREG_OFFSET_CAPTURE,$D);list($hd,$bg)=$B[0];if(!$hd&&$jd&&!feof($jd))$G.=fread($jd,1e5);else{if(!$hd&&rtrim($G)=="")break;$D=$bg+strlen($hd);if($hd&&rtrim($hd)!=$Wb){while(preg_match('('.($hd=='/*'?'\*/':($hd=='['?']':(preg_match('~^-- |^#~',$hd)?"\n":preg_quote($hd)."|\\\\."))).'|$)s',$G,$B,PREG_OFFSET_CAPTURE,$D)){$Vg=$B[0][0];if(!$Vg&&$jd&&!feof($jd))$G.=fread($jd,1e5);else{$D=$B[0][1]+strlen($Vg);if($Vg[0]!="\\")break;}}}else{$uc=false;$rg=substr($G,0,$bg);$ub++;$jg="<pre id='sql-$ub'><code class='jush-$x'>".$b->sqlCommandQuery($rg)."</code></pre>\n";if($x=="sqlite"&&preg_match("~^$th*+ATTACH\\b~i",$rg,$B)){echo$jg,"<p class='error'>".lang(146)."\n";$zc[]=" <a href='#sql-$ub'>$ub</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$jg;ob_flush();flush();}$_h=microtime(true);if($g->multi_query($rg)&&is_object($h)&&preg_match("~^$th*+USE\\b~i",$rg))$h->query($rg);do{$H=$g->store_result();if($g->error){echo($_POST["only_errors"]?$jg:""),"<p class='error'>".lang(147).($g->errno?" ($g->errno)":"").": ".error()."\n";$zc[]=" <a href='#sql-$ub'>$ub</a>";if($_POST["error_stops"])break
2;}else{$ai=" <span class='time'>(".format_time($_h).")</span>".(strlen($rg)<1000?" <a href='".h(ME)."sql=".urlencode(trim($rg))."'>".lang(10)."</a>":"");$_a=$g->affected_rows;$Zi=($_POST["only_errors"]?"":$m->warnings());$aj="warnings-$ub";if($Zi)$ai.=", <a href='#$aj'>".lang(47)."</a>".script("qsl('a').onclick = partial(toggle, '$aj');","");$Gc=null;$Hc="explain-$ub";if(is_object($H)){$z=$_POST["limit"];$_f=select($H,$h,array(),$z);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$df=$H->num_rows;echo"<p>".($df?($z&&$df>$z?lang(148,$z):"").lang(149,$df):""),$ai;if($h&&preg_match("~^($th|\\()*+SELECT\\b~i",$rg)&&($Gc=explain($h,$rg)))echo", <a href='#$Hc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Hc');","");$t="export-$ub";echo", <a href='#$t'>".lang(74)."</a>".script("qsl('a').onclick = partial(toggle, '$t');","")."<span id='$t' class='hidden'>: ".html_select("output",$b->dumpOutput(),$ya["output"])." ".html_select("format",$lc,$ya["format"])."<input type='hidden' name='query' value='".h($rg)."'>"." <input type='submit' name='export' value='".lang(74)."'><input type='hidden' name='token' value='$ki'></span>\n"."</form>\n";}}else{if(preg_match("~^$th*+(CREATE|DROP|ALTER)$th++(DATABASE|SCHEMA)\\b~i",$rg)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h($g->info)."'>".lang(150,$_a)."$ai\n";}echo($Zi?"<div id='$aj' class='hidden'>\n$Zi</div>\n":"");if($Gc){echo"<div id='$Hc' class='hidden'>\n";select($Gc,$h,$_f);echo"</div>\n";}}$_h=microtime(true);}while($g->next_result());}$G=substr($G,$D);$D=0;}}}}if($uc)echo"<p class='message'>".lang(151)."\n";elseif($_POST["only_errors"]){echo"<p class='message'>".lang(152,$ub-count($zc))," <span class='time'>(".format_time($mi).")</span>\n";}elseif($zc&&$ub>1)echo"<p class='error'>".lang(147).": ".implode("",$zc)."\n";}else
echo"<p class='error'>".upload_error($G)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Dc="<input type='submit' value='".lang(153)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$rg=$_GET["sql"];if($_POST)$rg=$_POST["query"];elseif($_GET["history"]=="all")$rg=$zd;elseif($_GET["history"]!="")$rg=$zd[$_GET["history"]][0];echo"<p>";textarea("query",$rg,20);echo($_POST?"":script("qs('textarea').focus();")),"<p>$Dc\n",lang(154).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(155)."</legend><div>";$sd=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$sd (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$Dc":lang(156)),"</div></fieldset>\n","<fieldset><legend>".lang(157)."</legend><div>",lang(158,"<code>".h($b->importServerPath())."$sd</code>"),' <input type="submit" name="webfile" value="'.lang(159).'">',"</div></fieldset>\n","<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])),lang(160))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])),lang(161))."\n","<input type='hidden' name='token' value='$ki'>\n";if(!isset($_GET["import"])&&$zd){print_fieldset("history",lang(162),$_GET["history"]!="");for($X=end($zd);$X;$X=prev($zd)){$y=key($zd);list($rg,$ai,$pc)=$X;echo'<a href="'.h(ME."sql=&history=$y").'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$ai)."'>".@date("H:i:s",$ai)."</span>"." <code class='jush-$x'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$rg)))),80,"</code>").($pc?" <span class='time'>($pc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(163)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(164)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$p=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$p):""):where($_GET,$p));$Gi=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($p
as$C=>$o){if(!isset($o["privileges"][$Gi?"update":"insert"])||$b->fieldName($o)=="")unset($p[$C]);}if($_POST&&!$n&&!isset($_GET["select"])){$A=$_POST["referer"];if($_POST["insert"])$A=($Gi?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$A))$A=ME."select=".urlencode($a);$w=indexes($a);$Bi=unique_array($_GET["where"],$w);$ug="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($A,lang(165),$m->delete($a,$ug,!$Bi));else{$O=array();foreach($p
as$C=>$o){$X=process_input($o);if($X!==false&&$X!==null)$O[idf_escape($C)]=$X;}if($Gi){if(!$O)redirect($A);queries_redirect($A,lang(166),$m->update($a,$O,$ug,!$Bi));if(is_ajax()){page_headers();page_messages($n);exit;}}else{$H=$m->insert($a,$O);$oe=($H?last_id():0);queries_redirect($A,lang(167,($oe?" $oe":"")),$H);}}}$J=null;if($_POST["save"])$J=(array)$_POST["fields"];elseif($Z){$L=array();foreach($p
as$C=>$o){if(isset($o["privileges"]["select"])){$Ha=convert_field($o);if($_POST["clone"]&&$o["auto_increment"])$Ha="''";if($x=="sql"&&preg_match("~enum|set~",$o["type"]))$Ha="1*".idf_escape($C);$L[]=($Ha?"$Ha AS ":"").idf_escape($C);}}$J=array();if(!support("table"))$L=array("*");if($L){$H=$m->select($a,$L,array($Z),$L,array(),(isset($_GET["select"])?2:1));if(!$H)$n=error();else{$J=$H->fetch_assoc();if(!$J)$J=false;}if(isset($_GET["select"])&&(!$J||$H->fetch_assoc()))$J=null;}}if(!support("table")&&!$p){if(!$Z){$H=$m->select($a,array("*"),$Z,array("*"));$J=($H?$H->fetch_assoc():false);if(!$J)$J=array($m->primary=>"");}if($J){foreach($J
as$y=>$X){if(!$Z)$J[$y]=null;$p[$y]=array("field"=>$y,"null"=>($y!=$m->primary),"auto_increment"=>($y==$m->primary));}}}edit_form($a,$p,$J,$Gi);}elseif(isset($_GET["create"])){$a=$_GET["create"];$Pf=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$y)$Pf[$y]=$y;$Bg=referencable_primary($a);$fd=array();foreach($Bg
as$Lh=>$o)$fd[str_replace("`","``",$Lh)."`".str_replace("`","``",$o["field"])]=$Lh;$Cf=array();$S=array();if($a!=""){$Cf=fields($a);$S=table_status($a);if(!$S)$n=lang(9);}$J=$_POST;$J["fields"]=(array)$J["fields"];if($J["auto_increment_col"])$J["fields"][$J["auto_increment_col"]]["auto_increment"]=true;if($_POST&&!process_fields($J["fields"])&&!$n){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(168),drop_tables(array($a)));else{$p=array();$Ea=array();$Li=false;$dd=array();$Bf=reset($Cf);$Ba=" FIRST";foreach($J["fields"]as$y=>$o){$q=$fd[$o["type"]];$xi=($q!==null?$Bg[$q]:$o);if($o["field"]!=""){if(!$o["has_default"])$o["default"]=null;if($y==$J["auto_increment_col"])$o["auto_increment"]=true;$og=process_field($o,$xi);$Ea[]=array($o["orig"],$og,$Ba);if($og!=process_field($Bf,$Bf)){$p[]=array($o["orig"],$og,$Ba);if($o["orig"]!=""||$Ba)$Li=true;}if($q!==null)$dd[idf_escape($o["field"])]=($a!=""&&$x!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$fd[$o["type"]],'source'=>array($o["field"]),'target'=>array($xi["field"]),'on_delete'=>$o["on_delete"],));$Ba=" AFTER ".idf_escape($o["field"]);}elseif($o["orig"]!=""){$Li=true;$p[]=array($o["orig"]);}if($o["orig"]!=""){$Bf=next($Cf);if(!$Bf)$Ba="";}}$Rf="";if($Pf[$J["partition_by"]]){$Sf=array();if($J["partition_by"]=='RANGE'||$J["partition_by"]=='LIST'){foreach(array_filter($J["partition_names"])as$y=>$X){$Y=$J["partition_values"][$y];$Sf[]="\n  PARTITION ".idf_escape($X)." VALUES ".($J["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$Rf.="\nPARTITION BY $J[partition_by]($J[partition])".($Sf?" (".implode(",",$Sf)."\n)":($J["partitions"]?" PARTITIONS ".(+$J["partitions"]):""));}elseif(support("partitioning")&&preg_match("~partitioned~",$S["Create_options"]))$Rf.="\nREMOVE PARTITIONING";$Ke=lang(169);if($a==""){cookie("adminer_engine",$J["Engine"]);$Ke=lang(170);}$C=trim($J["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($C),$Ke,alter_table($a,$C,($x=="sqlite"&&($Li||$dd)?$Ea:$p),$dd,($J["Comment"]!=$S["Comment"]?$J["Comment"]:null),($J["Engine"]&&$J["Engine"]!=$S["Engine"]?$J["Engine"]:""),($J["Collation"]&&$J["Collation"]!=$S["Collation"]?$J["Collation"]:""),($J["Auto_increment"]!=""?number($J["Auto_increment"]):""),$Rf));}}page_header(($a!=""?lang(45):lang(75)),$n,array("table"=>$a),h($a));if(!$_POST){$J=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($zi["int"])?"int":(isset($zi["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$J=$S;$J["name"]=$a;$J["fields"]=array();if(!$_GET["auto_increment"])$J["Auto_increment"]="";foreach($Cf
as$o){$o["has_default"]=isset($o["default"]);$J["fields"][]=$o;}if(support("partitioning")){$kd="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($a);$H=$g->query("SELECT PARTITION_METHOD, PARTITION_ORDINAL_POSITION, PARTITION_EXPRESSION $kd ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");list($J["partition_by"],$J["partitions"],$J["partition"])=$H->fetch_row();$Sf=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $kd AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$Sf[""]="";$J["partition_names"]=array_keys($Sf);$J["partition_values"]=array_values($Sf);}}}$qb=collations();$wc=engines();foreach($wc
as$vc){if(!strcasecmp($vc,$J["Engine"])){$J["Engine"]=$vc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(171),': <input name="name" maxlength="64" value="',h($J["name"]),'" autocapitalize="off">
';if($a==""&&!$_POST)echo
script("focus(qs('#form')['name']);");echo($wc?"<select name='Engine'>".optionlist(array(""=>"(".lang(172).")")+$wc,$J["Engine"])."</select>".on_help("getTarget(event).value",1).script("qsl('select').onchange = helpClose;"):""),' ',($qb&&!preg_match("~sqlite|mssql~",$x)?html_select("Collation",array(""=>"(".lang(100).")")+$qb,$J["Collation"]):""),' <input type="submit" value="',lang(14),'">
';}echo'
';if(support("columns")){echo'<table cellspacing="0" id="edit-fields" class="nowrap">
';$wb=($_POST?$_POST["comments"]:$J["Comment"]!="");if(!$_POST&&!$wb){foreach($J["fields"]as$o){if($o["comment"]!=""){$wb=true;break;}}}edit_fields($J["fields"],$qb,"TABLE",$fd,$wb);echo'</table>
<p>
',lang(52),': <input type="number" name="Auto_increment" size="6" value="',h($J["Auto_increment"]),'">
',checkbox("defaults",1,!$_POST||$_POST["defaults"],lang(173),"columnShow(this.checked, 5)","jsonly"),($_POST?"":script("editingHideDefaults();")),(support("comment")?"<label><input type='checkbox' name='comments' value='1' class='jsonly'".($wb?" checked":"").">".lang(51)."</label>".script("qsl('input').onclick = partial(editingCommentsClick, true);").' <input name="Comment" value="'.h($J["Comment"]).'" maxlength="'.(min_version(5.5)?2048:60).'"'.($wb?'':' class="hidden"').'>':''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(174,$a));}if(support("partitioning")){$Qf=preg_match('~RANGE|LIST~',$J["partition_by"]);print_fieldset("partition",lang(175),$J["partition_by"]);echo'<p>
',"<select name='partition_by'>".optionlist(array(""=>"")+$Pf,$J["partition_by"])."</select>".on_help("getTarget(event).value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),'(<input name="partition" value="',h($J["partition"]),'">)
',lang(176),': <input type="number" name="partitions" class="size',($Qf||!$J["partition_by"]?" hidden":""),'" value="',h($J["partitions"]),'">
<table cellspacing="0" id="partition-table"',($Qf?"":" class='hidden'"),'>
<thead><tr><th>',lang(177),'<th>',lang(178),'</thead>
';foreach($J["partition_names"]as$y=>$X){echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($y==count($J["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h($J["partition_values"][$y]).'">';}echo'</table>
</div></fieldset>
';}echo'<input type="hidden" name="token" value="',$ki,'">
</form>
',script("qs('#form')['defaults'].onclick();".(support("comment")?" editingCommentsClick.call(qs('#form')['comments']);":""));}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$Id=array("PRIMARY","UNIQUE","INDEX");$S=table_status($a,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$Id[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$Id[]="SPATIAL";$w=indexes($a);$hg=array();if($x=="mongo"){$hg=$w["_id_"];unset($Id[0]);unset($w["_id_"]);}$J=$_POST;if($_POST&&!$n&&!$_POST["add"]&&!$_POST["drop_col"]){$c=array();foreach($J["indexes"]as$v){$C=$v["name"];if(in_array($v["type"],$Id)){$e=array();$ue=array();$Yb=array();$O=array();ksort($v["columns"]);foreach($v["columns"]as$y=>$d){if($d!=""){$te=$v["lengths"][$y];$Xb=$v["descs"][$y];$O[]=idf_escape($d).($te?"(".(+$te).")":"").($Xb?" DESC":"");$e[]=$d;$ue[]=($te?$te:null);$Yb[]=$Xb;}}if($e){$Ec=$w[$C];if($Ec){ksort($Ec["columns"]);ksort($Ec["lengths"]);ksort($Ec["descs"]);if($v["type"]==$Ec["type"]&&array_values($Ec["columns"])===$e&&(!$Ec["lengths"]||array_values($Ec["lengths"])===$ue)&&array_values($Ec["descs"])===$Yb){unset($w[$C]);continue;}}$c[]=array($v["type"],$C,$O);}}}foreach($w
as$C=>$Ec)$c[]=array($Ec["type"],$C,"DROP");if(!$c)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(179),alter_indexes($a,$c));}page_header(lang(131),$n,array("table"=>$a),h($a));$p=array_keys(fields($a));if($_POST["add"]){foreach($J["indexes"]as$y=>$v){if($v["columns"][count($v["columns"])]!="")$J["indexes"][$y]["columns"][]="";}$v=end($J["indexes"]);if($v["type"]||array_filter($v["columns"],'strlen'))$J["indexes"][]=array("columns"=>array(1=>""));}if(!$J){foreach($w
as$y=>$v){$w[$y]["name"]=$y;$w[$y]["columns"][]="";}$w[]=array("columns"=>array(1=>""));$J["indexes"]=$w;}echo'
<form action="" method="post">
<table cellspacing="0" class="nowrap">
<thead><tr>
<th id="label-type">',lang(180),'<th><input type="submit" class="wayoff">',lang(181),'<th id="label-name">',lang(182),'<th><noscript>',"<input type='image' class='icon' name='add[0]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.6.3")."' alt='+' title='".lang(107)."'>",'</noscript>
</thead>
';if($hg){echo"<tr><td>PRIMARY<td>";foreach($hg["columns"]as$y=>$d){echo
select_input(" disabled",$p,$d),"<label><input disabled type='checkbox'>".lang(60)."</label> ";}echo"<td><td>\n";}$be=1;foreach($J["indexes"]as$v){if(!$_POST["drop_col"]||$be!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$be][type]",array(-1=>"")+$Id,$v["type"],($be==count($J["indexes"])?"indexesAddRow.call(this);":1),"label-type"),"<td>";ksort($v["columns"]);$s=1;foreach($v["columns"]as$y=>$d){echo"<span>".select_input(" name='indexes[$be][columns][$s]' title='".lang(49)."'",($p?array_combine($p,$p):$p),$d,"partial(".($s==count($v["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape($x=="sql"?"":$_GET["indexes"]."_")."')"),($x=="sql"||$x=="mssql"?"<input type='number' name='indexes[$be][lengths][$s]' class='size' value='".h($v["lengths"][$y])."' title='".lang(105)."'>":""),($x!="sql"?checkbox("indexes[$be][descs][$s]",1,$v["descs"][$y],lang(60)):"")," </span>";$s++;}echo"<td><input name='indexes[$be][name]' value='".h($v["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td><input type='image' class='icon' name='drop_col[$be]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.6.3")."' alt='x' title='".lang(110)."'>".script("qsl('input').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$be++;}echo'</table>
<p>
<input type="submit" value="',lang(14),'">
<input type="hidden" name="token" value="',$ki,'">
</form>
';}elseif(isset($_GET["database"])){$J=$_POST;if($_POST&&!$n&&!isset($_POST["add_x"])){$C=trim($J["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(183),drop_databases(array(DB)));}elseif(DB!==$C){if(DB!=""){$_GET["db"]=$C;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($C),lang(184),rename_database($C,$J["collation"]));}else{$k=explode("\n",str_replace("\r","",$C));$Fh=true;$ne="";foreach($k
as$l){if(count($k)==1||$l!=""){if(!create_database($l,$J["collation"]))$Fh=false;$ne=$l;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($ne),lang(185),$Fh);}}else{if(!$J["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($C).(preg_match('~^[a-z0-9_]+$~i',$J["collation"])?" COLLATE $J[collation]":""),substr(ME,0,-1),lang(186));}}page_header(DB!=""?lang(68):lang(114),$n,array(),h(DB));$qb=collations();$C=DB;if($_POST)$C=$J["name"];elseif(DB!="")$J["collation"]=db_collation(DB,$qb);elseif($x=="sql"){foreach(get_vals("SHOW GRANTS")as$md){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$md,$B)&&$B[1]){$C=stripcslashes(idf_unescape("`$B[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add_x"]||strpos($C,"\n")?'<textarea id="name" name="name" rows="10" cols="40">'.h($C).'</textarea><br>':'<input name="name" id="name" value="'.h($C).'" maxlength="64" autocapitalize="off">')."\n".($qb?html_select("collation",array(""=>"(".lang(100).")")+$qb,$J["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"ms187963.aspx",)):""),script("focus(qs('#name'));"),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(126)."'>".confirm(lang(174,DB))."\n";elseif(!$_POST["add_x"]&&$_GET["db"]=="")echo"<input type='image' class='icon' name='add' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.6.3")."' alt='+' title='".lang(107)."'>\n";echo'<input type="hidden" name="token" value="',$ki,'">
</form>
';}elseif(isset($_GET["scheme"])){$J=$_POST;if($_POST&&!$n){$_=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$_,lang(187));else{$C=trim($J["name"]);$_.=urlencode($C);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($C),$_,lang(188));elseif($_GET["ns"]!=$C)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($C),$_,lang(189));else
redirect($_);}}page_header($_GET["ns"]!=""?lang(69):lang(70),$n);if(!$J)$J["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" id="name" value="',h($J["name"]),'" autocapitalize="off">
',script("focus(qs('#name'));"),'<input type="submit" value="',lang(14),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(126)."'>".confirm(lang(174,$_GET["ns"]))."\n";echo'<input type="hidden" name="token" value="',$ki,'">
</form>
';}elseif(isset($_GET["call"])){$da=($_GET["name"]?$_GET["name"]:$_GET["call"]);page_header(lang(190).": ".h($da),$n);$Rg=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Gd=array();$Gf=array();foreach($Rg["fields"]as$s=>$o){if(substr($o["inout"],-3)=="OUT")$Gf[$s]="@".idf_escape($o["field"])." AS ".idf_escape($o["field"]);if(!$o["inout"]||substr($o["inout"],0,2)=="IN")$Gd[]=$s;}if(!$n&&$_POST){$ab=array();foreach($Rg["fields"]as$y=>$o){if(in_array($y,$Gd)){$X=process_input($o);if($X===false)$X="''";if(isset($Gf[$y]))$g->query("SET @".idf_escape($o["field"])." = $X");}$ab[]=(isset($Gf[$y])?"@".idf_escape($o["field"]):$X);}$G=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($da)."(".implode(", ",$ab).")";$_h=microtime(true);$H=$g->multi_query($G);$_a=$g->affected_rows;echo$b->selectQuery($G,$_h,!$H);if(!$H)echo"<p class='error'>".error()."\n";else{$h=connect();if(is_object($h))$h->select_db(DB);do{$H=$g->store_result();if(is_object($H))select($H,$h);else
echo"<p class='message'>".lang(191,$_a)."\n";}while($g->next_result());if($Gf)select($g->query("SELECT ".implode(", ",$Gf)));}}echo'
<form action="" method="post">
';if($Gd){echo"<table cellspacing='0'>\n";foreach($Gd
as$y){$o=$Rg["fields"][$y];$C=$o["field"];echo"<tr><th>".$b->fieldName($o);$Y=$_POST["fields"][$C];if($Y!=""){if($o["type"]=="enum")$Y=+$Y;if($o["type"]=="set")$Y=array_sum($Y);}input($o,$Y,(string)$_POST["function"][$C]);echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(190),'">
<input type="hidden" name="token" value="',$ki,'">
</form>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$C=$_GET["name"];$J=$_POST;if($_POST&&!$n&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){$Ke=($_POST["drop"]?lang(192):($C!=""?lang(193):lang(194)));$A=ME."table=".urlencode($a);if(!$_POST["drop"]){$J["source"]=array_filter($J["source"],'strlen');ksort($J["source"]);$Th=array();foreach($J["source"]as$y=>$X)$Th[$y]=$J["target"][$y];$J["target"]=$Th;}if($x=="sqlite")queries_redirect($A,$Ke,recreate_table($a,$a,array(),array(),array(" $C"=>($_POST["drop"]?"":" ".format_foreign_key($J)))));else{$c="ALTER TABLE ".table($a);$gc="\nDROP ".($x=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($C);if($_POST["drop"])query_redirect($c.$gc,$A,$Ke);else{query_redirect($c.($C!=""?"$gc,":"")."\nADD".format_foreign_key($J),$A,$Ke);$n=lang(195)."<br>$n";}}}page_header(lang(196),$n,array("table"=>$a),h($a));if($_POST){ksort($J["source"]);if($_POST["add"])$J["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$J["target"]=array();}elseif($C!=""){$fd=foreign_keys($a);$J=$fd[$C];$J["source"][]="";}else{$J["table"]=$a;$J["source"]=array("");}$sh=array_keys(fields($a));$Th=($a===$J["table"]?$sh:array_keys(fields($J["table"])));$Ag=array_keys(array_filter(table_status('',true),'fk_support'));echo'
<form action="" method="post">
<p>
';if($J["db"]==""&&$J["ns"]==""){echo
lang(197),':
',html_select("table",$Ag,$J["table"],"this.form['change-js'].value = '1'; this.form.submit();"),'<input type="hidden" name="change-js" value="">
<noscript><p><input type="submit" name="change" value="',lang(198),'"></noscript>
<table cellspacing="0">
<thead><tr><th id="label-source">',lang(133),'<th id="label-target">',lang(134),'</thead>
';$be=0;foreach($J["source"]as$y=>$X){echo"<tr>","<td>".html_select("source[".(+$y)."]",array(-1=>"")+$sh,$X,($be==count($J["source"])-1?"foreignAddRow.call(this);":1),"label-source"),"<td>".html_select("target[".(+$y)."]",$Th,$J["target"][$y],1,"label-target");$be++;}echo'</table>
<p>
',lang(102),': ',html_select("on_delete",array(-1=>"")+explode("|",$nf),$J["on_delete"]),' ',lang(101),': ',html_select("on_update",array(-1=>"")+explode("|",$nf),$J["on_update"]),doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"ms174979.aspx",'oracle'=>"clauses002.htm#sthref2903",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(199),'"></noscript>
';}if($C!=""){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(174,$C));}echo'<input type="hidden" name="token" value="',$ki,'">
</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$J=$_POST;$Df="VIEW";if($x=="pgsql"&&$a!=""){$P=table_status($a);$Df=strtoupper($P["Engine"]);}if($_POST&&!$n){$C=trim($J["name"]);$Ha=" AS\n$J[select]";$A=ME."table=".urlencode($C);$Ke=lang(200);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$C&&$x!="sqlite"&&$U=="VIEW"&&$Df=="VIEW")query_redirect(($x=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($C).$Ha,$A,$Ke);else{$Vh=$C."_adminer_".uniqid();drop_create("DROP $Df ".table($a),"CREATE $U ".table($C).$Ha,"DROP $U ".table($C),"CREATE $U ".table($Vh).$Ha,"DROP $U ".table($Vh),($_POST["drop"]?substr(ME,0,-1):$A),lang(201),$Ke,lang(202),$a,$C);}}if(!$_POST&&$a!=""){$J=view($a);$J["name"]=$a;$J["materialized"]=($Df!="VIEW");if(!$n)$n=error();}page_header(($a!=""?lang(44):lang(203)),$n,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(182),': <input name="name" value="',h($J["name"]),'" maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$J["materialized"],lang(128)):""),'<p>';textarea("select",$J["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(174,$a));}echo'<input type="hidden" name="token" value="',$ki,'">
</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$Td=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$Bh=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$J=$_POST;if($_POST&&!$n){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(204));elseif(in_array($J["INTERVAL_FIELD"],$Td)&&isset($Bh[$J["STATUS"]])){$Wg="\nON SCHEDULE ".($J["INTERVAL_VALUE"]?"EVERY ".q($J["INTERVAL_VALUE"])." $J[INTERVAL_FIELD]".($J["STARTS"]?" STARTS ".q($J["STARTS"]):"").($J["ENDS"]?" ENDS ".q($J["ENDS"]):""):"AT ".q($J["STARTS"]))." ON COMPLETION".($J["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(205):lang(206)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$Wg.($aa!=$J["EVENT_NAME"]?"\nRENAME TO ".idf_escape($J["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($J["EVENT_NAME"]).$Wg)."\n".$Bh[$J["STATUS"]]." COMMENT ".q($J["EVENT_COMMENT"]).rtrim(" DO\n$J[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(207).": ".h($aa):lang(208)),$n);if(!$J&&$aa!=""){$K=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$J=reset($K);}echo'
<form action="" method="post">
<table cellspacing="0">
<tr><th>',lang(182),'<td><input name="EVENT_NAME" value="',h($J["EVENT_NAME"]),'" maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(209),'<td><input name="STARTS" value="',h("$J[EXECUTE_AT]$J[STARTS]"),'">
<tr><th title="datetime">',lang(210),'<td><input name="ENDS" value="',h($J["ENDS"]),'">
<tr><th>',lang(211),'<td><input type="number" name="INTERVAL_VALUE" value="',h($J["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$Td,$J["INTERVAL_FIELD"]),'<tr><th>',lang(117),'<td>',html_select("STATUS",$Bh,$J["STATUS"]),'<tr><th>',lang(51),'<td><input name="EVENT_COMMENT" value="',h($J["EVENT_COMMENT"]),'" maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$J["ON_COMPLETION"]=="PRESERVE",lang(212)),'</table>
<p>';textarea("EVENT_DEFINITION",$J["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!=""){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(174,$aa));}echo'<input type="hidden" name="token" value="',$ki,'">
</form>
';}elseif(isset($_GET["procedure"])){$da=($_GET["name"]?$_GET["name"]:$_GET["procedure"]);$Rg=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$J=$_POST;$J["fields"]=(array)$J["fields"];if($_POST&&!process_fields($J["fields"])&&!$n){$Af=routine($_GET["procedure"],$Rg);$Vh="$J[name]_adminer_".uniqid();drop_create("DROP $Rg ".routine_id($da,$Af),create_routine($Rg,$J),"DROP $Rg ".routine_id($J["name"],$J),create_routine($Rg,array("name"=>$Vh)+$J),"DROP $Rg ".routine_id($Vh,$J),substr(ME,0,-1),lang(213),lang(214),lang(215),$da,$J["name"]);}page_header(($da!=""?(isset($_GET["function"])?lang(216):lang(217)).": ".h($da):(isset($_GET["function"])?lang(218):lang(219))),$n);if(!$_POST&&$da!=""){$J=routine($_GET["procedure"],$Rg);$J["name"]=$da;}$qb=get_vals("SHOW CHARACTER SET");sort($qb);$Sg=routine_languages();echo'
<form action="" method="post" id="form">
<p>',lang(182),': <input name="name" value="',h($J["name"]),'" maxlength="64" autocapitalize="off">
',($Sg?lang(19).": ".html_select("language",$Sg,$J["language"])."\n":""),'<input type="submit" value="',lang(14),'">
<table cellspacing="0" class="nowrap">
';edit_fields($J["fields"],$qb,$Rg);if(isset($_GET["function"])){echo"<tr><td>".lang(220);edit_type("returns",$J["returns"],$qb,array(),($x=="pgsql"?array("void","trigger"):array()));}echo'</table>
<p>';textarea("definition",$J["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($da!=""){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(174,$da));}echo'<input type="hidden" name="token" value="',$ki,'">
</form>
';}elseif(isset($_GET["sequence"])){$fa=$_GET["sequence"];$J=$_POST;if($_POST&&!$n){$_=substr(ME,0,-1);$C=trim($J["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($fa),$_,lang(221));elseif($fa=="")query_redirect("CREATE SEQUENCE ".idf_escape($C),$_,lang(222));elseif($fa!=$C)query_redirect("ALTER SEQUENCE ".idf_escape($fa)." RENAME TO ".idf_escape($C),$_,lang(223));else
redirect($_);}page_header($fa!=""?lang(224).": ".h($fa):lang(225),$n);if(!$J)$J["name"]=$fa;echo'
<form action="" method="post">
<p><input name="name" value="',h($J["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($fa!="")echo"<input type='submit' name='drop' value='".lang(126)."'>".confirm(lang(174,$fa))."\n";echo'<input type="hidden" name="token" value="',$ki,'">
</form>
';}elseif(isset($_GET["type"])){$ga=$_GET["type"];$J=$_POST;if($_POST&&!$n){$_=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($ga),$_,lang(226));else
query_redirect("CREATE TYPE ".idf_escape(trim($J["name"]))." $J[as]",$_,lang(227));}page_header($ga!=""?lang(228).": ".h($ga):lang(229),$n);if(!$J)$J["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($ga!="")echo"<input type='submit' name='drop' value='".lang(126)."'>".confirm(lang(174,$ga))."\n";else{echo"<input name='name' value='".h($J['name'])."' autocapitalize='off'>\n";textarea("as",$J["as"]);echo"<p><input type='submit' value='".lang(14)."'>\n";}echo'<input type="hidden" name="token" value="',$ki,'">
</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$C=$_GET["name"];$vi=trigger_options();$J=(array)trigger($C)+array("Trigger"=>$a."_bi");if($_POST){if(!$n&&in_array($_POST["Timing"],$vi["Timing"])&&in_array($_POST["Event"],$vi["Event"])&&in_array($_POST["Type"],$vi["Type"])){$mf=" ON ".table($a);$gc="DROP TRIGGER ".idf_escape($C).($x=="pgsql"?$mf:"");$A=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($gc,$A,lang(230));else{if($C!="")queries($gc);queries_redirect($A,($C!=""?lang(231):lang(232)),queries(create_trigger($mf,$_POST)));if($C!="")queries(create_trigger($mf,$J+array("Type"=>reset($vi["Type"]))));}}$J=$_POST;}page_header(($C!=""?lang(233).": ".h($C):lang(234)),$n,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table cellspacing="0">
<tr><th>',lang(235),'<td>',html_select("Timing",$vi["Timing"],$J["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(236),'<td>',html_select("Event",$vi["Event"],$J["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$vi["Event"])?" <input name='Of' value='".h($J["Of"])."' class='hidden'>":""),'<tr><th>',lang(50),'<td>',html_select("Type",$vi["Type"],$J["Type"]),'</table>
<p>',lang(182),': <input name="Trigger" value="',h($J["Trigger"]),'" maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$J["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($C!=""){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(174,$C));}echo'<input type="hidden" name="token" value="',$ki,'">
</form>
';}elseif(isset($_GET["user"])){$ha=$_GET["user"];$mg=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$J){foreach(explode(",",($J["Privilege"]=="Grant option"?"":$J["Context"]))as$Bb)$mg[$Bb][$J["Privilege"]]=$J["Comment"];}$mg["Server Admin"]+=$mg["File access on server"];$mg["Databases"]["Create routine"]=$mg["Procedures"]["Create routine"];unset($mg["Procedures"]["Create routine"]);$mg["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$mg["Columns"][$X]=$mg["Tables"][$X];unset($mg["Server Admin"]["Usage"]);foreach($mg["Tables"]as$y=>$X)unset($mg["Databases"][$y]);$Xe=array();if($_POST){foreach($_POST["objects"]as$y=>$X)$Xe[$X]=(array)$Xe[$X]+(array)$_POST["grants"][$y];}$nd=array();$kf="";if(isset($_GET["host"])&&($H=$g->query("SHOW GRANTS FOR ".q($ha)."@".q($_GET["host"])))){while($J=$H->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$J[0],$B)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$B[1],$Ce,PREG_SET_ORDER)){foreach($Ce
as$X){if($X[1]!="USAGE")$nd["$B[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$J[0]))$nd["$B[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$J[0],$B))$kf=$B[1];}}if($_POST&&!$n){$lf=(isset($_GET["host"])?q($ha)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $lf",ME."privileges=",lang(237));else{$Ze=q($_POST["user"])."@".q($_POST["host"]);$Uf=$_POST["pass"];if($Uf!=''&&!$_POST["hashed"]){$Uf=$g->result("SELECT PASSWORD(".q($Uf).")");$n=!$Uf;}$Gb=false;if(!$n){if($lf!=$Ze){$Gb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $Ze IDENTIFIED BY PASSWORD ".q($Uf));$n=!$Gb;}elseif($Uf!=$kf)queries("SET PASSWORD FOR $Ze = ".q($Uf));}if(!$n){$Og=array();foreach($Xe
as$ff=>$md){if(isset($_GET["grant"]))$md=array_filter($md);$md=array_keys($md);if(isset($_GET["grant"]))$Og=array_diff(array_keys(array_filter($Xe[$ff],'strlen')),$md);elseif($lf==$Ze){$if=array_keys((array)$nd[$ff]);$Og=array_diff($if,$md);$md=array_diff($md,$if);unset($nd[$ff]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$ff,$B)&&(!grant("REVOKE",$Og,$B[2]," ON $B[1] FROM $Ze")||!grant("GRANT",$md,$B[2]," ON $B[1] TO $Ze"))){$n=true;break;}}}if(!$n&&isset($_GET["host"])){if($lf!=$Ze)queries("DROP USER $lf");elseif(!isset($_GET["grant"])){foreach($nd
as$ff=>$Og){if(preg_match('~^(.+)(\(.*\))?$~U',$ff,$B))grant("REVOKE",array_keys($Og),$B[2]," ON $B[1] FROM $Ze");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(238):lang(239)),!$n);if($Gb)$g->query("DROP USER $Ze");}}page_header((isset($_GET["host"])?lang(36).": ".h("$ha@$_GET[host]"):lang(145)),$n,array("privileges"=>array('',lang(72))));if($_POST){$J=$_POST;$nd=$Xe;}else{$J=$_GET+array("host"=>$g->result("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$J["pass"]=$kf;if($kf!="")$J["hashed"]=true;$nd[(DB==""||$nd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table cellspacing="0">
<tr><th>',lang(35),'<td><input name="host" maxlength="60" value="',h($J["host"]),'" autocapitalize="off">
<tr><th>',lang(36),'<td><input name="user" maxlength="16" value="',h($J["user"]),'" autocapitalize="off">
<tr><th>',lang(37),'<td><input name="pass" id="pass" value="',h($J["pass"]),'" autocomplete="new-password">
';if(!$J["hashed"])echo
script("typePassword(qs('#pass'));");echo
checkbox("hashed",1,$J["hashed"],lang(240),"typePassword(this.form['pass'], this.checked);"),'</table>

';echo"<table cellspacing='0'>\n","<thead><tr><th colspan='2'>".lang(72).doc_link(array('sql'=>"grant.html#priv_level"));$s=0;foreach($nd
as$ff=>$md){echo'<th>'.($ff!="*.*"?"<input name='objects[$s]' value='".h($ff)."' size='10' autocapitalize='off'>":"<input type='hidden' name='objects[$s]' value='*.*' size='10'>*.*");$s++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(35),"Databases"=>lang(38),"Tables"=>lang(130),"Columns"=>lang(49),"Procedures"=>lang(241),)as$Bb=>$Xb){foreach((array)$mg[$Bb]as$lg=>$vb){echo"<tr".odd()."><td".($Xb?">$Xb<td":" colspan='2'").' lang="en" title="'.h($vb).'">'.h($lg);$s=0;foreach($nd
as$ff=>$md){$C="'grants[$s][".h(strtoupper($lg))."]'";$Y=$md[strtoupper($lg)];if($Bb=="Server Admin"&&$ff!=(isset($nd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$C><option><option value='1'".($Y?" selected":"").">".lang(242)."<option value='0'".($Y=="0"?" selected":"").">".lang(243)."</select>";else{echo"<td align='center'><label class='block'>","<input type='checkbox' name=$C value='1'".($Y?" checked":"").($lg=="All privileges"?" id='grants-$s-all'>":">".($lg=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$s-all'); };"))),"</label>";}$s++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"])){echo'<input type="submit" name="drop" value="',lang(126),'">',confirm(lang(174,"$ha@$_GET[host]"));}echo'<input type="hidden" name="token" value="',$ki,'">
</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")&&$_POST&&!$n){$ie=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$ie++;}queries_redirect(ME."processlist=",lang(244,$ie),$ie||!$_POST["kill"]);}page_header(lang(115),$n);echo'
<form action="" method="post">
<table cellspacing="0" class="nowrap checkable">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$s=-1;foreach(process_list()as$s=>$J){if(!$s){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($J
as$y=>$X)echo"<th>$y".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($y),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"../b14237/dynviews_2088.htm",));echo"</thead>\n";}echo"<tr".odd().">".(support("kill")?"<td>".checkbox("kill[]",$J[$x=="sql"?"Id":"pid"],0):"");foreach($J
as$y=>$X)echo"<td>".(($x=="sql"&&$y=="Info"&&preg_match("~Query|Killed~",$J["Command"])&&$X!="")||($x=="pgsql"&&$y=="current_query"&&$X!="<IDLE>")||($x=="oracle"&&$y=="sql_text"&&$X!="")?"<code class='jush-$x'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($J["db"]!=""?"db=".urlencode($J["db"])."&":"")."sql=".urlencode($X)).'">'.lang(245).'</a>':h($X));echo"\n";}echo'</table>
<p>
';if(support("kill")){echo($s+1)."/".lang(246,max_connections()),"<p><input type='submit' value='".lang(247)."'>\n";}echo'<input type="hidden" name="token" value="',$ki,'">
</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$w=indexes($a);$p=fields($a);$fd=column_foreign_keys($a);$hf=$S["Oid"];parse_str($_COOKIE["adminer_import"],$za);$Pg=array();$e=array();$Zh=null;foreach($p
as$y=>$o){$C=$b->fieldName($o);if(isset($o["privileges"]["select"])&&$C!=""){$e[$y]=html_entity_decode(strip_tags($C),ENT_QUOTES);if(is_shortable($o))$Zh=$b->selectLengthProcess();}$Pg+=$o["privileges"];}list($L,$od)=$b->selectColumnsProcess($e,$w);$Xd=count($od)<count($L);$Z=$b->selectSearchProcess($p,$w);$xf=$b->selectOrderProcess($p,$w);$z=$b->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$Ci=>$J){$Ha=convert_field($p[key($J)]);$L=array($Ha?$Ha:idf_escape(key($J)));$Z[]=where_check($Ci,$p);$I=$m->select($a,$L,$Z,$L);if($I)echo
reset($I->fetch_row());}exit;}$hg=$Ei=null;foreach($w
as$v){if($v["type"]=="PRIMARY"){$hg=array_flip($v["columns"]);$Ei=($L?$hg:array());foreach($Ei
as$y=>$X){if(in_array(idf_escape($y),$L))unset($Ei[$y]);}break;}}if($hf&&!$hg){$hg=$Ei=array($hf=>0);$w[]=array("type"=>"PRIMARY","columns"=>array($hf));}if($_POST&&!$n){$fj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$gb=array();foreach($_POST["check"]as$db)$gb[]=where_check($db,$p);$fj[]="((".implode(") OR (",$gb)."))";}$fj=($fj?"\nWHERE ".implode(" AND ",$fj):"");if($_POST["export"]){cookie("adminer_import","output=".urlencode($_POST["output"])."&format=".urlencode($_POST["format"]));dump_headers($a);$b->dumpTable($a,"");$kd=($L?implode(", ",$L):"*").convert_fields($e,$p,$L)."\nFROM ".table($a);$qd=($od&&$Xd?"\nGROUP BY ".implode(", ",$od):"").($xf?"\nORDER BY ".implode(", ",$xf):"");if(!is_array($_POST["check"])||$hg)$G="SELECT $kd$fj$qd";else{$Ai=array();foreach($_POST["check"]as$X)$Ai[]="(SELECT".limit($kd,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$p).$qd,1).")";$G=implode(" UNION ALL ",$Ai);}$b->dumpData($a,"table",$G);exit;}if(!$b->selectEmailProcess($Z,$fd)){if($_POST["save"]||$_POST["delete"]){$H=true;$_a=0;$O=array();if(!$_POST["delete"]){foreach($e
as$C=>$X){$X=process_input($p[$C]);if($X!==null&&($_POST["clone"]||$X!==false))$O[idf_escape($C)]=($X!==false?$X:idf_escape($C));}}if($_POST["delete"]||$O){if($_POST["clone"])$G="INTO ".table($a)." (".implode(", ",array_keys($O)).")\nSELECT ".implode(", ",$O)."\nFROM ".table($a);if($_POST["all"]||($hg&&is_array($_POST["check"]))||$Xd){$H=($_POST["delete"]?$m->delete($a,$fj):($_POST["clone"]?queries("INSERT $G$fj"):$m->update($a,$O,$fj)));$_a=$g->affected_rows;}else{foreach((array)$_POST["check"]as$X){$bj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$p);$H=($_POST["delete"]?$m->delete($a,$bj,1):($_POST["clone"]?queries("INSERT".limit1($a,$G,$bj)):$m->update($a,$O,$bj,1)));if(!$H)break;$_a+=$g->affected_rows;}}}$Ke=lang(248,$_a);if($_POST["clone"]&&$H&&$_a==1){$oe=last_id();if($oe)$Ke=lang(167," $oe");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$Ke,$H);if(!$_POST["delete"]){edit_form($a,$p,(array)$_POST["fields"],!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$n=lang(249);else{$H=true;$_a=0;foreach($_POST["val"]as$Ci=>$J){$O=array();foreach($J
as$y=>$X){$y=bracket_escape($y,1);$O[idf_escape($y)]=(preg_match('~char|text~',$p[$y]["type"])||$X!=""?$b->processInput($p[$y],$X):"NULL");}$H=$m->update($a,$O," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($Ci,$p),!$Xd&&!$hg," ");if(!$H)break;$_a+=$g->affected_rows;}queries_redirect(remove_from_uri(),lang(248,$_a),$H);}}elseif(!is_string($Uc=get_file("csv_file",true)))$n=upload_error($Uc);elseif(!preg_match('~~u',$Uc))$n=lang(250);else{cookie("adminer_import","output=".urlencode($za["output"])."&format=".urlencode($_POST["separator"]));$H=true;$sb=array_keys($p);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$Uc,$Ce);$_a=count($Ce[0]);$m->begin();$M=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$K=array();foreach($Ce[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$M]*)$M~",$X.$M,$De);if(!$y&&!array_diff($De[1],$sb)){$sb=$De[1];$_a--;}else{$O=array();foreach($De[1]as$s=>$nb)$O[idf_escape($sb[$s])]=($nb==""&&$p[$sb[$s]]["null"]?"NULL":q(str_replace('""','"',preg_replace('~^"|"$~','',$nb))));$K[]=$O;}}$H=(!$K||$m->insertUpdate($a,$K,$hg));if($H)$H=$m->commit();queries_redirect(remove_from_uri("page"),lang(251,$_a),$H);$m->rollback();}}}$Lh=$b->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(54).": $Lh",$n);$O=null;if(isset($Pg["insert"])||!support("table")){$O="";foreach((array)$_GET["where"]as$X){if($fd[$X["col"]]&&count($fd[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&!preg_match('~[_%]~',$X["val"]))))$O.="&set".urlencode("[".bracket_escape($X["col"])."]")."=".urlencode($X["val"]);}}$b->selectLinks($S,$O);if(!$e&&support("table"))echo"<p class='error'>".lang(252).($p?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?'<input type="hidden" name="db" value="'.h(DB).'">'.(isset($_GET["ns"])?'<input type="hidden" name="ns" value="'.h($_GET["ns"]).'">':""):"");echo'<input type="hidden" name="select" value="'.h($a).'">',"</div>\n";$b->selectColumnsPrint($L,$e);$b->selectSearchPrint($Z,$e,$w);$b->selectOrderPrint($xf,$e,$w);$b->selectLimitPrint($z);$b->selectLengthPrint($Zh);$b->selectActionPrint($w);echo"</form>\n";$E=$_GET["page"];if($E=="last"){$id=$g->result(count_rows($a,$Z,$Xd,$od));$E=floor(max(0,$id-1)/$z);}$bh=$L;$pd=$od;if(!$bh){$bh[]="*";$Cb=convert_fields($e,$p,$L);if($Cb)$bh[]=substr($Cb,2);}foreach($L
as$y=>$X){$o=$p[idf_unescape($X)];if($o&&($Ha=convert_field($o)))$bh[$y]="$Ha AS $X";}if(!$Xd&&$Ei){foreach($Ei
as$y=>$X){$bh[]=idf_escape($y);if($pd)$pd[]=idf_escape($y);}}$H=$m->select($a,$bh,$Z,$pd,$xf,$z,$E,true);if(!$H)echo"<p class='error'>".error()."\n";else{if($x=="mssql"&&$E)$H->seek($z*$E);$tc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$K=array();while($J=$H->fetch_assoc()){if($E&&$x=="oracle")unset($J["RNUM"]);$K[]=$J;}if($_GET["page"]!="last"&&$z!=""&&$od&&$Xd&&$x=="sql")$id=$g->result(" SELECT FOUND_ROWS()");if(!$K)echo"<p class='message'>".lang(12)."\n";else{$Qa=$b->backwardKeys($a,$Lh);echo"<table id='table' cellspacing='0' class='nowrap checkable'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$od&&$L?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(253)."</a>");$We=array();$ld=array();reset($L);$wg=1;foreach($K[0]as$y=>$X){if(!isset($Ei[$y])){$X=$_GET["columns"][key($L)];$o=$p[$L?($X?$X["col"]:current($L)):$y];$C=($o?$b->fieldName($o,$wg):($X["fun"]?"*":$y));if($C!=""){$wg++;$We[$y]=$C;$d=idf_escape($y);$Cd=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$Xb="&desc%5B0%5D=1";echo"<th>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});",""),'<a href="'.h($Cd.($xf[0]==$d||$xf[0]==$y||(!$xf&&$Xd&&$od[0]==$d)?$Xb:'')).'">';echo
apply_sql_function($X["fun"],$C)."</a>";echo"<span class='column hidden'>","<a href='".h($Cd.$Xb)."' title='".lang(60)."' class='text'> ↓</a>";if(!$X["fun"]){echo'<a href="#fieldset-search" title="'.lang(57).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");}echo"</span>";}$ld[$y]=$X["fun"];next($L);}}$ue=array();if($_GET["modify"]){foreach($K
as$J){foreach($J
as$y=>$X)$ue[$y]=max($ue[$y],min(40,strlen(utf8_decode($X))));}}echo($Qa?"<th>".lang(254):"")."</thead>\n";if(is_ajax()){if($z%2==1&&$E%2==1)odd();ob_end_clean();}foreach($b->rowDescriptions($K,$fd)as$Ve=>$J){$Bi=unique_array($K[$Ve],$w);if(!$Bi){$Bi=array();foreach($K[$Ve]as$y=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$y))$Bi[$y]=$X;}}$Ci="";foreach($Bi
as$y=>$X){if(($x=="sql"||$x=="pgsql")&&preg_match('~char|text|enum|set~',$p[$y]["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".($x!='sql'||preg_match("~^utf8~",$p[$y]["collation"])?$y:"CONVERT($y USING ".charset($g).")").")";$X=md5($X);}$Ci.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X):"null%5B%5D=".urlencode($y));}echo"<tr".odd().">".(!$od&&$L?"":"<td>".checkbox("check[]",substr($Ci,1),in_array(substr($Ci,1),(array)$_POST["check"])).($Xd||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$Ci)."' class='edit'>".lang(255)."</a>"));foreach($J
as$y=>$X){if(isset($We[$y])){$o=$p[$y];$X=$m->value($X,$o);if($X!=""&&(!isset($tc[$y])||$tc[$y]!=""))$tc[$y]=(is_mail($X)?$We[$y]:"");$_="";if(preg_match('~blob|bytea|raw|file~',$o["type"])&&$X!="")$_=ME.'download='.urlencode($a).'&field='.urlencode($y).$Ci;if(!$_&&$X!==null){foreach((array)$fd[$y]as$q){if(count($fd[$y])==1||end($q["source"])==$y){$_="";foreach($q["source"]as$s=>$sh)$_.=where_link($s,$q["target"][$s],$K[$Ve][$sh]);$_=($q["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($q["db"]),ME):ME).'select='.urlencode($q["table"]).$_;if($q["ns"])$_=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($q["ns"]),$_);if(count($q["source"])==1)break;}}}if($y=="COUNT(*)"){$_=ME."select=".urlencode($a);$s=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$Bi))$_.=where_link($s++,$W["col"],$W["val"],$W["op"]);}foreach($Bi
as$ce=>$W)$_.=where_link($s++,$ce,$W);}$X=select_value($X,$_,$o,$Zh);$t=h("val[$Ci][".bracket_escape($y)."]");$Y=$_POST["val"][$Ci][bracket_escape($y)];$oc=!is_array($J[$y])&&is_utf8($X)&&$K[$Ve][$y]==$J[$y]&&!$ld[$y];$Yh=preg_match('~text|lob~',$o["type"]);if(($_GET["modify"]&&$oc)||$Y!==null){$td=h($Y!==null?$Y:$J[$y]);echo"<td>".($Yh?"<textarea name='$t' cols='30' rows='".(substr_count($J[$y],"\n")+1)."'>$td</textarea>":"<input name='$t' value='$td' size='$ue[$y]'>");}else{$ye=strpos($X,"<i>...</i>");echo"<td id='$t' data-text='".($ye?2:($Yh?1:0))."'".($oc?"":" data-warning='".h(lang(256))."'").">$X</td>";}}}if($Qa)echo"<td>";$b->backwardKeysPrint($Qa,$K[$Ve]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n";}if(!is_ajax()){if($K||$E){$Cc=true;if($_GET["page"]!="last"){if($z==""||(count($K)<$z&&($K||!$E)))$id=($E?$E*$z:0)+count($K);elseif($x!="sql"||!$Xd){$id=($Xd?false:found_rows($S,$Z));if($id<max(1e4,2*($E+1)*$z))$id=reset(slow_query(count_rows($a,$Z,$Xd,$od)));else$Cc=false;}}$Jf=($z!=""&&($id===false||$id>$z||$E));if($Jf){echo(($id===false?count($K)+1:$id-$E*$z)>$z?'<p><a href="'.h(remove_from_uri("page")."&page=".($E+1)).'" class="loadmore">'.lang(257).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, ".(+$z).", '".lang(258)."...');",""):''),"\n";}}echo"<div class='footer'><div>\n";if($K||$E){if($Jf){$Fe=($id===false?$E+(count($K)>=$z?2:1):floor(($id-1)/$z));echo"<fieldset>";if($x!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(259)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(259)."', '".($E+1)."')); return false; };"),pagination(0,$E).($E>5?" ...":"");for($s=max(1,$E-4);$s<min($Fe,$E+5);$s++)echo
pagination($s,$E);if($Fe>0){echo($E+5<$Fe?" ...":""),($Cc&&$id!==false?pagination($Fe,$E):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Fe'>".lang(260)."</a>");}}else{echo"<legend>".lang(259)."</legend>",pagination(0,$E).($E>1?" ...":""),($E?pagination($E,$E):""),($Fe>$E?pagination($E+1,$E).($Fe>$E+1?" ...":""):"");}echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(261)."</legend>";$cc=($Cc?"":"~ ").$id;echo
checkbox("all",1,0,($id!==false?($Cc?"":"~ ").lang(149,$id):""),"var checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$cc' : checked); selectCount('selected2', this.checked || !checked ? '$cc' : checked);")."\n","</fieldset>\n";if($b->selectCommandPrint()){echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(253),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(249).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(125),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(245),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';}$gd=$b->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($gd['sql']);break;}}if($gd){print_fieldset("export",lang(74)." <span id='selected2'></span>");$Hf=$b->dumpOutput();echo($Hf?html_select("output",$Hf,$za["output"])." ":""),html_select("format",$gd,$za["format"])," <input type='submit' name='export' value='".lang(74)."'>\n","</div></fieldset>\n";}$b->selectEmailPrint(array_filter($tc,'strlen'),$e);}echo"</div></div>\n";if($b->selectImportPrint()){echo"<div>","<a href='#import'>".lang(73)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import' class='hidden'>: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$za["format"],1);echo" <input type='submit' name='import' value='".lang(73)."'>","</span>","</div>";}echo"<input type='hidden' name='token' value='$ki'>\n","</form>\n",(!$od&&$L?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$P=isset($_GET["status"]);page_header($P?lang(117):lang(116));$Si=($P?show_status():show_variables());if(!$Si)echo"<p class='message'>".lang(12)."\n";else{echo"<table cellspacing='0'>\n";foreach($Si
as$y=>$X){echo"<tr>","<th><code class='jush-".$x.($P?"status":"set")."'>".h($y)."</code>","<td>".h($X);}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$Ih=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$C=>$S){json_row("Comment-$C",h($S["Comment"]));if(!is_view($S)){foreach(array("Engine","Collation")as$y)json_row("$y-$C",h($S[$y]));foreach($Ih+array("Auto_increment"=>0,"Rows"=>0)as$y=>$X){if($S[$y]!=""){$X=format_number($S[$y]);json_row("$y-$C",($y=="Rows"&&$X&&$S["Engine"]==($vh=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($Ih[$y]))$Ih[$y]+=($S["Engine"]!="InnoDB"||$y!="Data_free"?$S[$y]:0);}elseif(array_key_exists($y,$S))json_row("$y-$C");}}}foreach($Ih
as$y=>$X)json_row("sum-$y",format_number($X));json_row("");}elseif($_GET["script"]=="kill")$g->query("KILL ".number($_POST["kill"]));else{foreach(count_tables($b->databases())as$l=>$X){json_row("tables-$l",$X);json_row("size-$l",db_size($l));}json_row("");}exit;}else{$Rh=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($Rh&&!$n&&!$_POST["search"]){$H=true;$Ke="";if($x=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$H=truncate_tables($_POST["tables"]);$Ke=lang(262);}elseif($_POST["move"]){$H=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Ke=lang(263);}elseif($_POST["copy"]){$H=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Ke=lang(264);}elseif($_POST["drop"]){if($_POST["views"])$H=drop_views($_POST["views"]);if($H&&$_POST["tables"])$H=drop_tables($_POST["tables"]);$Ke=lang(265);}elseif($x!="sql"){$H=($x=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$Ke=lang(266);}elseif(!$_POST["tables"])$Ke=lang(9);elseif($H=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('idf_escape',$_POST["tables"])))){while($J=$H->fetch_assoc())$Ke.="<b>".h($J["Table"])."</b>: ".h($J["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$Ke,$H);}page_header(($_GET["ns"]==""?lang(38).": ".h(DB):lang(78).": ".h($_GET["ns"])),$n,true);if($b->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(267)."</h3>\n";$Qh=tables_list();if(!$Qh)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(268)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(57)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]="LIKE %%";search_tables();}}$dc=doc_link(array('sql'=>'show-table-status.html'));echo"<table cellspacing='0' class='nowrap checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(130),'<td>'.lang(269).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(121).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(270).$dc,'<td>'.lang(271).$dc,'<td>'.lang(272).$dc,'<td>'.lang(52).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(273).$dc,(support("comment")?'<td>'.lang(51).$dc:''),"</thead>\n";$T=0;foreach($Qh
as$C=>$U){$Vi=($U!==null&&!preg_match('~table~i',$U));$t=h("Table-".$C);echo'<tr'.odd().'><td>'.checkbox(($Vi?"views[]":"tables[]"),$C,in_array($C,$Rh,true),"","","",$t),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($C)."' title='".lang(43)."' id='$t'>".h($C).'</a>':h($C));if($Vi){echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($C).'" title="'.lang(44).'">'.(preg_match('~materialized~i',$U)?lang(128):lang(129)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($C).'" title="'.lang(42).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(45)),"Index_length"=>array("indexes",lang(132)),"Data_free"=>array("edit",lang(46)),"Auto_increment"=>array("auto_increment=1&create",lang(45)),"Rows"=>array("select",lang(42)),)as$y=>$_){$t=" id='$y-".h($C)."'";echo($_?"<td align='right'>".(support("table")||$y=="Rows"||(support("indexes")&&$y!="Data_length")?"<a href='".h(ME."$_[0]=").urlencode($C)."'$t title='$_[1]'>?</a>":"<span$t>?</span>"):"<td id='$y-".h($C)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($C)."'>":"");}echo"<tr><td><th>".lang(246,count($Qh)),"<td>".h($x=="sql"?$g->result("SELECT @@storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$y)echo"<td align='right' id='sum-$y'>";echo"</table>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$Pi="<input type='submit' value='".lang(274)."'> ".on_help("'VACUUM'");$tf="<input type='submit' name='optimize' value='".lang(275)."'> ".on_help($x=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(125)." <span id='selected'></span></legend><div>".($x=="sqlite"?$Pi:($x=="pgsql"?$Pi.$tf:($x=="sql"?"<input type='submit' value='".lang(276)."'> ".on_help("'ANALYZE TABLE'").$tf."<input type='submit' name='check' value='".lang(277)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(278)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(279)."'> ".on_help($x=="sqlite"?"'DELETE'":"'TRUNCATE".($x=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(126)."'>".on_help("'DROP TABLE'").confirm()."\n";$k=(support("scheme")?$b->schemas():$b->databases());if(count($k)!=1&&$x!="sqlite"){$l=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p>".lang(280).": ",($k?html_select("target",$k,$l):'<input name="target" value="'.h($l).'" autocapitalize="off">')," <input type='submit' name='move' value='".lang(281)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(282)."'>":""),"\n";}echo"<input type='hidden' name='all' value=''>";echo
script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")." }"),"<input type='hidden' name='token' value='$ki'>\n","</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo'<p class="links"><a href="'.h(ME).'create=">'.lang(75)."</a>\n",(support("view")?'<a href="'.h(ME).'view=">'.lang(203)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(142)."</h3>\n";$Tg=routines();if($Tg){echo"<table cellspacing='0'>\n",'<thead><tr><th>'.lang(182).'<td>'.lang(50).'<td>'.lang(220)."<td></thead>\n";odd('');foreach($Tg
as$J){$C=($J["SPECIFIC_NAME"]==$J["ROUTINE_NAME"]?"":"&name=".urlencode($J["ROUTINE_NAME"]));echo'<tr'.odd().'>','<th><a href="'.h(ME.($J["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($J["SPECIFIC_NAME"]).$C).'">'.h($J["ROUTINE_NAME"]).'</a>','<td>'.h($J["ROUTINE_TYPE"]),'<td>'.h($J["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($J["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($J["SPECIFIC_NAME"]).$C).'">'.lang(135)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(219).'</a>':'').'<a href="'.h(ME).'function=">'.lang(218)."</a>\n";}if(support("sequence")){echo"<h3 id='sequences'>".lang(283)."</h3>\n";$hh=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($hh){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(182)."</thead>\n";odd('');foreach($hh
as$X)echo"<tr".odd()."><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."sequence='>".lang(225)."</a>\n";}if(support("type")){echo"<h3 id='user-types'>".lang(26)."</h3>\n";$Ni=types();if($Ni){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(182)."</thead>\n";odd('');foreach($Ni
as$X)echo"<tr".odd()."><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."type='>".lang(229)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(143)."</h3>\n";$K=get_rows("SHOW EVENTS");if($K){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(182)."<td>".lang(284)."<td>".lang(209)."<td>".lang(210)."<td></thead>\n";foreach($K
as$J){echo"<tr>","<th>".h($J["Name"]),"<td>".($J["Execute at"]?lang(285)."<td>".$J["Execute at"]:lang(211)." ".$J["Interval value"]." ".$J["Interval field"]."<td>$J[Starts]"),"<td>$J[Ends]",'<td><a href="'.h(ME).'event='.urlencode($J["Name"]).'">'.lang(135).'</a>';}echo"</table>\n";$Ac=$g->result("SELECT @@event_scheduler");if($Ac&&$Ac!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Ac)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(208)."</a>\n";}if($Qh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();